/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.dsl;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.dsl.BodyBuilder;
import au.com.dius.pact.consumer.dsl.DslPart;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithPath;
import au.com.dius.pact.consumer.dsl.PactDslRequestWithoutPath;
import au.com.dius.pact.consumer.dsl.PactDslWithState;
import au.com.dius.pact.consumer.dsl.QuoteUtil;
import au.com.dius.pact.consumer.xml.PactXmlBuilder;
import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.Consumer;
import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.HttpRequest;
import au.com.dius.pact.core.model.HttpResponse;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.Provider;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.RequestResponseInteraction;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.model.Response;
import au.com.dius.pact.core.model.SynchronousRequestResponse;
import au.com.dius.pact.core.model.UnknownPactSource;
import au.com.dius.pact.core.model.V4Interaction;
import au.com.dius.pact.core.model.V4Pact;
import au.com.dius.pact.core.model.generators.Category;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.Generators;
import au.com.dius.pact.core.model.generators.ProviderStateGenerator;
import au.com.dius.pact.core.model.matchingrules.ContentTypeMatcher;
import au.com.dius.pact.core.model.matchingrules.HttpStatus;
import au.com.dius.pact.core.model.matchingrules.MatchingRule;
import au.com.dius.pact.core.model.matchingrules.MatchingRuleCategory;
import au.com.dius.pact.core.model.matchingrules.MatchingRules;
import au.com.dius.pact.core.model.matchingrules.MatchingRulesImpl;
import au.com.dius.pact.core.model.matchingrules.RegexMatcher;
import au.com.dius.pact.core.model.matchingrules.RuleLogic;
import au.com.dius.pact.core.model.matchingrules.StatusCodeMatcher;
import au.com.dius.pact.core.support.JsonKt;
import au.com.dius.pact.core.support.Random;
import au.com.dius.pact.core.support.expressions.DataType;
import au.com.dius.pact.core.support.json.JsonValue;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.w3c.dom.Document;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0016\u0018\u0000 ^2\u00020\u0001:\u0001^Ba\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0000\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0011J\b\u0010$\u001a\u00020%H\u0002J\u0016\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u0010J\u0016\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bJ\u000e\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020,J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.J\u0014\u0010)\u001a\u00020\u00002\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0/J\u001c\u0010)\u001a\u00020\u00002\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0/2\u0006\u00100\u001a\u00020\u000bJ\u001c\u0010)\u001a\u00020\u00002\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000b0/2\u0006\u00100\u001a\u000201J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u000bJ\u0016\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000bJ\u0016\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u000b2\u0006\u00100\u001a\u000201J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u000202J\u000e\u0010)\u001a\u00020\u00002\u0006\u0010)\u001a\u000203J\u0016\u00104\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u000b2\u0006\u00105\u001a\u00020\u000bJ\u000e\u00106\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u000bJ\u0016\u00106\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000bJ\u0016\u00106\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u000b2\u0006\u00100\u001a\u000201J\u0006\u00107\u001a\u00020\u0000J\u000e\u00108\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u000bJ\u0006\u00109\u001a\u00020\u0000J\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u000bJ\"\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\u000b2\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00010>J\u001e\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\u000bJ\u001a\u0010C\u001a\u00020\u00002\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0>J\u0006\u0010D\u001a\u00020\u0000J$\u0010E\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u000b2\b\u0010G\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010H\u001a\u00020\u000bH\u0007J\u001e\u0010I\u001a\u00020\u00002\u0006\u0010J\u001a\u00020\u000b2\u0006\u0010K\u001a\u00020\u000b2\u0006\u0010B\u001a\u00020\u000bJ\u0006\u0010L\u001a\u00020\u0000J\u0006\u0010M\u001a\u00020\u0000J\u0006\u0010N\u001a\u00020\u0000J\b\u0010O\u001a\u00020%H\u0002J\u000e\u0010P\u001a\u00020\u00002\u0006\u0010P\u001a\u00020!J\u0014\u0010Q\u001a\u00020\u00002\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020!0\u001dJ\u0006\u0010R\u001a\u00020\u0000J\u0006\u0010S\u001a\u00020TJ#\u0010S\u001a\u0002HU\"\b\b\u0000\u0010U*\u00020V2\f\u0010W\u001a\b\u0012\u0004\u0012\u0002HU0X\u00a2\u0006\u0002\u0010YJ\u000e\u0010Z\u001a\u00020\u00052\u0006\u0010[\u001a\u00020\u000bJ\u0016\u0010\\\u001a\u00020\u00002\u0006\u0010B\u001a\u00020]2\u0006\u00100\u001a\u00020\u000bR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u001d0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006_"}, d2={"Lau/com/dius/pact/consumer/dsl/PactDslResponse;", "", "consumerPactBuilder", "Lau/com/dius/pact/consumer/ConsumerPactBuilder;", "request", "Lau/com/dius/pact/consumer/dsl/PactDslRequestWithPath;", "defaultRequestValues", "Lau/com/dius/pact/consumer/dsl/PactDslRequestWithoutPath;", "defaultResponseValues", "comments", "", "", "version", "Lau/com/dius/pact/core/model/PactSpecVersion;", "additionalMetadata", "", "Lau/com/dius/pact/core/support/json/JsonValue;", "(Lau/com/dius/pact/consumer/ConsumerPactBuilder;Lau/com/dius/pact/consumer/dsl/PactDslRequestWithPath;Lau/com/dius/pact/consumer/dsl/PactDslRequestWithoutPath;Lau/com/dius/pact/consumer/dsl/PactDslResponse;Ljava/util/List;Lau/com/dius/pact/core/model/PactSpecVersion;Ljava/util/Map;)V", "contentTypeHeader", "getContentTypeHeader", "()Ljava/lang/String;", "isContentTypeHeaderNotSet", "", "()Z", "responseBody", "Lau/com/dius/pact/core/model/OptionalBody;", "responseGenerators", "Lau/com/dius/pact/core/model/generators/Generators;", "responseHeaders", "", "responseMatchers", "Lau/com/dius/pact/core/model/matchingrules/MatchingRules;", "responseStatus", "", "getVersion", "()Lau/com/dius/pact/core/model/PactSpecVersion;", "addInteraction", "", "addMetadataValue", "key", "value", "body", "builder", "Lau/com/dius/pact/consumer/dsl/BodyBuilder;", "Lau/com/dius/pact/consumer/dsl/DslPart;", "xmlBuilder", "Lau/com/dius/pact/consumer/xml/PactXmlBuilder;", "Ljava/util/function/Supplier;", "contentType", "Lorg/apache/hc/core5/http/ContentType;", "Lorg/json/JSONObject;", "Lorg/w3c/dom/Document;", "bodyMatchingContentType", "exampleContents", "bodyWithSingleQuotes", "clientErrorStatus", "comment", "errorStatus", "given", "Lau/com/dius/pact/consumer/dsl/PactDslWithState;", "state", "params", "", "headerFromProviderState", "name", "expression", "example", "headers", "informationStatus", "matchHeader", "header", "regexp", "headerExample", "matchSetCookie", "cookie", "regex", "nonErrorStatus", "redirectStatus", "serverErrorStatus", "setupDefaultValues", "status", "statusCodes", "successStatus", "toPact", "Lau/com/dius/pact/core/model/RequestResponsePact;", "P", "Lau/com/dius/pact/core/model/BasePact;", "pactClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lau/com/dius/pact/core/model/BasePact;", "uponReceiving", "description", "withBinaryData", "", "Companion", "consumer"})
@SourceDebugExtension(value={"SMAP\nPactDslResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PactDslResponse.kt\nau/com/dius/pact/consumer/dsl/PactDslResponse\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,571:1\n1549#2:572\n1620#2,3:573\n1549#2:576\n1620#2,3:577\n2624#2,3:580\n1#3:583\n*S KotlinDebug\n*F\n+ 1 PactDslResponse.kt\nau/com/dius/pact/consumer/dsl/PactDslResponse\n*L\n337#1:572\n337#1:573,3\n343#1:576\n343#1:577,3\n561#1:580,3\n*E\n"})
public class PactDslResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConsumerPactBuilder consumerPactBuilder;
    @Nullable
    private final PactDslRequestWithPath request;
    @Nullable
    private final PactDslRequestWithoutPath defaultRequestValues;
    @Nullable
    private final PactDslResponse defaultResponseValues;
    @NotNull
    private final List<String> comments;
    @NotNull
    private final PactSpecVersion version;
    @NotNull
    private final Map<String, JsonValue> additionalMetadata;
    private int responseStatus;
    @NotNull
    private final Map<String, List<String>> responseHeaders;
    @NotNull
    private OptionalBody responseBody;
    @NotNull
    private MatchingRules responseMatchers;
    @NotNull
    private Generators responseGenerators;
    @NotNull
    private static final String CONTENT_TYPE = "Content-Type";
    @NotNull
    public static final String DEFAULT_JSON_CONTENT_TYPE_REGEX = "application/json(;\\s?charset=[\\w\\-]+)?";

    @JvmOverloads
    public PactDslResponse(@NotNull ConsumerPactBuilder consumerPactBuilder, @Nullable PactDslRequestWithPath request, @Nullable PactDslRequestWithoutPath defaultRequestValues, @Nullable PactDslResponse defaultResponseValues, @NotNull List<String> comments, @NotNull PactSpecVersion version, @NotNull Map<String, JsonValue> additionalMetadata) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(additionalMetadata, (String)"additionalMetadata");
        this.consumerPactBuilder = consumerPactBuilder;
        this.request = request;
        this.defaultRequestValues = defaultRequestValues;
        this.defaultResponseValues = defaultResponseValues;
        this.comments = comments;
        this.version = version;
        this.additionalMetadata = additionalMetadata;
        this.responseStatus = 200;
        this.responseHeaders = new HashMap();
        this.responseBody = OptionalBody.Companion.missing();
        this.responseMatchers = (MatchingRules)new MatchingRulesImpl();
        this.responseGenerators = new Generators(null, 1, null);
        this.setupDefaultValues();
    }

    public /* synthetic */ PactDslResponse(ConsumerPactBuilder consumerPactBuilder, PactDslRequestWithPath pactDslRequestWithPath, PactDslRequestWithoutPath pactDslRequestWithoutPath, PactDslResponse pactDslResponse, List list, PactSpecVersion pactSpecVersion, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pactDslRequestWithoutPath = null;
        }
        if ((n & 8) != 0) {
            pactDslResponse = null;
        }
        if ((n & 0x10) != 0) {
            list = new ArrayList();
        }
        if ((n & 0x20) != 0) {
            pactSpecVersion = PactSpecVersion.V3;
        }
        if ((n & 0x40) != 0) {
            map = new LinkedHashMap();
        }
        this(consumerPactBuilder, pactDslRequestWithPath, pactDslRequestWithoutPath, pactDslResponse, list, pactSpecVersion, map);
    }

    @NotNull
    public final PactSpecVersion getVersion() {
        return this.version;
    }

    private final void setupDefaultValues() {
        if (this.defaultResponseValues != null) {
            this.responseStatus = this.defaultResponseValues.responseStatus;
            this.responseHeaders.putAll(this.defaultResponseValues.responseHeaders);
            this.responseBody = this.defaultResponseValues.responseBody;
            MatchingRules matchingRules = this.defaultResponseValues.responseMatchers;
            Intrinsics.checkNotNull((Object)matchingRules, (String)"null cannot be cast to non-null type au.com.dius.pact.core.model.matchingrules.MatchingRulesImpl");
            this.responseMatchers = ((MatchingRulesImpl)matchingRules).copy();
            this.responseGenerators = new Generators(this.defaultResponseValues.responseGenerators.getCategories());
        }
    }

    @NotNull
    public final PactDslResponse status(int status) {
        this.responseStatus = status;
        return this;
    }

    @NotNull
    public final PactDslResponse headers(@NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.responseHeaders.put(key, CollectionsKt.listOf((Object)value));
        }
        return this;
    }

    @NotNull
    public final PactDslResponse body(@NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        String string = body;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.responseBody = OptionalBody.Companion.body(byArray);
        return this;
    }

    @NotNull
    public final PactDslResponse body(@NotNull String body, @NotNull String contentType) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        org.apache.hc.core5.http.ContentType contentType2 = org.apache.hc.core5.http.ContentType.parse((CharSequence)contentType);
        Intrinsics.checkNotNullExpressionValue((Object)contentType2, (String)"parse(contentType)");
        return this.body(body, contentType2);
    }

    @NotNull
    public final PactDslResponse body(@NotNull String body, @NotNull org.apache.hc.core5.http.ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Charset charset = contentType.getCharset() == null ? Charset.defaultCharset() : contentType.getCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset");
        byte[] byArray = body.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String string = contentType.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contentType.toString()");
        this.responseBody = OptionalBody.Companion.body(byArray, new ContentType(string));
        this.responseHeaders.put(CONTENT_TYPE, CollectionsKt.listOf((Object)contentType.toString()));
        return this;
    }

    @NotNull
    public final PactDslResponse body(@NotNull Supplier<String> body) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        String string = body.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body.get()");
        String string2 = string;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.responseBody = OptionalBody.Companion.body(byArray);
        return this;
    }

    @NotNull
    public final PactDslResponse body(@NotNull Supplier<String> body, @NotNull String contentType) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        return this.body(body, contentType);
    }

    @NotNull
    public final PactDslResponse body(@NotNull Supplier<String> body, @NotNull org.apache.hc.core5.http.ContentType contentType) {
        Intrinsics.checkNotNullParameter(body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Charset charset = contentType.getCharset() == null ? Charset.defaultCharset() : contentType.getCharset();
        String string = body.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body.get()");
        String string2 = string;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset");
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String string3 = contentType.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"contentType.toString()");
        this.responseBody = OptionalBody.Companion.body(byArray, new ContentType(string3));
        this.responseHeaders.put(CONTENT_TYPE, CollectionsKt.listOf((Object)contentType.toString()));
        return this;
    }

    @NotNull
    public final PactDslResponse bodyWithSingleQuotes(@NotNull String body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        String string = QuoteUtil.convert(body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convert(body)");
        return this.body(string);
    }

    @NotNull
    public final PactDslResponse bodyWithSingleQuotes(@NotNull String body, @NotNull String contentType) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        String string = QuoteUtil.convert(body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convert(body)");
        return this.body(string, contentType);
    }

    @NotNull
    public final PactDslResponse bodyWithSingleQuotes(@NotNull String body, @NotNull org.apache.hc.core5.http.ContentType contentType) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        String string = QuoteUtil.convert(body);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convert(body)");
        return this.body(string, contentType);
    }

    @NotNull
    public final PactDslResponse body(@NotNull JSONObject body) {
        OptionalBody optionalBody;
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        if (this.isContentTypeHeaderNotSet()) {
            String string = org.apache.hc.core5.http.ContentType.APPLICATION_JSON.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"APPLICATION_JSON.toString()");
            this.matchHeader(CONTENT_TYPE, DEFAULT_JSON_CONTENT_TYPE_REGEX, string);
            String string2 = body.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"body.toString()");
            String string3 = string2;
            byte[] byArray = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            optionalBody = OptionalBody.Companion.body(byArray);
        } else {
            String contentType = this.getContentTypeHeader();
            org.apache.hc.core5.http.ContentType ct = org.apache.hc.core5.http.ContentType.parse((CharSequence)contentType);
            Charset charset = ct.getCharset() != null ? ct.getCharset() : Charset.defaultCharset();
            String string = body.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body.toString()");
            String string4 = string;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset");
            byte[] byArray = string4.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            optionalBody = OptionalBody.Companion.body(byArray, new ContentType(contentType));
        }
        this.responseBody = optionalBody;
        return this;
    }

    @NotNull
    public final PactDslResponse body(@NotNull DslPart body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        DslPart dslPart = body.close();
        Intrinsics.checkNotNull((Object)dslPart);
        DslPart parent = dslPart;
        this.responseMatchers.addCategory(parent.getMatchers());
        Generators.addGenerators$default((Generators)this.responseGenerators, (Generators)parent.getGenerators(), null, (int)2, null);
        Charset charset = Charset.defaultCharset();
        String string = org.apache.hc.core5.http.ContentType.APPLICATION_JSON.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"APPLICATION_JSON.toString()");
        String contentType = string;
        if (this.isContentTypeHeaderNotSet()) {
            this.matchHeader(CONTENT_TYPE, DEFAULT_JSON_CONTENT_TYPE_REGEX, contentType);
        } else {
            contentType = this.getContentTypeHeader();
            org.apache.hc.core5.http.ContentType ct = org.apache.hc.core5.http.ContentType.parse((CharSequence)contentType);
            charset = ct.getCharset() != null ? ct.getCharset() : Charset.defaultCharset();
        }
        String string2 = parent.toString();
        Charset charset2 = charset;
        Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"charset");
        byte[] byArray = string2.getBytes(charset2);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.responseBody = OptionalBody.Companion.body(byArray, new ContentType(contentType));
        return this;
    }

    @NotNull
    public final PactDslResponse body(@NotNull Document body) throws TransformerException {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        if (this.isContentTypeHeaderNotSet()) {
            this.responseHeaders.put(CONTENT_TYPE, CollectionsKt.listOf((Object)org.apache.hc.core5.http.ContentType.APPLICATION_XML.toString()));
            String string = ConsumerPactBuilder.Companion.xmlToString(body);
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            this.responseBody = OptionalBody.Companion.body(byArray);
        } else {
            String contentType = this.getContentTypeHeader();
            org.apache.hc.core5.http.ContentType ct = org.apache.hc.core5.http.ContentType.parse((CharSequence)contentType);
            Charset charset = ct.getCharset() != null ? ct.getCharset() : Charset.defaultCharset();
            String string = ConsumerPactBuilder.Companion.xmlToString(body);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"charset");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            this.responseBody = OptionalBody.Companion.body(byArray, new ContentType(contentType));
        }
        return this;
    }

    @NotNull
    public final PactDslResponse body(@NotNull BodyBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        MatchingRuleCategory matchingRuleCategory = builder.getMatchers();
        Intrinsics.checkNotNullExpressionValue((Object)matchingRuleCategory, (String)"builder.matchers");
        this.responseMatchers.addCategory(matchingRuleCategory);
        MatchingRuleCategory headerMatchers = builder.getHeaderMatchers();
        if (headerMatchers != null) {
            this.responseMatchers.addCategory(headerMatchers);
        }
        Generators generators = builder.getGenerators();
        Intrinsics.checkNotNullExpressionValue((Object)generators, (String)"builder.generators");
        Generators.addGenerators$default((Generators)this.responseGenerators, (Generators)generators, null, (int)2, null);
        ContentType contentType = builder.getContentType();
        this.responseHeaders.put(CONTENT_TYPE, CollectionsKt.listOf((Object)contentType.toString()));
        byte[] byArray = builder.buildBody();
        Intrinsics.checkNotNullExpressionValue((Object)contentType, (String)"contentType");
        this.responseBody = OptionalBody.Companion.body(byArray, contentType);
        return this;
    }

    @NotNull
    public final PactDslResponse withBinaryData(@NotNull byte[] example, @NotNull String contentType) {
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.responseBody = OptionalBody.Companion.body(example, ContentType.Companion.fromString(contentType));
        this.responseHeaders.put(CONTENT_TYPE, CollectionsKt.listOf((Object)contentType));
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.responseMatchers.addCategory("body"), (String)"$", (MatchingRule)((MatchingRule)new ContentTypeMatcher(contentType)), null, (int)4, null);
        return this;
    }

    @JvmOverloads
    @NotNull
    public final PactDslResponse matchHeader(@NotNull String header, @Nullable String regexp, @NotNull String headerExample) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)headerExample, (String)"headerExample");
        MatchingRuleCategory matchingRuleCategory = this.responseMatchers.addCategory("header");
        String string = regexp;
        Intrinsics.checkNotNull((Object)string);
        MatchingRuleCategory.setRule$default((MatchingRuleCategory)matchingRuleCategory, (String)header, (MatchingRule)((MatchingRule)new RegexMatcher(string, null, 2, null)), null, (int)4, null);
        this.responseHeaders.put(header, CollectionsKt.listOf((Object)headerExample));
        return this;
    }

    public static /* synthetic */ PactDslResponse matchHeader$default(PactDslResponse pactDslResponse, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: matchHeader");
        }
        if ((n & 4) != 0) {
            String string4 = string2;
            if (string4 == null) {
                string4 = "";
            }
            string3 = Random.generateRandomString((String)string4);
        }
        return pactDslResponse.matchHeader(string, string2, string3);
    }

    private final void addInteraction() {
        if (this.version == PactSpecVersion.V4) {
            List<Interaction> list = this.consumerPactBuilder.getInteractions();
            PactDslRequestWithPath pactDslRequestWithPath = this.request;
            Intrinsics.checkNotNull((Object)pactDslRequestWithPath);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"text", (Object)JsonKt.jsonArray(this.comments))};
            list.add((Interaction)new V4Interaction.SynchronousHttp("", pactDslRequestWithPath.description, this.request.state, new HttpRequest(this.request.requestMethod, this.request.getPath(), this.request.query, this.request.requestHeaders, this.request.requestBody, this.request.requestMatchers, this.request.requestGenerators), new HttpResponse(this.responseStatus, this.responseHeaders, this.responseBody, this.responseMatchers, this.responseGenerators), null, MapsKt.mutableMapOf((Pair[])pairArray), false, null, null, null, 1920, null).withGeneratedKey());
        } else {
            List<Interaction> list = this.consumerPactBuilder.getInteractions();
            PactDslRequestWithPath pactDslRequestWithPath = this.request;
            Intrinsics.checkNotNull((Object)pactDslRequestWithPath);
            list.add((Interaction)new RequestResponseInteraction(pactDslRequestWithPath.description, this.request.state, new Request(this.request.requestMethod, this.request.getPath(), this.request.query, this.request.requestHeaders, this.request.requestBody, this.request.requestMatchers, this.request.requestGenerators), new Response(this.responseStatus, this.responseHeaders, this.responseBody, this.responseMatchers, this.responseGenerators), null));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <P extends BasePact> P toPact(@NotNull Class<P> pactClass) {
        BasePact basePact;
        Intrinsics.checkNotNullParameter(pactClass, (String)"pactClass");
        this.addInteraction();
        if (pactClass.isAssignableFrom(V4Pact.class)) {
            Collection<V4Interaction> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            PactDslRequestWithPath pactDslRequestWithPath = this.request;
            Intrinsics.checkNotNull((Object)pactDslRequestWithPath);
            Iterable iterable = this.consumerPactBuilder.getInteractions();
            Provider provider = this.request.provider;
            Consumer consumer = pactDslRequestWithPath.consumer;
            boolean $i$f$map = false;
            void var4_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void obj;
                Interaction interaction = (Interaction)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(obj.asV4Interaction());
            }
            collection = (List)destination$iv$iv;
            PactSource pactSource = (PactSource)UnknownPactSource.INSTANCE;
            Map map = MapsKt.plus(this.additionalMetadata, (Map)BasePact.Companion.metaData(null, PactSpecVersion.V4));
            List list = CollectionsKt.toMutableList((Collection)collection);
            Provider provider2 = provider;
            Consumer consumer2 = consumer;
            basePact = (BasePact)new V4Pact(consumer2, provider2, list, map, pactSource);
        } else if (pactClass.isAssignableFrom(RequestResponsePact.class)) {
            Collection<SynchronousRequestResponse> collection;
            PactDslRequestWithPath pactDslRequestWithPath = this.request;
            Intrinsics.checkNotNull((Object)pactDslRequestWithPath);
            Iterable $this$map$iv = this.consumerPactBuilder.getInteractions();
            Consumer consumer = this.request.consumer;
            Provider provider = pactDslRequestWithPath.provider;
            boolean $i$f$map = false;
            Iterable $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Interaction obj = (Interaction)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                SynchronousRequestResponse synchronousRequestResponse = it.asSynchronousRequestResponse();
                Intrinsics.checkNotNull((Object)synchronousRequestResponse);
                collection.add(synchronousRequestResponse);
            }
            collection = (List)destination$iv$iv;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 16;
            PactSource pactSource = null;
            Map map = MapsKt.plus((Map)BasePact.Companion.getDEFAULT_METADATA(), this.additionalMetadata);
            List list = CollectionsKt.toMutableList((Collection)collection);
            Consumer consumer3 = consumer;
            Provider provider3 = provider;
            basePact = (BasePact)new RequestResponsePact(provider3, consumer3, list, map, pactSource, n, defaultConstructorMarker);
        } else {
            throw new IllegalArgumentException(pactClass.getSimpleName() + " is not a valid Pact class");
        }
        return (P)basePact;
    }

    @NotNull
    public final RequestResponsePact toPact() {
        return this.toPact(RequestResponsePact.class);
    }

    @NotNull
    public final PactDslRequestWithPath uponReceiving(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.addInteraction();
        PactDslRequestWithPath pactDslRequestWithPath = this.request;
        Intrinsics.checkNotNull((Object)pactDslRequestWithPath);
        return new PactDslRequestWithPath(this.consumerPactBuilder, pactDslRequestWithPath, description, this.defaultRequestValues, this.defaultResponseValues, this.comments, this.version, this.additionalMetadata);
    }

    @NotNull
    public final PactDslWithState given(@NotNull String state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.addInteraction();
        PactDslRequestWithPath pactDslRequestWithPath = this.request;
        Intrinsics.checkNotNull((Object)pactDslRequestWithPath);
        return new PactDslWithState(this.consumerPactBuilder, pactDslRequestWithPath.consumer.getName(), this.request.provider.getName(), new ProviderState(state, null, 2, null), this.defaultRequestValues, this.defaultResponseValues, this.version, this.additionalMetadata);
    }

    @NotNull
    public final PactDslWithState given(@NotNull String state, @NotNull Map<String, ? extends Object> params2) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(params2, (String)"params");
        this.addInteraction();
        PactDslRequestWithPath pactDslRequestWithPath = this.request;
        Intrinsics.checkNotNull((Object)pactDslRequestWithPath);
        return new PactDslWithState(this.consumerPactBuilder, pactDslRequestWithPath.consumer.getName(), this.request.provider.getName(), new ProviderState(state, params2), this.defaultRequestValues, this.defaultResponseValues, this.version, this.additionalMetadata);
    }

    @NotNull
    public final PactDslResponse headerFromProviderState(@NotNull String name, @NotNull String expression, @NotNull String example) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        this.responseGenerators.addGenerator(Category.HEADER, name, (Generator)new ProviderStateGenerator(expression, DataType.STRING));
        this.responseHeaders.put(name, CollectionsKt.listOf((Object)example));
        return this;
    }

    @NotNull
    public final PactDslResponse matchSetCookie(@NotNull String cookie, @NotNull String regex, @NotNull String example) {
        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)example, (String)"example");
        MatchingRuleCategory header = this.responseMatchers.addCategory("header");
        if (header.numRules("set-cookie") > 0) {
            MatchingRuleCategory.addRule$default((MatchingRuleCategory)header, (String)"set-cookie", (MatchingRule)((MatchingRule)new RegexMatcher(Pattern.quote(cookie + "=") + regex, null, 2, null)), null, (int)4, null);
        } else {
            header.setRule("set-cookie", (MatchingRule)new RegexMatcher(Pattern.quote(cookie + "=") + regex, null, 2, null), RuleLogic.OR);
        }
        if (this.responseHeaders.containsKey("set-cookie")) {
            List<String> list = this.responseHeaders.get("set-cookie");
            Intrinsics.checkNotNull(list);
            this.responseHeaders.put("set-cookie", CollectionsKt.plus((Collection)list, (Object)(cookie + "=" + example)));
        } else {
            this.responseHeaders.put("set-cookie", CollectionsKt.listOf((Object)(cookie + "=" + example)));
        }
        return this;
    }

    @NotNull
    public final PactDslResponse body(@NotNull PactXmlBuilder xmlBuilder) {
        Intrinsics.checkNotNullParameter((Object)xmlBuilder, (String)"xmlBuilder");
        this.responseMatchers.addCategory(xmlBuilder.getMatchingRules());
        Generators.addGenerators$default((Generators)this.responseGenerators, (Generators)xmlBuilder.getGenerators(), null, (int)2, null);
        if (this.isContentTypeHeaderNotSet()) {
            this.responseHeaders.put(CONTENT_TYPE, CollectionsKt.listOf((Object)org.apache.hc.core5.http.ContentType.APPLICATION_XML.toString()));
            this.responseBody = OptionalBody.Companion.body(PactXmlBuilder.asBytes$default(xmlBuilder, null, 1, null));
        } else {
            String contentType = this.getContentTypeHeader();
            org.apache.hc.core5.http.ContentType ct = org.apache.hc.core5.http.ContentType.parse((CharSequence)contentType);
            Charset charset = ct.getCharset() != null ? ct.getCharset() : Charset.defaultCharset();
            this.responseBody = OptionalBody.Companion.body(xmlBuilder.asBytes(charset), new ContentType(contentType));
        }
        return this;
    }

    @NotNull
    public final PactDslResponse comment(@NotNull String comment2) {
        Intrinsics.checkNotNullParameter((Object)comment2, (String)"comment");
        this.comments.add(comment2);
        return this;
    }

    @NotNull
    public final PactDslResponse informationStatus() {
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.Information, null, 2, null);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.responseMatchers.addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.responseStatus = 100;
        return this;
    }

    @NotNull
    public final PactDslResponse successStatus() {
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.Success, null, 2, null);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.responseMatchers.addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.responseStatus = 200;
        return this;
    }

    @NotNull
    public final PactDslResponse redirectStatus() {
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.Redirect, null, 2, null);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.responseMatchers.addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.responseStatus = 300;
        return this;
    }

    @NotNull
    public final PactDslResponse clientErrorStatus() {
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.ClientError, null, 2, null);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.responseMatchers.addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.responseStatus = 400;
        return this;
    }

    @NotNull
    public final PactDslResponse serverErrorStatus() {
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.ServerError, null, 2, null);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.responseMatchers.addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.responseStatus = 500;
        return this;
    }

    @NotNull
    public final PactDslResponse nonErrorStatus() {
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.NonError, null, 2, null);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.responseMatchers.addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.responseStatus = 200;
        return this;
    }

    @NotNull
    public final PactDslResponse errorStatus() {
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.Error, null, 2, null);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.responseMatchers.addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.responseStatus = 400;
        return this;
    }

    @NotNull
    public final PactDslResponse statusCodes(@NotNull List<Integer> statusCodes) {
        Intrinsics.checkNotNullParameter(statusCodes, (String)"statusCodes");
        StatusCodeMatcher matcher = new StatusCodeMatcher(HttpStatus.StatusCodes, statusCodes);
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.responseMatchers.addCategory("status"), (MatchingRule)((MatchingRule)matcher), null, (int)2, null);
        this.responseStatus = ((Number)CollectionsKt.first(statusCodes)).intValue();
        return this;
    }

    @NotNull
    public final PactDslResponse addMetadataValue(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.additionalMetadata.put(key, (JsonValue)new JsonValue.StringValue(value));
        return this;
    }

    @NotNull
    public final PactDslResponse addMetadataValue(@NotNull String key, @NotNull JsonValue value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.additionalMetadata.put(key, value);
        return this;
    }

    @NotNull
    public final PactDslResponse bodyMatchingContentType(@NotNull String contentType, @NotNull String exampleContents) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)exampleContents, (String)"exampleContents");
        ContentType ct = new ContentType(contentType);
        Charset charset = ct.asCharset();
        byte[] byArray = exampleContents.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.responseBody = OptionalBody.Companion.body(byArray, ct);
        this.responseHeaders.put(CONTENT_TYPE, CollectionsKt.listOf((Object)contentType));
        MatchingRuleCategory.addRule$default((MatchingRuleCategory)this.responseMatchers.addCategory("body"), (String)"$", (MatchingRule)((MatchingRule)new ContentTypeMatcher(contentType)), null, (int)4, null);
        return this;
    }

    protected final boolean isContentTypeHeaderNotSet() {
        boolean bl;
        block3: {
            Iterable $this$none$iv = this.responseHeaders.keySet();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String key = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.equals((String)key, (String)CONTENT_TYPE, (boolean)true)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    protected final String getContentTypeHeader() {
        List list;
        Object v0;
        Object object;
        block1: {
            object = this.responseHeaders.entrySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                Map.Entry entry = (Map.Entry)t;
                boolean bl = false;
                String key = (String)entry.getKey();
                if (!StringsKt.equals((String)key, (String)CONTENT_TYPE, (boolean)true)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null && (list = (List)entry.getValue()) != null && (object = (String)list.get(0)) != null ? object : "";
    }

    @JvmOverloads
    public PactDslResponse(@NotNull ConsumerPactBuilder consumerPactBuilder, @Nullable PactDslRequestWithPath request, @Nullable PactDslRequestWithoutPath defaultRequestValues, @Nullable PactDslResponse defaultResponseValues, @NotNull List<String> comments, @NotNull PactSpecVersion version) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this(consumerPactBuilder, request, defaultRequestValues, defaultResponseValues, comments, version, null, 64, null);
    }

    @JvmOverloads
    public PactDslResponse(@NotNull ConsumerPactBuilder consumerPactBuilder, @Nullable PactDslRequestWithPath request, @Nullable PactDslRequestWithoutPath defaultRequestValues, @Nullable PactDslResponse defaultResponseValues, @NotNull List<String> comments) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        Intrinsics.checkNotNullParameter(comments, (String)"comments");
        this(consumerPactBuilder, request, defaultRequestValues, defaultResponseValues, comments, null, null, 96, null);
    }

    @JvmOverloads
    public PactDslResponse(@NotNull ConsumerPactBuilder consumerPactBuilder, @Nullable PactDslRequestWithPath request, @Nullable PactDslRequestWithoutPath defaultRequestValues, @Nullable PactDslResponse defaultResponseValues) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        this(consumerPactBuilder, request, defaultRequestValues, defaultResponseValues, null, null, null, 112, null);
    }

    @JvmOverloads
    public PactDslResponse(@NotNull ConsumerPactBuilder consumerPactBuilder, @Nullable PactDslRequestWithPath request, @Nullable PactDslRequestWithoutPath defaultRequestValues) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        this(consumerPactBuilder, request, defaultRequestValues, null, null, null, null, 120, null);
    }

    @JvmOverloads
    public PactDslResponse(@NotNull ConsumerPactBuilder consumerPactBuilder, @Nullable PactDslRequestWithPath request) {
        Intrinsics.checkNotNullParameter((Object)consumerPactBuilder, (String)"consumerPactBuilder");
        this(consumerPactBuilder, request, null, null, null, null, null, 124, null);
    }

    @JvmOverloads
    @NotNull
    public final PactDslResponse matchHeader(@NotNull String header, @Nullable String regexp) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        return PactDslResponse.matchHeader$default(this, header, regexp, null, 4, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lau/com/dius/pact/consumer/dsl/PactDslResponse$Companion;", "", "()V", "CONTENT_TYPE", "", "DEFAULT_JSON_CONTENT_TYPE_REGEX", "consumer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

