/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.junit;

import au.com.dius.pact.consumer.PactMismatchesException;
import au.com.dius.pact.consumer.PactVerificationResult;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.model.V4Pact;
import au.com.dius.pact.core.model.annotations.Pact;
import au.com.dius.pact.core.model.messaging.MessagePact;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lau/com/dius/pact/consumer/junit/JUnitTestSupport;", "", "()V", "conformsToMessagePactSignature", "", "m", "Ljava/lang/reflect/Method;", "pactVersion", "Lau/com/dius/pact/core/model/PactSpecVersion;", "conformsToSignature", "conformsToSynchMessagePactSignature", "validateMockServerResult", "", "result", "Lau/com/dius/pact/consumer/PactVerificationResult;", "consumer"})
public final class JUnitTestSupport {
    @NotNull
    public static final JUnitTestSupport INSTANCE = new JUnitTestSupport();

    private JUnitTestSupport() {
    }

    @JvmStatic
    public static final boolean conformsToSignature(@NotNull Method m, @NotNull PactSpecVersion pactVersion) {
        boolean conforms;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)pactVersion, (String)"pactVersion");
        Pact pact = m.getAnnotation(Pact.class);
        boolean bl = pactVersion.compareTo((Enum)PactSpecVersion.V4) >= 0 ? pact != null && V4Pact.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 1 && (m.getParameterTypes()[0].isAssignableFrom(Class.forName("au.com.dius.pact.consumer.dsl.PactDslWithProvider")) || m.getParameterTypes()[0].isAssignableFrom(Class.forName("au.com.dius.pact.consumer.dsl.PactBuilder"))) : (conforms = pact != null && RequestResponsePact.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isAssignableFrom(Class.forName("au.com.dius.pact.consumer.dsl.PactDslWithProvider")));
        if (!conforms && pact != null) {
            if (pactVersion == PactSpecVersion.V4) {
                throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public au.com.dius.pact.core.model.V4Pact xxx(PactBuilder builder)'");
            }
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public au.com.dius.pact.core.model.RequestResponsePact xxx(PactDslWithProvider builder)'");
        }
        return conforms;
    }

    @JvmStatic
    public static final boolean conformsToMessagePactSignature(@NotNull Method m, @NotNull PactSpecVersion pactVersion) {
        boolean hasValidPactSignature;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)pactVersion, (String)"pactVersion");
        Pact pact = m.getAnnotation(Pact.class);
        boolean bl = pactVersion.compareTo((Enum)PactSpecVersion.V4) >= 0 ? V4Pact.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 1 && (m.getParameterTypes()[0].isAssignableFrom(Class.forName("au.com.dius.pact.consumer.MessagePactBuilder")) || m.getParameterTypes()[0].isAssignableFrom(Class.forName("au.com.dius.pact.consumer.dsl.PactBuilder"))) : (hasValidPactSignature = MessagePact.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].isAssignableFrom(Class.forName("au.com.dius.pact.consumer.MessagePactBuilder")));
        if (!hasValidPactSignature && pact != null) {
            if (pactVersion == PactSpecVersion.V4) {
                throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public V4Pact xxx(PactBuilder builder)'");
            }
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public MessagePact xxx(MessagePactBuilder builder)'");
        }
        return hasValidPactSignature;
    }

    @JvmStatic
    public static final boolean conformsToSynchMessagePactSignature(@NotNull Method m, @NotNull PactSpecVersion pactVersion) {
        boolean hasValidPactSignature;
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Intrinsics.checkNotNullParameter((Object)pactVersion, (String)"pactVersion");
        Pact pact = m.getAnnotation(Pact.class);
        boolean bl = pactVersion.compareTo((Enum)PactSpecVersion.V4) >= 0 ? V4Pact.class.isAssignableFrom(m.getReturnType()) && m.getParameterTypes().length == 1 && (m.getParameterTypes()[0].isAssignableFrom(Class.forName("au.com.dius.pact.consumer.dsl.PactBuilder")) || m.getParameterTypes()[0].isAssignableFrom(Class.forName("au.com.dius.pact.consumer.dsl.SynchronousMessagePactBuilder"))) : (hasValidPactSignature = false);
        if (!hasValidPactSignature && pact != null) {
            throw new UnsupportedOperationException("Method " + m.getName() + " does not conform required method signature 'public V4Pact xxx(PactBuilder|SynchronousMessagePactBuilder builder)'");
        }
        return hasValidPactSignature;
    }

    @JvmStatic
    public static final void validateMockServerResult(@NotNull PactVerificationResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (!(result instanceof PactVerificationResult.Ok)) {
            if (result instanceof PactVerificationResult.Error) {
                if (!(((PactVerificationResult.Error)result).getMockServerState() instanceof PactVerificationResult.Ok)) {
                    throw new AssertionError("Pact Test function failed with an exception, possibly due to " + ((PactVerificationResult.Error)result).getMockServerState(), ((PactVerificationResult.Error)result).getError());
                }
                throw new AssertionError("Pact Test function failed with an exception: " + ((PactVerificationResult.Error)result).getError().getMessage(), ((PactVerificationResult.Error)result).getError());
            }
            throw new PactMismatchesException(result);
        }
    }
}

