/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.BaseJdkMockServer;
import au.com.dius.pact.consumer.BaseMockServer;
import au.com.dius.pact.consumer.Headers;
import au.com.dius.pact.consumer.model.MockProviderConfig;
import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.IRequest;
import au.com.dius.pact.core.model.IResponse;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.PactReaderKt;
import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.Response;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.github.oshai.kotlinlogging.KLogging;
import io.ktor.http.HeaderValue;
import io.ktor.http.HttpHeaderValueParserKt;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0016J\b\u0010\u001d\u001a\u00020\u0015H\u0016J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lau/com/dius/pact/consumer/BaseJdkMockServer;", "Lcom/sun/net/httpserver/HttpHandler;", "Lau/com/dius/pact/consumer/BaseMockServer;", "pact", "Lau/com/dius/pact/core/model/BasePact;", "config", "Lau/com/dius/pact/consumer/model/MockProviderConfig;", "server", "Lcom/sun/net/httpserver/HttpServer;", "stopped", "", "(Lau/com/dius/pact/core/model/BasePact;Lau/com/dius/pact/consumer/model/MockProviderConfig;Lcom/sun/net/httpserver/HttpServer;Z)V", "contentType", "Lau/com/dius/pact/core/model/ContentType;", "headers", "Lcom/sun/net/httpserver/Headers;", "getPort", "", "getUrl", "", "handle", "", "exchange", "Lcom/sun/net/httpserver/HttpExchange;", "initServer", "pactResponseToHttpExchange", "response", "Lau/com/dius/pact/core/model/IResponse;", "start", "stop", "toPactRequest", "Lau/com/dius/pact/core/model/Request;", "Companion", "consumer"})
@SourceDebugExtension(value={"SMAP\nMockHttpServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockHttpServer.kt\nau/com/dius/pact/consumer/BaseJdkMockServer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,413:1\n453#2:414\n403#2:415\n1238#3,2:416\n1549#3:418\n1620#3,3:419\n1241#3:422\n1#4:423\n*S KotlinDebug\n*F\n+ 1 MockHttpServer.kt\nau/com/dius/pact/consumer/BaseJdkMockServer\n*L\n292#1:414\n292#1:415\n292#1:416,2\n294#1:418\n294#1:419,3\n292#1:422\n*E\n"})
public abstract class BaseJdkMockServer
extends BaseMockServer
implements HttpHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HttpServer server;
    private boolean stopped;

    public BaseJdkMockServer(@NotNull BasePact pact, @NotNull MockProviderConfig config, @NotNull HttpServer server2, boolean stopped) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)server2, (String)"server");
        super(pact, config);
        this.server = server2;
        this.stopped = stopped;
        this.initServer();
    }

    public /* synthetic */ BaseJdkMockServer(BasePact basePact, MockProviderConfig mockProviderConfig, HttpServer httpServer, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(basePact, mockProviderConfig, httpServer, bl);
    }

    @Override
    public void handle(@NotNull HttpExchange exchange) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        if (Intrinsics.areEqual((Object)exchange.getRequestMethod(), (Object)"OPTIONS") && exchange.getRequestHeaders().containsKey("X-PACT-BOOTCHECK")) {
            exchange.getResponseHeaders().add("X-PACT-BOOTCHECK", "true");
            exchange.sendResponseHeaders(200, 0L);
            exchange.close();
        } else {
            try {
                Request request = this.toPactRequest(exchange);
                Companion.getLogger().debug((Function0)new Function0<Object>(request){
                    final /* synthetic */ Request $request;
                    {
                        this.$request = $request;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Received request: " + this.$request;
                    }
                });
                IResponse response = this.generatePactResponse((IRequest)request);
                Companion.getLogger().debug((Function0)new Function0<Object>(response){
                    final /* synthetic */ IResponse $response;
                    {
                        this.$response = $response;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Generating response: " + this.$response;
                    }
                });
                this.pactResponseToHttpExchange(response, exchange);
            }
            catch (Exception e) {
                Companion.getLogger().error((Throwable)e, (Function0)handle.3.INSTANCE);
                Object object = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)CollectionsKt.listOf((Object)"application/json"))};
                Map map = MapsKt.mutableMapOf((Pair[])object);
                object = "{\"error\": " + e.getMessage() + "}";
                byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                this.pactResponseToHttpExchange((IResponse)new Response(500, map, OptionalBody.Companion.body(byArray, ContentType.Companion.getJSON()), null, null, 24, null), exchange);
            }
        }
    }

    private final void pactResponseToHttpExchange(IResponse response, HttpExchange exchange) {
        OptionalBody body;
        Map headers = response.getHeaders();
        if (!headers.isEmpty()) {
            exchange.getResponseHeaders().putAll(headers);
        }
        if (this.getConfig().getAddCloseHeader()) {
            exchange.getResponseHeaders().add("Connection", "close");
        }
        if ((body = response.getBody()).isPresent()) {
            byte[] bytes = body.unwrap();
            exchange.sendResponseHeaders(response.getStatus(), bytes.length);
            exchange.getResponseBody().write(bytes);
        } else {
            exchange.sendResponseHeaders(response.getStatus(), -1L);
        }
        exchange.close();
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final Request toPactRequest(@NotNull HttpExchange exchange) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        v0 = exchange.getRequestHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"exchange.requestHeaders");
        $this$mapValues$iv = v0;
        $i$f$mapValues = false;
        var5_5 = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            var12_12 = (Map.Entry)element$iv$iv$iv;
            var13_13 = destination$iv$iv;
            $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv = false;
            var15_15 = (Map.Entry)element$iv$iv$iv;
            var28_28 = it$iv$iv.getKey();
            var27_27 = var13_13;
            $i$a$-mapValues-BaseJdkMockServer$toPactRequest$headers$1 = false;
            if (((List)entry.getValue()).size() != 1) ** GOTO lbl-1000
            v1 = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(v1, (String)"entry.key");
            if (Headers.INSTANCE.isKnowMultiValueHeader((String)v1)) {
                $this$map$iv = HttpHeaderValueParserKt.parseHeaderValue((String)((String)((List)entry.getValue()).get(0)));
                $i$f$map = false;
                var19_19 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var24_24 = (HeaderValue)item$iv$iv;
                    var25_25 = destination$iv$iv;
                    $i$a$-map-BaseJdkMockServer$toPactRequest$headers$1$1 = false;
                    var25_25.add(Headers.INSTANCE.headerToString((HeaderValue)it));
                }
                v2 = (List)destination$iv$iv;
            } else lbl-1000:
            // 2 sources

            {
                v2 = (List)entry.getValue();
            }
            var29_29 = v2;
            var27_27.put(var28_28, var29_29);
        }
        headers = destination$iv$iv;
        v3 = exchange.getRequestHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"exchange.requestHeaders");
        contentType = this.contentType(v3);
        $this$mapValuesTo$iv$iv = this.bodyIsCompressed(exchange.getRequestHeaders().getFirst("Content-Encoding"));
        if (Intrinsics.areEqual((Object)$this$mapValuesTo$iv$iv, (Object)"gzip")) {
            v4 = ByteStreamsKt.readBytes((InputStream)new GZIPInputStream(exchange.getRequestBody()));
        } else if (Intrinsics.areEqual((Object)$this$mapValuesTo$iv$iv, (Object)"deflate")) {
            v4 = ByteStreamsKt.readBytes((InputStream)new DeflaterInputStream(exchange.getRequestBody()));
        } else {
            v5 = exchange.getRequestBody();
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"exchange.requestBody");
            v4 = ByteStreamsKt.readBytes((InputStream)v5);
        }
        bodyContents = v4;
        body = bodyContents.length == 0 != false ? OptionalBody.Companion.empty() : OptionalBody.Companion.body(bodyContents, contentType);
        v6 = exchange.getRequestMethod();
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"exchange.requestMethod");
        v7 = exchange.getRequestURI().getRawPath();
        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"exchange.requestURI.rawPath");
        return new Request(v6, v7, MapsKt.toMutableMap((Map)PactReaderKt.queryStringToMap$default((String)exchange.getRequestURI().getRawQuery(), (boolean)false, (int)2, null)), MapsKt.toMutableMap((Map)headers), body, null, null, 96, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final ContentType contentType(com.sun.net.httpserver.Headers headers) {
        ContentType contentType;
        Object v4;
        block3: {
            Set<Map.Entry<String, List<String>>> set = headers.entrySet();
            Intrinsics.checkNotNullExpressionValue(set, (String)"headers.entries");
            Iterable iterable = set;
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                Object k = it.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
                String string = (String)k;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string2 = string.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                if (!Intrinsics.areEqual((Object)string2, (Object)"CONTENT-TYPE")) continue;
                v4 = t;
                break block3;
            }
            v4 = null;
        }
        Map.Entry contentType2 = v4;
        if (contentType2 != null) {
            Object v = contentType2.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"contentType.value");
            if (!((Collection)v).isEmpty()) {
                Object v2 = contentType2.getValue();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"contentType.value");
                Object object = CollectionsKt.first((List)((List)v2));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"contentType.value.first()");
                contentType = new ContentType((String)object);
                return contentType;
            }
        }
        contentType = ContentType.Companion.getJSON();
        return contentType;
    }

    private final void initServer() {
        this.server.createContext("/", this);
    }

    @Override
    public void start() {
        Companion.getLogger().debug((Function0)start.1.INSTANCE);
        this.server.start();
        Companion.getLogger().debug((Function0)new Function0<Object>(this){
            final /* synthetic */ BaseJdkMockServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Mock server started: " + BaseJdkMockServer.access$getServer$p(this.this$0).getAddress();
            }
        });
    }

    @Override
    public void stop() {
        if (!this.stopped) {
            this.stopped = true;
            this.server.stop(0);
            Companion.getLogger().debug((Function0)stop.1.INSTANCE);
        }
    }

    @Override
    @NotNull
    public String getUrl() {
        String string = this.server.getAddress().getHostName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.address.hostName");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String host = Intrinsics.areEqual((Object)string2, (Object)"miningmadness.com") ? this.getConfig().getHostname() : this.server.getAddress().getHostName();
        return this.getConfig().getScheme() + "://" + host + ":" + this.server.getAddress().getPort();
    }

    @Override
    public int getPort() {
        return this.server.getAddress().getPort();
    }

    public static final /* synthetic */ HttpServer access$getServer$p(BaseJdkMockServer $this) {
        return $this.server;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lau/com/dius/pact/consumer/BaseJdkMockServer$Companion;", "Lio/github/oshai/kotlinlogging/KLogging;", "()V", "consumer"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

