/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer;

import au.com.dius.pact.consumer.BaseMockServer;
import au.com.dius.pact.consumer.InvalidMockServerRegistryEntry;
import au.com.dius.pact.consumer.PactVerificationResult;
import au.com.dius.pact.consumer.model.MockProviderConfig;
import au.com.dius.pact.core.matchers.BodyMismatch;
import au.com.dius.pact.core.matchers.MetadataMismatch;
import au.com.dius.pact.core.matchers.Mismatch;
import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.V4Interaction;
import au.com.dius.pact.core.model.V4Pact;
import au.com.dius.pact.core.support.JsonKt;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.Result;
import io.github.oshai.kotlinlogging.KLogging;
import io.pact.plugins.jvm.core.CatalogueEntry;
import io.pact.plugins.jvm.core.CatalogueManager;
import io.pact.plugins.jvm.core.DefaultPluginManager;
import io.pact.plugins.jvm.core.MockServerDetails;
import io.pact.plugins.jvm.core.MockServerMismatch;
import io.pact.plugins.jvm.core.MockServerResults;
import io.pact.plugins.jvm.core.PluginManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\u0019H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lau/com/dius/pact/consumer/PluginMockServer;", "Lau/com/dius/pact/consumer/BaseMockServer;", "pact", "Lau/com/dius/pact/core/model/BasePact;", "config", "Lau/com/dius/pact/consumer/model/MockProviderConfig;", "(Lau/com/dius/pact/core/model/BasePact;Lau/com/dius/pact/consumer/model/MockProviderConfig;)V", "mockServerDetails", "Lio/pact/plugins/jvm/core/MockServerDetails;", "mockServerState", "", "Lio/pact/plugins/jvm/core/MockServerResults;", "pluginManager", "Lio/pact/plugins/jvm/core/PluginManager;", "getPluginManager", "()Lio/pact/plugins/jvm/core/PluginManager;", "setPluginManager", "(Lio/pact/plugins/jvm/core/PluginManager;)V", "transportEntry", "Lio/pact/plugins/jvm/core/CatalogueEntry;", "getPort", "", "getUrl", "", "start", "", "stop", "updatePact", "Lau/com/dius/pact/core/model/Pact;", "validateMockServerState", "Lau/com/dius/pact/consumer/PactVerificationResult;", "testResult", "", "waitForServer", "Companion", "consumer"})
@SourceDebugExtension(value={"SMAP\nPluginMockServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginMockServer.kt\nau/com/dius/pact/consumer/PluginMockServer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1549#2:116\n1620#2,2:117\n1549#2:119\n1620#2,3:120\n1622#2:123\n*S KotlinDebug\n*F\n+ 1 PluginMockServer.kt\nau/com/dius/pact/consumer/PluginMockServer\n*L\n94#1:116\n94#1:117,2\n98#1:119\n98#1:120,3\n94#1:123\n*E\n"})
public final class PluginMockServer
extends BaseMockServer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private List<MockServerResults> mockServerState;
    @Nullable
    private MockServerDetails mockServerDetails;
    private CatalogueEntry transportEntry;
    @NotNull
    private PluginManager pluginManager;

    public PluginMockServer(@NotNull BasePact pact, @NotNull MockProviderConfig config) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(pact, config);
        this.pluginManager = (PluginManager)DefaultPluginManager.INSTANCE;
    }

    @NotNull
    public final PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public final void setPluginManager(@NotNull PluginManager pluginManager) {
        Intrinsics.checkNotNullParameter((Object)pluginManager, (String)"<set-?>");
        this.pluginManager = pluginManager;
    }

    @Override
    public void start() {
        CatalogueEntry catalogueEntry;
        CatalogueEntry entry;
        CatalogueEntry catalogueEntry2 = entry = KotlinLanguageSupportKt.contains((String)this.getConfig().getTransportRegistryEntry(), (String)"/") ? CatalogueManager.INSTANCE.lookupEntry(this.getConfig().getTransportRegistryEntry()) : CatalogueManager.INSTANCE.lookupEntry("transport/" + this.getConfig().getTransportRegistryEntry());
        if (entry == null) {
            throw new InvalidMockServerRegistryEntry(this.getConfig().getTransportRegistryEntry());
        }
        Map testContext = new LinkedHashMap();
        if (!this.getConfig().getTransportConfig().isEmpty()) {
            testContext.put("transport_config", JsonKt.toJson(this.getConfig().getTransportConfig()));
        }
        if ((catalogueEntry = (this.transportEntry = entry)) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transportEntry");
            catalogueEntry = null;
        }
        this.mockServerDetails = this.pluginManager.startMockServer(catalogueEntry, this.getConfig().toPluginMockServerConfig(), (Pact)this.getPact(), testContext);
    }

    @Override
    public void waitForServer() {
    }

    @Override
    public void stop() {
        if (this.mockServerDetails != null) {
            MockServerDetails mockServerDetails = this.mockServerDetails;
            Intrinsics.checkNotNull((Object)mockServerDetails);
            List response = this.pluginManager.shutdownMockServer(mockServerDetails);
            if (KotlinLanguageSupportKt.isNotEmpty((List)response)) {
                Companion.getLogger().warn((Function0)new Function0<Object>((List<MockServerResults>)response){
                    final /* synthetic */ List<MockServerResults> $response;
                    {
                        this.$response = $response;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Mock server returned an error response - " + this.$response;
                    }
                });
                this.mockServerState = response;
            }
        } else {
            throw new RuntimeException("Mock server is not running");
        }
    }

    @Override
    @NotNull
    public String getUrl() {
        Object object = this.mockServerDetails;
        if (object == null || (object = object.getBaseUrl()) == null) {
            throw new RuntimeException("Mock server is not running");
        }
        return object;
    }

    @Override
    public int getPort() {
        MockServerDetails mockServerDetails = this.mockServerDetails;
        if (mockServerDetails == null) {
            throw new RuntimeException("Mock server is not running");
        }
        return mockServerDetails.getPort();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Pact updatePact(@NotNull Pact pact) {
        Pact pact2;
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        if (pact.isV4Pact()) {
            Result p = pact.asV4Pact();
            if (p instanceof Result.Ok) {
                for (Interaction interaction : ((V4Pact)((Result.Ok)p).getValue()).getInteractions()) {
                    V4Interaction v4Interaction = interaction.asV4Interaction();
                    CatalogueEntry catalogueEntry = this.transportEntry;
                    if (catalogueEntry == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"transportEntry");
                        catalogueEntry = null;
                    }
                    v4Interaction.setTransport(catalogueEntry.getKey());
                }
                pact2 = (Pact)((Result.Ok)p).getValue();
                return pact2;
            } else {
                if (!(p instanceof Result.Err)) throw new NoWhenBranchMatchedException();
                pact2 = pact;
            }
            return pact2;
        } else {
            pact2 = pact;
        }
        return pact2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PactVerificationResult validateMockServerState(@Nullable Object testResult) {
        PactVerificationResult pactVerificationResult;
        Collection collection = this.mockServerState;
        if (collection == null || collection.isEmpty()) {
            pactVerificationResult = new PactVerificationResult.Ok(testResult);
        } else {
            void $this$mapTo$iv$iv;
            List<MockServerResults> list = this.mockServerState;
            Intrinsics.checkNotNull(list);
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PactVerificationResult pactVerificationResult2;
                void results;
                MockServerResults mockServerResults = (MockServerResults)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                if (KotlinLanguageSupportKt.isNotEmpty((String)results.getError())) {
                    pactVerificationResult2 = new PactVerificationResult.Error(new RuntimeException(results.getError()), new PactVerificationResult.Ok(testResult));
                } else {
                    void $this$mapTo$iv$iv2;
                    Iterable $this$map$iv2 = results.getMismatches();
                    boolean $i$f$map2 = false;
                    Iterable iterable2 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it;
                        MockServerMismatch mockServerMismatch = (MockServerMismatch)item$iv$iv2;
                        Collection collection3 = destination$iv$iv2;
                        boolean bl2 = false;
                        collection3.add(Intrinsics.areEqual((Object)it.getMismatchType(), (Object)"metadata") ? (Mismatch)new MetadataMismatch(it.getPath(), it.getExpected(), it.getActual(), it.getMismatch()) : (Mismatch)new BodyMismatch(it.getExpected(), it.getActual(), it.getMismatch(), it.getPath(), it.getDiff()));
                    }
                    List list2 = (List)destination$iv$iv2;
                    pactVerificationResult2 = new PactVerificationResult.PartialMismatch(list2);
                }
                collection2.add(pactVerificationResult2);
            }
            List list3 = (List)destination$iv$iv;
            pactVerificationResult = new PactVerificationResult.Mismatches(list3);
        }
        return pactVerificationResult;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lau/com/dius/pact/consumer/PluginMockServer$Companion;", "Lio/github/oshai/kotlinlogging/KLogging;", "()V", "consumer"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

