/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.groovy;

import au.com.dius.pact.consumer.groovy.AndMatcher;
import au.com.dius.pact.consumer.groovy.DateMatcher;
import au.com.dius.pact.consumer.groovy.DateTimeMatcher;
import au.com.dius.pact.consumer.groovy.EachLikeMatcher;
import au.com.dius.pact.consumer.groovy.EqualsMatcher;
import au.com.dius.pact.consumer.groovy.HexadecimalMatcher;
import au.com.dius.pact.consumer.groovy.IncludeMatcher;
import au.com.dius.pact.consumer.groovy.InvalidMatcherException;
import au.com.dius.pact.consumer.groovy.Matcher;
import au.com.dius.pact.consumer.groovy.MaxLikeMatcher;
import au.com.dius.pact.consumer.groovy.MinLikeMatcher;
import au.com.dius.pact.consumer.groovy.MinMaxLikeMatcher;
import au.com.dius.pact.consumer.groovy.NullMatcher;
import au.com.dius.pact.consumer.groovy.OrMatcher;
import au.com.dius.pact.consumer.groovy.RegexpMatcher;
import au.com.dius.pact.consumer.groovy.StatusCodeMatcher;
import au.com.dius.pact.consumer.groovy.TimeMatcher;
import au.com.dius.pact.consumer.groovy.TypeMatcher;
import au.com.dius.pact.consumer.groovy.UrlMatcher;
import au.com.dius.pact.consumer.groovy.UuidMatcher;
import au.com.dius.pact.core.model.generators.Generator;
import au.com.dius.pact.core.model.generators.RandomBooleanGenerator;
import au.com.dius.pact.core.model.generators.RandomDecimalGenerator;
import au.com.dius.pact.core.model.generators.RandomIntGenerator;
import au.com.dius.pact.core.model.generators.RandomStringGenerator;
import au.com.dius.pact.core.model.matchingrules.HttpStatus;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import io.github.oshai.kotlinlogging.KLogging;
import java.text.ParseException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lau/com/dius/pact/consumer/groovy/Matchers;", "", "()V", "Companion", "groovy"})
public class Matchers {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final long DATE_2000 = 949323600000L;

    public static final long getDATE_2000() {
        return Companion.getDATE_2000();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher regexp(@NotNull Pattern re, @Nullable String value) {
        return Companion.regexp(re, value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher regexp(@NotNull String regexp, @Nullable String value) {
        return Companion.regexp(regexp, value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher hexValue(@Nullable String value) {
        return Companion.hexValue(value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher identifier(@Nullable Object value) {
        return Companion.identifier(value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher ipAddress(@Nullable String value) {
        return Companion.ipAddress(value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher numeric(@Nullable Number value) {
        return Companion.numeric(value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher decimal(@Nullable Number value) {
        return Companion.decimal(value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher integer(@Nullable Long value) {
        return Companion.integer(value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher datetime(@NotNull String pattern, @Nullable String value) {
        return Companion.datetime(pattern, value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher time(@NotNull String pattern, @Nullable String value) {
        return Companion.time(pattern, value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher timeExpression(@NotNull String expression, @NotNull String pattern) {
        return Companion.timeExpression(expression, pattern);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher date(@NotNull String pattern, @Nullable String value) {
        return Companion.date(pattern, value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher dateExpression(@NotNull String expression, @NotNull String pattern) {
        return Companion.dateExpression(expression, pattern);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher uuid(@Nullable String value) {
        return Companion.uuid(value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher string(@Nullable String value) {
        return Companion.string(value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher bool(@Nullable Boolean value) {
        return Companion.bool(value);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher eachLike(int numberExamples, @NotNull Object arg) {
        return Companion.eachLike(numberExamples, arg);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher maxLike(int max, int numberExamples, @NotNull Object arg) {
        return Companion.maxLike(max, numberExamples, arg);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher minLike(int min, int numberExamples, @NotNull Object arg) {
        return Companion.minLike(min, numberExamples, arg);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher minMaxLike(int min, int max, int numberExamples, @NotNull Object arg) {
        return Companion.minMaxLike(min, max, numberExamples, arg);
    }

    @JvmStatic
    @NotNull
    public static final Matcher equalTo(@NotNull Object value) {
        return Companion.equalTo(value);
    }

    @JvmStatic
    @NotNull
    public static final Matcher includesStr(@NotNull String value) {
        return Companion.includesStr(value);
    }

    @JvmStatic
    @NotNull
    public static final Matcher or(@Nullable Object example, Object ... values) {
        return Companion.or(example, values);
    }

    @JvmStatic
    @NotNull
    public static final Matcher and(@Nullable Object example, Object ... values) {
        return Companion.and(example, values);
    }

    @JvmStatic
    @NotNull
    public static final Matcher nullValue() {
        return Companion.nullValue();
    }

    @JvmStatic
    @NotNull
    public static final Matcher url(@NotNull String basePath, Object ... pathFragments) {
        return Companion.url(basePath, pathFragments);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher eachArrayLike(int numberExamples, @NotNull Object arg) {
        return Companion.eachArrayLike(numberExamples, arg);
    }

    @JvmStatic
    @NotNull
    public static final StatusCodeMatcher informationStatus() {
        return Companion.informationStatus();
    }

    @JvmStatic
    @NotNull
    public static final StatusCodeMatcher successStatus() {
        return Companion.successStatus();
    }

    @JvmStatic
    @NotNull
    public static final StatusCodeMatcher redirectStatus() {
        return Companion.redirectStatus();
    }

    @JvmStatic
    @NotNull
    public static final StatusCodeMatcher clientErrorStatus() {
        return Companion.clientErrorStatus();
    }

    @JvmStatic
    @NotNull
    public static final StatusCodeMatcher serverErrorStatus() {
        return Companion.serverErrorStatus();
    }

    @JvmStatic
    @NotNull
    public static final StatusCodeMatcher nonErrorStatus() {
        return Companion.nonErrorStatus();
    }

    @JvmStatic
    @NotNull
    public static final StatusCodeMatcher errorStatus() {
        return Companion.errorStatus();
    }

    @JvmStatic
    @NotNull
    public static final StatusCodeMatcher statusCodes(@NotNull List<Integer> statusCodes) {
        return Companion.statusCodes(statusCodes);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher regexp(@NotNull Pattern re) {
        return Companion.regexp(re);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher regexp(@NotNull String regexp) {
        return Companion.regexp(regexp);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher hexValue() {
        return Companion.hexValue();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher identifier() {
        return Companion.identifier();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher ipAddress() {
        return Companion.ipAddress();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher numeric() {
        return Companion.numeric();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher decimal() {
        return Companion.decimal();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher integer() {
        return Companion.integer();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher datetime(@NotNull String pattern) {
        return Companion.datetime(pattern);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher datetime() {
        return Companion.datetime();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher time(@NotNull String pattern) {
        return Companion.time(pattern);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher time() {
        return Companion.time();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher timeExpression(@NotNull String expression) {
        return Companion.timeExpression(expression);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher date(@NotNull String pattern) {
        return Companion.date(pattern);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher date() {
        return Companion.date();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher dateExpression(@NotNull String expression) {
        return Companion.dateExpression(expression);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher uuid() {
        return Companion.uuid();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher string() {
        return Companion.string();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher bool() {
        return Companion.bool();
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher eachLike(@NotNull Object arg) {
        return Companion.eachLike(arg);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher maxLike(int max, @NotNull Object arg) {
        return Companion.maxLike(max, arg);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher minLike(int min, @NotNull Object arg) {
        return Companion.minLike(min, arg);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher minMaxLike(int min, int max, @NotNull Object arg) {
        return Companion.minMaxLike(min, max, arg);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Matcher eachArrayLike(@NotNull Object arg) {
        return Companion.eachArrayLike(arg);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\r\"\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\u000f\u001a\u00020\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\u001e\u0010\u0015\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u0007J\u001a\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0007J\u001e\u0010\u001a\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u0007J\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u001c\u001a\u00020\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u001dH\u0007J\u001a\u0010\u001e\u001a\u00020\t2\b\b\u0002\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bH\u0007J\u001a\u0010\"\u001a\u00020\t2\b\b\u0002\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bH\u0007J\u0010\u0010#\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000bH\u0007J\b\u0010$\u001a\u00020\u0014H\u0007J\u0014\u0010%\u001a\u00020\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u0007J\u0014\u0010&\u001a\u00020\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0007J\u0010\u0010'\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0017H\u0007J\b\u0010(\u001a\u00020\u0014H\u0007J\u0019\u0010)\u001a\u00020\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u0010*J\u0014\u0010+\u001a\u00020\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u0007J\"\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020 2\b\b\u0002\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bH\u0007J\"\u0010.\u001a\u00020\t2\u0006\u0010/\u001a\u00020 2\b\b\u0002\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bH\u0007J*\u00100\u001a\u00020\t2\u0006\u0010/\u001a\u00020 2\u0006\u0010-\u001a\u00020 2\b\b\u0002\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000bH\u0007J\b\u00101\u001a\u00020\u0014H\u0007J\b\u00102\u001a\u00020\tH\u0007J\u0014\u00103\u001a\u00020\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u001dH\u0007J+\u00104\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\r\"\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010\u000eJ\b\u00105\u001a\u00020\u0014H\u0007J\u001c\u00106\u001a\u00020\t2\u0006\u00107\u001a\u0002082\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u0007J\u001c\u00106\u001a\u00020\t2\u0006\u00106\u001a\u00020\u00172\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u0007J\b\u00109\u001a\u00020\u0014H\u0007J\u0016\u0010:\u001a\u00020\u00142\f\u0010:\u001a\b\u0012\u0004\u0012\u00020 0;H\u0007J\u0014\u0010<\u001a\u00020\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u0007J\b\u0010=\u001a\u00020\u0014H\u0007J\u001e\u0010>\u001a\u00020\t2\b\b\u0002\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u0007J\u001a\u0010?\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0007J)\u0010@\u001a\u00020\t2\u0006\u0010A\u001a\u00020\u00172\u0012\u0010B\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\r\"\u00020\u000bH\u0007\u00a2\u0006\u0002\u0010CJ\u0014\u0010D\u001a\u00020\t2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0017H\u0007J\u001c\u0010E\u001a\u00020F2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u001c\u0010G\u001a\u00020F2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006H"}, d2={"Lau/com/dius/pact/consumer/groovy/Matchers$Companion;", "Lio/github/oshai/kotlinlogging/KLogging;", "()V", "DATE_2000", "", "getDATE_2000$annotations", "getDATE_2000", "()J", "and", "Lau/com/dius/pact/consumer/groovy/Matcher;", "example", "", "values", "", "(Ljava/lang/Object;[Ljava/lang/Object;)Lau/com/dius/pact/consumer/groovy/Matcher;", "bool", "value", "", "(Ljava/lang/Boolean;)Lau/com/dius/pact/consumer/groovy/Matcher;", "clientErrorStatus", "Lau/com/dius/pact/consumer/groovy/StatusCodeMatcher;", "date", "pattern", "", "dateExpression", "expression", "datetime", "datetimeExpression", "decimal", "", "eachArrayLike", "numberExamples", "", "arg", "eachLike", "equalTo", "errorStatus", "hexValue", "identifier", "includesStr", "informationStatus", "integer", "(Ljava/lang/Long;)Lau/com/dius/pact/consumer/groovy/Matcher;", "ipAddress", "maxLike", "max", "minLike", "min", "minMaxLike", "nonErrorStatus", "nullValue", "numeric", "or", "redirectStatus", "regexp", "re", "Ljava/util/regex/Pattern;", "serverErrorStatus", "statusCodes", "", "string", "successStatus", "time", "timeExpression", "url", "basePath", "pathFragments", "(Ljava/lang/String;[Ljava/lang/Object;)Lau/com/dius/pact/consumer/groovy/Matcher;", "uuid", "validateDateTimeValue", "", "validateTimeValue", "groovy"})
    @SourceDebugExtension(value={"SMAP\nMatchers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matchers.kt\nau/com/dius/pact/consumer/groovy/Matchers$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,703:1\n11335#2:704\n11670#2,3:705\n11335#2:708\n11670#2,3:709\n*S KotlinDebug\n*F\n+ 1 Matchers.kt\nau/com/dius/pact/consumer/groovy/Matchers$Companion\n*L\n604#1:704\n604#1:705,3\n619#1:708\n619#1:709,3\n*E\n"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public final long getDATE_2000() {
            return DATE_2000;
        }

        @JvmStatic
        public static /* synthetic */ void getDATE_2000$annotations() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher regexp(@NotNull Pattern re, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)re, (String)"re");
            String string = re.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"re.toString()");
            return this.regexp(string, value);
        }

        public static /* synthetic */ Matcher regexp$default(Companion companion, Pattern pattern, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.regexp(pattern, string);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher regexp(@NotNull String regexp, @Nullable String value) {
            CharSequence charSequence;
            Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
            if (value != null && !new Regex(regexp).matches(charSequence = (CharSequence)value)) {
                throw new InvalidMatcherException("Example \"" + value + "\" does not match regular expression \"" + regexp + "\"");
            }
            return new RegexpMatcher(regexp, value);
        }

        public static /* synthetic */ Matcher regexp$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.regexp(string, string2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher hexValue(@Nullable String value) {
            CharSequence charSequence;
            if (value != null && !new Regex("[0-9a-fA-F]+").matches(charSequence = (CharSequence)value)) {
                throw new InvalidMatcherException("Example \"" + value + "\" is not a hexadecimal value");
            }
            return new HexadecimalMatcher(value);
        }

        public static /* synthetic */ Matcher hexValue$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            return companion.hexValue(string);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher identifier(@Nullable Object value) {
            Object object = value;
            if (object == null) {
                object = 12345678;
            }
            return new TypeMatcher(object, "integer", (Generator)(value == null ? new RandomIntGenerator(0, Integer.MAX_VALUE) : null));
        }

        public static /* synthetic */ Matcher identifier$default(Companion companion, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                object = null;
            }
            return companion.identifier(object);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher ipAddress(@Nullable String value) {
            CharSequence charSequence;
            if (value != null && !new Regex("(\\d{1,3}\\.)+\\d{1,3}").matches(charSequence = (CharSequence)value)) {
                throw new InvalidMatcherException("Example \"" + value + "\" is not an ip address");
            }
            String string = value;
            if (string == null) {
                string = "127.0.0.1";
            }
            return new RegexpMatcher("(\\d{1,3}\\.)+\\d{1,3}", string);
        }

        public static /* synthetic */ Matcher ipAddress$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            return companion.ipAddress(string);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher numeric(@Nullable Number value) {
            Number number = value;
            if (number == null) {
                number = 100;
            }
            return new TypeMatcher((Object)number, "number", (Generator)(value == null ? new RandomDecimalGenerator(6) : null));
        }

        public static /* synthetic */ Matcher numeric$default(Companion companion, Number number, int n, Object object) {
            if ((n & 1) != 0) {
                number = null;
            }
            return companion.numeric(number);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher decimal(@Nullable Number value) {
            Number number = value;
            if (number == null) {
                number = 100.0;
            }
            return new TypeMatcher((Object)number, "decimal", (Generator)(value == null ? new RandomDecimalGenerator(6) : null));
        }

        public static /* synthetic */ Matcher decimal$default(Companion companion, Number number, int n, Object object) {
            if ((n & 1) != 0) {
                number = null;
            }
            return companion.decimal(number);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher integer(@Nullable Long value) {
            Long l = value;
            return new TypeMatcher((Object)(l != null ? l : 100L), "integer", (Generator)(value == null ? new RandomIntGenerator(0, Integer.MAX_VALUE) : null));
        }

        public static /* synthetic */ Matcher integer$default(Companion companion, Long l, int n, Object object) {
            if ((n & 1) != 0) {
                l = null;
            }
            return companion.integer(l);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher datetime(@NotNull String pattern, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.validateDateTimeValue(value, pattern);
            return new DateTimeMatcher(pattern, value, null, 4, null);
        }

        public static /* synthetic */ Matcher datetime$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                String string3 = DateFormatUtils.ISO_DATETIME_FORMAT.getPattern();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ISO_DATETIME_FORMAT.pattern");
                string = string3;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.datetime(string, string2);
        }

        @NotNull
        public final Matcher datetimeExpression(@NotNull String expression, @NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return new DateTimeMatcher(pattern, null, expression);
        }

        public static /* synthetic */ Matcher datetimeExpression$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                String string3 = DateFormatUtils.ISO_DATETIME_FORMAT.getPattern();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ISO_DATETIME_FORMAT.pattern");
                string2 = string3;
            }
            return companion.datetimeExpression(string, string2);
        }

        private final void validateTimeValue(String value, String pattern) {
            if (KotlinLanguageSupportKt.isNotEmpty((String)value) && KotlinLanguageSupportKt.isNotEmpty((String)pattern)) {
                try {
                    String[] stringArray = new String[]{pattern};
                    DateUtils.parseDateStrictly((String)value, (String[])stringArray);
                }
                catch (ParseException e) {
                    throw new InvalidMatcherException("Example \"" + value + "\" does not match pattern \"" + pattern + "\"");
                }
            }
        }

        private final void validateDateTimeValue(String value, String pattern) {
            if (KotlinLanguageSupportKt.isNotEmpty((String)value) && KotlinLanguageSupportKt.isNotEmpty((String)pattern)) {
                try {
                    ZonedDateTime.parse(value, DateTimeFormatter.ofPattern(pattern).withZone(ZoneId.systemDefault()));
                }
                catch (DateTimeParseException e) {
                    this.getLogger().error((Throwable)e, (Function0)new Function0<Object>(value, pattern){
                        final /* synthetic */ String $value;
                        final /* synthetic */ String $pattern;
                        {
                            this.$value = $value;
                            this.$pattern = $pattern;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Example \"" + this.$value + "\" does not match pattern \"" + this.$pattern + "\"";
                        }
                    });
                    throw new InvalidMatcherException("Example \"" + value + "\" does not match pattern \"" + pattern + "\"");
                }
            }
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher time(@NotNull String pattern, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.validateTimeValue(value, pattern);
            return new TimeMatcher(pattern, value, null, 4, null);
        }

        public static /* synthetic */ Matcher time$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                String string3 = DateFormatUtils.ISO_TIME_FORMAT.getPattern();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ISO_TIME_FORMAT.pattern");
                string = string3;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.time(string, string2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher timeExpression(@NotNull String expression, @NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return new TimeMatcher(pattern, null, expression);
        }

        public static /* synthetic */ Matcher timeExpression$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                String string3 = DateFormatUtils.ISO_TIME_FORMAT.getPattern();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ISO_TIME_FORMAT.pattern");
                string2 = string3;
            }
            return companion.timeExpression(string, string2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher date(@NotNull String pattern, @Nullable String value) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            this.validateTimeValue(value, pattern);
            return new DateMatcher(pattern, value, null, 4, null);
        }

        public static /* synthetic */ Matcher date$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                String string3 = DateFormatUtils.ISO_DATE_FORMAT.getPattern();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ISO_DATE_FORMAT.pattern");
                string = string3;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.date(string, string2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher dateExpression(@NotNull String expression, @NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return new DateMatcher(pattern, null, expression);
        }

        public static /* synthetic */ Matcher dateExpression$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                String string3 = DateFormatUtils.ISO_DATE_FORMAT.getPattern();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ISO_DATE_FORMAT.pattern");
                string2 = string3;
            }
            return companion.dateExpression(string, string2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher uuid(@Nullable String value) {
            CharSequence charSequence;
            if (value != null && !new Regex("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}").matches(charSequence = (CharSequence)value)) {
                throw new InvalidMatcherException("Example \"" + value + "\" is not a UUID");
            }
            return new UuidMatcher(value);
        }

        public static /* synthetic */ Matcher uuid$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            return companion.uuid(string);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher string(@Nullable String value) {
            return value != null ? (Matcher)new TypeMatcher((Object)value, null, null, 6, null) : (Matcher)new TypeMatcher((Object)"string", null, (Generator)new RandomStringGenerator(10), 2, null);
        }

        public static /* synthetic */ Matcher string$default(Companion companion, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = null;
            }
            return companion.string(string);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher bool(@Nullable Boolean value) {
            return value != null ? (Matcher)new TypeMatcher((Object)value, "boolean", null, 4, null) : (Matcher)new TypeMatcher((Object)true, "boolean", (Generator)RandomBooleanGenerator.INSTANCE);
        }

        public static /* synthetic */ Matcher bool$default(Companion companion, Boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = null;
            }
            return companion.bool(bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher eachLike(int numberExamples, @NotNull Object arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            return new EachLikeMatcher(arg, numberExamples);
        }

        public static /* synthetic */ Matcher eachLike$default(Companion companion, int n, Object object, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return companion.eachLike(n, object);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher maxLike(int max, int numberExamples, @NotNull Object arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            if (numberExamples > max) {
                throw new InvalidMatcherException("The number of examples you have specified (" + numberExamples + ") is greater than the maximum (" + max + ")");
            }
            return new MaxLikeMatcher(max, arg, numberExamples);
        }

        public static /* synthetic */ Matcher maxLike$default(Companion companion, int n, int n2, Object object, int n3, Object object2) {
            if ((n3 & 2) != 0) {
                n2 = 1;
            }
            return companion.maxLike(n, n2, object);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher minLike(int min, int numberExamples, @NotNull Object arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            boolean bl = 2 <= numberExamples ? numberExamples < min : false;
            if (bl) {
                throw new InvalidMatcherException("The number of examples you have specified (" + numberExamples + ") is less than the minimum (" + min + ")");
            }
            return new MinLikeMatcher(min, arg, numberExamples);
        }

        public static /* synthetic */ Matcher minLike$default(Companion companion, int n, int n2, Object object, int n3, Object object2) {
            if ((n3 & 2) != 0) {
                n2 = 1;
            }
            return companion.minLike(n, n2, object);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher minMaxLike(int min, int max, int numberExamples, @NotNull Object arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            if (min > max) {
                throw new InvalidMatcherException("The minimum you have specified (" + min + ") is greater than the maximum (" + max + ")");
            }
            if (numberExamples > 1 && numberExamples < min) {
                throw new InvalidMatcherException("The number of examples you have specified (" + numberExamples + ") is less than the minimum (" + min + ")");
            }
            if (numberExamples > 1 && numberExamples > max) {
                throw new InvalidMatcherException("The number of examples you have specified (" + numberExamples + ") is greater than the maximum (" + max + ")");
            }
            return new MinMaxLikeMatcher(min, max, arg, numberExamples);
        }

        public static /* synthetic */ Matcher minMaxLike$default(Companion companion, int n, int n2, int n3, Object object, int n4, Object object2) {
            if ((n4 & 4) != 0) {
                n3 = 1;
            }
            return companion.minMaxLike(n, n2, n3, object);
        }

        @JvmStatic
        @NotNull
        public final Matcher equalTo(@NotNull Object value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new EqualsMatcher(value);
        }

        @JvmStatic
        @NotNull
        public final Matcher includesStr(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new IncludeMatcher(value);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Matcher or(@Nullable Object example, Object ... values) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            Object[] objectArray = values;
            Object object = example;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it instanceof Matcher ? (Matcher)it : (Matcher)new EqualsMatcher(it));
            }
            List list = (List)destination$iv$iv;
            Object object2 = object;
            return new OrMatcher(object2, list);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Matcher and(@Nullable Object example, Object ... values) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)values, (String)"values");
            Object[] objectArray = values;
            Object object = example;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it instanceof Matcher ? (Matcher)it : (Matcher)new EqualsMatcher(it));
            }
            List list = (List)destination$iv$iv;
            Object object2 = object;
            return new AndMatcher(object2, list);
        }

        @JvmStatic
        @NotNull
        public final Matcher nullValue() {
            return new NullMatcher();
        }

        @JvmStatic
        @NotNull
        public final Matcher url(@NotNull String basePath, Object ... pathFragments) {
            Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
            Intrinsics.checkNotNullParameter((Object)pathFragments, (String)"pathFragments");
            return new UrlMatcher(basePath, ArraysKt.toList((Object[])pathFragments), null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher eachArrayLike(int numberExamples, @NotNull Object arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            return new EachLikeMatcher((Object)new EachLikeMatcher(arg, numberExamples), numberExamples);
        }

        public static /* synthetic */ Matcher eachArrayLike$default(Companion companion, int n, Object object, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            return companion.eachArrayLike(n, object);
        }

        @JvmStatic
        @NotNull
        public final StatusCodeMatcher informationStatus() {
            return new StatusCodeMatcher(HttpStatus.Information, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final StatusCodeMatcher successStatus() {
            return new StatusCodeMatcher(HttpStatus.Success, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final StatusCodeMatcher redirectStatus() {
            return new StatusCodeMatcher(HttpStatus.Redirect, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final StatusCodeMatcher clientErrorStatus() {
            return new StatusCodeMatcher(HttpStatus.ClientError, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final StatusCodeMatcher serverErrorStatus() {
            return new StatusCodeMatcher(HttpStatus.ServerError, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final StatusCodeMatcher nonErrorStatus() {
            return new StatusCodeMatcher(HttpStatus.NonError, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final StatusCodeMatcher errorStatus() {
            return new StatusCodeMatcher(HttpStatus.Error, null, 2, null);
        }

        @JvmStatic
        @NotNull
        public final StatusCodeMatcher statusCodes(@NotNull List<Integer> statusCodes) {
            Intrinsics.checkNotNullParameter(statusCodes, (String)"statusCodes");
            return new StatusCodeMatcher(HttpStatus.StatusCodes, statusCodes);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher regexp(@NotNull Pattern re) {
            Intrinsics.checkNotNullParameter((Object)re, (String)"re");
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.regexp$default(this, re, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher regexp(@NotNull String regexp) {
            Intrinsics.checkNotNullParameter((Object)regexp, (String)"regexp");
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.regexp$default(this, regexp, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher hexValue() {
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.hexValue$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher identifier() {
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.identifier$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher ipAddress() {
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.ipAddress$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher numeric() {
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.numeric$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher decimal() {
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.decimal$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher integer() {
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.integer$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher datetime(@NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.datetime$default(this, pattern, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher datetime() {
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.datetime$default(this, null, null, 3, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher time(@NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.time$default(this, pattern, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher time() {
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.time$default(this, null, null, 3, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher timeExpression(@NotNull String expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.timeExpression$default(this, expression, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher date(@NotNull String pattern) {
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.date$default(this, pattern, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher date() {
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.date$default(this, null, null, 3, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher dateExpression(@NotNull String expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.dateExpression$default(this, expression, null, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher uuid() {
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.uuid$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher string() {
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.string$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher bool() {
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.bool$default(this, null, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher eachLike(@NotNull Object arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.eachLike$default(this, 0, arg, 1, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher maxLike(int max, @NotNull Object arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.maxLike$default(this, max, 0, arg, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher minLike(int min, @NotNull Object arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.minLike$default(this, min, 0, arg, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher minMaxLike(int min, int max, @NotNull Object arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.minMaxLike$default(this, min, max, 0, arg, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Matcher eachArrayLike(@NotNull Object arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            return au.com.dius.pact.consumer.groovy.Matchers$Companion.eachArrayLike$default(this, 0, arg, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

