/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.consumer.junit;

import au.com.dius.pact.consumer.ConsumerPactBuilder;
import au.com.dius.pact.consumer.ConsumerPactRunnerKt;
import au.com.dius.pact.consumer.MockServer;
import au.com.dius.pact.consumer.PactMismatchesException;
import au.com.dius.pact.consumer.PactTestExecutionContext;
import au.com.dius.pact.consumer.PactVerificationResult;
import au.com.dius.pact.consumer.dsl.PactDslWithProvider;
import au.com.dius.pact.consumer.model.MockProviderConfig;
import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.PactSpecVersion;
import au.com.dius.pact.core.model.RequestResponsePact;
import au.com.dius.pact.core.support.MetricEvent;
import au.com.dius.pact.core.support.Metrics;
import java.io.IOException;
import org.junit.Test;

public abstract class ConsumerPactTest {
    protected abstract RequestResponsePact createPact(PactDslWithProvider var1);

    protected abstract String providerName();

    protected abstract String consumerName();

    protected abstract void runTest(MockServer var1, PactTestExecutionContext var2) throws IOException;

    @Test
    public void testPact() throws Throwable {
        RequestResponsePact pact = this.createPact(ConsumerPactBuilder.consumer((String)this.consumerName()).hasPactWith(this.providerName()));
        MockProviderConfig config = MockProviderConfig.createDefault((PactSpecVersion)this.getSpecificationVersion());
        PactVerificationResult result = ConsumerPactRunnerKt.runConsumerTest((BasePact)pact, (MockProviderConfig)config, (mockServer, context) -> {
            this.runTest(mockServer, context);
            return null;
        });
        Metrics.INSTANCE.sendMetrics((MetricEvent)new MetricEvent.ConsumerTestRun(pact.getInteractions().size(), "junit"));
        if (!(result instanceof PactVerificationResult.Ok)) {
            if (result instanceof PactVerificationResult.Error) {
                PactVerificationResult.Error error = (PactVerificationResult.Error)result;
                if (!(error.getMockServerState() instanceof PactVerificationResult.Ok)) {
                    throw new AssertionError("Pact Test function failed with an exception, possibly due to " + String.valueOf(error.getMockServerState()), ((PactVerificationResult.Error)result).getError());
                }
                throw new AssertionError("Pact Test function failed with an exception: " + error.getError().getMessage(), error.getError());
            }
            throw new PactMismatchesException(result);
        }
    }

    protected PactSpecVersion getSpecificationVersion() {
        return PactSpecVersion.V3;
    }
}

