/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.server;

import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.model.RequestResponseInteraction;
import au.com.dius.pact.core.model.Response;
import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.PactBrokerClientConfig;
import au.com.dius.pact.core.pactbroker.RequestFailedException;
import au.com.dius.pact.server.Config;
import au.com.dius.pact.server.JsonUtils$;
import au.com.dius.pact.server.ResponseUtils$;
import au.com.dius.pact.server.Result;
import au.com.dius.pact.server.StatefulMockProvider;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public final class Publish$
implements StrictLogging {
    public static Publish$ MODULE$;
    private final Logger logger;

    static {
        new Publish$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Result apply(Request request, Map<String, StatefulMockProvider<RequestResponseInteraction>> oldState, Config config) {
        Object jsonBody = JsonUtils$.MODULE$.parseJsonString(request.getBody().valueAsString());
        Option<String> consumer = this.getVarFromJson("consumer", jsonBody);
        Option<String> consumerVersion = this.getVarFromJson("consumerVersion", jsonBody);
        Option<String> provider = this.getVarFromJson("provider", jsonBody);
        Option<.colon.colon<String>> tags = this.getListFromJson("tags", jsonBody);
        Option<String> broker = this.getBrokerUrlFromConfig(config);
        Option<String> authToken = this.getVarFromConfig(config.authToken());
        Response response = new Response(500, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ResponseUtils$.MODULE$.CrossSiteHeaders()).asJava());
        response = broker.isDefined() ? (consumer.isDefined() && consumerVersion.isDefined() && provider.isDefined() ? this.publishPact((String)consumer.get(), (String)consumerVersion.get(), (String)provider.get(), (String)broker.get(), authToken, tags) : new Response(400, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ResponseUtils$.MODULE$.CrossSiteHeaders()).asJava(), Publish$.body$1())) : new Response(500, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ResponseUtils$.MODULE$.CrossSiteHeaders()).asJava(), Publish$.body$2());
        return new Result(response, oldState);
    }

    private Response publishPact(String consumer, String consumerVersion, String provider, String broker, Option<String> authToken, Option<.colon.colon<String>> tags) {
        Response response;
        block19: {
            BoxedUnit boxedUnit;
            BoxedUnit boxedUnit2;
            BoxedUnit boxedUnit3;
            BoxedUnit boxedUnit4;
            BoxedUnit boxedUnit5;
            BoxedUnit boxedUnit6;
            String fileName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ".json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{consumer, provider}));
            File pact = new File(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{System.getProperty("pact.rootDir", "target/pacts"), fileName})));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Publishing pact with following details: ");
                boxedUnit6 = BoxedUnit.UNIT;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Consumer: " + consumer);
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("ConsumerVersion: " + consumerVersion);
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Provider: " + provider);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Pact Broker: " + broker);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Tags: " + tags.getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            try {
                Map<String, Object> options = this.getOptions(authToken);
                PactBrokerClient brokerClient = new PactBrokerClient(broker, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(options).asJava(), new PactBrokerClientConfig());
                com.github.michaelbull.result.Result res = brokerClient.uploadPactFile(pact, consumerVersion, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)tags.getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).asJava());
                if (res.component2() == null) {
                    BoxedUnit boxedUnit7;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Pact successfully shared. deleting file..");
                        boxedUnit7 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit7 = BoxedUnit.UNIT;
                    }
                    this.removePact(pact);
                    response = new Response(200, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ResponseUtils$.MODULE$.CrossSiteHeaders()).asJava(), OptionalBody.body((byte[])((String)res.component1()).getBytes()));
                    break block19;
                }
                response = new Response(500, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ResponseUtils$.MODULE$.CrossSiteHeaders()).asJava(), OptionalBody.body((byte[])((Throwable)res.component2()).getLocalizedMessage().getBytes()));
            }
            catch (IOException e) {
                response = new Response(500, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ResponseUtils$.MODULE$.CrossSiteHeaders()).asJava(), OptionalBody.body((byte[])new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"error\": \"Got IO Exception while reading file. ", "\"}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()})).getBytes()));
            }
            catch (RequestFailedException e) {
                response = new Response(e.getStatus().getStatusCode(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ResponseUtils$.MODULE$.CrossSiteHeaders()).asJava(), OptionalBody.body((byte[])e.getBody().getBytes()));
            }
            catch (Throwable t) {
                response = new Response(500, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ResponseUtils$.MODULE$.CrossSiteHeaders()).asJava(), OptionalBody.body((byte[])t.getMessage().getBytes()));
            }
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> getOptions(Option<String> authToken) {
        void var2_2;
        block0: {
            Map options = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            if (!authToken.isDefined()) break block0;
            options = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"authentication"), JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bearer", (String)authToken.get()}))).asJava())}));
        }
        return var2_2;
    }

    private void removePact(File file) {
        block0: {
            if (!file.exists()) break block0;
            file.delete();
        }
    }

    private Option<String> getVarFromConfig(String variable) {
        return !variable.isEmpty() ? new Some((Object)variable) : None$.MODULE$;
    }

    public Option<String> getBrokerUrlFromConfig(Config config) {
        return !config.broker().isEmpty() && config.broker().startsWith("http") ? new Some((Object)config.broker()) : None$.MODULE$;
    }

    private Option<String> getVarFromJson(String variable, Object json) {
        Map map;
        Object object = json;
        Object object2 = object instanceof Map ? ((map = (Map)object).contains((Object)variable) ? new Some((Object)map.apply((Object)variable).toString()) : None$.MODULE$) : None$.MODULE$;
        return object2;
    }

    private Option<.colon.colon<String>> getListFromJson(String variable, Object json) {
        Map map;
        Object object = json;
        Object object2 = object instanceof Map ? ((map = (Map)object).contains((Object)variable) ? new Some((Object)((.colon.colon)map.apply((Object)variable))) : None$.MODULE$) : None$.MODULE$;
        return object2;
    }

    private static final String errorJson$1() {
        return "{\"error\": \"body should contain consumer, consumerVersion and provider.\"}";
    }

    private static final OptionalBody body$1() {
        return OptionalBody.body((byte[])Publish$.errorJson$1().getBytes());
    }

    private static final String errorJson$2() {
        return "{\"error\" : \"Broker url not correctly configured please run server with -b or --broker 'http://pact-broker.adomain.com' option\" }";
    }

    private static final OptionalBody body$2() {
        return OptionalBody.body((byte[])Publish$.errorJson$2().getBytes());
    }

    private Publish$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
    }
}

