/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junitsupport.loader;

import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.DirectorySource;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.provider.junitsupport.loader.PactFolder;
import au.com.dius.pact.provider.junitsupport.loader.PactFolderLoader;
import au.com.dius.pact.provider.junitsupport.loader.PactLoader;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\r\u0012\u0006\u0010\u0004\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u0005H\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0016J\u001c\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\b\u0010\u0014\u001a\u00020\nH\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lau/com/dius/pact/provider/junitsupport/loader/PactFolderLoader;", "I", "Lau/com/dius/pact/core/model/Interaction;", "Lau/com/dius/pact/provider/junitsupport/loader/PactLoader;", "path", "", "(Ljava/lang/String;)V", "pactFolder", "Lau/com/dius/pact/provider/junitsupport/loader/PactFolder;", "(Lau/com/dius/pact/provider/junitsupport/loader/PactFolder;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "pactSource", "Lau/com/dius/pact/core/model/DirectorySource;", "description", "getPactSource", "load", "", "Lau/com/dius/pact/core/model/Pact;", "providerName", "resolvePath", "provider"})
public final class PactFolderLoader<I extends Interaction>
implements PactLoader {
    private final DirectorySource<I> pactSource;
    private final File path;

    @Override
    @NotNull
    public String description() {
        return "Directory(" + this.pactSource.getDir() + ')';
    }

    @NotNull
    public List<Pact<I>> load(@NotNull String providerName) {
        Intrinsics.checkParameterIsNotNull((Object)providerName, (String)"providerName");
        boolean bl = false;
        List pacts = new ArrayList();
        File pactFolder = this.resolvePath();
        File[] files2 = pactFolder.listFiles(load.files.1.INSTANCE);
        if (files2 != null) {
            File[] fileArray = files2;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file;
                File file2 = file = fileArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                Pact pact2 = DefaultPactReader.INSTANCE.loadPact((Object)file2);
                if (!Intrinsics.areEqual((Object)pact2.getProvider().getName(), (Object)providerName)) continue;
                Pact pact3 = pact2;
                if (pact3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type au.com.dius.pact.core.model.Pact<I>");
                }
                pacts.add(pact3);
                this.pactSource.getPacts().put(file, pact2);
            }
        }
        return pacts;
    }

    @NotNull
    public DirectorySource<I> getPactSource() {
        return this.pactSource;
    }

    private final File resolvePath() {
        URL resourcePath = PactFolderLoader.class.getClassLoader().getResource(this.path.getPath());
        if (resourcePath == null) {
            return this.path;
        }
        return new File(URLDecoder.decode(resourcePath.getPath(), "UTF-8"));
    }

    public PactFolderLoader(@NotNull File path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.path = path;
        this.pactSource = new DirectorySource(this.path, null, 2, null);
    }

    public PactFolderLoader(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this(new File(path));
    }

    public PactFolderLoader(@NotNull PactFolder pactFolder) {
        Intrinsics.checkParameterIsNotNull((Object)pactFolder, (String)"pactFolder");
        this(pactFolder.value());
    }
}

