/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junitsupport.loader;

import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.DirectorySource;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.support.expressions.DataType;
import au.com.dius.pact.core.support.expressions.ExpressionParser;
import au.com.dius.pact.core.support.expressions.SystemPropertyResolver;
import au.com.dius.pact.core.support.expressions.ValueResolver;
import au.com.dius.pact.provider.junitsupport.loader.PactBrokerLoader;
import au.com.dius.pact.provider.junitsupport.loader.PactFolder;
import au.com.dius.pact.provider.junitsupport.loader.PactFolderLoader;
import au.com.dius.pact.provider.junitsupport.loader.PactLoader;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B/\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\b\u0002\u0010\u0006\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0016J\u001c\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0002J$\u0010\u0019\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0010\u0010\u0006\u001a\f\u0012\u0006\b\u0001\u0012\u00020\b\u0018\u00010\u0007H\u0002R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lau/com/dius/pact/provider/junitsupport/loader/PactFolderLoader;", "I", "Lau/com/dius/pact/core/model/Interaction;", "Lau/com/dius/pact/provider/junitsupport/loader/PactLoader;", "path", "", "valueResolverClass", "Lkotlin/reflect/KClass;", "Lau/com/dius/pact/core/support/expressions/ValueResolver;", "valueResolver", "(Ljava/lang/String;Lkotlin/reflect/KClass;Lau/com/dius/pact/core/support/expressions/ValueResolver;)V", "pactFolder", "Lau/com/dius/pact/provider/junitsupport/loader/PactFolder;", "(Lau/com/dius/pact/provider/junitsupport/loader/PactFolder;)V", "Ljava/io/File;", "(Ljava/io/File;)V", "pactSource", "Lau/com/dius/pact/core/model/DirectorySource;", "description", "getPactSource", "load", "", "Lau/com/dius/pact/core/model/Pact;", "providerName", "resolvePath", "setupValueResolver", "provider"})
public final class PactFolderLoader<I extends Interaction>
implements PactLoader {
    private final File path;
    private final DirectorySource<I> pactSource;

    @Override
    @NotNull
    public String description() {
        return "Directory(" + this.pactSource.getDir() + ')';
    }

    @NotNull
    public List<Pact<I>> load(@NotNull String providerName) {
        Intrinsics.checkParameterIsNotNull((Object)providerName, (String)"providerName");
        boolean bl = false;
        List pacts = new ArrayList();
        File pactFolder = this.resolvePath();
        File[] files2 = pactFolder.listFiles(load.files.1.INSTANCE);
        if (files2 != null) {
            File[] fileArray = files2;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File file;
                File file2 = file = fileArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                Pact pact2 = DefaultPactReader.INSTANCE.loadPact((Object)file2);
                if (!Intrinsics.areEqual((Object)pact2.getProvider().getName(), (Object)providerName)) continue;
                Pact pact3 = pact2;
                if (pact3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type au.com.dius.pact.core.model.Pact<I>");
                }
                pacts.add(pact3);
                this.pactSource.getPacts().put(file, pact2);
            }
        }
        return pacts;
    }

    @NotNull
    public DirectorySource<I> getPactSource() {
        return this.pactSource;
    }

    private final File resolvePath() {
        URL resourcePath = Thread.currentThread().getContextClassLoader().getResource(this.path.getPath());
        if (resourcePath == null) {
            return this.path;
        }
        return new File(URLDecoder.decode(resourcePath.getPath(), "UTF-8"));
    }

    private final ValueResolver setupValueResolver(ValueResolver valueResolver, KClass<? extends ValueResolver> valueResolverClass) {
        ValueResolver resolver;
        ValueResolver valueResolver2 = valueResolver;
        if (valueResolver2 == null) {
            valueResolver2 = resolver = (ValueResolver)SystemPropertyResolver.INSTANCE;
        }
        if (valueResolverClass != null) {
            if (valueResolverClass.getObjectInstance() != null) {
                Object object = valueResolverClass.getObjectInstance();
                if (object == null) {
                    Intrinsics.throwNpe();
                }
                resolver = (ValueResolver)object;
            } else {
                try {
                    Object t = JvmClassMappingKt.getJavaClass(valueResolverClass).newInstance();
                    Intrinsics.checkExpressionValueIsNotNull(t, (String)"valueResolverClass.java.newInstance()");
                    resolver = (ValueResolver)t;
                }
                catch (InstantiationException e) {
                    PactBrokerLoader.Companion.getLogger().warn((Throwable)e, (Function0)setupValueResolver.1.INSTANCE);
                }
                catch (IllegalAccessException e) {
                    PactBrokerLoader.Companion.getLogger().warn((Throwable)e, (Function0)setupValueResolver.2.INSTANCE);
                }
            }
        }
        return resolver;
    }

    @JvmOverloads
    public PactFolderLoader(@NotNull String path, @Nullable KClass<? extends ValueResolver> valueResolverClass, @Nullable ValueResolver valueResolver) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        ValueResolver resolver = this.setupValueResolver(valueResolver, valueResolverClass);
        Object object = ExpressionParser.parseExpression$default((String)path, (DataType)DataType.STRING, (ValueResolver)resolver, (boolean)false, (int)8, null);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String interpolatedPath = (String)object;
        this.path = new File(interpolatedPath);
        this.pactSource = new DirectorySource(this.path, null, 2, null);
    }

    public /* synthetic */ PactFolderLoader(String string, KClass kClass, ValueResolver valueResolver, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            kClass = null;
        }
        if ((n & 4) != 0) {
            valueResolver = null;
        }
        this(string, (KClass<? extends ValueResolver>)kClass, valueResolver);
    }

    @JvmOverloads
    public PactFolderLoader(@NotNull String path, @Nullable KClass<? extends ValueResolver> valueResolverClass) {
        this(path, valueResolverClass, null, 4, null);
    }

    @JvmOverloads
    public PactFolderLoader(@NotNull String path) {
        this(path, null, null, 6, null);
    }

    public PactFolderLoader(@NotNull PactFolder pactFolder) {
        Intrinsics.checkParameterIsNotNull((Object)pactFolder, (String)"pactFolder");
        this(pactFolder.value(), Reflection.getOrCreateKotlinClass(pactFolder.valueResolver()), null, 4, null);
    }

    public PactFolderLoader(@NotNull File path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.path = path;
        this.pactSource = new DirectorySource(this.path, null, 2, null);
    }
}

