/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.reporters;

import au.com.dius.pact.core.matchers.BodyMismatch;
import au.com.dius.pact.core.matchers.BodyTypeMismatch;
import au.com.dius.pact.core.matchers.HeaderMismatch;
import au.com.dius.pact.core.model.BasePact;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.UrlPactSource;
import au.com.dius.pact.core.pactbroker.VerificationNotice;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.json.JsonValue;
import au.com.dius.pact.provider.BodyComparisonResult;
import au.com.dius.pact.provider.IConsumerInfo;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.IProviderVerifier;
import au.com.dius.pact.provider.VerificationResult;
import au.com.dius.pact.provider.reporters.BaseVerifierReporter;
import au.com.dius.pact.provider.reporters.Event;
import au.com.dius.pact.provider.reporters.MREvent;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ext.tables.TableBlock;
import com.vladsch.flexmark.ext.tables.TableBody;
import com.vladsch.flexmark.ext.tables.TableCell;
import com.vladsch.flexmark.ext.tables.TableRow;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.formatter.Formatter;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\"H\u0016J\u001e\u0010&\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010(\u0012\u0004\u0012\u00020\u00030'2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020-H\u0002J\u0016\u0010.\u001a\u00020\"2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0016J\u001c\u0010.\u001a\u00020\"2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020$02H\u0016J\u0010\u00103\u001a\u00020\"2\u0006\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020\"H\u0016J\b\u00107\u001a\u00020\"H\u0002J\b\u00108\u001a\u00020\"H\u0016J&\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020\u00032\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u0003002\u0006\u0010#\u001a\u00020$H\u0016J\u001e\u0010<\u001a\u00020\"2\u0006\u0010:\u001a\u00020\u00032\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u000300H\u0016J\b\u0010=\u001a\u00020\"H\u0016J\b\u0010>\u001a\u00020\"H\u0016J\u0010\u0010?\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010@\u001a\u00020\"2\u0006\u00104\u001a\u000205H\u0016J\"\u0010A\u001a\u00020\"2\u0006\u0010:\u001a\u00020\u00032\b\u0010;\u001a\u0004\u0018\u00010$2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010B\u001a\u00020\"H\u0016J\u001a\u0010B\u001a\u00020\"2\u0006\u0010:\u001a\u00020\u00032\b\u0010;\u001a\u0004\u0018\u00010$H\u0016J\u0018\u0010C\u001a\u00020\"2\u0006\u0010D\u001a\u00020(2\u0006\u0010E\u001a\u00020\u0003H\u0016J\b\u0010F\u001a\u00020GH\u0002J\u0010\u0010H\u001a\u00020\"2\u0006\u0010,\u001a\u00020IH\u0016J\u001a\u0010J\u001a\u00020\"2\u0006\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010$H\u0002J\"\u0010N\u001a\u00020\"2\u0006\u0010D\u001a\u00020(2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010O\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010P\u001a\u00020\"2\u0006\u0010D\u001a\u00020(2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020R00H\u0016J4\u0010S\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00104\u001a\u0002052\u0006\u0010T\u001a\u00020\u00032\n\u0010U\u001a\u00060Vj\u0002`W2\u0006\u0010X\u001a\u00020YH\u0016J\b\u0010Z\u001a\u00020\"H\u0016J(\u0010[\u001a\u00020\"2\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010]\u001a\u00020Y2\u0006\u0010^\u001a\u00020\u0003H\u0016J,\u0010_\u001a\u00020\"2\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010]\u001a\u00020Y2\n\u0010U\u001a\u00060Vj\u0002`W2\u0006\u0010X\u001a\u00020YH\u0016J(\u0010`\u001a\u00020\"2\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010D\u001a\u00020(2\u0006\u0010]\u001a\u00020YH\u0016J\u0018\u0010a\u001a\u00020\"2\u0006\u0010b\u001a\u00020c2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010d\u001a\u00020\"2\u0006\u0010b\u001a\u00020cH\u0016J\b\u0010e\u001a\u00020\"H\u0002J\"\u0010f\u001a\u00020\"2\b\u0010g\u001a\u0004\u0018\u00010h2\u0006\u0010D\u001a\u00020(2\u0006\u0010\\\u001a\u00020\u0003H\u0002J$\u0010i\u001a\u00020\"2\u0006\u00104\u001a\u0002052\n\u0010U\u001a\u00060Vj\u0002`W2\u0006\u0010X\u001a\u00020YH\u0016J\u0018\u0010j\u001a\u00020\"2\u0006\u0010k\u001a\u00020l2\u0006\u0010D\u001a\u00020(H\u0016J\u0018\u0010m\u001a\u00020\"2\u0006\u0010n\u001a\u00020o2\u0006\u0010D\u001a\u00020(H\u0016J\u0010\u0010p\u001a\u00020\"2\u0006\u0010q\u001a\u00020rH\u0016J\u0010\u0010s\u001a\u00020\"2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010t\u001a\u00020\"2\u0006\u0010u\u001a\u00020\u0003H\u0016J\b\u0010v\u001a\u00020\"H\u0016J \u0010w\u001a\u00020\"2\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010D\u001a\u00020(H\u0016J(\u0010x\u001a\u00020\"2\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010]\u001a\u00020Y2\u0006\u0010y\u001a\u00020$H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0005X\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u001cX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006\u0012"}, d2={"Lau/com/dius/pact/provider/reporters/MarkdownReporter;", "Lau/com/dius/pact/provider/reporters/BaseVerifierReporter;", "name", "", "reportDir", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "ext", "(Ljava/lang/String;Ljava/io/File;Ljava/lang/String;)V", "events", "", "Lau/com/dius/pact/provider/reporters/MREvent;", "getExt", "()Ljava/lang/String;", "setExt", "(Ljava/lang/String;)V", "getName", "setName", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "getReportDir", "()Ljava/io/File;", "setReportDir", "(Ljava/io/File;)V", "reportFile", "getReportFile", "setReportFile", "verifier", "Lau/com/dius/pact/provider/IProviderVerifier;", "getVerifier", "()Lau/com/dius/pact/provider/IProviderVerifier;", "setVerifier", "(Lau/com/dius/pact/provider/IProviderVerifier;)V", "bodyComparisonFailed", "", "comparison", "", "bodyComparisonOk", "consumerAndStatus", "Lkotlin/Pair;", "Lau/com/dius/pact/provider/IConsumerInfo;", "document", "Lcom/vladsch/flexmark/util/ast/Document;", "displayComments", "event", "Lau/com/dius/pact/provider/reporters/Event$DisplayInteractionComments;", "displayFailures", "failures", "", "Lau/com/dius/pact/provider/VerificationResult$Failed;", "", "errorHasNoAnnotatedMethodsFoundForInteraction", "interaction", "Lau/com/dius/pact/core/model/Interaction;", "finaliseReport", "generateReportFile", "generatesAMessageWhich", "headerComparisonFailed", "key", "value", "headerComparisonOk", "includesHeaders", "includesMetadata", "initialise", "interactionDescription", "metadataComparisonFailed", "metadataComparisonOk", "pactLoadFailureForConsumer", "consumer", "message", "parserOptions", "Lcom/vladsch/flexmark/util/data/MutableDataSet;", "receive", "Lau/com/dius/pact/provider/reporters/Event;", "renderDiff", "pw", "Ljava/io/PrintWriter;", "diff", "reportVerificationForConsumer", "tag", "reportVerificationNoticesForConsumer", "notices", "Lau/com/dius/pact/core/pactbroker/VerificationNotice;", "requestFailed", "interactionMessage", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "printStackTrace", "", "returnsAResponseWhich", "stateChangeRequestFailed", "state", "isSetup", "httpStatus", "stateChangeRequestFailedWithException", "stateForInteraction", "statusComparisonFailed", "status", "", "statusComparisonOk", "updateReportFile", "updateSummary", "table", "Lcom/vladsch/flexmark/util/ast/Node;", "verificationFailed", "verifyConsumerFromFile", "pactFile", "Lau/com/dius/pact/core/model/PactSource;", "verifyConsumerFromUrl", "pactUrl", "Lau/com/dius/pact/core/model/UrlPactSource;", "warnPactFileHasNoInteractions", "pact", "Lau/com/dius/pact/core/model/Pact;", "warnProviderHasNoConsumers", "warnPublishResultsSkippedBecauseDisabled", "envVar", "warnPublishResultsSkippedBecauseFiltered", "warnStateChangeIgnored", "warnStateChangeIgnoredDueToInvalidUrl", "stateChangeHandler"})
public final class MarkdownReporter
extends BaseVerifierReporter {
    public File reportFile;
    public IProviderVerifier verifier;
    private IProviderInfo provider;
    private final List<MREvent> events;
    @NotNull
    private String name;
    @Nullable
    private File reportDir;
    @NotNull
    private String ext;

    @Override
    @NotNull
    public File getReportFile() {
        File file = this.reportFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"reportFile");
        }
        return file;
    }

    @Override
    public void setReportFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.reportFile = file;
    }

    @Override
    @NotNull
    public IProviderVerifier getVerifier() {
        IProviderVerifier iProviderVerifier = this.verifier;
        if (iProviderVerifier == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"verifier");
        }
        return iProviderVerifier;
    }

    @Override
    public void setVerifier(@NotNull IProviderVerifier iProviderVerifier) {
        Intrinsics.checkNotNullParameter((Object)iProviderVerifier, (String)"<set-?>");
        this.verifier = iProviderVerifier;
    }

    @Override
    public void initialise(@NotNull IProviderInfo provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.provider = provider;
        File file = this.getReportDir();
        Intrinsics.checkNotNull((Object)file);
        file.mkdirs();
        this.setReportFile(new File(this.getReportDir(), provider.getName() + this.getExt()));
        this.events.clear();
    }

    @Override
    public void finaliseReport() {
        if (this.getReportFile().exists()) {
            this.updateReportFile();
        } else {
            this.generateReportFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateReportFile() {
        Closeable closeable = new PrintWriter(new BufferedWriter(new FileWriter(this.getReportFile(), true)));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            PrintWriter pw = (PrintWriter)closeable;
            boolean bl3 = false;
            StringBuilder stringBuilder = new StringBuilder().append("\n        # ");
            IProviderInfo iProviderInfo = this.provider;
            if (iProviderInfo == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"provider");
            }
            pw.write(StringsKt.trimIndent((String)stringBuilder.append(iProviderInfo.getName()).append("\n      \n        | Description    | Value |\n        | -------------- | ----- |\n        | Date Generated | ").append(ZonedDateTime.now()).append(" |\n        | Pact Version   | ").append(BasePact.Companion.lookupVersion()).append(" |\n        \n        ## Summary\n        \n        | Consumer    | Result |\n        | ----------- | ------ |\n        \n      ").toString()));
            IConsumerInfo consumer = null;
            String state = "OK";
            for (MREvent event : this.events) {
                switch (event.getType()) {
                    case "reportVerificationForConsumer": {
                        if (consumer != null) {
                            String pending = consumer.getPending() ? " [Pending]" : "";
                            pw.println("| " + consumer.getName() + pending + " | " + state + " |");
                        }
                        Object object = event.getData().get(0);
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type au.com.dius.pact.provider.IConsumerInfo");
                        }
                        consumer = (IConsumerInfo)object;
                        break;
                    }
                    case "stateChangeRequestFailedWithException": 
                    case "stateChangeRequestFailed": {
                        state = "State change call failed";
                        break;
                    }
                    case "requestFailed": {
                        state = "Request failed";
                        break;
                    }
                    case "headerComparisonFailed": 
                    case "bodyComparisonFailed": 
                    case "verificationFailed": 
                    case "metadataComparisonFailed": 
                    case "statusComparisonFailed": {
                        state = "Failed";
                    }
                }
            }
            if (consumer != null) {
                String pending = consumer.getPending() ? " [Pending]" : "";
                pw.println("| " + consumer.getName() + pending + " | " + state + " |");
            }
            pw.println();
            for (MREvent event : this.events) {
                pw.write(event.getContents());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void updateReportFile() {
        block21: {
            options = this.parserOptions();
            v0 = Parser.builder((DataHolder)((DataHolder)options)).build();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"Parser.builder(options).build()");
            parser = v0;
            v1 = parser.parseReader((Reader)new BufferedReader(new FileReader(this.getReportFile())));
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"parser.parseReader(Buffe\u2026(FileReader(reportFile)))");
            document = v1;
            var6_4 = this.consumerAndStatus(document);
            var4_5 = (IConsumerInfo)var6_4.component1();
            state = (String)var6_4.component2();
            var7_7 = this.events;
            var8_8 = 0;
            var9_13 = var7_7;
            var10_17 = false;
            for (T var12_25 : var9_13) {
                it = (MREvent)var12_25;
                $i$a$-find-MarkdownReporter$updateReportFile$header$1 = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"reportVerificationForConsumer")) continue;
                v2 = var12_25;
                break block21;
            }
            v2 = null;
        }
        if ((v3 = (MREvent)v2) == null || (v3 = v3.getContents()) == null) ** GOTO lbl-1000
        var7_7 = v3;
        var8_8 = 2;
        var9_14 = false;
        v4 = var7_7;
        if (v4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        v5 = v4.substring(var8_8);
        Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"(this as java.lang.String).substring(startIndex)");
        v3 = v5;
        if (v5 != null) {
            var7_7 = v3;
            var8_8 = 0;
            v6 = var7_7;
            if (v6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            v7 = StringsKt.trim((CharSequence)((CharSequence)v6)).toString();
        } else lbl-1000:
        // 2 sources

        {
            v7 = header = null;
        }
        if (consumer != null) {
            consumerSection = null;
            for (Node child : document.getChildren()) {
                if (child instanceof Heading && Intrinsics.areEqual((Object)((Heading)child).getText().unescape(), (Object)"Summary")) {
                    this.updateSummary(((Heading)child).getNext(), (IConsumerInfo)consumer, state);
                }
                if (!(child instanceof Heading)) continue;
                v8 = ((Heading)child).getText();
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"child.text");
                if (!StringsKt.contains$default((CharSequence)((CharSequence)v8), (CharSequence)String.valueOf(header), (boolean)false, (int)2, null)) continue;
                consumerSection = child;
            }
            if (consumerSection == null) {
                for (MREvent event : this.events) {
                    Intrinsics.checkNotNullExpressionValue((Object)parser.parseReader((Reader)new StringReader(event.getContents())), (String)"parser.parseReader(StringReader(event.contents))");
                    document.appendChild((Node)section);
                }
            } else {
                for (child = consumerSection.getNext(); child != null && !(child instanceof Heading); child = child.getNext()) {
                }
                if (child == null) {
                    for (MREvent event : this.events) {
                        if (!(Intrinsics.areEqual((Object)event.getType(), (Object)"reportVerificationForConsumer") ^ true)) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)parser.parseReader((Reader)new StringReader(event.getContents())), (String)"parser.parseReader(StringReader(event.contents))");
                        document.appendChild((Node)section);
                    }
                } else {
                    for (MREvent event : this.events) {
                        if (!(Intrinsics.areEqual((Object)event.getType(), (Object)"reportVerificationForConsumer") ^ true)) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)parser.parseReader((Reader)new StringReader(event.getContents())), (String)"parser.parseReader(StringReader(event.contents))");
                        child.insertBefore((Node)section);
                    }
                }
            }
        }
        v9 = Formatter.builder((DataHolder)((DataHolder)options)).build();
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"Formatter.builder(options).build()");
        formatter = v9;
        var8_12 = new BufferedWriter(new FileWriter(this.getReportFile()));
        var9_16 = false;
        var10_17 = false;
        var10_21 = null;
        try {
            w = (BufferedWriter)var8_12;
            $i$a$-use-MarkdownReporter$updateReportFile$1 = false;
            w.write(formatter.render((Node)document));
            var11_22 = Unit.INSTANCE;
        }
        catch (Throwable var11_23) {
            var10_21 = var11_23;
            throw var11_23;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var8_12, (Throwable)var10_21);
        }
    }

    private final Pair<IConsumerInfo, String> consumerAndStatus(Document document) {
        IConsumerInfo consumer = null;
        String state = "OK";
        for (MREvent event : this.events) {
            switch (event.getType()) {
                case "reportVerificationForConsumer": {
                    if (consumer != null) {
                        for (Node child : document.getChildren()) {
                            if (!(child instanceof Heading) || !Intrinsics.areEqual((Object)((Heading)child).getText().unescape(), (Object)"Summary")) continue;
                            this.updateSummary(((Heading)child).getNext(), consumer, state);
                        }
                    }
                    Object object = event.getData().get(0);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type au.com.dius.pact.provider.IConsumerInfo");
                    }
                    consumer = (IConsumerInfo)object;
                    break;
                }
                case "stateChangeRequestFailedWithException": 
                case "stateChangeRequestFailed": {
                    state = "State change call failed";
                    break;
                }
                case "requestFailed": {
                    state = "Request failed";
                    break;
                }
                case "headerComparisonFailed": 
                case "bodyComparisonFailed": 
                case "verificationFailed": 
                case "metadataComparisonFailed": 
                case "statusComparisonFailed": {
                    state = "Failed";
                    break;
                }
            }
        }
        return new Pair((Object)consumer, (Object)state);
    }

    private final MutableDataSet parserOptions() {
        MutableDataSet mutableDataSet = new MutableDataSet().set(Parser.EXTENSIONS, (Object)CollectionsKt.listOf((Object)TablesExtension.create())).set(TablesExtension.WITH_CAPTION, (Object)false).set(TablesExtension.COLUMN_SPANS, (Object)false).set(TablesExtension.MIN_HEADER_ROWS, (Object)1).set(TablesExtension.MAX_HEADER_ROWS, (Object)1).set(TablesExtension.APPEND_MISSING_COLUMNS, (Object)true).set(TablesExtension.DISCARD_EXTRA_COLUMNS, (Object)true).set(TablesExtension.HEADER_SEPARATOR_COLUMN_MATCH, (Object)true);
        Intrinsics.checkNotNullExpressionValue((Object)mutableDataSet, (String)"MutableDataSet().set(Par\u2026RATOR_COLUMN_MATCH, true)");
        MutableDataSet options = mutableDataSet;
        return options;
    }

    /*
     * Unable to fully structure code
     */
    private final void updateSummary(Node table, IConsumerInfo consumer, String state) {
        block8: {
            if (!(table instanceof TableBlock)) break block8;
            for (Node child : ((TableBlock)table).getChildren()) {
                block7: {
                    if (!(child instanceof TableBody)) continue;
                    v0 = ((TableBody)child).getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"child.children");
                    var7_7 = (Iterable)v0;
                    var8_8 = false;
                    var9_10 = var7_7;
                    var10_11 = false;
                    for (T var12_14 : var9_10) {
                        it = (Node)var12_14;
                        $i$a$-find-MarkdownReporter$updateSummary$consumerRow$1 = false;
                        if (!(it instanceof TableRow) || !(((TableRow)it).getFirstChild() instanceof TableCell)) ** GOTO lbl-1000
                        v1 = ((TableRow)it).getFirstChild();
                        if (v1 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.vladsch.flexmark.ext.tables.TableCell");
                        }
                        if (((TableCell)v1).getText().startsWith((CharSequence)consumer.getName())) {
                            v2 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v2 = false;
                        }
                        if (!v2) continue;
                        v3 = var12_14;
                        break block7;
                    }
                    v3 = null;
                }
                consumerRow = v3;
                if (consumerRow != null) {
                    v4 = consumerRow.getLastChild();
                    if (v4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.vladsch.flexmark.ext.tables.TableCell");
                    }
                    stateCell = (TableCell)v4;
                    stateCell.setText(BasedSequence.of((CharSequence)state));
                    continue;
                }
                row = new TableRow();
                pending = consumer.getPending() != false ? " [Pending]" : "";
                Intrinsics.checkNotNullExpressionValue((Object)BasedSequence.of((CharSequence)(consumer.getName() + pending)), (String)"BasedSequence.of(consumer.name + pending)");
                tableCell = new TableCell(tableCellText);
                tableCell.setText(tableCellText);
                row.appendChild((Node)tableCell);
                statusCell = new TableCell(BasedSequence.of((CharSequence)state));
                statusCell.setText(BasedSequence.of((CharSequence)state));
                row.appendChild((Node)statusCell);
                child.appendChild((Node)row);
            }
        }
    }

    @Override
    public void reportVerificationForConsumer(@NotNull IConsumerInfo consumer, @NotNull IProviderInfo provider, @Nullable String tag) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        StringBuilder output = new StringBuilder("## Verifying a pact between _" + consumer.getName() + '_');
        if (!StringsKt.contains$default((CharSequence)consumer.getName(), (CharSequence)provider.getName(), (boolean)false, (int)2, null)) {
            output.append(" and _" + provider.getName() + '_');
        }
        if (tag != null) {
            output.append(" for tag " + tag);
        }
        if (consumer.getPending()) {
            output.append(" [PENDING]");
        }
        output.append("\n\n");
        String string = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"output.toString()");
        this.events.add(new MREvent("reportVerificationForConsumer", string, CollectionsKt.listOf((Object[])new Object[]{consumer, provider, tag})));
    }

    @Override
    public void verifyConsumerFromUrl(@NotNull UrlPactSource pactUrl, @NotNull IConsumerInfo consumer) {
        Intrinsics.checkNotNullParameter((Object)pactUrl, (String)"pactUrl");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.events.add(new MREvent("verifyConsumerFromUrl", "From `" + pactUrl.description() + "`<br/>\n", CollectionsKt.listOf((Object[])new Object[]{pactUrl, consumer})));
    }

    @Override
    public void verifyConsumerFromFile(@NotNull PactSource pactFile, @NotNull IConsumerInfo consumer) {
        Intrinsics.checkNotNullParameter((Object)pactFile, (String)"pactFile");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.events.add(new MREvent("verifyConsumerFromFile", "From `" + pactFile.description() + "`<br/>\n", CollectionsKt.listOf((Object[])new Object[]{pactFile, consumer})));
    }

    @Override
    public void pactLoadFailureForConsumer(@NotNull IConsumerInfo consumer, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    @Override
    public void warnProviderHasNoConsumers(@NotNull IProviderInfo provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
    }

    @Override
    public void warnPactFileHasNoInteractions(@NotNull Pact pact2) {
        Intrinsics.checkNotNullParameter((Object)pact2, (String)"pact");
    }

    @Override
    public void interactionDescription(@NotNull Interaction interaction) {
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        this.events.add(new MREvent("interactionDescription", interaction.getDescription() + "  <br/>\n", CollectionsKt.listOf((Object)interaction)));
    }

    @Override
    public void stateForInteraction(@NotNull String state, @NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer, boolean isSetup) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.events.add(new MREvent("stateForInteraction", "Given **" + state + "**  <br/>\n", CollectionsKt.listOf((Object[])new Object[]{state, provider, consumer, isSetup})));
    }

    @Override
    public void warnStateChangeIgnored(@NotNull String state, @NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        this.events.add(new MREvent("warnStateChangeIgnored", "&nbsp;&nbsp;&nbsp;&nbsp;<span style='color: yellow'>WARNING: State Change ignored as there is no stateChange URL</span>  <br/>\n", CollectionsKt.listOf((Object[])new Object[]{state, provider, consumer})));
    }

    @Override
    public void stateChangeRequestFailedWithException(@NotNull String state, boolean isSetup, @NotNull Exception e, boolean printStackTrace) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.write("&nbsp;&nbsp;&nbsp;&nbsp;<span style='color: red'>State Change Request Failed - " + e.getMessage() + "</span>\n\n```\n");
        e.printStackTrace(pw);
        pw.write("\n```\n\n");
        pw.close();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        this.events.add(new MREvent("stateChangeRequestFailedWithException", string, CollectionsKt.listOf((Object[])new Serializable[]{(Serializable)((Object)state), Boolean.valueOf(isSetup), e, Boolean.valueOf(printStackTrace)})));
    }

    @Override
    public void stateChangeRequestFailed(@NotNull String state, @NotNull IProviderInfo provider, boolean isSetup, @NotNull String httpStatus) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)httpStatus, (String)"httpStatus");
        this.events.add(new MREvent("stateChangeRequestFailedWithException", "&nbsp;&nbsp;&nbsp;&nbsp;<span style='color: red'>State Change Request Failed - " + httpStatus + "</span>  \n", CollectionsKt.listOf((Object[])new Object[]{state, provider, isSetup, httpStatus})));
    }

    @Override
    public void warnStateChangeIgnoredDueToInvalidUrl(@NotNull String state, @NotNull IProviderInfo provider, boolean isSetup, @NotNull Object stateChangeHandler) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)stateChangeHandler, (String)"stateChangeHandler");
        this.events.add(new MREvent("warnStateChangeIgnoredDueToInvalidUrl", "&nbsp;&nbsp;&nbsp;&nbsp;<span style='color: yellow'>WARNING: State Change ignored as " + "there is no stateChange URL, received `" + stateChangeHandler + "`</span>  <br/>\n", CollectionsKt.listOf((Object[])new Object[]{state, provider, isSetup, stateChangeHandler})));
    }

    @Override
    public void requestFailed(@NotNull IProviderInfo provider, @NotNull Interaction interaction, @NotNull String interactionMessage, @NotNull Exception e, boolean printStackTrace) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter((Object)interactionMessage, (String)"interactionMessage");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.write("&nbsp;&nbsp;&nbsp;&nbsp;<span style='color: red'>Request Failed - " + e.getMessage() + "</span>\n\n```\n");
        e.printStackTrace(pw);
        pw.write("\n```\n\n");
        pw.close();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        this.events.add(new MREvent("requestFailed", string, CollectionsKt.listOf((Object[])new Object[]{provider, interaction, interactionMessage, e, printStackTrace})));
    }

    @Override
    public void returnsAResponseWhich() {
        boolean bl = false;
        this.events.add(new MREvent("returnsAResponseWhich", "&nbsp;&nbsp;returns a response which  <br/>\n", CollectionsKt.emptyList()));
    }

    @Override
    public void statusComparisonOk(int status) {
        this.events.add(new MREvent("statusComparisonOk", "&nbsp;&nbsp;&nbsp;&nbsp;has status code **" + status + "** " + "(<span style='color:green'>OK</span>)  <br/>\n", CollectionsKt.listOf((Object)status)));
    }

    @Override
    public void statusComparisonFailed(int status, @NotNull Object comparison) {
        Intrinsics.checkNotNullParameter((Object)comparison, (String)"comparison");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.write("&nbsp;&nbsp;&nbsp;&nbsp;has status code **" + status + "** " + "(<span style='color:red'>FAILED</span>)\n\n```\n");
        if (KotlinLanguageSupportKt.hasProperty((Object)comparison, (String)"message")) {
            KProperty1 kProperty1 = KotlinLanguageSupportKt.property((Object)comparison, (String)"message");
            pw.write(String.valueOf(kProperty1 != null ? kProperty1.get(comparison) : null));
        } else {
            pw.write(comparison.toString());
        }
        pw.write("\n```\n\n");
        pw.close();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        this.events.add(new MREvent("statusComparisonFailed", string, CollectionsKt.listOf((Object[])new Object[]{status, comparison})));
    }

    @Override
    public void includesHeaders() {
        boolean bl = false;
        this.events.add(new MREvent("includesHeaders", "&nbsp;&nbsp;&nbsp;&nbsp;includes headers  <br/>\n", CollectionsKt.emptyList()));
    }

    @Override
    public void headerComparisonOk(@NotNull String key, @NotNull List<String> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.events.add(new MREvent("headerComparisonOk", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\"**" + key + "**\" with value \"**" + value + "**\" " + "(<span style='color:green'>OK</span>)  <br/>\n", CollectionsKt.listOf((Object[])new Object[]{key, value})));
    }

    @Override
    public void headerComparisonFailed(@NotNull String key, @NotNull List<String> value, @NotNull Object comparison) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)comparison, (String)"comparison");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\"**" + key + "**\" with value \"**" + value + "**\" " + "(<span style='color:red'>FAILED</span>)  \n\n```\n");
        Object object = comparison;
        if (object instanceof List) {
            Iterable $this$forEach$iv = (Iterable)comparison;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Object t = it;
                if (t instanceof HeaderMismatch) {
                    pw.write(((HeaderMismatch)it).getMismatch());
                    continue;
                }
                pw.write(String.valueOf(it));
            }
        } else {
            pw.write(comparison.toString());
        }
        pw.write("\n```\n\n");
        pw.close();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        this.events.add(new MREvent("headerComparisonFailed", string, CollectionsKt.listOf((Object[])new Object[]{key, value, comparison})));
    }

    @Override
    public void bodyComparisonOk() {
        boolean bl = false;
        this.events.add(new MREvent("bodyComparisonOk", "&nbsp;&nbsp;&nbsp;&nbsp;has a matching body (<span style='color:green'>OK</span>)  <br/>\n", CollectionsKt.emptyList()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bodyComparisonFailed(@NotNull Object comparison) {
        Intrinsics.checkNotNullParameter((Object)comparison, (String)"comparison");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.write("&nbsp;&nbsp;&nbsp;&nbsp;has a matching body (<span style='color:red'>FAILED</span>)  \n\n");
        Object object = comparison;
        if (object instanceof Err) {
            Err cfr_ignored_0 = (Err)comparison;
            pw.write("```\n" + ((BodyTypeMismatch)((Err)comparison).getError()).description() + "\n```\n");
        } else if (object instanceof Ok) {
            Ok cfr_ignored_1 = (Ok)comparison;
            pw.write("| Path | Failure |\n");
            pw.write("| ---- | ------- |\n");
            Map<String, List<BodyMismatch>> $this$forEach$iv = ((BodyComparisonResult)((Ok)comparison).getValue()).getMismatches();
            boolean $i$f$forEach = false;
            Map<String, List<BodyMismatch>> map = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<String, List<BodyMismatch>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                void path;
                Map.Entry<String, List<BodyMismatch>> element$iv;
                Map.Entry<String, List<BodyMismatch>> $dstr$path$mismatches = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry<String, List<BodyMismatch>> entry = $dstr$path$mismatches;
                boolean bl3 = false;
                String string = entry.getKey();
                entry = $dstr$path$mismatches;
                bl3 = false;
                List<BodyMismatch> mismatches = entry.getValue();
                pw.write("|`" + (String)path + "`|" + ((BodyMismatch)CollectionsKt.first(mismatches)).description() + "|\n");
                if (mismatches.size() <= 1) continue;
                Iterable $this$forEach$iv2 = CollectionsKt.drop((Iterable)mismatches, (int)1);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    BodyMismatch it = (BodyMismatch)element$iv2;
                    boolean bl4 = false;
                    pw.write("||" + it.description() + "|\n");
                }
            }
            pw.write("\n\nDiff:\n\n");
            this.renderDiff(pw, ((BodyComparisonResult)((Ok)comparison).getValue()).getDiff());
            pw.write("\n\n");
        } else {
            pw.write("```\n" + comparison + "\n```\n");
        }
        pw.close();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        this.events.add(new MREvent("bodyComparisonFailed", string, CollectionsKt.listOf((Object)comparison)));
    }

    private final void renderDiff(PrintWriter pw, Object diff2) {
        pw.write("```diff\n");
        if (diff2 instanceof List) {
            pw.write(CollectionsKt.joinToString$default((Iterable)((Iterable)diff2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        } else {
            pw.write(String.valueOf(diff2));
        }
        pw.write("\n```\n");
    }

    @Override
    public void errorHasNoAnnotatedMethodsFoundForInteraction(@NotNull Interaction interaction) {
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
    }

    @Override
    public void verificationFailed(@NotNull Interaction interaction, @NotNull Exception e, boolean printStackTrace) {
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.write("&nbsp;&nbsp;&nbsp;&nbsp;<span style='color: red'>Verification Failed - " + e.getMessage() + "</span>\n\n```\n");
        e.printStackTrace(pw);
        pw.write("\n```\n\n");
        pw.close();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        this.events.add(new MREvent("verificationFailed", string, CollectionsKt.listOf((Object[])new Object[]{interaction, e, printStackTrace})));
    }

    @Override
    public void generatesAMessageWhich() {
        boolean bl = false;
        this.events.add(new MREvent("generatesAMessageWhich", "&nbsp;&nbsp;generates a message which  <br/>\n", CollectionsKt.emptyList()));
    }

    @Override
    public void displayFailures(@NotNull Map<String, ? extends Object> failures) {
        Intrinsics.checkNotNullParameter(failures, (String)"failures");
    }

    @Override
    public void displayFailures(@NotNull List<VerificationResult.Failed> failures) {
        Intrinsics.checkNotNullParameter(failures, (String)"failures");
    }

    @Override
    public void metadataComparisonFailed(@NotNull String key, @Nullable Object value, @NotNull Object comparison) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)comparison, (String)"comparison");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.write("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\"**" + key + "**\" with value \"**" + value + "**\" " + "(<span style='color:red'>FAILED</span>)  \n");
        pw.write("\n```\n" + comparison + "\n```\n\n");
        pw.close();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        this.events.add(new MREvent("metadataComparisonFailed", string, CollectionsKt.listOf((Object[])new Object[]{key, value, comparison})));
    }

    @Override
    public void includesMetadata() {
        boolean bl = false;
        this.events.add(new MREvent("includesMetadata", "&nbsp;&nbsp;&nbsp;&nbsp;includes metadata  <br/>\n", CollectionsKt.emptyList()));
    }

    @Override
    public void metadataComparisonOk(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.events.add(new MREvent("metadataComparisonOk", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\"**" + key + "**\" with value \"**" + value + "**\" " + "(<span style='color:green'>OK</span>)  <br/>\n", CollectionsKt.listOf((Object[])new Object[]{key, value})));
    }

    @Override
    public void metadataComparisonOk() {
        boolean bl = false;
        this.events.add(new MREvent("metadataComparisonOk", "&nbsp;&nbsp;&nbsp;&nbsp;has matching metadata (<span style='color:green'>OK</span>)<br/>\n", CollectionsKt.emptyList()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void reportVerificationNoticesForConsumer(@NotNull IConsumerInfo consumer, @NotNull IProviderInfo provider, @NotNull List<VerificationNotice> notices) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter(notices, (String)"notices");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.write("Notices:\n");
        Iterable $this$forEachIndexed$iv = notices;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void notice;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VerificationNotice verificationNotice = (VerificationNotice)item$iv;
            int i = n;
            boolean bl2 = false;
            pw.write(i + 1 + ". " + notice.getText() + '\n');
        }
        pw.write("\n");
        pw.close();
        String string = sw.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
        this.events.add(new MREvent("reportVerificationNoticesForConsumer", string, CollectionsKt.listOf((Object[])new Object[]{consumer, provider, notices})));
    }

    @Override
    public void warnPublishResultsSkippedBecauseFiltered() {
        boolean bl = false;
        this.events.add(new MREvent("warnPublishResultsSkippedBecauseFiltered", "NOTE: Skipping publishing of verification results as the interactions have been filtered<br/>\n", CollectionsKt.emptyList()));
    }

    @Override
    public void warnPublishResultsSkippedBecauseDisabled(@NotNull String envVar) {
        Intrinsics.checkNotNullParameter((Object)envVar, (String)"envVar");
        this.events.add(new MREvent("warnPublishResultsSkippedBecauseDisabled", "NOTE: Skipping publishing of verification results as it has been disabled (" + envVar + " is not 'true')<br/>\n", CollectionsKt.listOf((Object)envVar)));
    }

    @Override
    public void receive(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Event event2 = event;
        if (event2 instanceof Event.DisplayInteractionComments) {
            this.events.add(new MREvent("displayComments", this.displayComments((Event.DisplayInteractionComments)event), null, 4, null));
        } else {
            super.receive(event);
        }
    }

    private final String displayComments(Event.DisplayInteractionComments event) {
        JsonValue text;
        CharSequence charSequence;
        String test;
        StringBuilder result2 = new StringBuilder();
        JsonValue jsonValue = event.getComments().get("testname");
        String string = test = jsonValue != null ? jsonValue.asString() : null;
        if (test != null) {
            StringBuilder stringBuilder = result2;
            charSequence = "Test Name: " + test;
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append((String)charSequence);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringBuilder stringBuilder3 = stringBuilder2;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        }
        if ((text = event.getComments().get("text")) != null) {
            charSequence = result2;
            CharSequence charSequence2 = "Comments:";
            boolean bl = false;
            StringBuilder stringBuilder = ((StringBuilder)charSequence).append((String)charSequence2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringBuilder stringBuilder4 = stringBuilder;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            charSequence = text;
            if (charSequence instanceof JsonValue.Array) {
                for (JsonValue value : ((JsonValue.Array)text).getValues()) {
                    StringBuilder stringBuilder5;
                    stringBuilder4 = result2;
                    String string2 = "  * " + value.asString();
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append(string2), (String)"append(value)");
                    boolean bl5 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append('\\n')");
                }
            } else {
                charSequence2 = result2;
                String string3 = "    " + text;
                boolean bl6 = false;
                StringBuilder stringBuilder6 = ((StringBuilder)charSequence2).append(string3);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                StringBuilder stringBuilder7 = stringBuilder6;
                boolean bl7 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append('\\n')");
            }
        }
        String string4 = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"result.toString()");
        return string4;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Override
    @Nullable
    public File getReportDir() {
        return this.reportDir;
    }

    @Override
    public void setReportDir(@Nullable File file) {
        this.reportDir = file;
    }

    @Override
    @NotNull
    public String getExt() {
        return this.ext;
    }

    public void setExt(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.ext = string;
    }

    public MarkdownReporter(@NotNull String name, @Nullable File reportDir, @NotNull String ext) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)ext, (String)"ext");
        this.name = name;
        this.reportDir = reportDir;
        this.ext = ext;
        boolean bl = false;
        this.events = new ArrayList();
        if (this.getReportDir() == null) {
            this.setReportDir(new File(System.getProperty("user.dir")));
        }
        this.setReportFile(new File(this.getReportDir(), this.name + this.getExt()));
    }

    public MarkdownReporter(@NotNull String name, @Nullable File reportDir) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, reportDir, ".md");
    }
}

