/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.BrokerUrlSource;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.pactbroker.TestResult;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.core.support.Result;
import au.com.dius.pact.core.support.expressions.ValueResolver;
import au.com.dius.pact.provider.DefaultTestResultAccumulator;
import au.com.dius.pact.provider.DefaultVerificationReporter;
import au.com.dius.pact.provider.ProviderVersion;
import au.com.dius.pact.provider.TestResultAccumulator;
import au.com.dius.pact.provider.VerificationReporter;
import au.com.dius.pact.provider.VerificationResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u001a\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ(\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005JD\u0010#\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001f0$2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016JH\u0010#\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001f0$2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R)\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006("}, d2={"Lau/com/dius/pact/provider/DefaultTestResultAccumulator;", "Lau/com/dius/pact/provider/TestResultAccumulator;", "Lmu/KLogging;", "()V", "testResults", "", "", "Lau/com/dius/pact/core/pactbroker/TestResult;", "getTestResults", "()Ljava/util/Map;", "verificationReporter", "Lau/com/dius/pact/provider/VerificationReporter;", "getVerificationReporter", "()Lau/com/dius/pact/provider/VerificationReporter;", "setVerificationReporter", "(Lau/com/dius/pact/provider/VerificationReporter;)V", "calculateInteractionHash", "interaction", "Lau/com/dius/pact/core/model/Interaction;", "calculatePactHash", "pact", "Lau/com/dius/pact/core/model/Pact;", "source", "Lau/com/dius/pact/core/model/PactSource;", "clearTestResult", "", "lookupProviderBranch", "", "propertyResolver", "Lau/com/dius/pact/core/support/expressions/ValueResolver;", "lookupProviderTags", "", "lookupProviderVersion", "unverifiedInteractions", "results", "updateTestResult", "Lau/com/dius/pact/core/support/Result;", "", "testExecutionResult", "Lau/com/dius/pact/provider/VerificationResult;", "provider"})
@SourceDebugExtension(value={"SMAP\nTestResultAccumulator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestResultAccumulator.kt\nau/com/dius/pact/provider/DefaultTestResultAccumulator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,145:1\n1789#2,3:146\n2661#2,7:156\n1855#2,2:163\n1855#2,2:165\n1549#2:167\n1620#2,3:168\n766#2:171\n857#2,2:172\n766#2:174\n857#2,2:175\n361#3,7:149\n*S KotlinDebug\n*F\n+ 1 TestResultAccumulator.kt\nau/com/dius/pact/provider/DefaultTestResultAccumulator\n*L\n51#1:146,3\n86#1:156,7\n94#1:163,2\n103#1:165,2\n129#1:167\n129#1:168,3\n130#1:171\n130#1:172,2\n137#1:174\n137#1:175,2\n66#1:149,7\n*E\n"})
public final class DefaultTestResultAccumulator
extends KLogging
implements TestResultAccumulator {
    @NotNull
    public static final DefaultTestResultAccumulator INSTANCE = new DefaultTestResultAccumulator();
    @NotNull
    private static final Map<Integer, Map<Integer, TestResult>> testResults = new LinkedHashMap();
    @NotNull
    private static VerificationReporter verificationReporter = DefaultVerificationReporter.INSTANCE;

    private DefaultTestResultAccumulator() {
    }

    @NotNull
    public final Map<Integer, Map<Integer, TestResult>> getTestResults() {
        return testResults;
    }

    @NotNull
    public final VerificationReporter getVerificationReporter() {
        return verificationReporter;
    }

    public final void setVerificationReporter(@NotNull VerificationReporter verificationReporter) {
        Intrinsics.checkNotNullParameter((Object)verificationReporter, (String)"<set-?>");
        DefaultTestResultAccumulator.verificationReporter = verificationReporter;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result<Boolean, List<String>> updateTestResult(@NotNull Pact pact, @NotNull Interaction interaction, @NotNull List<? extends VerificationResult> testExecutionResult, @NotNull PactSource source, @NotNull ValueResolver propertyResolver) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(testExecutionResult, (String)"testExecutionResult");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)propertyResolver, (String)"propertyResolver");
        TestResult.Ok initial = new TestResult.Ok(interaction.getInteractionId());
        Iterable iterable = testExecutionResult;
        Interaction interaction2 = interaction;
        Pact pact2 = pact;
        DefaultTestResultAccumulator defaultTestResultAccumulator = this;
        boolean $i$f$fold = false;
        TestResult.Ok accumulator$iv = initial;
        for (Object element$iv : $this$fold$iv) {
            void r;
            VerificationResult verificationResult = (VerificationResult)element$iv;
            TestResult acc = (TestResult)accumulator$iv;
            boolean bl = false;
            accumulator$iv = acc.merge(r.toTestResult());
        }
        TestResult.Ok ok = accumulator$iv;
        return defaultTestResultAccumulator.updateTestResult(pact2, interaction2, (TestResult)ok, source, propertyResolver);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Result<Boolean, List<String>> updateTestResult(@NotNull Pact pact, @NotNull Interaction interaction, @NotNull TestResult testExecutionResult, @Nullable PactSource source, @NotNull ValueResolver propertyResolver) {
        Result result2;
        int interactionHash;
        Map interactionResults;
        TestResult testResult;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter((Object)testExecutionResult, (String)"testExecutionResult");
        Intrinsics.checkNotNullParameter((Object)propertyResolver, (String)"propertyResolver");
        this.getLogger().debug((Function0)new Function0<Object>(testExecutionResult, pact, interaction, source){
            final /* synthetic */ TestResult $testExecutionResult;
            final /* synthetic */ Pact $pact;
            final /* synthetic */ Interaction $interaction;
            final /* synthetic */ PactSource $source;
            {
                this.$testExecutionResult = $testExecutionResult;
                this.$pact = $pact;
                this.$interaction = $interaction;
                this.$source = $source;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                PactSource pactSource = this.$source;
                return "Received test result '" + this.$testExecutionResult + "' for Pact " + this.$pact.getProvider().getName() + "-" + this.$pact.getConsumer().getName() + " and " + this.$interaction.getDescription() + " (" + (pactSource != null ? pactSource.description() : null) + ")";
            }
        });
        int pactHash = this.calculatePactHash(pact, source);
        Map<Integer, Map<Integer, TestResult>> map = testResults;
        Integer key$iv = pactHash;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Map answer$iv = new LinkedHashMap();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        if ((testResult = (TestResult)(interactionResults = (Map)object).get(interactionHash = this.calculateInteractionHash(interaction))) == null) {
            value$iv = interactionHash;
            interactionResults.put(value$iv, testExecutionResult);
        } else {
            value$iv = interactionHash;
            interactionResults.put(value$iv, testResult.merge(testExecutionResult));
        }
        List<Interaction> unverifiedInteractions2 = this.unverifiedInteractions(pact, interactionResults);
        if (unverifiedInteractions2.isEmpty()) {
            Result<Boolean, List<String>> result3;
            this.getLogger().debug((Function0)new Function0<Object>(pact){
                final /* synthetic */ Pact $pact;
                {
                    this.$pact = $pact;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "All interactions for Pact " + this.$pact.getProvider().getName() + "-" + this.$pact.getConsumer().getName() + " have a verification result";
                }
            });
            if (verificationReporter.publishingResultsDisabled(propertyResolver)) {
                this.getLogger().warn((Function0)updateTestResult.result.1.INSTANCE);
                result3 = (Result<Boolean, List<String>>)new Result.Ok((Object)false);
            } else {
                Iterable $this$reduce$iv = interactionResults.values();
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object accumulator$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void result4;
                    TestResult testResult2 = (TestResult)iterator$iv.next();
                    TestResult acc = (TestResult)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = acc.merge((TestResult)result4);
                }
                TestResult calculatedTestResult = (TestResult)accumulator$iv;
                result3 = verificationReporter.reportResults(pact, calculatedTestResult, this.lookupProviderVersion(propertyResolver), null, this.lookupProviderTags(propertyResolver), this.lookupProviderBranch(propertyResolver));
            }
            Result<Boolean, List<String>> result5 = result3;
            testResults.remove(pactHash);
            result2 = result5;
        } else {
            this.getLogger().warn((Function0)new Function0<Object>(pact){
                final /* synthetic */ Pact $pact;
                {
                    this.$pact = $pact;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Not all of the " + this.$pact.getInteractions().size() + " were verified. The following were missing:";
                }
            });
            Iterable $this$forEach$iv = unverifiedInteractions2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Interaction it = (Interaction)element$iv;
                boolean bl = false;
                INSTANCE.getLogger().warn((Function0)new Function0<Object>(it){
                    final /* synthetic */ Interaction $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "    " + this.$it.getDescription();
                    }
                });
            }
            result2 = (Result)new Result.Ok((Object)true);
        }
        return result2;
    }

    public final int calculateInteractionHash(@NotNull Interaction interaction) {
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        HashCodeBuilder builder = new HashCodeBuilder().append((Object)interaction.getDescription());
        Iterable $this$forEach$iv = interaction.getProviderStates();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProviderState it = (ProviderState)element$iv;
            boolean bl = false;
            builder.append((Object)it.getName());
        }
        return builder.toHashCode();
    }

    public final int calculatePactHash(@NotNull Pact pact, @Nullable PactSource source) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        HashCodeBuilder builder = new HashCodeBuilder(91, 47).append((Object)pact.getConsumer().getName()).append((Object)pact.getProvider().getName());
        if (source instanceof BrokerUrlSource && KotlinLanguageSupportKt.isNotEmpty((String)((BrokerUrlSource)source).getUrl())) {
            builder.append((Object)((BrokerUrlSource)source).getUrl());
        }
        return builder.toHashCode();
    }

    @NotNull
    public final String lookupProviderVersion(@NotNull ValueResolver propertyResolver) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)propertyResolver, (String)"propertyResolver");
        String version2 = new ProviderVersion((Function0<String>)((Function0)new Function0<String>(propertyResolver){
            final /* synthetic */ ValueResolver $propertyResolver;
            {
                this.$propertyResolver = $propertyResolver;
                super(0);
            }

            @Nullable
            public final String invoke() {
                return this.$propertyResolver.resolveValue("pact.provider.version", "");
            }
        })).get();
        CharSequence charSequence2 = version2;
        if (charSequence2.length() == 0) {
            boolean bl = false;
            INSTANCE.getLogger().warn((Function0)lookupProviderVersion.1.1.INSTANCE);
            charSequence = "0.0.0";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> lookupProviderTags(ValueResolver propertyResolver) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        String string = propertyResolver.resolveValue("pact.provider.tag", "");
        if (string == null) {
            string = "";
        }
        char[] cArray = new char[]{','};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!KotlinLanguageSupportKt.isNotEmpty((String)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String lookupProviderBranch(ValueResolver propertyResolver) {
        return propertyResolver.resolveValue("pact.provider.branch", "");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Interaction> unverifiedInteractions(@NotNull Pact pact, @NotNull Map<Integer, TestResult> results) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        this.getLogger().debug((Function0)new Function0<Object>(pact, results){
            final /* synthetic */ Pact $pact;
            final /* synthetic */ Map<Integer, TestResult> $results;
            {
                this.$pact = $pact;
                this.$results = $results;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Number of interactions #" + this.$pact.getInteractions().size() + " and results: " + this.$results.values();
            }
        });
        Iterable $this$filter$iv = pact.getInteractions();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Interaction it = (Interaction)element$iv$iv;
            boolean bl = false;
            if (!(!results.containsKey(INSTANCE.calculateInteractionHash(it)))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void clearTestResult(@NotNull Pact pact, @Nullable PactSource source) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        int pactHash = this.calculatePactHash(pact, source);
        testResults.remove(pactHash);
    }
}

