/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junitsupport;

import au.com.dius.pact.core.model.FilteredPact;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.provider.ProviderUtils;
import au.com.dius.pact.provider.junitsupport.AllowOverridePactUrl;
import au.com.dius.pact.provider.junitsupport.Consumer;
import au.com.dius.pact.provider.junitsupport.JUnitProviderTestSupport;
import au.com.dius.pact.provider.junitsupport.filter.InteractionFilter;
import au.com.dius.pact.provider.junitsupport.loader.OverrideablePactLoader;
import au.com.dius.pact.provider.junitsupport.loader.PactFilter;
import au.com.dius.pact.provider.junitsupport.loader.PactLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u001a\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J&\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019J\u001c\u0010\u001a\u001a\u00020\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001b0\u000eH\u0007J\u001a\u0010\u001c\u001a\u00020\f2\u0010\u0010\u001d\u001a\f\u0012\u0004\u0012\u00020\f\u0012\u0002\b\u00030\u000eH\u0002\u00a8\u0006\u001e"}, d2={"Lau/com/dius/pact/provider/junitsupport/JUnitProviderTestSupport;", "Lmu/KLogging;", "()V", "checkForOverriddenPactUrl", "", "loader", "Lau/com/dius/pact/provider/junitsupport/loader/PactLoader;", "overridePactUrl", "Lau/com/dius/pact/provider/junitsupport/AllowOverridePactUrl;", "consumer", "Lau/com/dius/pact/provider/junitsupport/Consumer;", "convertMapToErrorString", "", "mismatches", "", "exceptionMessage", "err", "", "prefixLength", "", "filterPactsByAnnotations", "", "Lau/com/dius/pact/core/model/Pact;", "pacts", "testClass", "Ljava/lang/Class;", "generateErrorStringFromMismatches", "", "mapToString", "comparison", "provider"})
@SourceDebugExtension(value={"SMAP\nJUnitProviderTestSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JUnitProviderTestSupport.kt\nau/com/dius/pact/provider/junitsupport/JUnitProviderTestSupport\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n12541#2,2:119\n1549#3:121\n1620#3,3:122\n766#3:125\n857#3,2:126\n1559#3:128\n1590#3,4:129\n2683#3,8:133\n*S KotlinDebug\n*F\n+ 1 JUnitProviderTestSupport.kt\nau/com/dius/pact/provider/junitsupport/JUnitProviderTestSupport\n*L\n21#1:119,2\n24#1:121\n24#1:122,3\n26#1:125\n26#1:126,2\n32#1:128\n32#1:129,4\n56#1:133,8\n*E\n"})
public final class JUnitProviderTestSupport
extends KLogging {
    @NotNull
    public static final JUnitProviderTestSupport INSTANCE = new JUnitProviderTestSupport();

    private JUnitProviderTestSupport() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Pact> filterPactsByAnnotations(@NotNull List<? extends Pact> pacts, @NotNull Class<?> testClass) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        FilteredPact pact;
        void $this$mapTo$iv$iv;
        boolean bl;
        PactFilter pactFilter;
        block5: {
            Intrinsics.checkNotNullParameter(pacts, (String)"pacts");
            Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
            PactFilter pactFilter2 = ProviderUtils.findAnnotation(testClass, PactFilter.class);
            if (pactFilter2 == null) {
                return pacts;
            }
            pactFilter = pactFilter2;
            String[] $this$all$iv = pactFilter.value();
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$all$iv[i];
                boolean bl2 = false;
                if (((CharSequence)it).length() == 0) continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        if (bl) {
            return pacts;
        }
        Object object = KClasses.createInstance((KClass)Reflection.getOrCreateKotlinClass(pactFilter.filter()));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type au.com.dius.pact.provider.junitsupport.filter.InteractionFilter<@[FlexibleNullability] au.com.dius.pact.core.model.Interaction?>");
        InteractionFilter interactionFilter = (InteractionFilter)object;
        Iterable $this$map$iv = pacts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pact pact2 = (Pact)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            Predicate predicate = interactionFilter.buildPredicate(pactFilter.value());
            Intrinsics.checkNotNullExpressionValue(predicate, (String)"interactionFilter.buildPredicate(pactFilter.value)");
            collection.add(new FilteredPact((Pact)pact, predicate));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            pact = (FilteredPact)element$iv$iv;
            boolean bl4 = false;
            if (!KotlinLanguageSupportKt.isNotEmpty((List)pact.getInteractions())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String generateErrorStringFromMismatches(@NotNull Map<String, ? extends Object> mismatches) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(mismatches, (String)"mismatches");
        Iterable iterable = mismatches.values();
        String string = System.lineSeparator();
        boolean $i$f$mapIndexed = false;
        void var3_4 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            String string2;
            void value;
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String errPrefix = (int)i + " - ";
            void var14_15 = value;
            if (var14_15 instanceof Throwable) {
                string2 = errPrefix + JUnitProviderTestSupport.exceptionMessage((Throwable)value, errPrefix.length());
            } else if (var14_15 instanceof Map) {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                string2 = errPrefix + INSTANCE.convertMapToErrorString((Map)value);
            } else {
                string2 = errPrefix + value;
            }
            collection.add(string2);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        String string3 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lineSeparator()");
        return string + CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String exceptionMessage(@NotNull Throwable err, int prefixLength) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)err, (String)"err");
        String message = err.getMessage();
        Throwable cause = err.getCause();
        String details = "";
        if (cause != null) {
            String string = ExceptionUtils.getStackTrace((Throwable)cause);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(cause)");
            details = string;
        }
        String lineSeparator = System.lineSeparator();
        if (message != null && StringsKt.contains$default((CharSequence)message, (CharSequence)"\n", (boolean)false, (int)2, null)) {
            String padString = StringUtils.leftPad((String)"", (int)prefixLength);
            String[] stringArray = new String[]{"\n"};
            List lines = StringsKt.split$default((CharSequence)message, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Iterable $this$reduceIndexed$iv = lines;
            boolean $i$f$reduceIndexed = false;
            Iterator iterator$iv = $this$reduceIndexed$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            int index$iv = 1;
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void line;
                void acc;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)iterator$iv.next();
                String string2 = (String)accumulator$iv;
                int index = n;
                boolean bl = false;
                accumulator$iv = index > 0 ? (String)acc + lineSeparator + padString + (String)line : (String)line + lineSeparator;
            }
            object = (String)accumulator$iv;
        } else {
            object = message + "\n" + details;
        }
        return object;
    }

    private final String convertMapToErrorString(Map<String, ?> mismatches) {
        String string;
        if (mismatches.containsKey("comparison")) {
            Object comparison = mismatches.get("comparison");
            if (mismatches.containsKey("diff")) {
                Intrinsics.checkNotNull(comparison, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, *>");
                string = this.mapToString((Map)comparison);
            } else {
                string = comparison instanceof Map ? this.mapToString((Map)comparison) : String.valueOf(comparison);
            }
        } else {
            string = this.mapToString(mismatches);
        }
        return string;
    }

    private final String mapToString(Map<String, ?> comparison) {
        Iterable iterable = comparison.entrySet();
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator()");
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, (Function1)mapToString.1.INSTANCE, (int)30, null);
    }

    @JvmStatic
    public static final void checkForOverriddenPactUrl(@Nullable PactLoader loader, @Nullable AllowOverridePactUrl overridePactUrl, @Nullable Consumer consumer) {
        String pactUrl = System.getProperty("pact.filter.pacturl");
        CharSequence charSequence = pactUrl;
        if (charSequence == null || charSequence.length() == 0) {
            pactUrl = System.getenv("pact.filter.pacturl");
        }
        if (loader instanceof OverrideablePactLoader && overridePactUrl != null && KotlinLanguageSupportKt.isNotEmpty((String)pactUrl)) {
            String consumerProperty = System.getProperty("pact.filter.consumers");
            CharSequence charSequence2 = consumerProperty;
            if (charSequence2 == null || charSequence2.length() == 0) {
                consumerProperty = System.getenv("pact.filter.consumers");
            }
            if (KotlinLanguageSupportKt.isNotEmpty((String)consumerProperty)) {
                OverrideablePactLoader overrideablePactLoader = (OverrideablePactLoader)loader;
                String string = pactUrl;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pactUrl");
                String string2 = consumerProperty;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"consumerProperty");
                overrideablePactLoader.overridePactUrl(string, string2);
            } else if (consumer != null) {
                OverrideablePactLoader overrideablePactLoader = (OverrideablePactLoader)loader;
                String string = pactUrl;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pactUrl");
                overrideablePactLoader.overridePactUrl(string, consumer.value());
            } else {
                INSTANCE.getLogger().warn((Function0)checkForOverriddenPactUrl.1.INSTANCE);
            }
        }
    }
}

