/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.Result;
import au.com.dius.pact.core.support.ResultKt;
import au.com.dius.pact.core.support.json.JsonParser;
import au.com.dius.pact.provider.DefaultStateChange;
import au.com.dius.pact.provider.IConsumerInfo;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.IProviderVerifier;
import au.com.dius.pact.provider.ProviderClient;
import au.com.dius.pact.provider.StateChange;
import au.com.dius.pact.provider.StateChangeResult;
import au.com.dius.pact.provider.reporters.VerifierReporter;
import groovy.lang.Closure;
import io.github.oshai.kotlinlogging.KLogging;
import java.io.Closeable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J^\u0010\u0004\u001a \u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u0012\b\u0012\u00060\tj\u0002`\n0\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002JL\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u001f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J0\u0010 \u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J0\u0010\"\u001a \u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u0012\b\u0012\u00060\tj\u0002`\n0\u00052\b\u0010#\u001a\u0004\u0018\u00010$H\u0002JV\u0010%\u001a \u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u0012\b\u0012\u00060\tj\u0002`\n0\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0012"}, d2={"Lau/com/dius/pact/provider/DefaultStateChange;", "Lau/com/dius/pact/provider/StateChange;", "Lio/github/oshai/kotlinlogging/KLogging;", "()V", "executeHttpStateChangeRequest", "Lau/com/dius/pact/core/support/Result;", "", "", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "verifier", "Lau/com/dius/pact/provider/IProviderVerifier;", "stateChangeHandler", "useBody", "", "state", "Lau/com/dius/pact/core/model/ProviderState;", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "isSetup", "providerClient", "Lau/com/dius/pact/provider/ProviderClient;", "executeStateChange", "Lau/com/dius/pact/provider/StateChangeResult;", "consumer", "Lau/com/dius/pact/provider/IConsumerInfo;", "interaction", "Lau/com/dius/pact/core/model/Interaction;", "interactionMessage", "failures", "", "executeStateChangeTeardown", "", "parseJsonResponse", "entity", "Lorg/apache/hc/core5/http/HttpEntity;", "stateChange"})
@SourceDebugExtension(value={"SMAP\nStateChange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateChange.kt\nau/com/dius/pact/provider/DefaultStateChange\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1855#2,2:235\n1855#2,2:237\n1855#2,2:239\n1855#2,2:241\n*S KotlinDebug\n*F\n+ 1 StateChange.kt\nau/com/dius/pact/provider/DefaultStateChange\n*L\n127#1:235,2\n175#1:237,2\n198#1:239,2\n213#1:241,2\n*E\n"})
public final class DefaultStateChange
extends KLogging
implements StateChange {
    @NotNull
    public static final DefaultStateChange INSTANCE = new DefaultStateChange();

    private DefaultStateChange() {
    }

    @Override
    @NotNull
    public StateChangeResult executeStateChange(@NotNull IProviderVerifier verifier, @NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer, @NotNull Interaction interaction, @NotNull String interactionMessage, @NotNull Map<String, Object> failures, @NotNull ProviderClient providerClient) {
        Intrinsics.checkNotNullParameter((Object)verifier, (String)"verifier");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter((Object)interactionMessage, (String)"interactionMessage");
        Intrinsics.checkNotNullParameter(failures, (String)"failures");
        Intrinsics.checkNotNullParameter((Object)providerClient, (String)"providerClient");
        Ref.ObjectRef message = new Ref.ObjectRef();
        message.element = interactionMessage;
        Ref.ObjectRef stateChangeResult = new Ref.ObjectRef();
        stateChangeResult.element = new Result.Ok((Object)MapsKt.emptyMap());
        if (!((Collection)interaction.getProviderStates()).isEmpty()) {
            Iterator iterator = interaction.getProviderStates().iterator();
            Ref.BooleanRef first = new Ref.BooleanRef();
            first.element = true;
            while (stateChangeResult.element instanceof Result.Ok && iterator.hasNext()) {
                ProviderState providerState = (ProviderState)iterator.next();
                Result<Map<String, Object>, Exception> result2 = this.stateChange(verifier, providerState, provider, consumer, true, providerClient);
                this.getLogger().debug((Function0)new Function0<Object>(providerState, result2){
                    final /* synthetic */ ProviderState $providerState;
                    final /* synthetic */ Result<Map<String, Object>, Exception> $result;
                    {
                        this.$providerState = $providerState;
                        this.$result = $result;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "State Change: \"" + this.$providerState + "\" -> " + this.$result;
                    }
                });
                stateChangeResult.element = ResultKt.mapEither(result2, (Function1)((Function1)new Function1<Map<String, ? extends Object>, Map<String, ? extends Object>>(first, (Ref.ObjectRef<String>)message, providerState, (Ref.ObjectRef<Result<Map<String, Object>, Exception>>)stateChangeResult){
                    final /* synthetic */ Ref.BooleanRef $first;
                    final /* synthetic */ Ref.ObjectRef<String> $message;
                    final /* synthetic */ ProviderState $providerState;
                    final /* synthetic */ Ref.ObjectRef<Result<Map<String, Object>, Exception>> $stateChangeResult;
                    {
                        this.$first = $first;
                        this.$message = $message;
                        this.$providerState = $providerState;
                        this.$stateChangeResult = $stateChangeResult;
                        super(1);
                    }

                    @NotNull
                    public final Map<String, Object> invoke(@NotNull Map<String, ? extends Object> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        if (this.$first.element) {
                            this.$message.element = this.$message.element + " Given " + this.$providerState.getName();
                            this.$first.element = false;
                        } else {
                            this.$message.element = this.$message.element + " And " + this.$providerState.getName();
                        }
                        return MapsKt.plus((Map)((Map)((Result)this.$stateChangeResult.element).unwrap()), it);
                    }
                }), (Function1)((Function1)new Function1<Exception, Exception>(failures, (Ref.ObjectRef<String>)message){
                    final /* synthetic */ Map<String, Object> $failures;
                    final /* synthetic */ Ref.ObjectRef<String> $message;
                    {
                        this.$failures = $failures;
                        this.$message = $message;
                        super(1);
                    }

                    @NotNull
                    public final Exception invoke(@NotNull Exception it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$failures.put((String)this.$message.element, String.valueOf(it.getMessage()));
                        return it;
                    }
                }));
            }
        } else {
            Result<Map<String, Object>, Exception> result3 = this.stateChange(verifier, new ProviderState("", null, 2, null), provider, consumer, true, providerClient);
            this.getLogger().debug((Function0)new Function0<Object>(result3){
                final /* synthetic */ Result<Map<String, Object>, Exception> $result;
                {
                    this.$result = $result;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "State Change: \"\" -> " + this.$result;
                }
            });
            ResultKt.mapEither(result3, (Function1)((Function1)new Function1<Map<String, ? extends Object>, Map<String, ? extends Object>>((Ref.ObjectRef<Result<Map<String, Object>, Exception>>)stateChangeResult){
                final /* synthetic */ Ref.ObjectRef<Result<Map<String, Object>, Exception>> $stateChangeResult;
                {
                    this.$stateChangeResult = $stateChangeResult;
                    super(1);
                }

                @NotNull
                public final Map<String, Object> invoke(@NotNull Map<String, ? extends Object> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return MapsKt.plus((Map)((Map)((Result)this.$stateChangeResult.element).unwrap()), it);
                }
            }), (Function1)((Function1)new Function1<Exception, Exception>(failures, (Ref.ObjectRef<String>)message){
                final /* synthetic */ Map<String, Object> $failures;
                final /* synthetic */ Ref.ObjectRef<String> $message;
                {
                    this.$failures = $failures;
                    this.$message = $message;
                    super(1);
                }

                @NotNull
                public final Exception invoke(@NotNull Exception it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    this.$failures.put((String)this.$message.element, String.valueOf(it.getMessage()));
                    return it;
                }
            }));
        }
        return new StateChangeResult((Result<? extends Map<String, ? extends Object>, ? extends Exception>)((Result)stateChangeResult.element), (String)message.element);
    }

    @Override
    @NotNull
    public Result<Map<String, Object>, Exception> stateChange(@NotNull IProviderVerifier verifier, @NotNull ProviderState state, @NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer, boolean isSetup, @NotNull ProviderClient providerClient) {
        Intrinsics.checkNotNullParameter((Object)verifier, (String)"verifier");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)providerClient, (String)"providerClient");
        verifier.reportStateForInteraction(String.valueOf(state.getName()), provider, consumer, isSetup);
        this.getLogger().debug((Function0)new Function0<Object>(consumer, provider){
            final /* synthetic */ IConsumerInfo $consumer;
            final /* synthetic */ IProviderInfo $provider;
            {
                this.$consumer = $consumer;
                this.$provider = $provider;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "stateChangeHandler: consumer.stateChange=" + this.$consumer.getStateChange() + ", provider.stateChangeUrl=" + this.$provider.getStateChangeUrl();
            }
        });
        try {
            Result result2;
            Result stateChangeResult;
            Result result3;
            Ref.ObjectRef stateChangeHandler = new Ref.ObjectRef();
            stateChangeHandler.element = consumer.getStateChange();
            boolean stateChangeUsesBody = consumer.getStateChangeUsesBody();
            if (stateChangeHandler.element == null) {
                stateChangeHandler.element = provider.getStateChangeUrl();
                stateChangeUsesBody = provider.getStateChangeUsesBody();
            }
            if (stateChangeHandler.element == null || stateChangeHandler.element instanceof String && StringsKt.isBlank((CharSequence)((CharSequence)stateChangeHandler.element))) {
                Iterable $this$forEach$iv = verifier.getReporters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    VerifierReporter it = (VerifierReporter)element$iv;
                    boolean bl = false;
                    it.warnStateChangeIgnored(String.valueOf(state.getName()), provider, consumer);
                }
                return (Result)new Result.Ok((Object)MapsKt.emptyMap());
            }
            Boolean bl = verifier.getCheckBuildSpecificTask().apply(stateChangeHandler.element);
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"verifier.checkBuildSpeci\u2026apply(stateChangeHandler)");
            if (bl.booleanValue()) {
                this.getLogger().debug((Function0)new Function0<Object>((Ref.ObjectRef<Object>)stateChangeHandler){
                    final /* synthetic */ Ref.ObjectRef<Object> $stateChangeHandler;
                    {
                        this.$stateChangeHandler = $stateChangeHandler;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Invoking build specific task " + this.$stateChangeHandler.element;
                    }
                });
                verifier.getExecuteBuildSpecificTask().accept(stateChangeHandler.element, state);
                return (Result)new Result.Ok((Object)MapsKt.emptyMap());
            }
            if (stateChangeHandler.element instanceof Closure) {
                Object object;
                if (provider.getStateChangeTeardown()) {
                    Object[] $i$f$forEach = new Object[]{state, isSetup ? "setup" : "teardown"};
                    object = ((Closure)stateChangeHandler.element).call($i$f$forEach);
                } else {
                    object = ((Closure)stateChangeHandler.element).call((Object)state);
                }
                Object result4 = object;
                this.getLogger().debug((Function0)new Function0<Object>(result4){
                    final /* synthetic */ Object $result;
                    {
                        this.$result = $result;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Invoked state change closure -> " + this.$result;
                    }
                });
                if (!(result4 instanceof URL)) {
                    Map map = result4 instanceof Map ? MapsKt.plus((Map)state.getParams(), (Map)((Map)result4)) : state.getParams();
                    return (Result)new Result.Ok((Object)map);
                }
                stateChangeHandler.element = result4;
            }
            if ((result3 = (stateChangeResult = this.executeHttpStateChangeRequest(verifier, stateChangeHandler.element, stateChangeUsesBody, state, provider, isSetup, providerClient))) instanceof Result.Ok) {
                result2 = (Result)new Result.Ok((Object)MapsKt.plus((Map)state.getParams(), (Map)((Map)((Result.Ok)stateChangeResult).getValue())));
            } else if (result3 instanceof Result.Err) {
                result2 = stateChangeResult;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return result2;
        }
        catch (Exception e) {
            verifier.reportStateChangeFailed(state, e, isSetup);
            return (Result)new Result.Err((Object)e);
        }
    }

    @Override
    public void executeStateChangeTeardown(@NotNull IProviderVerifier verifier, @NotNull Interaction interaction, @NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer, @NotNull ProviderClient providerClient) {
        Intrinsics.checkNotNullParameter((Object)verifier, (String)"verifier");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)providerClient, (String)"providerClient");
        if (!((Collection)interaction.getProviderStates()).isEmpty()) {
            Iterable $this$forEach$iv = interaction.getProviderStates();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProviderState it = (ProviderState)element$iv;
                boolean bl = false;
                INSTANCE.stateChange(verifier, it, provider, consumer, false, providerClient);
            }
        } else {
            this.stateChange(verifier, new ProviderState("", null, 2, null), provider, consumer, false, providerClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Result<Map<String, Object>, Exception> executeHttpStateChangeRequest(IProviderVerifier verifier, Object stateChangeHandler, boolean useBody, ProviderState state, IProviderInfo provider, boolean isSetup, ProviderClient providerClient) {
        Result result2;
        try {
            Result result3;
            block17: {
                block16: {
                    Result result4;
                    URI uRI = stateChangeHandler instanceof URI ? (URI)stateChangeHandler : null;
                    if (uRI == null) {
                        uRI = new URI(stateChangeHandler.toString());
                    }
                    URI url = uRI;
                    Result response = providerClient.makeStateChangeRequest(url, state, useBody, isSetup, provider.getStateChangeTeardown());
                    this.getLogger().debug((Function0)new Function0<Object>(url, (ClassicHttpResponse)response){
                        final /* synthetic */ URI $url;
                        final /* synthetic */ ClassicHttpResponse $response;
                        {
                            this.$url = $url;
                            this.$response = $response;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            ClassicHttpResponse classicHttpResponse = this.$response;
                            return "Invoked state change " + this.$url + " -> " + (classicHttpResponse != null ? Integer.valueOf(classicHttpResponse.getCode()) : null);
                        }
                    });
                    result3 = response;
                    if (result3 == null) break block16;
                    Closeable closeable = (Closeable)result3;
                    Throwable throwable = null;
                    try {
                        Result result5;
                        Result it = (Result)closeable;
                        boolean bl = false;
                        if (response.getCode() >= 400) {
                            Iterable $this$forEach$iv = verifier.getReporters();
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                VerifierReporter it2 = (VerifierReporter)element$iv;
                                boolean bl2 = false;
                                it2.stateChangeRequestFailed(String.valueOf(state.getName()), provider, isSetup, response.getCode() + " " + response.getReasonPhrase());
                            }
                            result5 = (Result)new Result.Err((Object)new Exception("State Change Request Failed - " + response.getCode() + " " + response.getReasonPhrase()));
                        } else {
                            result5 = INSTANCE.parseJsonResponse(response.getEntity());
                        }
                        it = result5;
                        result4 = it;
                    }
                    catch (Throwable it) {
                        throwable = it;
                        throw it;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    result3 = result4;
                    if (result4 != null) break block17;
                }
                result3 = (Result)new Result.Ok((Object)MapsKt.emptyMap());
            }
            result2 = result3;
        }
        catch (URISyntaxException ex) {
            this.getLogger().error((Throwable)ex, (Function0)executeHttpStateChangeRequest.3.INSTANCE);
            Iterable $this$forEach$iv = verifier.getReporters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VerifierReporter it = (VerifierReporter)element$iv;
                boolean bl = false;
                it.warnStateChangeIgnoredDueToInvalidUrl(String.valueOf(state.getName()), provider, isSetup, stateChangeHandler);
            }
            result2 = (Result)new Result.Ok((Object)MapsKt.emptyMap());
        }
        return result2;
    }

    private final Result<Map<String, Object>, Exception> parseJsonResponse(HttpEntity entity) {
        Result result2;
        if (entity != null) {
            Result.Ok ok;
            ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
            if (contentType != null && Intrinsics.areEqual((Object)contentType.getMimeType(), (Object)ContentType.APPLICATION_JSON.getMimeType())) {
                String body = EntityUtils.toString((HttpEntity)entity);
                Intrinsics.checkNotNullExpressionValue((Object)body, (String)"body");
                ok = new Result.Ok((Object)Json.INSTANCE.toMap(JsonParser.parseString((String)body)));
            } else {
                ok = new Result.Ok((Object)MapsKt.emptyMap());
            }
            result2 = (Result)ok;
        } else {
            result2 = (Result)new Result.Ok((Object)MapsKt.emptyMap());
        }
        return result2;
    }
}

