/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.IRequest;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.ProviderState;
import au.com.dius.pact.core.model.Request;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.json.JsonValue;
import au.com.dius.pact.provider.IHttpClientFactory;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.MetadataValue;
import au.com.dius.pact.provider.ProviderResponse;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import io.github.oshai.kotlinlogging.KLogging;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.collections4.Closure;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpOptions;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpTrace;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.net.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u0000 +2\u00020\u0001:\u0001+B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J4\u0010\u001c\u001a\u0004\u0018\u00010\u00152\b\u0010\u001d\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!H\u0016J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010&\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u0011H\u0016J\u0018\u0010'\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u0011H\u0016J\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0002"}, d2={"Lau/com/dius/pact/provider/ProviderClient;", "", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "httpClientFactory", "Lau/com/dius/pact/provider/IHttpClientFactory;", "(Lau/com/dius/pact/provider/IProviderInfo;Lau/com/dius/pact/provider/IHttpClientFactory;)V", "getProvider", "()Lau/com/dius/pact/provider/IProviderInfo;", "executeRequest", "Lau/com/dius/pact/provider/ProviderResponse;", "httpclient", "Lorg/apache/hc/client5/http/impl/classic/CloseableHttpClient;", "method", "Lorg/apache/hc/client5/http/classic/methods/HttpUriRequest;", "executeRequestFilter", "", "Lorg/apache/hc/core5/http/HttpRequest;", "getHttpClient", "handleResponse", "httpResponse", "Lorg/apache/hc/core5/http/ClassicHttpResponse;", "invokeJavaFunctionalInterface", "functionalInterface", "httpRequest", "makeRequest", "request", "Lau/com/dius/pact/core/model/IRequest;", "makeStateChangeRequest", "stateChangeUrl", "state", "Lau/com/dius/pact/core/model/ProviderState;", "postStateInBody", "", "isSetup", "stateChangeTeardown", "newRequest", "prepareRequest", "setupBody", "setupHeaders", "systemPropertySet", "property", "", "Companion"})
@SourceDebugExtension(value={"SMAP\nProviderClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProviderClient.kt\nau/com/dius/pact/provider/ProviderClient\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,511:1\n215#2,2:512\n215#2,2:514\n215#2:548\n216#2:551\n10622#3:516\n10892#3,3:517\n10895#3:527\n10897#3:532\n372#4,7:520\n453#4:533\n403#4:534\n453#4:539\n403#4:540\n1549#5:528\n1620#5,3:529\n1238#5,4:535\n1238#5,2:541\n1549#5:543\n1620#5,3:544\n1241#5:547\n1855#5,2:549\n*S KotlinDebug\n*F\n+ 1 ProviderClient.kt\nau/com/dius/pact/provider/ProviderClient\n*L\n359#1:512,2\n401#1:514,2\n490#1:548\n490#1:551\n437#1:516\n437#1:517,3\n437#1:527\n437#1:532\n437#1:520,7\n444#1:533\n444#1:534\n460#1:539\n460#1:540\n441#1:528\n441#1:529,3\n444#1:535,4\n460#1:541,2\n462#1:543\n462#1:544,3\n460#1:547\n491#1:549,2\n*E\n"})
public class ProviderClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IProviderInfo provider;
    @NotNull
    private final IHttpClientFactory httpClientFactory;
    @NotNull
    public static final String CONTENT_TYPE = "Content-Type";
    @NotNull
    public static final String UTF8 = "UTF-8";
    @NotNull
    public static final String REQUEST = "request";
    @NotNull
    public static final String ACTION = "action";
    @NotNull
    private static final Set<String> SINGLE_VALUE_HEADERS;

    public ProviderClient(@NotNull IProviderInfo provider, @NotNull IHttpClientFactory httpClientFactory) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)httpClientFactory, (String)"httpClientFactory");
        this.provider = provider;
        this.httpClientFactory = httpClientFactory;
    }

    @NotNull
    public final IProviderInfo getProvider() {
        return this.provider;
    }

    @NotNull
    public ProviderResponse makeRequest(@NotNull IRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)REQUEST);
        CloseableHttpClient httpclient = this.getHttpClient();
        HttpUriRequest method = this.prepareRequest(request);
        return this.executeRequest(httpclient, method);
    }

    @NotNull
    public ProviderResponse executeRequest(@NotNull CloseableHttpClient httpclient, @NotNull HttpUriRequest method) {
        Intrinsics.checkNotNullParameter((Object)httpclient, (String)"httpclient");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Object object = httpclient.execute((ClassicHttpRequest)method, arg_0 -> ProviderClient.executeRequest$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"httpclient.execute(metho\u2026andleResponse(response) }");
        return (ProviderResponse)object;
    }

    @NotNull
    public HttpUriRequest prepareRequest(@NotNull IRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)REQUEST);
        Companion.getLogger().debug((Function0)new Function0<Object>(this){
            final /* synthetic */ ProviderClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Making request for provider " + this.this$0.getProvider() + ":";
            }
        });
        Companion.getLogger().debug((Function0)new Function0<Object>(request){
            final /* synthetic */ IRequest $request;
            {
                this.$request = $request;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return this.$request.toString();
            }
        });
        HttpUriRequest method = this.newRequest(request);
        this.setupHeaders(request, (HttpRequest)method);
        this.setupBody(request, (HttpRequest)method);
        this.executeRequestFilter((HttpRequest)method);
        return method;
    }

    public void executeRequestFilter(@NotNull HttpRequest method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Object requestFilter = this.provider.getRequestFilter();
        if (requestFilter != null) {
            Object object = requestFilter;
            if (object instanceof groovy.lang.Closure) {
                ((groovy.lang.Closure)requestFilter).call((Object)method);
            } else if (object instanceof Closure) {
                ((Closure)requestFilter).execute((Object)method);
            } else if (Companion.isFunctionalInterface(requestFilter)) {
                this.invokeJavaFunctionalInterface(requestFilter, method);
            } else {
                Binding binding = new Binding();
                binding.setVariable(REQUEST, (Object)method);
                GroovyShell shell = new GroovyShell(binding);
                shell.evaluate((String)requestFilter);
            }
        }
    }

    private final void invokeJavaFunctionalInterface(Object functionalInterface, HttpRequest httpRequest) {
        Object object = functionalInterface;
        if (object instanceof Consumer) {
            Intrinsics.checkNotNull((Object)functionalInterface, (String)"null cannot be cast to non-null type java.util.function.Consumer<org.apache.hc.core5.http.HttpRequest>");
            ((Consumer)functionalInterface).accept(httpRequest);
        } else if (object instanceof Function) {
            Intrinsics.checkNotNull((Object)functionalInterface, (String)"null cannot be cast to non-null type java.util.function.Function<org.apache.hc.core5.http.HttpRequest, kotlin.Any?>");
            ((Function)functionalInterface).apply(httpRequest);
        } else if (object instanceof Callable) {
            Intrinsics.checkNotNull((Object)functionalInterface, (String)"null cannot be cast to non-null type java.util.concurrent.Callable<org.apache.hc.core5.http.HttpRequest>");
            ((Callable)functionalInterface).call();
        } else {
            throw new IllegalArgumentException("Java request filters must be either a Consumer or Function that takes at least one HttpRequest parameter");
        }
    }

    public void setupBody(@NotNull IRequest request, @NotNull HttpRequest method) {
        Intrinsics.checkNotNullParameter((Object)request, (String)REQUEST);
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (method instanceof HttpEntityContainer && request.getBody().isPresent()) {
            org.apache.hc.core5.http.ContentType contentType;
            String contentTypeHeader = request.asHttpPart().contentTypeHeader();
            try {
                String string = contentTypeHeader;
                if (string == null) {
                    string = request.getBody().getContentType().toString();
                }
                String ct = string;
                contentType = org.apache.hc.core5.http.ContentType.parse((CharSequence)ct);
            }
            catch (UnsupportedCharsetException e) {
                contentType = null;
            }
            org.apache.hc.core5.http.ContentType contentType2 = contentType;
            ((HttpEntityContainer)method).setEntity((HttpEntity)new ByteArrayEntity(request.getBody().orEmpty(), contentType2));
        }
    }

    public void setupHeaders(@NotNull IRequest request, @NotNull HttpRequest method) {
        Intrinsics.checkNotNullParameter((Object)request, (String)REQUEST);
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Map headers = request.getHeaders();
        if (!headers.isEmpty()) {
            Map $this$forEach$iv = headers;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                method.addHeader(key, (Object)CollectionsKt.joinToString$default((Iterable)value, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
            }
        }
        if (!method.containsHeader(CONTENT_TYPE) && request.getBody().isPresent()) {
            String contentType = Intrinsics.areEqual((Object)request.getBody().getContentType(), (Object)ContentType.Companion.getUNKNOWN()) ? "text/plain; charset=ISO-8859-1" : request.getBody().getContentType().toString();
            method.addHeader(CONTENT_TYPE, (Object)contentType);
        }
    }

    @Nullable
    public ClassicHttpResponse makeStateChangeRequest(@Nullable Object stateChangeUrl, @NotNull ProviderState state, boolean postStateInBody, boolean isSetup, boolean stateChangeTeardown) {
        ClassicHttpResponse classicHttpResponse;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (stateChangeUrl != null) {
            CloseableHttpClient httpclient = this.getHttpClient();
            URIBuilder urlBuilder = stateChangeUrl instanceof URI ? new URIBuilder((URI)stateChangeUrl) : new URIBuilder(stateChangeUrl.toString());
            HttpPost method = null;
            if (postStateInBody) {
                method = new HttpPost(urlBuilder.build());
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"state", (Object)String.valueOf(state.getName()))};
                Map map = MapsKt.mutableMapOf((Pair[])pairArray);
                if (!state.getParams().isEmpty()) {
                    map.put("params", state.getParams());
                }
                if (stateChangeTeardown) {
                    map.put(ACTION, isSetup ? "setup" : "teardown");
                }
                method.setEntity((HttpEntity)new StringEntity(Json.INSTANCE.prettyPrint((Object)map), org.apache.hc.core5.http.ContentType.APPLICATION_JSON));
            } else {
                urlBuilder.setParameter("state", state.getName());
                Map $this$forEach$iv = state.getParams();
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl = false;
                    String k = (String)entry.getKey();
                    Object v = entry.getValue();
                    urlBuilder.setParameter(k, String.valueOf(v));
                }
                if (stateChangeTeardown) {
                    if (isSetup) {
                        urlBuilder.setParameter(ACTION, "setup");
                    } else {
                        urlBuilder.setParameter(ACTION, "teardown");
                    }
                }
                method = new HttpPost(urlBuilder.build());
            }
            if (this.provider.getStateChangeRequestFilter() != null) {
                if (this.provider.getStateChangeRequestFilter() instanceof groovy.lang.Closure) {
                    Object object = this.provider.getStateChangeRequestFilter();
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type groovy.lang.Closure<*>");
                    ((groovy.lang.Closure)object).call((Object)method);
                } else {
                    Binding binding = new Binding();
                    binding.setVariable(REQUEST, (Object)method);
                    GroovyShell shell = new GroovyShell(binding);
                    shell.evaluate(String.valueOf(this.provider.getStateChangeRequestFilter()));
                }
            }
            classicHttpResponse = (ClassicHttpResponse)httpclient.execute((ClassicHttpRequest)method);
        } else {
            classicHttpResponse = null;
        }
        return classicHttpResponse;
    }

    @NotNull
    public final CloseableHttpClient getHttpClient() {
        return this.httpClientFactory.newClient(this.provider);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProviderResponse handleResponse(@NotNull ClassicHttpResponse httpResponse) {
        Map map;
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        void $this$mapValuesTo$iv$iv2;
        void $this$mapValues$iv2;
        Iterable it;
        Map.Entry header;
        Object object2;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        Companion.getLogger().debug((Function0)new Function0<Object>(httpResponse){
            final /* synthetic */ ClassicHttpResponse $httpResponse;
            {
                this.$httpResponse = $httpResponse;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Received response: " + this.$httpResponse.getCode();
            }
        });
        ContentType contentType = ContentType.Companion.getTEXT_PLAIN();
        Header[] headerArray = httpResponse.getHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)headerArray, (String)"httpResponse.headers");
        Object[] objectArray = headerArray;
        boolean $i$f$groupBy = false;
        void var6_6 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Iterator element$iv$iv : $this$groupByTo$iv$iv) {
            List list;
            Object object3;
            Header header2 = (Header)element$iv$iv;
            boolean $i$a$-groupBy-ProviderClient$handleResponse$headers$32 = false;
            String key$iv$iv = header2.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object3;
            Header $i$a$-groupBy-ProviderClient$handleResponse$headers$32 = (Header)element$iv$iv;
            object2 = list$iv$iv;
            boolean bl4 = false;
            String string = header.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"header.name");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (SINGLE_VALUE_HEADERS.contains(string2)) {
                String string3 = header.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"header.value");
                list = CollectionsKt.listOf((Object)((Object)StringsKt.trim((CharSequence)string3)).toString());
            } else {
                void $this$mapTo$iv$iv;
                String string4 = header.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"header.value");
                char[] cArray = new char[]{','};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)string4, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string5 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)((Object)it)))).toString());
                }
                list = (List)destination$iv$iv2;
            }
            object2.add(list);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv2;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            header = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry $i$f$getOrPut = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object2 = map2;
            boolean bl3 = false;
            object = CollectionsKt.flatten((Iterable)((Iterable)it2.getValue()));
            object2.put(k, object);
        }
        Map headers = destination$iv$iv;
        OptionalBody body = null;
        HttpEntity entity = httpResponse.getEntity();
        if (entity != null) {
            if (entity.getContentType() != null) {
                contentType = ContentType.Companion.fromString(entity.getContentType());
            }
            body = OptionalBody.Companion.body(entity.getContent().readAllBytes(), contentType);
        }
        destination$iv$iv = headers;
        OptionalBody optionalBody = body;
        ContentType contentType2 = contentType;
        Map map3 = headers;
        object = httpResponse.getCode();
        boolean $i$f$mapValues2 = false;
        $this$associateByTo$iv$iv$iv = $this$mapValues$iv;
        Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void $this$mapTo$iv$iv;
            void headerEntry;
            void it$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv3;
            boolean bl = false;
            Map.Entry bl4 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map4;
            boolean bl5 = false;
            Iterable $this$map$iv = (Iterable)headerEntry.getValue();
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it3;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv4;
                boolean bl6 = false;
                collection.add(new JsonValue.StringValue((String)it3));
            }
            List list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv4));
            JsonValue jsonValue = (JsonValue)new JsonValue.Array(list);
            MetadataValue.NonBinaryData nonBinaryData = new MetadataValue.NonBinaryData(jsonValue);
            map.put(k, nonBinaryData);
        }
        Map map5 = map = destination$iv$iv3;
        OptionalBody optionalBody2 = optionalBody;
        ContentType contentType3 = contentType2;
        Map map6 = map3;
        Object object4 = object;
        ProviderResponse response = new ProviderResponse((Integer)object4, map6, contentType3, optionalBody2, map5);
        Companion.getLogger().debug((Function0)new Function0<Object>(response){
            final /* synthetic */ ProviderResponse $response;
            {
                this.$response = $response;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Response: " + this.$response;
            }
        });
        return response;
    }

    @NotNull
    public HttpUriRequest newRequest(@NotNull IRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)REQUEST);
        String scheme = this.provider.getProtocol();
        Object host = ProviderClient.Companion.invokeIfClosure(this.provider.getHost());
        int port = ProviderClient.Companion.convertToInteger(ProviderClient.Companion.invokeIfClosure(this.provider.getPort()));
        Object path = Companion.stripTrailingSlash(this.provider.getPath());
        URIBuilder urlBuilder = null;
        urlBuilder = new URIBuilder();
        if (this.systemPropertySet("pact.verifier.disableUrlPathDecoding")) {
            path = (String)path + request.getPath();
            urlBuilder = new URIBuilder(scheme + "://" + host + ":" + port + (String)path);
        } else {
            path = (String)path + URLDecoder.decode(request.getPath(), UTF8);
            urlBuilder.setScheme(this.provider.getProtocol());
            Object object = ProviderClient.Companion.invokeIfClosure(this.provider.getHost());
            urlBuilder.setHost(object != null ? object.toString() : null);
            urlBuilder.setPort(ProviderClient.Companion.convertToInteger(ProviderClient.Companion.invokeIfClosure(this.provider.getPort())));
            urlBuilder.setPath((String)path);
        }
        Map $this$forEach$iv = request.getQuery();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)entry.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                urlBuilder.addParameter((String)entry.getKey(), it);
            }
        }
        String string = urlBuilder.build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlBuilder.build().toString()");
        String url = string;
        String string2 = request.getMethod().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return switch (string2) {
            case "post" -> (HttpUriRequest)new HttpPost(url);
            case "put" -> (HttpUriRequest)new HttpPut(url);
            case "options" -> (HttpUriRequest)new HttpOptions(url);
            case "delete" -> (HttpUriRequest)new HttpDelete(url);
            case "head" -> (HttpUriRequest)new HttpHead(url);
            case "patch" -> (HttpUriRequest)new HttpPatch(url);
            case "trace" -> (HttpUriRequest)new HttpTrace(url);
            default -> (HttpUriRequest)new HttpGet(url);
        };
    }

    public boolean systemPropertySet(@NotNull String property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return Boolean.getBoolean(property);
    }

    private static final ProviderResponse executeRequest$lambda$0(ProviderClient this$0, ClassicHttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        return this$0.handleResponse(response);
    }

    @JvmStatic
    public static final boolean urlEncodedFormPost(@NotNull Request request) {
        return Companion.urlEncodedFormPost(request);
    }

    @JvmStatic
    @NotNull
    public static final String stripTrailingSlash(@NotNull String basePath) {
        return Companion.stripTrailingSlash(basePath);
    }

    static {
        Object[] objectArray = new String[]{"set-cookie", "www-authenticate", "proxy-authenticate", "date", "expires", "last-modified", "if-modified-since", "if-unmodified-since", "retry-after"};
        SINGLE_VALUE_HEADERS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fJ\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0007J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lau/com/dius/pact/provider/ProviderClient$Companion;", "Lio/github/oshai/kotlinlogging/KLogging;", "()V", "ACTION", "", "CONTENT_TYPE", "REQUEST", "SINGLE_VALUE_HEADERS", "", "getSINGLE_VALUE_HEADERS", "()Ljava/util/Set;", "UTF8", "convertToInteger", "", "port", "", "invokeIfClosure", "property", "isFunctionalInterface", "", "requestFilter", "stripTrailingSlash", "basePath", "urlEncodedFormPost", "request", "Lau/com/dius/pact/core/model/Request;", "provider"})
    @SourceDebugExtension(value={"SMAP\nProviderClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProviderClient.kt\nau/com/dius/pact/provider/ProviderClient$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,511:1\n12474#2,2:512\n*S KotlinDebug\n*F\n+ 1 ProviderClient.kt\nau/com/dius/pact/provider/ProviderClient$Companion\n*L\n277#1:512,2\n*E\n"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        @NotNull
        public final Set<String> getSINGLE_VALUE_HEADERS() {
            return SINGLE_VALUE_HEADERS;
        }

        private final Object invokeIfClosure(Object property) {
            return property instanceof groovy.lang.Closure ? ((groovy.lang.Closure)property).call() : property;
        }

        private final int convertToInteger(Object port) {
            return port instanceof Number ? ((Number)port).intValue() : Integer.parseInt(String.valueOf(port));
        }

        @JvmStatic
        public final boolean urlEncodedFormPost(@NotNull Request request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)ProviderClient.REQUEST);
            String string = request.getMethod().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            return Intrinsics.areEqual((Object)string, (Object)"post") && Intrinsics.areEqual((Object)request.determineContentType().getBaseType(), (Object)org.apache.hc.core5.http.ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
        }

        public final boolean isFunctionalInterface(@NotNull Object requestFilter) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)requestFilter, (String)"requestFilter");
                Class<?>[] classArray = requestFilter.getClass().getInterfaces();
                Intrinsics.checkNotNullExpressionValue(classArray, (String)"requestFilter::class.java.interfaces");
                Object[] $this$any$iv = classArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Class it = (Class)element$iv;
                    boolean bl2 = false;
                    if (!it.isAnnotationPresent(FunctionalInterface.class)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @JvmStatic
        @NotNull
        public final String stripTrailingSlash(@NotNull String basePath) {
            String string;
            Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
            if (Intrinsics.areEqual((Object)basePath, (Object)"/")) {
                string = "";
            } else if (((CharSequence)basePath).length() > 0 && StringsKt.last((CharSequence)basePath) == '/') {
                String string2 = basePath.substring(0, basePath.length() - 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = basePath;
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

