/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider;

import au.com.dius.pact.core.model.DefaultPactReader;
import au.com.dius.pact.core.model.FileSource;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PluginData;
import au.com.dius.pact.core.model.V4Interaction;
import au.com.dius.pact.core.model.V4Pact;
import au.com.dius.pact.core.support.Json;
import au.com.dius.pact.core.support.json.JsonValue;
import au.com.dius.pact.provider.ConsumerInfo;
import au.com.dius.pact.provider.IConsumerInfo;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.PactVerification;
import au.com.dius.pact.provider.PactVerifierException;
import au.com.dius.pact.provider.ProviderUtils;
import au.com.dius.pact.provider.junitsupport.loader.PactLoader;
import au.com.dius.pact.provider.junitsupport.loader.PactSource;
import io.github.oshai.kotlinlogging.KLogging;
import io.pact.plugins.jvm.core.PluginConfiguration;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00050\u00042\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tH\u0007J3\u0010\n\u001a\u0004\u0018\u0001H\u000b\"\b\b\u0000\u0010\u000b*\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\fH\u0007\u00a2\u0006\u0002\u0010\u000eJ.\u0010\u000f\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00050\u00042\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0016J^\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00042\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010!\u001a\u00020\u00182\b\b\u0002\u0010\"\u001a\u00020#2\u000e\b\u0002\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00042\u000e\b\u0002\u0010&\u001a\b\u0012\u0004\u0012\u00020%0\u0004H\u0007J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u00042\u0006\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001bH\u0007J\u000e\u0010)\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020*J&\u0010+\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020-0,2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0007J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u001bH\u0007\u00a8\u0006\u001c"}, d2={"Lau/com/dius/pact/provider/ProviderUtils;", "Lio/github/oshai/kotlinlogging/KLogging;", "()V", "findAllPactSources", "", "Lkotlin/Pair;", "Lau/com/dius/pact/provider/junitsupport/loader/PactSource;", "", "clazz", "Lkotlin/reflect/KClass;", "findAnnotation", "T", "Ljava/lang/Class;", "annotation", "(Ljava/lang/Class;Ljava/lang/Class;)Ljava/lang/annotation/Annotation;", "findPactSourceOnAnnotations", "parent", "instantiatePactLoader", "Lau/com/dius/pact/provider/junitsupport/loader/PactLoader;", "pactSource", "testClass", "testInstance", "", "isS3Url", "", "pactFile", "loadPactFiles", "Lau/com/dius/pact/provider/IConsumerInfo;", "provider", "Lau/com/dius/pact/provider/IProviderInfo;", "pactFileDir", "Ljava/io/File;", "stateChange", "stateChangeUsesBody", "verificationType", "Lau/com/dius/pact/provider/PactVerification;", "packagesToScan", "", "pactFileAuthentication", "providerInfo", "consumer", "pactFileExists", "Lau/com/dius/pact/core/model/FileSource;", "pluginConfigForInteraction", "", "Lio/pact/plugins/jvm/core/PluginConfiguration;", "pact", "Lau/com/dius/pact/core/model/Pact;", "interaction", "Lau/com/dius/pact/core/model/Interaction;"})
@SourceDebugExtension(value={"SMAP\nProviderUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProviderUtils.kt\nau/com/dius/pact/provider/ProviderUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,203:1\n1855#2:204\n1856#2:206\n1179#2,2:207\n1253#2,2:209\n1238#2,4:213\n1256#2:217\n1#3:205\n453#4:211\n403#4:212\n*S KotlinDebug\n*F\n+ 1 ProviderUtils.kt\nau/com/dius/pact/provider/ProviderUtils\n*L\n105#1:204\n105#1:206\n192#1:207,2\n192#1:209,2\n195#1:213,4\n192#1:217\n195#1:211\n195#1:212\n*E\n"})
public final class ProviderUtils
extends KLogging {
    @NotNull
    public static final ProviderUtils INSTANCE = new ProviderUtils();

    private ProviderUtils() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType, @NotNull List<String> packagesToScan, @NotNull List<String> pactFileAuthentication) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pactFileDir, (String)"pactFileDir");
        Intrinsics.checkNotNullParameter((Object)((Object)verificationType), (String)"verificationType");
        Intrinsics.checkNotNullParameter(packagesToScan, (String)"packagesToScan");
        Intrinsics.checkNotNullParameter(pactFileAuthentication, (String)"pactFileAuthentication");
        if (!pactFileDir.exists()) {
            throw new PactVerifierException("Pact file directory (" + pactFileDir + ") does not exist", null, 2, null);
        }
        if (!pactFileDir.isDirectory()) {
            throw new PactVerifierException("Pact file directory (" + pactFileDir + ") is not a directory", null, 2, null);
        }
        if (!pactFileDir.canRead()) {
            throw new PactVerifierException("Pact file directory (" + pactFileDir + ") is not readable", null, 2, null);
        }
        System.out.println((Object)("Loading pact files for provider " + provider.getName() + " from " + pactFileDir));
        List consumers2 = new ArrayList();
        File[] fileArray = pactFileDir.listFiles(ProviderUtils::loadPactFiles$lambda$0);
        Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"pactFileDir.listFiles { \u2026Extension(name, \"json\") }");
        for (File f : fileArray) {
            Intrinsics.checkNotNullExpressionValue((Object)f, (String)"f");
            Pact pact = DefaultPactReader.INSTANCE.loadPact((Object)f);
            String providerName = pact.getProvider().getName();
            if (Intrinsics.areEqual((Object)providerName, (Object)provider.getName())) {
                consumers2.add(new ConsumerInfo(pact.getConsumer().getName(), stateChange2, stateChangeUsesBody, packagesToScan, verificationType, new FileSource(f, null, 2, null), pactFileAuthentication, null, false, false, null, 1920, null));
                continue;
            }
            String string = "Skipping " + f + " as the provider names don't match provider.name: " + provider.getName() + " vs pactJson.provider.name: " + providerName;
            System.out.println((Object)string);
        }
        System.out.println((Object)("Found " + consumers2.size() + " pact files"));
        return consumers2;
    }

    public static /* synthetic */ List loadPactFiles$default(IProviderInfo iProviderInfo, File file, Object object, boolean bl, PactVerification pactVerification, List list, List list2, int n, Object object2) {
        if ((n & 4) != 0) {
            object = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            pactVerification = PactVerification.REQUEST_RESPONSE;
        }
        if ((n & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x40) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return ProviderUtils.loadPactFiles(iProviderInfo, file, object, bl, pactVerification, list, list2);
    }

    public final boolean pactFileExists(@NotNull FileSource pactFile) {
        Intrinsics.checkNotNullParameter((Object)pactFile, (String)"pactFile");
        return pactFile.getFile().exists();
    }

    @JvmStatic
    @NotNull
    public static final PactVerification verificationType(@NotNull IProviderInfo provider, @NotNull IConsumerInfo consumer) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        PactVerification pactVerification = consumer.getVerificationType();
        if (pactVerification == null && (pactVerification = provider.getVerificationType()) == null) {
            pactVerification = PactVerification.REQUEST_RESPONSE;
        }
        return pactVerification;
    }

    @JvmStatic
    @NotNull
    public static final List<String> packagesToScan(@NotNull IProviderInfo providerInfo, @NotNull IConsumerInfo consumer) {
        Intrinsics.checkNotNullParameter((Object)providerInfo, (String)"providerInfo");
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        return !((Collection)consumer.getPackagesToScan()).isEmpty() ? consumer.getPackagesToScan() : providerInfo.getPackagesToScan();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isS3Url(@Nullable Object pactFile) {
        if (!(pactFile instanceof String)) return false;
        String string = ((String)pactFile).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"s3://", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @JvmStatic
    @Nullable
    public static final <T extends Annotation> T findAnnotation(@NotNull Class<?> clazz, @NotNull Class<T> annotation) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(annotation, (String)"annotation");
        T value = clazz.getAnnotation(annotation);
        if (value == null) {
            for (Annotation anno : JvmClassMappingKt.getKotlinClass(clazz).getAnnotations()) {
                KClass annotationClass = JvmClassMappingKt.getAnnotationClass((Annotation)anno);
                if (StringsKt.startsWith$default((String)String.valueOf(annotationClass.getQualifiedName()), (String)"java.lang.annotation.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)String.valueOf(annotationClass.getQualifiedName()), (String)"kotlin.annotation.", (boolean)false, (int)2, null)) continue;
                T valueAnnotation = ProviderUtils.findAnnotation(JvmClassMappingKt.getJavaClass((KClass)annotationClass), annotation);
                if (valueAnnotation == null) continue;
                value = valueAnnotation;
            }
        }
        return value;
    }

    @JvmStatic
    @NotNull
    public static final List<Pair<PactSource, Annotation>> findAllPactSources(@NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf(clazz), (Iterable)KClasses.getAllSuperclasses(clazz));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            KClass it;
            block4: {
                it = (KClass)element$iv;
                boolean bl = false;
                Iterable iterable = it.getAnnotations();
                for (Object t : iterable) {
                    Annotation annotation = (Annotation)t;
                    boolean bl2 = false;
                    if (!(annotation instanceof PactSource)) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            Annotation annotationOnClass = v0;
            if (annotationOnClass instanceof PactSource) {
                result2.add(TuplesKt.to((Object)annotationOnClass, null));
            }
            for (Annotation anno : it.getAnnotations()) {
                result2.addAll((Collection)INSTANCE.findPactSourceOnAnnotations(anno, null));
            }
        }
        return result2;
    }

    private final List<Pair<PactSource, Annotation>> findPactSourceOnAnnotations(Annotation annotation, Annotation parent) {
        List result2 = new ArrayList();
        if (annotation instanceof PactSource && parent != null) {
            result2.add(TuplesKt.to((Object)annotation, (Object)parent));
        }
        for (Annotation anno : JvmClassMappingKt.getAnnotationClass((Annotation)annotation).getAnnotations()) {
            KClass annotationClass = JvmClassMappingKt.getAnnotationClass((Annotation)anno);
            if (StringsKt.startsWith$default((String)String.valueOf(annotationClass.getQualifiedName()), (String)"java.lang.annotation.", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)String.valueOf(annotationClass.getQualifiedName()), (String)"kotlin.annotation.", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)anno, (Object)annotation)) continue;
            result2.addAll((Collection)this.findPactSourceOnAnnotations(anno, annotation));
        }
        return result2;
    }

    @NotNull
    public final PactLoader instantiatePactLoader(@NotNull PactSource pactSource, @NotNull Class<?> testClass, @Nullable Object testInstance, @Nullable Annotation annotation) {
        PactLoader pactLoader2;
        Intrinsics.checkNotNullParameter((Object)pactSource, (String)"pactSource");
        Intrinsics.checkNotNullParameter(testClass, (String)"testClass");
        KClass pactLoaderClass = Reflection.getOrCreateKotlinClass(pactSource.value());
        try {
            Object[] objectArray = new Class[]{Class.class};
            Constructor constructorWithClass = JvmClassMappingKt.getJavaClass((KClass)pactLoaderClass).getDeclaredConstructor((Class<?>[])objectArray);
            constructorWithClass.setAccessible(true);
            objectArray = new Object[]{testClass};
            pactLoader2 = (PactLoader)constructorWithClass.newInstance(objectArray);
        }
        catch (NoSuchMethodException e) {
            PactLoader pactLoader3;
            this.getLogger().debug((Function0)instantiatePactLoader.pactLoader.1.INSTANCE);
            if (annotation != null) {
                PactLoader pactLoader4;
                try {
                    Object[] objectArray = new Class[]{JvmClassMappingKt.getJavaClass((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation))};
                    Constructor constructor = JvmClassMappingKt.getJavaClass((KClass)pactLoaderClass).getDeclaredConstructor((Class<?>[])objectArray);
                    constructor.setAccessible(true);
                    objectArray = new Object[]{annotation};
                    pactLoader4 = (PactLoader)constructor.newInstance(objectArray);
                }
                catch (NoSuchMethodException e2) {
                    PactLoader pactLoader5;
                    this.getLogger().debug((Function0)new Function0<Object>(pactSource){
                        final /* synthetic */ PactSource $pactSource;
                        {
                            this.$pactSource = $pactSource;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Pact loader does not have a constructor with one argument of type " + this.$pactSource;
                        }
                    });
                    try {
                        KProperty1 annotationValueProp;
                        Object v0;
                        Object[] objectArray;
                        block9: {
                            objectArray = (Object[])KClasses.getMemberProperties((KClass)JvmClassMappingKt.getAnnotationClass((Annotation)annotation));
                            for (Object t : objectArray) {
                                KProperty1 it = (KProperty1)t;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"value")) continue;
                                v0 = t;
                                break block9;
                            }
                            v0 = null;
                        }
                        KProperty1 kProperty1 = annotationValueProp = (KProperty1)v0;
                        Intrinsics.checkNotNull((Object)kProperty1);
                        objectArray = new Object[]{annotation};
                        Object object = kProperty1.getGetter().call(objectArray);
                        Intrinsics.checkNotNull((Object)object);
                        Object annotationValue = object;
                        objectArray = new Class[]{annotationValue.getClass()};
                        Constructor constructor = JvmClassMappingKt.getJavaClass((KClass)pactLoaderClass).getDeclaredConstructor((Class<?>[])objectArray);
                        objectArray = new Object[]{annotationValue};
                        pactLoader5 = (PactLoader)constructor.newInstance(objectArray);
                    }
                    catch (NoSuchMethodException e3) {
                        this.getLogger().debug((Function0)new Function0<Object>(pactSource){
                            final /* synthetic */ PactSource $pactSource;
                            {
                                this.$pactSource = $pactSource;
                                super(0);
                            }

                            @Nullable
                            public final Object invoke() {
                                return "Pact loader does not have a constructor with one argument of type " + Reflection.getOrCreateKotlinClass(this.$pactSource.value());
                            }
                        });
                        pactLoader5 = (PactLoader)KClasses.createInstance((KClass)pactLoaderClass);
                    }
                    pactLoader4 = pactLoader5;
                }
                pactLoader3 = pactLoader4;
            } else {
                pactLoader3 = (PactLoader)KClasses.createInstance((KClass)pactLoaderClass);
            }
            pactLoader2 = pactLoader3;
        }
        PactLoader pactLoader6 = pactLoader2;
        pactLoader6.initLoader(testClass, testInstance);
        Intrinsics.checkNotNullExpressionValue((Object)pactLoader6, (String)"pactLoader");
        return pactLoader6;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Map<String, PluginConfiguration> pluginConfigForInteraction(@Nullable Pact pact, @NotNull Interaction interaction) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        if (pact != null && pact.isV4Pact()) {
            void $this$associateTo$iv$iv;
            V4Pact v4Pact = (V4Pact)pact.asV4Pact().unwrap();
            V4Interaction v4Interaction = interaction.asV4Interaction();
            List pactPluginData = v4Pact.pluginData();
            Map interactionPluginData = MapsKt.toMap((Map)v4Interaction.getPluginConfiguration());
            Iterable $this$associate$iv = pactPluginData;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2;
                void $this$mapValuesTo$iv$iv;
                void $this$mapValues$iv;
                Map map3 = destination$iv$iv;
                PluginData it = (PluginData)element$iv$iv;
                boolean bl = false;
                String string = it.getName();
                Map map4 = (Map)interactionPluginData.get(it.getName());
                if (map4 == null) {
                    map4 = MapsKt.emptyMap();
                }
                Map map5 = it.getConfiguration();
                Map map6 = MapsKt.toMutableMap((Map)map4);
                String string2 = string;
                boolean $i$f$mapValues = false;
                void var21_21 = $this$mapValues$iv;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map7 = destination$iv$iv2;
                    boolean bl2 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    map2 = map7;
                    boolean bl3 = false;
                    Object v = entry2.getValue();
                    JsonValue jsonValue = Json.toJson(v);
                    map2.put(k, jsonValue);
                }
                map2 = destination$iv$iv2;
                Map map8 = MapsKt.toMutableMap((Map)map2);
                Map map9 = map6;
                Pair pair = TuplesKt.to((Object)string2, (Object)new PluginConfiguration(map9, map8));
                map3.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType, @NotNull List<String> packagesToScan) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pactFileDir, (String)"pactFileDir");
        Intrinsics.checkNotNullParameter((Object)((Object)verificationType), (String)"verificationType");
        Intrinsics.checkNotNullParameter(packagesToScan, (String)"packagesToScan");
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, verificationType, packagesToScan, null, 64, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody, @NotNull PactVerification verificationType) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pactFileDir, (String)"pactFileDir");
        Intrinsics.checkNotNullParameter((Object)((Object)verificationType), (String)"verificationType");
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, verificationType, null, null, 96, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2, boolean stateChangeUsesBody) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pactFileDir, (String)"pactFileDir");
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, stateChangeUsesBody, null, null, null, 112, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir, @Nullable Object stateChange2) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pactFileDir, (String)"pactFileDir");
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, stateChange2, false, null, null, null, 120, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final List<IConsumerInfo> loadPactFiles(@NotNull IProviderInfo provider, @NotNull File pactFileDir) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)pactFileDir, (String)"pactFileDir");
        return ProviderUtils.loadPactFiles$default(provider, pactFileDir, null, false, null, null, null, 124, null);
    }

    private static final boolean loadPactFiles$lambda$0(File file, String name) {
        return FilenameUtils.isExtension((String)name, (String)"json");
    }
}

