/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.junit5;

import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.PluginData;
import au.com.dius.pact.core.model.V4Pact;
import au.com.dius.pact.core.support.Result;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.IProviderVerifier;
import au.com.dius.pact.provider.ProviderResponse;
import au.com.dius.pact.provider.RequestDataToBeVerified;
import au.com.dius.pact.provider.junit5.PluginProvider;
import au.com.dius.pact.provider.junit5.TestTarget;
import io.pact.plugins.jvm.core.CatalogueEntry;
import io.pact.plugins.jvm.core.CatalogueManager;
import io.pact.plugins.jvm.core.DefaultPluginManager;
import io.pact.plugins.jvm.core.InteractionVerificationData;
import io.pact.plugins.jvm.core.PactPluginNotFoundException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J<\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J \u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006%"}, d2={"Lau/com/dius/pact/provider/junit5/PluginTestTarget;", "Lau/com/dius/pact/provider/junit5/TestTarget;", "config", "", "", "", "(Ljava/util/Map;)V", "transportEntry", "Lio/pact/plugins/jvm/core/CatalogueEntry;", "userConfig", "", "getUserConfig", "()Ljava/util/Map;", "executeInteraction", "Lau/com/dius/pact/provider/ProviderResponse;", "client", "request", "getProviderInfo", "Lau/com/dius/pact/provider/IProviderInfo;", "serviceName", "pactSource", "Lau/com/dius/pact/core/model/PactSource;", "isHttpTarget", "", "prepareRequest", "Lkotlin/Pair;", "pact", "Lau/com/dius/pact/core/model/Pact;", "interaction", "Lau/com/dius/pact/core/model/Interaction;", "context", "prepareVerifier", "", "verifier", "Lau/com/dius/pact/provider/IProviderVerifier;", "testInstance", "supportsInteraction", "junit5"})
public final class PluginTestTarget
implements TestTarget {
    @NotNull
    private final Map<String, Object> config;
    private CatalogueEntry transportEntry;

    public PluginTestTarget(@NotNull Map<String, Object> config) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        this.config = config;
    }

    public /* synthetic */ PluginTestTarget(Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = new LinkedHashMap();
        }
        this(map);
    }

    @Override
    @NotNull
    public Map<String, Object> getUserConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public IProviderInfo getProviderInfo(@NotNull String serviceName, @Nullable PactSource pactSource) {
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        return new PluginProvider(serviceName, pactSource, this.config);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Pair<Object, Object> prepareRequest(@NotNull Pact pact, @NotNull Interaction interaction, @NotNull Map<String, Object> context) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Result v4pact = pact.asV4Pact();
        if (!(v4pact instanceof Result.Ok)) {
            if (!(v4pact instanceof Result.Err)) throw new NoWhenBranchMatchedException();
            throw new RuntimeException("PluginTestTarget can only be used with V4 Pacts");
        }
        CatalogueEntry catalogueEntry = this.transportEntry;
        if (catalogueEntry == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"transportEntry");
            catalogueEntry = null;
        }
        if ((result = DefaultPluginManager.INSTANCE.prepareValidationForInteraction(catalogueEntry, (V4Pact)((Result.Ok)v4pact).getValue(), interaction.asV4Interaction(), this.config)) instanceof Result.Ok) {
            RequestDataToBeVerified requestDataToBeVerified = new RequestDataToBeVerified((InteractionVerificationData)((Result.Ok)result).getValue());
            CatalogueEntry catalogueEntry2 = this.transportEntry;
            CatalogueEntry catalogueEntry3 = catalogueEntry2;
            if (catalogueEntry2 != null) return TuplesKt.to((Object)requestDataToBeVerified, (Object)catalogueEntry3);
            Intrinsics.throwUninitializedPropertyAccessException((String)"transportEntry");
            catalogueEntry3 = null;
            return TuplesKt.to((Object)requestDataToBeVerified, (Object)catalogueEntry3);
        }
        if (!(result instanceof Result.Err)) throw new NoWhenBranchMatchedException();
        throw new RuntimeException("Failed to configure the interaction for verification - " + ((Result.Err)result).getError());
    }

    @Override
    public boolean isHttpTarget() {
        return false;
    }

    @Override
    public boolean supportsInteraction(@NotNull Interaction interaction) {
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        return interaction.isV4();
    }

    @Override
    @NotNull
    public ProviderResponse executeInteraction(@Nullable Object client, @Nullable Object request) {
        return new ProviderResponse(null, null, null, null, null, 31, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepareVerifier(@NotNull IProviderVerifier verifier, @NotNull Object testInstance, @NotNull Pact pact) {
        Intrinsics.checkNotNullParameter((Object)verifier, (String)"verifier");
        Intrinsics.checkNotNullParameter((Object)testInstance, (String)"testInstance");
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        if (!pact.isV4Pact()) throw new RuntimeException("PluginTestTarget can only be used with V4 Pacts");
        Result v4pact = pact.asV4Pact();
        if (v4pact instanceof Result.Ok) {
            for (PluginData plugin : ((V4Pact)((Result.Ok)v4pact).getValue()).pluginData()) {
                Result result = DefaultPluginManager.INSTANCE.loadPlugin(plugin.getName(), plugin.getVersion());
                if (result instanceof Result.Ok || !(result instanceof Result.Err)) continue;
                throw new PactPluginNotFoundException(plugin.getName(), plugin.getVersion());
            }
            Object transport = this.config.get("transport");
            if (!(transport instanceof String)) throw new RuntimeException("PluginTestTarget requires the transport to be configured");
            CatalogueEntry entry = CatalogueManager.INSTANCE.lookupEntry("transport/" + transport);
            if (entry == null) throw new RuntimeException("Did not find a registered transport '" + transport + "'");
            this.transportEntry = entry;
            return;
        } else {
            if (!(v4pact instanceof Result.Err)) return;
            throw new RuntimeException("PluginTestTarget can only be used with V4 Pacts");
        }
    }

    public PluginTestTarget() {
        this(null, 1, null);
    }
}

