/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.spring.junit5;

import au.com.dius.pact.core.model.IRequest;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.SynchronousRequestResponse;
import au.com.dius.pact.core.model.generators.GeneratorTestMode;
import au.com.dius.pact.provider.IProviderVerifier;
import au.com.dius.pact.provider.ProviderInfo;
import au.com.dius.pact.provider.ProviderResponse;
import au.com.dius.pact.provider.spring.junit5.WebFluxBasedTestTarget;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.server.RouterFunction;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J4\u0010\u0005\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lau/com/dius/pact/provider/spring/junit5/WebFluxTarget;", "Lau/com/dius/pact/provider/spring/junit5/WebFluxBasedTestTarget;", "routerFunction", "Lorg/springframework/web/reactive/function/server/RouterFunction;", "(Lorg/springframework/web/reactive/function/server/RouterFunction;)V", "prepareRequest", "Lkotlin/Pair;", "Lorg/springframework/test/web/reactive/server/WebTestClient$RequestHeadersSpec;", "Lorg/springframework/test/web/reactive/server/WebTestClient;", "interaction", "Lau/com/dius/pact/core/model/Interaction;", "context", "", "", "", "junit5spring"})
public final class WebFluxTarget
implements WebFluxBasedTestTarget {
    @NotNull
    private final RouterFunction<?> routerFunction;

    public WebFluxTarget(@NotNull RouterFunction<?> routerFunction) {
        Intrinsics.checkNotNullParameter(routerFunction, (String)"routerFunction");
        this.routerFunction = routerFunction;
    }

    @NotNull
    public Pair<WebTestClient.RequestHeadersSpec<?>, WebTestClient> prepareRequest(@NotNull Interaction interaction, @NotNull Map<String, Object> context) {
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        if (interaction instanceof SynchronousRequestResponse) {
            IRequest request = ((SynchronousRequestResponse)interaction).getRequest().generatedRequest(context, GeneratorTestMode.Provider);
            WebTestClient webClient = WebTestClient.bindToRouterFunction(this.routerFunction).build();
            Intrinsics.checkNotNullExpressionValue((Object)webClient, (String)"webClient");
            return TuplesKt.to(this.toWebFluxRequestBuilder(webClient, request), (Object)webClient);
        }
        throw new UnsupportedOperationException("Only request/response interactions can be used with a WebFlux test target");
    }

    @Override
    @NotNull
    public ProviderResponse executeInteraction(@Nullable Object client, @Nullable Object request) {
        return WebFluxBasedTestTarget.DefaultImpls.executeInteraction(this, client, request);
    }

    @Override
    @NotNull
    public ProviderInfo getProviderInfo(@NotNull String serviceName, @Nullable PactSource pactSource) {
        return WebFluxBasedTestTarget.DefaultImpls.getProviderInfo(this, serviceName, pactSource);
    }

    @Override
    public boolean isHttpTarget() {
        return WebFluxBasedTestTarget.DefaultImpls.isHttpTarget(this);
    }

    @Override
    public void prepareVerifier(@NotNull IProviderVerifier verifier, @NotNull Object testInstance) {
        WebFluxBasedTestTarget.DefaultImpls.prepareVerifier(this, verifier, testInstance);
    }

    @Override
    @NotNull
    public String requestUriString(@NotNull IRequest request) {
        return WebFluxBasedTestTarget.DefaultImpls.requestUriString(this, request);
    }

    @Override
    @NotNull
    public WebTestClient.RequestHeadersSpec<?> toWebFluxRequestBuilder(@NotNull WebTestClient webClient, @NotNull IRequest request) {
        return WebFluxBasedTestTarget.DefaultImpls.toWebFluxRequestBuilder(this, webClient, request);
    }
}

