/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.spring.junit5;

import au.com.dius.pact.core.model.IRequest;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.Pact;
import au.com.dius.pact.core.model.PactSource;
import au.com.dius.pact.core.model.SynchronousRequestResponse;
import au.com.dius.pact.core.model.generators.GeneratorTestMode;
import au.com.dius.pact.provider.IProviderVerifier;
import au.com.dius.pact.provider.ProviderInfo;
import au.com.dius.pact.provider.ProviderResponse;
import au.com.dius.pact.provider.spring.junit5.WebFluxBasedTestTarget;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.reactive.function.server.RouterFunction;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J:\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0013H\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\t0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lau/com/dius/pact/provider/spring/junit5/WebFluxTarget;", "Lau/com/dius/pact/provider/spring/junit5/WebFluxBasedTestTarget;", "routerFunction", "Lorg/springframework/web/reactive/function/server/RouterFunction;", "<init>", "(Lorg/springframework/web/reactive/function/server/RouterFunction;)V", "userConfig", "", "", "", "getUserConfig", "()Ljava/util/Map;", "prepareRequest", "Lkotlin/Pair;", "pact", "Lau/com/dius/pact/core/model/Pact;", "interaction", "Lau/com/dius/pact/core/model/Interaction;", "context", "", "junit5spring"})
public final class WebFluxTarget
implements WebFluxBasedTestTarget {
    @NotNull
    private final RouterFunction<?> routerFunction;
    @NotNull
    private final Map<String, Object> userConfig;

    public WebFluxTarget(@NotNull RouterFunction<?> routerFunction) {
        Intrinsics.checkNotNullParameter(routerFunction, (String)"routerFunction");
        this.routerFunction = routerFunction;
        this.userConfig = MapsKt.emptyMap();
    }

    @NotNull
    public Map<String, Object> getUserConfig() {
        return this.userConfig;
    }

    @Nullable
    public Pair<Object, Object> prepareRequest(@NotNull Pact pact, @NotNull Interaction interaction, @NotNull Map<String, Object> context) {
        Intrinsics.checkNotNullParameter((Object)pact, (String)"pact");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        if (interaction instanceof SynchronousRequestResponse) {
            IRequest request = ((SynchronousRequestResponse)interaction).getRequest().generatedRequest(context, GeneratorTestMode.Provider);
            WebTestClient webClient = WebTestClient.bindToRouterFunction(this.routerFunction).build();
            Intrinsics.checkNotNull((Object)webClient);
            return TuplesKt.to(this.toWebFluxRequestBuilder(webClient, request), (Object)webClient);
        }
        throw new UnsupportedOperationException("Only request/response interactions can be used with a WebFlux test target");
    }

    @Override
    @NotNull
    public ProviderInfo getProviderInfo(@NotNull String serviceName, @Nullable PactSource pactSource) {
        return WebFluxBasedTestTarget.DefaultImpls.getProviderInfo(this, serviceName, pactSource);
    }

    @Override
    public boolean isHttpTarget() {
        return WebFluxBasedTestTarget.DefaultImpls.isHttpTarget(this);
    }

    @Override
    @NotNull
    public ProviderResponse executeInteraction(@Nullable Object client, @Nullable Object request) {
        return WebFluxBasedTestTarget.DefaultImpls.executeInteraction(this, client, request);
    }

    @Override
    public void prepareVerifier(@NotNull IProviderVerifier verifier, @NotNull Object testInstance, @NotNull Pact pact) {
        WebFluxBasedTestTarget.DefaultImpls.prepareVerifier(this, verifier, testInstance, pact);
    }

    @Override
    @NotNull
    public WebTestClient.RequestHeadersSpec<?> toWebFluxRequestBuilder(@NotNull WebTestClient webClient, @NotNull IRequest request) {
        return WebFluxBasedTestTarget.DefaultImpls.toWebFluxRequestBuilder(this, webClient, request);
    }

    @Override
    @NotNull
    public String requestUriString(@NotNull IRequest request) {
        return WebFluxBasedTestTarget.DefaultImpls.requestUriString(this, request);
    }

    @Override
    public boolean supportsInteraction(@NotNull Interaction interaction) {
        return WebFluxBasedTestTarget.DefaultImpls.supportsInteraction(this, interaction);
    }
}

