/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.maven;

import au.com.dius.pact.core.pactbroker.PactBrokerClient;
import au.com.dius.pact.core.pactbroker.RequestFailedException;
import au.com.dius.pact.core.support.KotlinLanguageSupportKt;
import au.com.dius.pact.provider.maven.PactBaseMojo;
import au.com.dius.pact.provider.maven.PactPublishMojo;
import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Ok;
import com.github.michaelbull.result.Result;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00078\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\u00078\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lau/com/dius/pact/provider/maven/PactPublishMojo;", "Lau/com/dius/pact/provider/maven/PactBaseMojo;", "()V", "brokerClient", "Lau/com/dius/pact/core/pactbroker/PactBrokerClient;", "excludes", "", "", "pactDirectory", "projectVersion", "skipPactPublish", "", "tags", "trimSnapshot", "calculateTags", "", "execute", "", "pactFileIsExcluded", "exclusions", "Lkotlin/text/Regex;", "pactFile", "Ljava/io/File;", "maven"})
@Mojo(name="publish")
public class PactPublishMojo
extends PactBaseMojo {
    @Parameter(defaultValue="false")
    private boolean skipPactPublish;
    @Parameter(required=true, defaultValue="${project.version}", property="pact.projectVersion")
    private String projectVersion;
    @Parameter(defaultValue="false", property="pact.trimSnapshot")
    private boolean trimSnapshot;
    @Parameter(defaultValue="${project.build.directory}/pacts", property="pact.pactDirectory")
    private String pactDirectory;
    private PactBrokerClient brokerClient;
    @Parameter
    private List<String> tags;
    @Parameter
    private List<String> excludes;

    /*
     * WARNING - void declaration
     */
    public void execute() {
        File pactDirectory;
        Object object;
        Object object2;
        if (this.skipPactPublish) {
            String string = "'skipPactPublish' is set to true, skipping uploading of pacts";
            boolean bl = false;
            System.out.println((Object)string);
            return;
        }
        CharSequence charSequence = this.getPactBrokerUrl();
        boolean bl = false;
        boolean bl2 = false;
        if ((charSequence == null || charSequence.length() == 0) && this.brokerClient == null) {
            throw (Throwable)new MojoExecutionException("pactBrokerUrl is required");
        }
        String snapShotDefinitionString = "-SNAPSHOT";
        if (this.trimSnapshot) {
            String string = this.projectVersion;
            if (string == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
            }
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)snapShotDefinitionString, (boolean)false, (int)2, null)) {
                Regex snapshotRegex = new Regex(".*(" + snapShotDefinitionString + ')');
                String string2 = this.projectVersion;
                if (string2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                }
                String string3 = string2;
                String string4 = this.projectVersion;
                if (string4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                }
                MatchResult matchResult = Regex.find$default((Regex)snapshotRegex, (CharSequence)string4, (int)0, (int)2, null);
                if (matchResult == null) {
                    Intrinsics.throwNpe();
                }
                MatchGroup matchGroup = matchResult.getGroups().get(1);
                if (matchGroup == null) {
                    Intrinsics.throwNpe();
                }
                IntRange intRange = matchGroup.getRange();
                object2 = this;
                boolean bl3 = false;
                String string5 = string3;
                if (string5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                object = ((Object)StringsKt.removeRange((CharSequence)string5, (IntRange)intRange)).toString();
                ((PactPublishMojo)((Object)object2)).projectVersion = object;
            }
        }
        if (this.brokerClient == null) {
            String string = this.getPactBrokerUrl();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.brokerClient = new PactBrokerClient(string, this.brokerClientOptions(), null, 4, null);
        }
        String string = this.pactDirectory;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pactDirectory");
        }
        if (!(pactDirectory = new File(string)).exists()) {
            String string6 = "Pact directory " + pactDirectory + " does not exist, skipping uploading of pacts";
            boolean bl4 = false;
            System.out.println((Object)string6);
        } else {
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.excludes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string7 = (String)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl52 = false;
                object = new Regex(it);
                object2.add(object);
            }
            List excludedList = (List)destination$iv$iv;
            boolean anyFailed = false;
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)pactDirectory)), (Function1)execute.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Result result;
                boolean bl6;
                String bl52;
                File pactFile = (File)element$iv;
                boolean bl7 = false;
                if (this.pactFileIsExcluded(excludedList, pactFile)) {
                    it = "Not publishing '" + pactFile.getName() + "' as it matches an item in the excluded list";
                    boolean bl52 = false;
                    System.out.println((Object)it);
                    continue;
                }
                List<String> tagsToPublish = this.calculateTags();
                if (KotlinLanguageSupportKt.isNotEmpty(tagsToPublish)) {
                    bl52 = "Publishing '" + pactFile.getName() + "' with tags '" + CollectionsKt.joinToString$default((Iterable)tagsToPublish, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + "' ... ";
                    bl6 = false;
                    System.out.print((Object)bl52);
                } else {
                    bl52 = "Publishing '" + pactFile.getName() + "' ... ";
                    bl6 = false;
                    System.out.print((Object)bl52);
                }
                PactBrokerClient pactBrokerClient = this.brokerClient;
                if (pactBrokerClient == null) {
                    Intrinsics.throwNpe();
                }
                String string8 = this.projectVersion;
                if (string8 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectVersion");
                }
                if ((result = pactBrokerClient.uploadPactFile(pactFile, string8, tagsToPublish)) instanceof Ok) {
                    String string9 = "OK";
                    boolean bl8 = false;
                    System.out.println((Object)string9);
                    continue;
                }
                if (!(result instanceof Err)) continue;
                Exception error = (Exception)((Err)result).getError();
                String string10 = "Failed - " + ((Exception)((Err)result).getError()).getMessage();
                boolean bl9 = false;
                System.out.println((Object)string10);
                if (error instanceof RequestFailedException && KotlinLanguageSupportKt.isNotEmpty((String)((RequestFailedException)error).getBody())) {
                    string10 = ((RequestFailedException)error).getBody();
                    bl9 = false;
                    System.out.println((Object)string10);
                }
                anyFailed = true;
            }
            if (anyFailed) {
                throw (Throwable)new MojoExecutionException("One or more of the pact files were rejected by the pact broker");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> calculateTags() {
        List list;
        String property = System.getProperty("pact.consumer.tags");
        if (KotlinLanguageSupportKt.isNotEmpty((String)property)) {
            void $this$mapTo$iv$iv;
            String string = property;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property");
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (char[])new char[]{','}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var11_11 = it;
                boolean bl2 = false;
                void v1 = var11_11;
                if (v1 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string3 = ((Object)StringsKt.trim((CharSequence)((CharSequence)v1))).toString();
                collection.add(string3);
            }
            list = (List)destination$iv$iv;
        } else {
            list = this.tags;
        }
        return list;
    }

    private final boolean pactFileIsExcluded(List<Regex> exclusions, File pactFile) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = exclusions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!it.matches((CharSequence)FilesKt.getNameWithoutExtension((File)pactFile))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public PactPublishMojo() {
        List list;
        PactPublishMojo pactPublishMojo = this;
        boolean bl = false;
        pactPublishMojo.tags = list = (List)new ArrayList();
        pactPublishMojo = this;
        bl = false;
        pactPublishMojo.excludes = list = (List)new ArrayList();
    }
}

