/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.spring;

import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.IRequest;
import au.com.dius.pact.core.model.IResponse;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.SynchronousRequestResponse;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.ProviderClient;
import au.com.dius.pact.provider.ProviderInfo;
import au.com.dius.pact.provider.ProviderResponse;
import au.com.dius.pact.provider.ProviderVerifier;
import au.com.dius.pact.provider.VerificationFailureType;
import au.com.dius.pact.provider.VerificationResult;
import au.com.dius.pact.provider.reporters.VerifierReporter;
import au.com.dius.pact.provider.spring.MvcProviderVerifierKt;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.collections4.Closure;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matchers;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultHandlers;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.web.util.UriComponentsBuilder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0017J\u0016\u0010#\u001a\u00020$2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u0003J\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lau/com/dius/pact/provider/spring/MvcProviderVerifier;", "Lau/com/dius/pact/provider/ProviderVerifier;", "debugRequestResponse", "", "<init>", "(Z)V", "verifyResponseFromProvider", "Lau/com/dius/pact/provider/VerificationResult;", "provider", "Lau/com/dius/pact/provider/ProviderInfo;", "interaction", "Lau/com/dius/pact/core/model/SynchronousRequestResponse;", "interactionMessage", "", "failures", "", "", "mockMvc", "Lorg/springframework/test/web/servlet/MockMvc;", "pending", "executeMockMvcRequest", "Lorg/springframework/test/web/servlet/MvcResult;", "request", "Lau/com/dius/pact/core/model/IRequest;", "executeRequestFilter", "", "requestBuilder", "Lorg/springframework/test/web/servlet/request/MockHttpServletRequestBuilder;", "invokeJavaFunctionalInterface", "functionalInterface", "performRequest", "Lorg/springframework/test/web/servlet/ResultActions;", "Lorg/springframework/test/web/servlet/RequestBuilder;", "requestUriString", "Ljava/net/URI;", "mapHeaders", "Lorg/springframework/http/HttpHeaders;", "hasBody", "handleResponse", "Lau/com/dius/pact/provider/ProviderResponse;", "httpResponse", "Lorg/springframework/mock/web/MockHttpServletResponse;", "spring"})
@SourceDebugExtension(value={"SMAP\nMvcProviderVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MvcProviderVerifier.kt\nau/com/dius/pact/provider/spring/MvcProviderVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,214:1\n1869#2,2:215\n1869#2,2:225\n216#3:217\n217#3:222\n216#3,2:223\n37#4:218\n36#4,3:219\n*S KotlinDebug\n*F\n+ 1 MvcProviderVerifier.kt\nau/com/dius/pact/provider/spring/MvcProviderVerifier\n*L\n70#1:215,2\n193#1:225,2\n167#1:217\n167#1:222\n178#1:223,2\n168#1:218\n168#1:219,3\n*E\n"})
public class MvcProviderVerifier
extends ProviderVerifier {
    private final boolean debugRequestResponse;

    public MvcProviderVerifier(boolean debugRequestResponse) {
        super(null, null, null, null, null, null, null, null, null, null, null, null, 4095, null);
        this.debugRequestResponse = debugRequestResponse;
    }

    public /* synthetic */ MvcProviderVerifier(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    public final VerificationResult verifyResponseFromProvider(@NotNull ProviderInfo provider, @NotNull SynchronousRequestResponse interaction, @NotNull String interactionMessage, @NotNull Map<String, Object> failures, @NotNull MockMvc mockMvc, boolean pending) {
        VerificationResult verificationResult;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter((Object)interactionMessage, (String)"interactionMessage");
        Intrinsics.checkNotNullParameter(failures, (String)"failures");
        Intrinsics.checkNotNullParameter((Object)mockMvc, (String)"mockMvc");
        try {
            IRequest request = interaction.getRequest();
            MvcResult mvcResult = this.executeMockMvcRequest(mockMvc, request, provider);
            IResponse expectedResponse = interaction.getResponse();
            MockHttpServletResponse mockHttpServletResponse = mvcResult.getResponse();
            Intrinsics.checkNotNullExpressionValue((Object)mockHttpServletResponse, (String)"getResponse(...)");
            ProviderResponse actualResponse = this.handleResponse(mockHttpServletResponse);
            String string = interaction.getInteractionId();
            if (string == null) {
                string = "";
            }
            verificationResult = this.verifyRequestResponsePact(expectedResponse, actualResponse, interactionMessage, failures, string, false, MapsKt.emptyMap());
        }
        catch (Exception e) {
            failures.put(interactionMessage, e);
            Iterable $this$forEach$iv = this.getReporters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VerifierReporter it = (VerifierReporter)element$iv;
                boolean bl = false;
                IProviderInfo iProviderInfo = (IProviderInfo)provider;
                Interaction interaction2 = (Interaction)interaction;
                Object r = this.getProjectHasProperty().apply("pact.showStacktrace");
                Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
                it.requestFailed(iProviderInfo, interaction2, interactionMessage, e, ((Boolean)r).booleanValue());
            }
            String string = interaction.getInteractionId();
            if (string == null) {
                string = "";
            }
            return (VerificationResult)new VerificationResult.Failed("Request to provider method failed with an exception", interactionMessage, MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)CollectionsKt.listOf((Object)new VerificationFailureType.ExceptionFailure("Request to provider method failed with an exception", (Throwable)e, (Interaction)interaction)))), pending, null, null, 48, null);
        }
        return verificationResult;
    }

    @NotNull
    public final MvcResult executeMockMvcRequest(@NotNull MockMvc mockMvc, @NotNull IRequest request, @NotNull ProviderInfo provider) {
        MockHttpServletRequestBuilder mockHttpServletRequestBuilder;
        Intrinsics.checkNotNullParameter((Object)mockMvc, (String)"mockMvc");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        OptionalBody body = request.getBody();
        if (body.isPresent()) {
            if (request.isMultipartFileUpload()) {
                MimeMultipart multipart = new MimeMultipart((DataSource)new ByteArrayDataSource(body.unwrap(), request.contentTypeHeader()));
                MockMultipartHttpServletRequestBuilder multipartRequest = MockMvcRequestBuilders.multipart((URI)this.requestUriString(request));
                for (int i = 0; i < multipart.getCount(); ++i) {
                    MockHttpServletRequestBuilder mockHttpServletRequestBuilder2;
                    BodyPart bodyPart = multipart.getBodyPart(i);
                    String[] stringArray = bodyPart.getHeader("Content-Disposition");
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getHeader(...)");
                    ContentDisposition contentDisposition = new ContentDisposition((String)ArraysKt.first((Object[])stringArray));
                    String name = StringUtils.defaultString((String)contentDisposition.getParameter("name"), (String)"file");
                    String filename = contentDisposition.getParameter("filename");
                    String[] stringArray2 = (String[])filename;
                    if (stringArray2 == null || stringArray2.length() == 0) {
                        stringArray2 = new String[]{bodyPart.getContent().toString()};
                        mockHttpServletRequestBuilder2 = multipartRequest.param(name, stringArray2);
                        continue;
                    }
                    mockHttpServletRequestBuilder2 = (MockHttpServletRequestBuilder)multipartRequest.file(new MockMultipartFile(name, filename, bodyPart.getContentType(), bodyPart.getInputStream()));
                }
                mockHttpServletRequestBuilder = multipartRequest.headers(this.mapHeaders(request, true));
            } else {
                MockHttpServletRequestBuilder mockHttpServletRequestBuilder3 = MockMvcRequestBuilders.request((HttpMethod)HttpMethod.valueOf((String)request.getMethod()), (URI)this.requestUriString(request)).headers(this.mapHeaders(request, true));
                byte[] byArray = body.getValue();
                if (byArray == null) {
                    byArray = new byte[]{};
                }
                mockHttpServletRequestBuilder = mockHttpServletRequestBuilder3.content(byArray);
            }
        } else {
            mockHttpServletRequestBuilder = MockMvcRequestBuilders.request((HttpMethod)HttpMethod.valueOf((String)request.getMethod()), (URI)this.requestUriString(request)).headers(this.mapHeaders(request, false));
        }
        MockHttpServletRequestBuilder requestBuilder = mockHttpServletRequestBuilder;
        Intrinsics.checkNotNull((Object)requestBuilder);
        this.executeRequestFilter(requestBuilder, provider);
        MvcResult mvcResult = this.performRequest(mockMvc, (RequestBuilder)requestBuilder).andDo(arg_0 -> MvcProviderVerifier.executeMockMvcRequest$lambda$1(this, arg_0)).andReturn();
        Intrinsics.checkNotNullExpressionValue((Object)mvcResult, (String)"andReturn(...)");
        return mvcResult;
    }

    private final void executeRequestFilter(MockHttpServletRequestBuilder requestBuilder, ProviderInfo provider) {
        Object requestFilter = provider.getRequestFilter();
        if (requestFilter != null) {
            Object object = requestFilter;
            if (object instanceof groovy.lang.Closure) {
                ((groovy.lang.Closure)requestFilter).call((Object)requestBuilder);
            } else if (object instanceof Closure) {
                ((Closure)requestFilter).execute((Object)requestBuilder);
            } else if (ProviderClient.Companion.isFunctionalInterface(requestFilter)) {
                this.invokeJavaFunctionalInterface(requestFilter, requestBuilder);
            } else {
                Binding binding = new Binding();
                binding.setVariable("request", (Object)requestBuilder);
                GroovyShell shell = new GroovyShell(binding);
                shell.evaluate((String)requestFilter);
            }
        }
    }

    private final void invokeJavaFunctionalInterface(Object functionalInterface, MockHttpServletRequestBuilder requestBuilder) {
        Object object = functionalInterface;
        if (object instanceof Consumer) {
            Object object2 = functionalInterface;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.util.function.Consumer<org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder>");
            ((Consumer)object2).accept(requestBuilder);
            v1 = Unit.INSTANCE;
        } else if (object instanceof Function) {
            Object object3 = functionalInterface;
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type java.util.function.Function<org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder, kotlin.Any?>");
            v1 = ((Function)object3).apply(requestBuilder);
        } else if (object instanceof Callable) {
            Object object4 = functionalInterface;
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type java.util.concurrent.Callable<org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder>");
            v1 = ((Callable)object4).call();
        } else {
            throw new IllegalArgumentException("Java request filters must be either a Consumer or Function that takes at least one MockHttpServletRequestBuilder parameter");
        }
    }

    private final ResultActions performRequest(MockMvc mockMvc, RequestBuilder requestBuilder) {
        ResultActions resultActions;
        ResultActions resultActions2 = mockMvc.perform(requestBuilder);
        if (resultActions2.andReturn().getRequest().isAsyncStarted()) {
            ResultActions resultActions3 = mockMvc.perform(MockMvcRequestBuilders.asyncDispatch((MvcResult)resultActions2.andExpect(MockMvcResultMatchers.request().asyncResult(Matchers.anything())).andReturn()));
            Intrinsics.checkNotNull((Object)resultActions3);
            resultActions = resultActions3;
        } else {
            ResultActions resultActions4 = resultActions2;
            Intrinsics.checkNotNull((Object)resultActions4);
            resultActions = resultActions4;
        }
        return resultActions;
    }

    @NotNull
    public final URI requestUriString(@NotNull IRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromPath((String)request.getPath());
        Map query = request.getQuery();
        if (!query.isEmpty()) {
            Map $this$forEach$iv = query;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                Collection $this$toTypedArray$iv = value;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                uriBuilder.queryParam(key, (Object[])Arrays.copyOf(stringArray, stringArray.length));
            }
        }
        URI uRI = URI.create(uriBuilder.toUriString());
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
        return uRI;
    }

    @NotNull
    public final HttpHeaders mapHeaders(@NotNull IRequest request, boolean hasBody) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpHeaders httpHeaders = new HttpHeaders();
        Map $this$forEach$iv = request.getHeaders();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            List v = (List)entry.getValue();
            httpHeaders.add(k, CollectionsKt.joinToString$default((Iterable)v, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        if (hasBody && !httpHeaders.containsKey((Object)"Content-Type")) {
            httpHeaders.add("Content-Type", "application/json");
        }
        return httpHeaders;
    }

    @NotNull
    public final ProviderResponse handleResponse(@NotNull MockHttpServletResponse httpResponse) {
        ContentType contentType;
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        MvcProviderVerifierKt.access$getLogger$p().debug(() -> MvcProviderVerifier.handleResponse$lambda$4(httpResponse));
        Map headers = new LinkedHashMap();
        Collection collection = httpResponse.getHeaderNames();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getHeaderNames(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            String headerName = (String)element$iv;
            boolean bl = false;
            String header = httpResponse.getHeader(headerName);
            if (header == null) continue;
            headers.put(headerName, CollectionsKt.listOf((Object)header));
        }
        CharSequence $i$f$forEach22 = httpResponse.getContentType();
        if ($i$f$forEach22 == null || $i$f$forEach22.length() == 0) {
            contentType = ContentType.Companion.getJSON();
        } else {
            String string = httpResponse.getContentType();
            Intrinsics.checkNotNull((Object)string);
            contentType = ContentType.Companion.fromString(string.toString());
        }
        ContentType contentType2 = contentType;
        ProviderResponse response = new ProviderResponse(Integer.valueOf(httpResponse.getStatus()), headers, contentType2, OptionalBody.Companion.body(httpResponse.getContentAsString(), contentType2), null, 16, null);
        MvcProviderVerifierKt.access$getLogger$p().debug(() -> MvcProviderVerifier.handleResponse$lambda$6(response));
        return response;
    }

    private static final void executeMockMvcRequest$lambda$1(MvcProviderVerifier this$0, MvcResult it) {
        if (this$0.debugRequestResponse) {
            MockMvcResultHandlers.print().handle(it);
        }
    }

    private static final Object handleResponse$lambda$4(MockHttpServletResponse $httpResponse) {
        return "Received response: " + $httpResponse.getStatus();
    }

    private static final Object handleResponse$lambda$6(ProviderResponse $response) {
        return "Response: " + $response;
    }

    public MvcProviderVerifier() {
        this(false, 1, null);
    }
}

