/*
 * Decompiled with CFR 0.152.
 */
package au.com.dius.pact.provider.spring;

import au.com.dius.pact.core.model.ContentType;
import au.com.dius.pact.core.model.IRequest;
import au.com.dius.pact.core.model.IResponse;
import au.com.dius.pact.core.model.Interaction;
import au.com.dius.pact.core.model.OptionalBody;
import au.com.dius.pact.core.model.SynchronousRequestResponse;
import au.com.dius.pact.provider.IProviderInfo;
import au.com.dius.pact.provider.ProviderClient;
import au.com.dius.pact.provider.ProviderInfo;
import au.com.dius.pact.provider.ProviderResponse;
import au.com.dius.pact.provider.ProviderVerifier;
import au.com.dius.pact.provider.VerificationFailureType;
import au.com.dius.pact.provider.VerificationResult;
import au.com.dius.pact.provider.reporters.VerifierReporter;
import au.com.dius.pact.provider.spring.WebFluxProviderVerifierKt;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.apache.commons.collections4.Closure;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.MultipartBodyBuilder;
import org.springframework.test.web.reactive.server.EntityExchangeResult;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.util.UriComponentsBuilder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u000e2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u000e\u0010 \u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014\u00a8\u0006$"}, d2={"Lau/com/dius/pact/provider/spring/WebFluxProviderVerifier;", "Lau/com/dius/pact/provider/ProviderVerifier;", "<init>", "()V", "verifyResponseFromProvider", "Lau/com/dius/pact/provider/VerificationResult;", "provider", "Lau/com/dius/pact/provider/ProviderInfo;", "interaction", "Lau/com/dius/pact/core/model/SynchronousRequestResponse;", "interactionMessage", "", "failures", "", "", "webClient", "Lorg/springframework/test/web/reactive/server/WebTestClient;", "pending", "", "executeWebFluxRequest", "Lorg/springframework/test/web/reactive/server/EntityExchangeResult;", "", "webTestClient", "request", "Lau/com/dius/pact/core/model/IRequest;", "executeRequestFilter", "", "requestBuilder", "Lorg/springframework/test/web/reactive/server/WebTestClient$RequestHeadersSpec;", "invokeJavaFunctionalInterface", "functionalInterface", "headersSpec", "requestUriString", "handleResponse", "Lau/com/dius/pact/provider/ProviderResponse;", "exchangeResult", "spring"})
@SourceDebugExtension(value={"SMAP\nWebFluxProviderVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebFluxProviderVerifier.kt\nau/com/dius/pact/provider/spring/WebFluxProviderVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1869#2,2:211\n216#3,2:213\n216#3,2:215\n1#4:217\n*S KotlinDebug\n*F\n+ 1 WebFluxProviderVerifier.kt\nau/com/dius/pact/provider/spring/WebFluxProviderVerifier\n*L\n60#1:211,2\n176#1:213,2\n187#1:215,2\n*E\n"})
public final class WebFluxProviderVerifier
extends ProviderVerifier {
    public WebFluxProviderVerifier() {
        super(null, null, null, null, null, null, null, null, null, null, null, null, 4095, null);
    }

    @NotNull
    public final VerificationResult verifyResponseFromProvider(@NotNull ProviderInfo provider, @NotNull SynchronousRequestResponse interaction, @NotNull String interactionMessage, @NotNull Map<String, Object> failures, @NotNull WebTestClient webClient, boolean pending) {
        VerificationResult verificationResult;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)interaction, (String)"interaction");
        Intrinsics.checkNotNullParameter((Object)interactionMessage, (String)"interactionMessage");
        Intrinsics.checkNotNullParameter(failures, (String)"failures");
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        try {
            IRequest request = interaction.getRequest();
            EntityExchangeResult<byte[]> clientResponse = this.executeWebFluxRequest(webClient, request, provider);
            IResponse expectedResponse = interaction.getResponse();
            ProviderResponse actualResponse = this.handleResponse(clientResponse);
            String string = interaction.getInteractionId();
            if (string == null) {
                string = "";
            }
            verificationResult = this.verifyRequestResponsePact(expectedResponse, actualResponse, interactionMessage, failures, string, false, MapsKt.emptyMap());
        }
        catch (Exception e) {
            WebFluxProviderVerifierKt.access$getLogger$p().error((Throwable)e, WebFluxProviderVerifier::verifyResponseFromProvider$lambda$0);
            failures.put(interactionMessage, e);
            Iterable $this$forEach$iv = this.getReporters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VerifierReporter it = (VerifierReporter)element$iv;
                boolean bl = false;
                IProviderInfo iProviderInfo = (IProviderInfo)provider;
                Interaction interaction2 = (Interaction)interaction;
                Object r = this.getProjectHasProperty().apply("pact.showStacktrace");
                Intrinsics.checkNotNullExpressionValue(r, (String)"apply(...)");
                it.requestFailed(iProviderInfo, interaction2, interactionMessage, e, ((Boolean)r).booleanValue());
            }
            String string = interaction.getInteractionId();
            if (string == null) {
                string = "";
            }
            return (VerificationResult)new VerificationResult.Failed("Request to provider method failed with an exception", interactionMessage, MapsKt.mapOf((Pair)TuplesKt.to((Object)string, (Object)CollectionsKt.listOf((Object)new VerificationFailureType.ExceptionFailure("Request to provider method failed with an exception", (Throwable)e, (Interaction)interaction)))), pending, null, null, 48, null);
        }
        return verificationResult;
    }

    @NotNull
    public final EntityExchangeResult<byte[]> executeWebFluxRequest(@NotNull WebTestClient webTestClient, @NotNull IRequest request, @NotNull ProviderInfo provider) {
        WebTestClient.RequestHeadersSpec requestHeadersSpec;
        Intrinsics.checkNotNullParameter((Object)webTestClient, (String)"webTestClient");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        OptionalBody body = request.getBody();
        if (body.isPresent()) {
            if (request.isMultipartFileUpload()) {
                MimeMultipart multipart = new MimeMultipart((DataSource)new ByteArrayDataSource(body.unwrap(), request.contentTypeHeader()));
                MultipartBodyBuilder bodyBuilder = new MultipartBodyBuilder();
                for (int i = 0; i < multipart.getCount(); ++i) {
                    BodyPart bodyPart = multipart.getBodyPart(i);
                    String[] stringArray = bodyPart.getHeader("Content-Disposition");
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getHeader(...)");
                    ContentDisposition contentDisposition = new ContentDisposition((String)ArraysKt.first((Object[])stringArray));
                    String name = StringUtils.defaultString((String)contentDisposition.getParameter("name"), (String)"file");
                    String string = contentDisposition.getParameter("filename");
                    if (string == null) {
                        string = "";
                    }
                    String filename = string;
                    String[] stringArray2 = new String[]{"form-data; name=" + name + "; filename=" + filename};
                    bodyBuilder.part(name, bodyPart.getContent()).filename(filename).contentType(MediaType.valueOf((String)bodyPart.getContentType())).header("Content-Disposition", stringArray2);
                }
                requestHeadersSpec = ((WebTestClient.RequestBodySpec)webTestClient.method(HttpMethod.POST).uri(this.requestUriString(request), new Object[0])).body((BodyInserter)BodyInserters.fromMultipartData((MultiValueMap)bodyBuilder.build())).headers(arg_0 -> WebFluxProviderVerifier.executeWebFluxRequest$lambda$4(request, arg_0));
            } else {
                WebTestClient.RequestBodySpec requestBodySpec = (WebTestClient.RequestBodySpec)webTestClient.method(HttpMethod.valueOf((String)request.getMethod())).uri(this.requestUriString(request), new Object[0]);
                byte[] byArray = body.getValue();
                Intrinsics.checkNotNull((Object)byArray);
                requestHeadersSpec = requestBodySpec.bodyValue((Object)byArray).headers(arg_0 -> WebFluxProviderVerifier.executeWebFluxRequest$lambda$7(request, arg_0));
            }
        } else {
            requestHeadersSpec = ((WebTestClient.RequestBodySpec)webTestClient.method(HttpMethod.valueOf((String)request.getMethod())).uri(this.requestUriString(request), new Object[0])).headers(arg_0 -> WebFluxProviderVerifier.executeWebFluxRequest$lambda$10(request, arg_0));
        }
        WebTestClient.RequestHeadersSpec builder = requestHeadersSpec;
        Intrinsics.checkNotNull((Object)builder);
        this.executeRequestFilter(builder, provider);
        WebTestClient.ResponseSpec exchangeResult = builder.exchange();
        EntityExchangeResult entityExchangeResult = exchangeResult.expectBody().returnResult();
        Intrinsics.checkNotNullExpressionValue((Object)entityExchangeResult, (String)"returnResult(...)");
        return entityExchangeResult;
    }

    private final void executeRequestFilter(WebTestClient.RequestHeadersSpec<?> requestBuilder, ProviderInfo provider) {
        Object requestFilter = provider.getRequestFilter();
        if (requestFilter != null) {
            Object object = requestFilter;
            if (object instanceof groovy.lang.Closure) {
                ((groovy.lang.Closure)requestFilter).call(requestBuilder);
            } else if (object instanceof Closure) {
                ((Closure)requestFilter).execute(requestBuilder);
            } else if (ProviderClient.Companion.isFunctionalInterface(requestFilter)) {
                this.invokeJavaFunctionalInterface(requestFilter, requestBuilder);
            } else {
                Binding binding = new Binding();
                binding.setVariable("request", requestBuilder);
                GroovyShell shell = new GroovyShell(binding);
                shell.evaluate((String)requestFilter);
            }
        }
    }

    private final void invokeJavaFunctionalInterface(Object functionalInterface, WebTestClient.RequestHeadersSpec<?> headersSpec) {
        Object object = functionalInterface;
        if (object instanceof Consumer) {
            Object object2 = functionalInterface;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type java.util.function.Consumer<org.springframework.test.web.reactive.server.WebTestClient.RequestHeadersSpec<*>>");
            ((Consumer)object2).accept(headersSpec);
            v1 = Unit.INSTANCE;
        } else if (object instanceof Function) {
            Object object3 = functionalInterface;
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type java.util.function.Function<org.springframework.test.web.reactive.server.WebTestClient.RequestHeadersSpec<*>, kotlin.Any?>");
            v1 = ((Function)object3).apply(headersSpec);
        } else if (object instanceof Callable) {
            Object object4 = functionalInterface;
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type java.util.concurrent.Callable<org.springframework.test.web.reactive.server.WebTestClient.RequestHeadersSpec<*>>");
            v1 = ((Callable)object4).call();
        } else {
            throw new IllegalArgumentException("Java request filters must be either a Consumer or Function that takes at least one WebTestClient.RequestHeadersSpec<*> parameter");
        }
    }

    @NotNull
    public final String requestUriString(@NotNull IRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromPath((String)request.getPath());
        Map $this$forEach$iv = request.getQuery();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            uriBuilder.queryParam(key, (Collection)value);
        }
        String string = uriBuilder.toUriString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUriString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProviderResponse handleResponse(@NotNull EntityExchangeResult<byte[]> exchangeResult) {
        String string;
        Intrinsics.checkNotNullParameter(exchangeResult, (String)"exchangeResult");
        WebFluxProviderVerifierKt.access$getLogger$p().debug(() -> WebFluxProviderVerifier.handleResponse$lambda$12(exchangeResult));
        Map headers = new LinkedHashMap();
        HttpHeaders httpHeaders = exchangeResult.getResponseHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)httpHeaders, (String)"getResponseHeaders(...)");
        Map $this$forEach$iv = (Map)httpHeaders;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry header = element$iv = iterator.next();
            boolean bl = false;
            headers.put(header.getKey(), header.getValue());
        }
        MediaType contentTypeHeader = exchangeResult.getResponseHeaders().getContentType();
        ContentType contentType = contentTypeHeader == null ? ContentType.Companion.getJSON() : ContentType.Companion.fromString(contentTypeHeader.toString());
        Integer n = exchangeResult.getStatus().value();
        Map map = headers;
        ContentType contentType2 = contentType;
        OptionalBody.Companion companion = OptionalBody.Companion;
        byte[] byArray = (byte[])exchangeResult.getResponseBody();
        if (byArray != null) {
            void it;
            byte[] bl = byArray;
            OptionalBody.Companion companion2 = companion;
            ContentType contentType3 = contentType2;
            Map map2 = map;
            Integer n2 = n;
            boolean bl2 = false;
            String string2 = new String((byte[])it, Charsets.UTF_8);
            n = n2;
            map = map2;
            contentType2 = contentType3;
            companion = companion2;
            string = string2;
        } else {
            string = null;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n3 = 16;
        Map map3 = null;
        OptionalBody optionalBody = companion.body(string, contentType);
        ContentType contentType4 = contentType2;
        Map map4 = map;
        Integer n4 = n;
        ProviderResponse response = new ProviderResponse(n4, map4, contentType4, optionalBody, map3, n3, defaultConstructorMarker);
        WebFluxProviderVerifierKt.access$getLogger$p().debug(() -> WebFluxProviderVerifier.handleResponse$lambda$15(response));
        return response;
    }

    private static final Object verifyResponseFromProvider$lambda$0() {
        return "Request to provider method failed";
    }

    private static final Unit executeWebFluxRequest$lambda$4$lambda$2(HttpHeaders $it, String k, List v) {
        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        $it.addAll(k, v);
        return Unit.INSTANCE;
    }

    private static final void executeWebFluxRequest$lambda$4$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void executeWebFluxRequest$lambda$4(IRequest $request, HttpHeaders it) {
        $request.getHeaders().forEach((arg_0, arg_1) -> WebFluxProviderVerifier.executeWebFluxRequest$lambda$4$lambda$3((arg_0, arg_1) -> WebFluxProviderVerifier.executeWebFluxRequest$lambda$4$lambda$2(it, arg_0, arg_1), arg_0, arg_1));
    }

    private static final Unit executeWebFluxRequest$lambda$7$lambda$5(HttpHeaders $it, String k, List v) {
        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        $it.addAll(k, v);
        return Unit.INSTANCE;
    }

    private static final void executeWebFluxRequest$lambda$7$lambda$6(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void executeWebFluxRequest$lambda$7(IRequest $request, HttpHeaders it) {
        $request.getHeaders().forEach((arg_0, arg_1) -> WebFluxProviderVerifier.executeWebFluxRequest$lambda$7$lambda$6((arg_0, arg_1) -> WebFluxProviderVerifier.executeWebFluxRequest$lambda$7$lambda$5(it, arg_0, arg_1), arg_0, arg_1));
        if (!$request.getHeaders().containsKey("Content-Type")) {
            it.set("Content-Type", "application/json");
        }
    }

    private static final Unit executeWebFluxRequest$lambda$10$lambda$8(HttpHeaders $it, String k, List v) {
        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        $it.addAll(k, v);
        return Unit.INSTANCE;
    }

    private static final void executeWebFluxRequest$lambda$10$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void executeWebFluxRequest$lambda$10(IRequest $request, HttpHeaders it) {
        $request.getHeaders().forEach((arg_0, arg_1) -> WebFluxProviderVerifier.executeWebFluxRequest$lambda$10$lambda$9((arg_0, arg_1) -> WebFluxProviderVerifier.executeWebFluxRequest$lambda$10$lambda$8(it, arg_0, arg_1), arg_0, arg_1));
    }

    private static final Object handleResponse$lambda$12(EntityExchangeResult $exchangeResult) {
        return "Received response: " + $exchangeResult.getStatus();
    }

    private static final Object handleResponse$lambda$15(ProviderResponse $response) {
        return "Response: " + $response;
    }
}

