/*
 * Decompiled with CFR 0.152.
 */
package au.com.flyingkite.mobiledetect;

public class UAgentInfo {
    private String userAgent = "";
    private String httpAccept = "";
    private boolean initCompleted = false;
    private boolean isWebkit = false;
    private boolean isMobilePhone = false;
    private boolean isIphone = false;
    private boolean isAndroid = false;
    private boolean isAndroidPhone = false;
    private boolean isTierTablet = false;
    private boolean isTierIphone = false;
    private boolean isTierRichCss = false;
    private boolean isTierGenericMobile = false;
    private static final String engineWebKit = "webkit";
    private static final String deviceIphone = "iphone";
    private static final String deviceIpod = "ipod";
    private static final String deviceIpad = "ipad";
    private static final String deviceMacPpc = "macintosh";
    private static final String deviceAndroid = "android";
    private static final String deviceGoogleTV = "googletv";
    private static final String deviceHtcFlyer = "htc_flyer";
    private static final String deviceWinPhone7 = "windows phone os 7";
    private static final String deviceWinPhone8 = "windows phone 8";
    private static final String deviceWinMob = "windows ce";
    private static final String deviceWindows = "windows";
    private static final String deviceIeMob = "iemobile";
    private static final String devicePpc = "ppc";
    private static final String enginePie = "wm5 pie";
    private static final String deviceBB = "blackberry";
    private static final String deviceBB10 = "bb10";
    private static final String vndRIM = "vnd.rim";
    private static final String deviceBBStorm = "blackberry95";
    private static final String deviceBBBold = "blackberry97";
    private static final String deviceBBBoldTouch = "blackberry 99";
    private static final String deviceBBTour = "blackberry96";
    private static final String deviceBBCurve = "blackberry89";
    private static final String deviceBBCurveTouch = "blackberry 938";
    private static final String deviceBBTorch = "blackberry 98";
    private static final String deviceBBPlaybook = "playbook";
    private static final String deviceSymbian = "symbian";
    private static final String deviceS60 = "series60";
    private static final String deviceS70 = "series70";
    private static final String deviceS80 = "series80";
    private static final String deviceS90 = "series90";
    private static final String devicePalm = "palm";
    private static final String deviceWebOS = "webos";
    private static final String deviceWebOShp = "hpwos";
    private static final String engineBlazer = "blazer";
    private static final String engineXiino = "xiino";
    private static final String deviceNuvifone = "nuvifone";
    private static final String deviceBada = "bada";
    private static final String deviceTizen = "tizen";
    private static final String deviceMeego = "meego";
    private static final String deviceKindle = "kindle";
    private static final String engineSilk = "silk-accelerated";
    private static final String vndwap = "vnd.wap";
    private static final String wml = "wml";
    private static final String deviceTablet = "tablet";
    private static final String deviceBrew = "brew";
    private static final String deviceDanger = "danger";
    private static final String deviceHiptop = "hiptop";
    private static final String devicePlaystation = "playstation";
    private static final String devicePlaystationVita = "vita";
    private static final String deviceNintendoDs = "nitro";
    private static final String deviceNintendo = "nintendo";
    private static final String deviceWii = "wii";
    private static final String deviceXbox = "xbox";
    private static final String deviceArchos = "archos";
    private static final String engineOpera = "opera";
    private static final String engineNetfront = "netfront";
    private static final String engineUpBrowser = "up.browser";
    private static final String engineOpenWeb = "openweb";
    private static final String deviceMidp = "midp";
    private static final String uplink = "up.link";
    private static final String engineTelecaQ = "teleca q";
    private static final String engineObigo = "obigo";
    private static final String devicePda = "pda";
    private static final String mini = "mini";
    private static final String mobile = "mobile";
    private static final String mobi = "mobi";
    private static final String maemo = "maemo";
    private static final String linux = "linux";
    private static final String qtembedded = "qt embedded";
    private static final String mylocom2 = "com2";
    private static final String manuSonyEricsson = "sonyericsson";
    private static final String manuericsson = "ericsson";
    private static final String manuSamsung1 = "sec-sgh";
    private static final String manuSony = "sony";
    private static final String manuHtc = "htc";
    private static final String svcDocomo = "docomo";
    private static final String svcKddi = "kddi";
    private static final String svcVodafone = "vodafone";
    private static final String disUpdate = "update";

    public UAgentInfo(String userAgent, String httpAccept) {
        if (userAgent != null) {
            this.userAgent = userAgent.toLowerCase();
        }
        if (httpAccept != null) {
            this.httpAccept = httpAccept.toLowerCase();
        }
        this.initDeviceScan();
    }

    public boolean getIsIphone() {
        return this.isIphone;
    }

    public boolean getIsTierTablet() {
        return this.isTierTablet;
    }

    public boolean getIsTierIphone() {
        return this.isTierIphone;
    }

    public boolean getIsTierRichCss() {
        return this.isTierRichCss;
    }

    public boolean getIsTierGenericMobile() {
        return this.isTierGenericMobile;
    }

    public void initDeviceScan() {
        this.isWebkit = this.detectWebkit();
        this.isIphone = this.detectIphone();
        this.isAndroid = this.detectAndroid();
        this.isAndroidPhone = this.detectAndroidPhone();
        this.isMobilePhone = this.detectMobileQuick();
        this.isTierTablet = this.detectTierTablet();
        this.isTierIphone = this.detectTierIphone();
        this.isTierRichCss = this.detectTierRichCss();
        this.isTierGenericMobile = this.detectTierOtherPhones();
        this.initCompleted = true;
    }

    public boolean detectIphone() {
        if (this.initCompleted || this.isIphone) {
            return this.isIphone;
        }
        return this.userAgent.indexOf(deviceIphone) != -1 && !this.detectIpad() && !this.detectIpod();
    }

    public boolean detectIpod() {
        return this.userAgent.indexOf(deviceIpod) != -1;
    }

    public boolean detectIpad() {
        return this.userAgent.indexOf(deviceIpad) != -1 && this.detectWebkit();
    }

    public boolean detectIphoneOrIpod() {
        return this.userAgent.indexOf(deviceIphone) != -1 || this.userAgent.indexOf(deviceIpod) != -1;
    }

    public boolean detectIos() {
        return this.detectIphoneOrIpod() || this.detectIpad();
    }

    public boolean detectAndroid() {
        if (this.initCompleted || this.isAndroid) {
            return this.isAndroid;
        }
        if (this.userAgent.indexOf(deviceAndroid) != -1 || this.detectGoogleTV()) {
            return true;
        }
        return this.userAgent.indexOf(deviceHtcFlyer) != -1;
    }

    public boolean detectAndroidPhone() {
        if (this.initCompleted || this.isAndroidPhone) {
            return this.isAndroidPhone;
        }
        if (this.detectAndroid() && this.userAgent.indexOf(mobile) != -1) {
            return true;
        }
        if (this.detectOperaAndroidPhone()) {
            return true;
        }
        return this.userAgent.indexOf(deviceHtcFlyer) != -1;
    }

    public boolean detectAndroidTablet() {
        if (!this.detectAndroid()) {
            return false;
        }
        if (this.detectOperaMobile()) {
            return false;
        }
        if (this.userAgent.indexOf(deviceHtcFlyer) != -1) {
            return false;
        }
        return this.userAgent.indexOf(mobile) <= -1;
    }

    public boolean detectAndroidWebKit() {
        return this.detectAndroid() && this.detectWebkit();
    }

    public boolean detectGoogleTV() {
        return this.userAgent.indexOf(deviceGoogleTV) != -1;
    }

    public boolean detectWebkit() {
        if (this.initCompleted || this.isWebkit) {
            return this.isWebkit;
        }
        return this.userAgent.indexOf(engineWebKit) != -1;
    }

    public boolean detectWindowsPhone() {
        return this.detectWindowsPhone7() || this.detectWindowsPhone8();
    }

    public boolean detectWindowsPhone7() {
        return this.userAgent.indexOf(deviceWinPhone7) != -1;
    }

    public boolean detectWindowsPhone8() {
        return this.userAgent.indexOf(deviceWinPhone8) != -1;
    }

    public boolean detectWindowsMobile() {
        if (this.detectWindowsPhone()) {
            return false;
        }
        if (this.userAgent.indexOf(deviceWinMob) != -1 || this.userAgent.indexOf(deviceWinMob) != -1 || this.userAgent.indexOf(deviceIeMob) != -1 || this.userAgent.indexOf(enginePie) != -1 || this.userAgent.indexOf(manuHtc) != -1 && this.userAgent.indexOf(deviceWindows) != -1 || this.detectWapWml() && this.userAgent.indexOf(deviceWindows) != -1) {
            return true;
        }
        return this.userAgent.indexOf(devicePpc) != -1 && this.userAgent.indexOf(deviceMacPpc) == -1;
    }

    public boolean detectBlackBerry() {
        if (this.userAgent.indexOf(deviceBB) != -1 || this.httpAccept.indexOf(vndRIM) != -1) {
            return true;
        }
        return this.detectBlackBerry10Phone();
    }

    public boolean detectBlackBerry10Phone() {
        return this.userAgent.indexOf(deviceBB10) != -1 && this.userAgent.indexOf(mobile) != -1;
    }

    public boolean detectBlackBerryTablet() {
        return this.userAgent.indexOf(deviceBBPlaybook) != -1;
    }

    public boolean detectBlackBerryWebKit() {
        return this.detectBlackBerry() && this.detectWebkit();
    }

    public boolean detectBlackBerryTouch() {
        return this.detectBlackBerry() && (this.userAgent.indexOf(deviceBBStorm) != -1 || this.userAgent.indexOf(deviceBBTorch) != -1 || this.userAgent.indexOf(deviceBBBoldTouch) != -1 || this.userAgent.indexOf(deviceBBCurveTouch) != -1);
    }

    public boolean detectBlackBerryHigh() {
        if (this.detectBlackBerryWebKit()) {
            return false;
        }
        if (this.detectBlackBerry()) {
            return this.detectBlackBerryTouch() || this.userAgent.indexOf(deviceBBBold) != -1 || this.userAgent.indexOf(deviceBBTour) != -1 || this.userAgent.indexOf(deviceBBCurve) != -1;
        }
        return false;
    }

    public boolean detectBlackBerryLow() {
        if (this.detectBlackBerry()) {
            return !this.detectBlackBerryHigh() && !this.detectBlackBerryWebKit();
        }
        return false;
    }

    public boolean detectS60OssBrowser() {
        return this.detectWebkit() && (this.userAgent.indexOf(deviceSymbian) != -1 || this.userAgent.indexOf(deviceS60) != -1);
    }

    public boolean detectSymbianOS() {
        return this.userAgent.indexOf(deviceSymbian) != -1 || this.userAgent.indexOf(deviceS60) != -1 || this.userAgent.indexOf(deviceS70) != -1 || this.userAgent.indexOf(deviceS80) != -1 || this.userAgent.indexOf(deviceS90) != -1;
    }

    public boolean detectPalmOS() {
        if (this.detectPalmWebOS()) {
            return false;
        }
        return this.userAgent.indexOf(devicePalm) != -1 || this.userAgent.indexOf(engineBlazer) != -1 || this.userAgent.indexOf(engineXiino) != -1;
    }

    public boolean detectPalmWebOS() {
        return this.userAgent.indexOf(deviceWebOS) != -1;
    }

    public boolean detectWebOSTablet() {
        return this.userAgent.indexOf(deviceWebOShp) != -1 && this.userAgent.indexOf(deviceTablet) != -1;
    }

    public boolean detectOperaMobile() {
        return this.userAgent.indexOf(engineOpera) != -1 && (this.userAgent.indexOf(mini) != -1 || this.userAgent.indexOf(mobi) != -1);
    }

    public boolean detectOperaAndroidPhone() {
        return this.userAgent.indexOf(engineOpera) != -1 && this.userAgent.indexOf(deviceAndroid) != -1 && this.userAgent.indexOf(mobi) != -1;
    }

    public boolean detectOperaAndroidTablet() {
        return this.userAgent.indexOf(engineOpera) != -1 && this.userAgent.indexOf(deviceAndroid) != -1 && this.userAgent.indexOf(deviceTablet) != -1;
    }

    public boolean detectKindle() {
        return this.userAgent.indexOf(deviceKindle) != -1 && !this.detectAndroid();
    }

    public boolean detectAmazonSilk() {
        return this.userAgent.indexOf(engineSilk) != -1;
    }

    public boolean detectGarminNuvifone() {
        return this.userAgent.indexOf(deviceNuvifone) != -1;
    }

    public boolean detectBada() {
        return this.userAgent.indexOf(deviceBada) != -1;
    }

    public boolean detectTizen() {
        return this.userAgent.indexOf(deviceTizen) != -1;
    }

    public boolean detectMeego() {
        return this.userAgent.indexOf(deviceMeego) != -1;
    }

    public boolean detectDangerHiptop() {
        return this.userAgent.indexOf(deviceDanger) != -1 || this.userAgent.indexOf(deviceHiptop) != -1;
    }

    public boolean detectSonyMylo() {
        return this.userAgent.indexOf(manuSony) != -1 && (this.userAgent.indexOf(qtembedded) != -1 || this.userAgent.indexOf(mylocom2) != -1);
    }

    public boolean detectMaemoTablet() {
        if (this.userAgent.indexOf(maemo) != -1) {
            return true;
        }
        return this.userAgent.indexOf(linux) != -1 && this.userAgent.indexOf(deviceTablet) != -1 && !this.detectWebOSTablet() && !this.detectAndroid();
    }

    public boolean detectArchos() {
        return this.userAgent.indexOf(deviceArchos) != -1;
    }

    public boolean detectGameConsole() {
        return this.detectSonyPlaystation() || this.detectNintendo() || this.detectXbox();
    }

    public boolean detectSonyPlaystation() {
        return this.userAgent.indexOf(devicePlaystation) != -1;
    }

    public boolean detectGamingHandheld() {
        return this.userAgent.indexOf(devicePlaystation) != -1 && this.userAgent.indexOf(devicePlaystationVita) != -1;
    }

    public boolean detectNintendo() {
        return this.userAgent.indexOf(deviceNintendo) != -1 || this.userAgent.indexOf(deviceWii) != -1 || this.userAgent.indexOf(deviceNintendoDs) != -1;
    }

    public boolean detectXbox() {
        return this.userAgent.indexOf(deviceXbox) != -1;
    }

    public boolean detectBrewDevice() {
        return this.userAgent.indexOf(deviceBrew) != -1;
    }

    public boolean detectWapWml() {
        return this.httpAccept.indexOf(vndwap) != -1 || this.httpAccept.indexOf(wml) != -1;
    }

    public boolean detectMidpCapable() {
        return this.userAgent.indexOf(deviceMidp) != -1 || this.httpAccept.indexOf(deviceMidp) != -1;
    }

    public boolean detectSmartphone() {
        return this.detectTierIphone() || this.detectS60OssBrowser() || this.detectSymbianOS() || this.detectWindowsMobile() || this.detectBlackBerry() || this.detectPalmOS();
    }

    public boolean detectMobileQuick() {
        if (this.detectTierTablet()) {
            return false;
        }
        if (this.initCompleted || this.isMobilePhone) {
            return this.isMobilePhone;
        }
        if (this.detectSmartphone()) {
            return true;
        }
        if (this.detectWapWml() || this.detectBrewDevice() || this.detectOperaMobile()) {
            return true;
        }
        if (this.userAgent.indexOf(engineObigo) != -1 || this.userAgent.indexOf(engineNetfront) != -1 || this.userAgent.indexOf(engineUpBrowser) != -1 || this.userAgent.indexOf(engineOpenWeb) != -1) {
            return true;
        }
        if (this.detectDangerHiptop() || this.detectMidpCapable() || this.detectMaemoTablet() || this.detectArchos()) {
            return true;
        }
        if (this.userAgent.indexOf(devicePda) != -1 && this.userAgent.indexOf(disUpdate) < 0) {
            return true;
        }
        if (this.userAgent.indexOf(mobile) != -1) {
            return true;
        }
        return this.detectKindle() || this.detectAmazonSilk();
    }

    public boolean detectMobileLong() {
        if (this.detectMobileQuick() || this.detectGameConsole() || this.detectSonyMylo()) {
            return true;
        }
        if (this.userAgent.indexOf(uplink) != -1) {
            return true;
        }
        if (this.userAgent.indexOf(manuSonyEricsson) != -1) {
            return true;
        }
        if (this.userAgent.indexOf(manuericsson) != -1) {
            return true;
        }
        if (this.userAgent.indexOf(manuSamsung1) != -1) {
            return true;
        }
        if (this.userAgent.indexOf(svcDocomo) != -1) {
            return true;
        }
        if (this.userAgent.indexOf(svcKddi) != -1) {
            return true;
        }
        return this.userAgent.indexOf(svcVodafone) != -1;
    }

    public boolean detectTierTablet() {
        if (this.initCompleted || this.isTierTablet) {
            return this.isTierTablet;
        }
        return this.detectIpad() || this.detectAndroidTablet() || this.detectBlackBerryTablet() || this.detectWebOSTablet();
    }

    public boolean detectTierIphone() {
        if (this.initCompleted || this.isTierIphone) {
            return this.isTierIphone;
        }
        return this.detectIphoneOrIpod() || this.detectAndroidPhone() || this.detectWindowsPhone() || this.detectBlackBerry10Phone() || this.detectBlackBerryWebKit() && this.detectBlackBerryTouch() || this.detectPalmWebOS() || this.detectBada() || this.detectTizen() || this.detectGamingHandheld();
    }

    public boolean detectTierRichCss() {
        if (this.initCompleted || this.isTierRichCss) {
            return this.isTierRichCss;
        }
        boolean result = false;
        if (this.detectMobileQuick() && !this.detectTierIphone() && !this.detectKindle() && (this.detectWebkit() || this.detectS60OssBrowser() || this.detectBlackBerryHigh() || this.detectWindowsMobile() || this.userAgent.indexOf(engineTelecaQ) != -1)) {
            result = true;
        }
        return result;
    }

    public boolean detectTierOtherPhones() {
        if (this.initCompleted || this.isTierGenericMobile) {
            return this.isTierGenericMobile;
        }
        return this.detectMobileLong() && !this.detectTierIphone() && !this.detectTierRichCss();
    }
}

