/*
 * Decompiled with CFR 0.152.
 */
package com.skytix.velocity.entities;

import com.skytix.velocity.scheduler.OfferPredicate;
import com.skytix.velocity.scheduler.Priority;
import com.skytix.velocity.scheduler.TaskEventHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.mesos.v1.Protos;

public class TaskDefinition {
    private final Protos.TaskInfo.Builder taskInfo;
    private final Enum<? extends Priority> priority;
    private final TaskEventHandler taskEventHandler;
    private final List<OfferPredicate> conditions;
    private final double memoryTolerance = 0.0;

    public static TaskDefinition from(Protos.TaskInfo.Builder aTaskInfo, Enum<? extends Priority> aPriority, OfferPredicate ... aConditions) {
        return TaskDefinition.from(aTaskInfo, aPriority, null, aConditions);
    }

    public static TaskDefinition from(Protos.TaskInfo.Builder aTaskInfo, Enum<? extends Priority> aPriority, TaskEventHandler aEventHandler, OfferPredicate ... aConditions) {
        return TaskDefinition.builder().taskInfo(aTaskInfo).priority(aPriority).taskEventHandler(aEventHandler).conditions(aConditions != null ? Arrays.asList(aConditions) : Collections.emptyList()).build();
    }

    public boolean hasConditions() {
        return this.getConditions() != null && !this.getConditions().isEmpty();
    }

    public boolean hasTaskId() {
        return this.getTaskInfo() != null && this.getTaskInfo().getTaskId() != null;
    }

    TaskDefinition(Protos.TaskInfo.Builder taskInfo, Enum<? extends Priority> priority, TaskEventHandler taskEventHandler, List<OfferPredicate> conditions) {
        this.taskInfo = taskInfo;
        this.priority = priority;
        this.taskEventHandler = taskEventHandler;
        this.conditions = conditions;
    }

    public static TaskDefinitionBuilder builder() {
        return new TaskDefinitionBuilder();
    }

    public Protos.TaskInfo.Builder getTaskInfo() {
        return this.taskInfo;
    }

    public Enum<? extends Priority> getPriority() {
        return this.priority;
    }

    public TaskEventHandler getTaskEventHandler() {
        return this.taskEventHandler;
    }

    public List<OfferPredicate> getConditions() {
        return this.conditions;
    }

    public double getMemoryTolerance() {
        return this.memoryTolerance;
    }

    public static class TaskDefinitionBuilder {
        private Protos.TaskInfo.Builder taskInfo;
        private Enum<? extends Priority> priority;
        private TaskEventHandler taskEventHandler;
        private List<OfferPredicate> conditions;

        TaskDefinitionBuilder() {
        }

        public TaskDefinitionBuilder taskInfo(Protos.TaskInfo.Builder taskInfo) {
            this.taskInfo = taskInfo;
            return this;
        }

        public TaskDefinitionBuilder priority(Enum<? extends Priority> priority) {
            this.priority = priority;
            return this;
        }

        public TaskDefinitionBuilder taskEventHandler(TaskEventHandler taskEventHandler) {
            this.taskEventHandler = taskEventHandler;
            return this;
        }

        public TaskDefinitionBuilder conditions(List<OfferPredicate> conditions) {
            this.conditions = conditions;
            return this;
        }

        public TaskDefinition build() {
            return new TaskDefinition(this.taskInfo, this.priority, this.taskEventHandler, this.conditions);
        }

        public String toString() {
            return "TaskDefinition.TaskDefinitionBuilder(taskInfo=" + this.taskInfo + ", priority=" + this.priority + ", taskEventHandler=" + this.taskEventHandler + ", conditions=" + this.conditions + ")";
        }
    }
}

