/*
 * Decompiled with CFR 0.152.
 */
package com.skytix.velocity.entities;

import com.skytix.velocity.entities.Task;
import com.skytix.velocity.entities.TaskDefinition;
import com.skytix.velocity.scheduler.TaskRemote;
import java.time.LocalDateTime;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.mesos.v1.Protos;

public class VelocityTask
implements Task {
    private TaskDefinition taskDefinition;
    private Protos.TaskInfo taskInfo;
    private TaskRemote remote;
    private LocalDateTime created;
    private LocalDateTime startTime;
    private LocalDateTime finishTime;
    private Protos.TaskState state;
    private boolean started;
    private boolean running;
    private int taskRetries;

    public void incrementRetry() {
        ++this.taskRetries;
    }

    public boolean isComplete() {
        return this.finishTime != null;
    }

    public String getTaskId() {
        return this.getTaskDefinition().getTaskInfo().getTaskId().getValue();
    }

    @Override
    public int compareTo(VelocityTask o) {
        return new CompareToBuilder().append((Object)this.created, (Object)o.created).append((Object)this.taskDefinition.getTaskInfo().getTaskId().getValue(), (Object)o.taskDefinition.getTaskInfo().getTaskId().getValue()).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        VelocityTask rhs = (VelocityTask)obj;
        return new EqualsBuilder().append((Object)this.taskDefinition.getTaskInfo().getTaskId().getValue(), (Object)rhs.taskDefinition.getTaskInfo().getTaskId().getValue()).build();
    }

    public int hashCode() {
        return new HashCodeBuilder(223, 555).append((Object)this.taskDefinition.getTaskInfo().getTaskId().getValue()).toHashCode();
    }

    private static boolean $default$started() {
        return false;
    }

    private static boolean $default$running() {
        return false;
    }

    private static int $default$taskRetries() {
        return 0;
    }

    VelocityTask(TaskDefinition taskDefinition, Protos.TaskInfo taskInfo, TaskRemote remote, LocalDateTime created, LocalDateTime startTime, LocalDateTime finishTime, Protos.TaskState state, boolean started, boolean running, int taskRetries) {
        this.taskDefinition = taskDefinition;
        this.taskInfo = taskInfo;
        this.remote = remote;
        this.created = created;
        this.startTime = startTime;
        this.finishTime = finishTime;
        this.state = state;
        this.started = started;
        this.running = running;
        this.taskRetries = taskRetries;
    }

    public static VelocityTaskBuilder builder() {
        return new VelocityTaskBuilder();
    }

    public TaskDefinition getTaskDefinition() {
        return this.taskDefinition;
    }

    @Override
    public Protos.TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    @Override
    public TaskRemote getRemote() {
        return this.remote;
    }

    @Override
    public LocalDateTime getCreated() {
        return this.created;
    }

    public LocalDateTime getStartTime() {
        return this.startTime;
    }

    public LocalDateTime getFinishTime() {
        return this.finishTime;
    }

    @Override
    public Protos.TaskState getState() {
        return this.state;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getTaskRetries() {
        return this.taskRetries;
    }

    public void setTaskDefinition(TaskDefinition taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public void setTaskInfo(Protos.TaskInfo taskInfo) {
        this.taskInfo = taskInfo;
    }

    public void setRemote(TaskRemote remote) {
        this.remote = remote;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public void setStartTime(LocalDateTime startTime) {
        this.startTime = startTime;
    }

    public void setFinishTime(LocalDateTime finishTime) {
        this.finishTime = finishTime;
    }

    public void setState(Protos.TaskState state) {
        this.state = state;
    }

    public void setStarted(boolean started) {
        this.started = started;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void setTaskRetries(int taskRetries) {
        this.taskRetries = taskRetries;
    }

    public static class VelocityTaskBuilder {
        private TaskDefinition taskDefinition;
        private Protos.TaskInfo taskInfo;
        private TaskRemote remote;
        private LocalDateTime created;
        private LocalDateTime startTime;
        private LocalDateTime finishTime;
        private Protos.TaskState state;
        private boolean started$set;
        private boolean started$value;
        private boolean running$set;
        private boolean running$value;
        private boolean taskRetries$set;
        private int taskRetries$value;

        VelocityTaskBuilder() {
        }

        public VelocityTaskBuilder taskDefinition(TaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        public VelocityTaskBuilder taskInfo(Protos.TaskInfo taskInfo) {
            this.taskInfo = taskInfo;
            return this;
        }

        public VelocityTaskBuilder remote(TaskRemote remote) {
            this.remote = remote;
            return this;
        }

        public VelocityTaskBuilder created(LocalDateTime created) {
            this.created = created;
            return this;
        }

        public VelocityTaskBuilder startTime(LocalDateTime startTime) {
            this.startTime = startTime;
            return this;
        }

        public VelocityTaskBuilder finishTime(LocalDateTime finishTime) {
            this.finishTime = finishTime;
            return this;
        }

        public VelocityTaskBuilder state(Protos.TaskState state) {
            this.state = state;
            return this;
        }

        public VelocityTaskBuilder started(boolean started) {
            this.started$value = started;
            this.started$set = true;
            return this;
        }

        public VelocityTaskBuilder running(boolean running) {
            this.running$value = running;
            this.running$set = true;
            return this;
        }

        public VelocityTaskBuilder taskRetries(int taskRetries) {
            this.taskRetries$value = taskRetries;
            this.taskRetries$set = true;
            return this;
        }

        public VelocityTask build() {
            boolean started$value = this.started$value;
            if (!this.started$set) {
                started$value = VelocityTask.$default$started();
            }
            boolean running$value = this.running$value;
            if (!this.running$set) {
                running$value = VelocityTask.$default$running();
            }
            int taskRetries$value = this.taskRetries$value;
            if (!this.taskRetries$set) {
                taskRetries$value = VelocityTask.$default$taskRetries();
            }
            return new VelocityTask(this.taskDefinition, this.taskInfo, this.remote, this.created, this.startTime, this.finishTime, this.state, started$value, running$value, taskRetries$value);
        }

        public String toString() {
            return "VelocityTask.VelocityTaskBuilder(taskDefinition=" + this.taskDefinition + ", taskInfo=" + this.taskInfo + ", remote=" + this.remote + ", created=" + this.created + ", startTime=" + this.startTime + ", finishTime=" + this.finishTime + ", state=" + this.state + ", started$value=" + this.started$value + ", running$value=" + this.running$value + ", taskRetries$value=" + this.taskRetries$value + ")";
        }
    }
}

