/*
 * Decompiled with CFR 0.152.
 */
package com.skytix.velocity.repository;

import com.google.common.util.concurrent.AtomicDouble;
import com.skytix.schedulerclient.mesos.MesosConstants;
import com.skytix.velocity.TaskValidationException;
import com.skytix.velocity.VelocityTaskException;
import com.skytix.velocity.entities.TaskDefinition;
import com.skytix.velocity.entities.VelocityTask;
import com.skytix.velocity.mesos.MesosUtils;
import com.skytix.velocity.repository.TaskRepository;
import com.skytix.velocity.scheduler.DefaultPriority;
import com.skytix.velocity.scheduler.OfferBucket;
import com.skytix.velocity.scheduler.OfferBucketFullException;
import com.skytix.velocity.scheduler.OfferPredicate;
import com.skytix.velocity.scheduler.Priority;
import com.skytix.velocity.scheduler.TaskQueueFullException;
import com.skytix.velocity.scheduler.VelocitySchedulerConfig;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.mesos.v1.Protos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTaskRepository
implements TaskRepository<VelocityTask> {
    private static final Logger log = LoggerFactory.getLogger(InMemoryTaskRepository.class);
    private final VelocitySchedulerConfig mConfig;
    private final Map<String, VelocityTask> mTaskInfoByTaskId = new HashMap<String, VelocityTask>();
    private final Semaphore mTaskQueue;
    private final Map<Enum<? extends Priority>, Set<VelocityTask>> mAwaitingTasks = new HashMap<Enum<? extends Priority>, Set<VelocityTask>>();
    private final Map<Enum<? extends Priority>, Set<VelocityTask>> mAwaitingGpuTasks = new HashMap<Enum<? extends Priority>, Set<VelocityTask>>();
    private final List<VelocityTask> mRunningTasks = new ArrayList<VelocityTask>();
    private final AtomicInteger mTotalWaitingTasks = new AtomicInteger(0);
    private AtomicDouble mWaitingCpu = new AtomicDouble(0.0);
    private AtomicDouble mWaitingMem = new AtomicDouble(0.0);
    private AtomicDouble mWaitingDisk = new AtomicDouble(0.0);
    private AtomicDouble mWaitingGpu = new AtomicDouble(0.0);
    private AtomicDouble mRunningCpu = new AtomicDouble(0.0);
    private AtomicDouble mRunningMem = new AtomicDouble(0.0);
    private AtomicDouble mRunningDisk = new AtomicDouble(0.0);
    private AtomicDouble mRunningGpu = new AtomicDouble(0.0);
    private final AtomicInteger mTotalTaskCounter = new AtomicInteger(0);
    private final List<Enum<? extends Priority>> mTaskPriorities;

    public InMemoryTaskRepository(MeterRegistry aMeterRegistry, VelocitySchedulerConfig aConfig) {
        this.mConfig = aConfig;
        this.mTaskPriorities = this.mConfig.getPriorites() != null ? Arrays.asList(this.mConfig.getPriorites().getEnumConstants()) : Arrays.asList(DefaultPriority.values());
        Integer maxTaskQueueSize = aConfig.getMaxTaskQueueSize();
        if (maxTaskQueueSize <= 0) {
            throw new IllegalArgumentException("maxTaskQueueSize must be greater than zero");
        }
        this.mTaskQueue = new Semaphore(maxTaskQueueSize);
        this.configurePriorityQueues();
        this.configureMetrics(aMeterRegistry);
    }

    @Override
    public synchronized List<VelocityTask> getActiveTasks() {
        return this.mRunningTasks;
    }

    @Override
    public List<VelocityTask> getQueuedTasks() {
        ArrayList<VelocityTask> tasks = new ArrayList<VelocityTask>();
        this.mAwaitingGpuTasks.forEach((key, value) -> tasks.addAll((Collection<VelocityTask>)value));
        this.mAwaitingTasks.forEach((key, value) -> tasks.addAll((Collection<VelocityTask>)value));
        return tasks;
    }

    @Override
    public void queueTask(VelocityTask aTask) throws VelocityTaskException {
        this.queueTask(aTask, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void queueTask(VelocityTask aTask, boolean aIsRetry) throws VelocityTaskException {
        Enum enum_;
        TaskDefinition definition = aTask.getTaskDefinition();
        Enum enum_2 = enum_ = definition.getPriority() != null ? definition.getPriority() : DefaultPriority.STANDARD;
        if (!definition.hasTaskId()) throw new TaskValidationException("TaskInfo is missing a TaskID");
        try {
            if (!aIsRetry && !this.mTaskQueue.tryAcquire(this.mConfig.getTaskQueueFullWaitTimeout(), this.mConfig.getTaskQueueFullWaitTimeoutUnit())) throw new TaskQueueFullException();
            Protos.TaskInfo.Builder taskInfo = definition.getTaskInfo();
            double taskGpus = MesosUtils.getGpus((Protos.TaskInfoOrBuilder)taskInfo, 0.0);
            InMemoryTaskRepository inMemoryTaskRepository = this;
            synchronized (inMemoryTaskRepository) {
                this.mTaskInfoByTaskId.put(taskInfo.getTaskId().getValue(), aTask);
                if (taskGpus > 0.0) {
                    if (!this.mConfig.isEnableGPUResources()) throw new TaskValidationException("Unable to request GPU as GPU resources have not been enabled in the scheduler config");
                    this.mAwaitingGpuTasks.get(enum_).add(aTask);
                } else {
                    this.mAwaitingTasks.get(enum_).add(aTask);
                }
                this.incrementWaitingCounters((Protos.TaskInfoOrBuilder)taskInfo);
                return;
            }
        }
        catch (InterruptedException aE) {
            throw new VelocityTaskException(aE);
        }
    }

    @Override
    public void retryTask(VelocityTask aTask) throws VelocityTaskException {
        if (aTask != null) {
            this.completeTask(aTask);
            if (aTask.getTaskRetries() < 3) {
                aTask.setStarted(false);
                aTask.setRemote(null);
                aTask.setTaskInfo(null);
                aTask.incrementRetry();
                this.queueTask(aTask, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completeTask(VelocityTask aTask) {
        Protos.TaskInfo taskInfo = aTask.getTaskInfo();
        String taskId = taskInfo.getTaskId().getValue();
        InMemoryTaskRepository inMemoryTaskRepository = this;
        synchronized (inMemoryTaskRepository) {
            this.mTotalTaskCounter.incrementAndGet();
            if (this.mTaskInfoByTaskId.containsKey(taskId)) {
                this.mRunningTasks.remove(aTask);
                this.decrementRunningCounters((Protos.TaskInfoOrBuilder)taskInfo);
                this.mTaskInfoByTaskId.remove(taskId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launchTasks(List<Protos.TaskInfo> aTasks) {
        InMemoryTaskRepository inMemoryTaskRepository = this;
        synchronized (inMemoryTaskRepository) {
            for (Protos.TaskInfo task : aTasks) {
                VelocityTask velocityTask = this.mTaskInfoByTaskId.get(task.getTaskId().getValue());
                double taskGpus = MesosUtils.getGpus((Protos.TaskInfoOrBuilder)task, 0.0);
                Enum<? extends Priority> priority = velocityTask.getTaskDefinition().getPriority();
                velocityTask.setTaskInfo(task);
                if (taskGpus > 0.0) {
                    this.mAwaitingGpuTasks.get(priority).remove(velocityTask);
                } else {
                    this.mAwaitingTasks.get(priority).remove(velocityTask);
                }
                this.decrementWaitingCounters((Protos.TaskInfoOrBuilder)task);
                this.mRunningTasks.add(velocityTask);
                this.incrementRunningCounters((Protos.TaskInfoOrBuilder)task);
                this.mTaskQueue.release();
            }
        }
    }

    @Override
    public void updateTaskState(VelocityTask aTaskID, Protos.TaskState aTaskState) {
        if (this.mTaskInfoByTaskId.containsKey(aTaskID)) {
            VelocityTask velocityTask = this.mTaskInfoByTaskId.get(aTaskID);
            velocityTask.setState(aTaskState);
            if (aTaskState.equals((Object)Protos.TaskState.TASK_STARTING)) {
                velocityTask.setStarted(true);
            }
        }
    }

    @Override
    public List<Protos.TaskInfo.Builder> getMatchingWaitingTasks(Protos.Offer aOffer) {
        OfferBucket bucket = new OfferBucket(aOffer);
        if (this.mConfig.isEnableGPUResources()) {
            if (MesosUtils.getGpus((Protos.OfferOrBuilder)aOffer, 0.0) > 0.0) {
                this.populateOfferBucket(aOffer, bucket, this.mAwaitingGpuTasks);
                if (!this.mConfig.isRestrictedGpuScheduling()) {
                    this.populateOfferBucket(aOffer, bucket, this.mAwaitingTasks);
                }
            } else {
                this.populateOfferBucket(aOffer, bucket, this.mAwaitingTasks);
            }
        } else {
            this.populateOfferBucket(aOffer, bucket, this.mAwaitingTasks);
        }
        return bucket.getAllocatedTasks();
    }

    @Override
    public VelocityTask getTaskByTaskId(String aTaskId) {
        return this.mTaskInfoByTaskId.getOrDefault(aTaskId, null);
    }

    @Override
    public int getNumQueuedTasks() {
        return this.mTotalWaitingTasks.get();
    }

    @Override
    public int getNumActiveTasks() {
        return this.mRunningTasks.size();
    }

    @Override
    public void close() throws IOException {
    }

    private void populateOfferBucket(Protos.Offer aOffer, OfferBucket aOfferBucket, Map<Enum<? extends Priority>, Set<VelocityTask>> aAwaitingTasks) {
        this.mTaskPriorities.stream().sorted(Comparator.comparing(Enum::ordinal)).forEach(priority -> {
            for (VelocityTask velocityTask : (Set)aAwaitingTasks.get(priority)) {
                TaskDefinition taskDefinition = velocityTask.getTaskDefinition();
                Protos.TaskInfo.Builder taskInfo = taskDefinition.getTaskInfo();
                double memoryTolerance = taskDefinition.getMemoryTolerance();
                try {
                    boolean meetsConditions;
                    if (taskDefinition.hasConditions()) {
                        boolean condition = true;
                        for (OfferPredicate predicate : taskDefinition.getConditions()) {
                            condition = condition && predicate.test(aOffer);
                        }
                        meetsConditions = condition;
                    } else {
                        meetsConditions = true;
                    }
                    if (!meetsConditions) continue;
                    if (aOfferBucket.hasResources((Protos.TaskInfoOrBuilder)taskInfo)) {
                        aOfferBucket.add(taskInfo);
                        continue;
                    }
                    if (!aOfferBucket.hasCpuResources((Protos.TaskInfoOrBuilder)taskInfo) || !aOfferBucket.hasDiskResources((Protos.TaskInfoOrBuilder)taskInfo) || !aOfferBucket.hasGpuResources((Protos.TaskInfoOrBuilder)taskInfo) || !(memoryTolerance > 0.0)) continue;
                    double memDemanded = MesosUtils.getMem((Protos.TaskInfoOrBuilder)taskInfo, 0.0);
                    double minMemoryDemanded = memDemanded - memDemanded * (memoryTolerance / 100.0);
                    double availableMemory = aOfferBucket.getOfferMem() - aOfferBucket.getAllocatedMem();
                    if (!(availableMemory >= minMemoryDemanded)) continue;
                    log.info(String.format("Task '%s' demanded %fM of memory with a minimum threshold of %fM. Using remaining %fM available memory on the offer.", taskInfo.getTaskId().getValue(), memDemanded, minMemoryDemanded, availableMemory));
                    taskInfo.getResourcesList().remove(MesosUtils.getNamedResource(MesosConstants.SCALAR_MEM, (Protos.TaskInfoOrBuilder)taskInfo));
                    taskInfo.addResources(MesosUtils.createMemResource(availableMemory));
                    aOfferBucket.add(taskInfo);
                }
                catch (OfferBucketFullException aE) {
                    break;
                }
            }
        });
    }

    private void incrementWaitingCounters(Protos.TaskInfoOrBuilder aTaskInfo) {
        this.mTotalWaitingTasks.incrementAndGet();
        this.mWaitingCpu.addAndGet(MesosUtils.getNamedResourceScalar("cpus", aTaskInfo, 0.0));
        this.mWaitingMem.addAndGet(MesosUtils.getNamedResourceScalar("mem", aTaskInfo, 0.0));
        this.mWaitingDisk.addAndGet(MesosUtils.getNamedResourceScalar("disk", aTaskInfo, 0.0));
        this.mWaitingGpu.addAndGet(MesosUtils.getNamedResourceScalar("gpus", aTaskInfo, 0.0));
    }

    private void decrementWaitingCounters(Protos.TaskInfoOrBuilder aTaskInfo) {
        this.mTotalWaitingTasks.decrementAndGet();
        this.mWaitingCpu.set(this.mWaitingCpu.get() - MesosUtils.getNamedResourceScalar("cpus", aTaskInfo, 0.0));
        this.mWaitingMem.set(this.mWaitingMem.get() - MesosUtils.getNamedResourceScalar("mem", aTaskInfo, 0.0));
        this.mWaitingDisk.set(this.mWaitingDisk.get() - MesosUtils.getNamedResourceScalar("disk", aTaskInfo, 0.0));
        this.mWaitingGpu.set(this.mWaitingGpu.get() - MesosUtils.getNamedResourceScalar("gpus", aTaskInfo, 0.0));
    }

    private void incrementRunningCounters(Protos.TaskInfoOrBuilder aTaskInfo) {
        this.mRunningCpu.addAndGet(MesosUtils.getNamedResourceScalar("cpus", aTaskInfo, 0.0));
        this.mRunningMem.addAndGet(MesosUtils.getNamedResourceScalar("mem", aTaskInfo, 0.0));
        this.mRunningDisk.addAndGet(MesosUtils.getNamedResourceScalar("disk", aTaskInfo, 0.0));
        this.mRunningGpu.addAndGet(MesosUtils.getNamedResourceScalar("gpus", aTaskInfo, 0.0));
    }

    private void decrementRunningCounters(Protos.TaskInfoOrBuilder aTaskInfo) {
        this.mRunningCpu.set(this.mRunningCpu.get() - MesosUtils.getNamedResourceScalar("cpus", aTaskInfo, 0.0));
        this.mRunningMem.set(this.mRunningMem.get() - MesosUtils.getNamedResourceScalar("mem", aTaskInfo, 0.0));
        this.mRunningDisk.set(this.mRunningDisk.get() - MesosUtils.getNamedResourceScalar("disk", aTaskInfo, 0.0));
        this.mRunningGpu.set(this.mRunningGpu.get() - MesosUtils.getNamedResourceScalar("gpus", aTaskInfo, 0.0));
    }

    private void configurePriorityQueues() {
        this.mTaskPriorities.forEach(priority -> this.mAwaitingTasks.put((Enum<? extends Priority>)priority, new ConcurrentSkipListSet()));
        this.mTaskPriorities.forEach(priority -> this.mAwaitingGpuTasks.put((Enum<? extends Priority>)priority, new ConcurrentSkipListSet()));
    }

    private void configureMetrics(MeterRegistry aMeterRegistry) {
        aMeterRegistry.gauge("velocity.gauge.scheduler.numRunningTasks", this.mRunningTasks, List::size);
        aMeterRegistry.gauge("velocity.gauge.scheduler.totalWaitingTasks", (Object)this.mTotalWaitingTasks, AtomicInteger::get);
        this.mTaskPriorities.forEach(priority -> {
            aMeterRegistry.gauge(String.format("velocity.gauge.scheduler.numWaitingTasks_%s", priority.name()), this.mAwaitingTasks.get(priority), Set::size);
            aMeterRegistry.gauge(String.format("velocity.gauge.scheduler.numWaitingGpuTasks_%s", priority.name()), this.mAwaitingGpuTasks.get(priority), Set::size);
        });
        aMeterRegistry.gauge("velocity.gauge.scheduler.numTotalTasks", (Object)this.mTotalTaskCounter, AtomicInteger::get);
        aMeterRegistry.gauge("velocity.gauge.scheduler.numWaitingCpu", (Object)this.mWaitingCpu, AtomicDouble::get);
        aMeterRegistry.gauge("velocity.gauge.scheduler.numWaitingMem", (Object)this.mWaitingMem, AtomicDouble::get);
        aMeterRegistry.gauge("velocity.gauge.scheduler.numWaitingDisk", (Object)this.mWaitingDisk, AtomicDouble::get);
        aMeterRegistry.gauge("velocity.gauge.scheduler.numWaitingGpu", (Object)this.mWaitingGpu, AtomicDouble::get);
        aMeterRegistry.gauge("velocity.gauge.scheduler.numRunningCpu", (Object)this.mRunningCpu, AtomicDouble::get);
        aMeterRegistry.gauge("velocity.gauge.scheduler.numRunningMem", (Object)this.mRunningMem, AtomicDouble::get);
        aMeterRegistry.gauge("velocity.gauge.scheduler.numRunningDisk", (Object)this.mRunningDisk, AtomicDouble::get);
        aMeterRegistry.gauge("velocity.gauge.scheduler.numRunningGpu", (Object)this.mRunningGpu, AtomicDouble::get);
    }
}

