/*
 * Decompiled with CFR 0.152.
 */
package com.skytix.velocity.scheduler;

import com.skytix.velocity.mesos.MesosUtils;
import com.skytix.velocity.scheduler.OfferBucketFullException;
import java.util.ArrayList;
import java.util.List;
import org.apache.mesos.v1.Protos;

public class OfferBucket {
    private final Protos.OfferID mOfferID;
    private final int mMaxTasksPerOffer;
    private final List<Protos.TaskInfo.Builder> mAllocatedTasks = new ArrayList<Protos.TaskInfo.Builder>();
    private final double mOfferCpus;
    private final double mOfferMem;
    private final double mOfferDisk;
    private final double mOfferGpus;
    private double mAllocatedCpus = 0.0;
    private double mAllocatedMem = 0.0;
    private double mAllocatedDisk = 0.0;
    private double mAllocatedGpus = 0.0;

    public OfferBucket(Protos.Offer aOffer) {
        this(aOffer, 15);
    }

    public OfferBucket(Protos.Offer aOffer, int aMaxTasksPerOffer) {
        this.mOfferID = aOffer.getId();
        this.mMaxTasksPerOffer = aMaxTasksPerOffer;
        this.mOfferCpus = MesosUtils.getCpus((Protos.OfferOrBuilder)aOffer, 0.0);
        this.mOfferMem = MesosUtils.getMem((Protos.OfferOrBuilder)aOffer, 0.0);
        this.mOfferDisk = MesosUtils.getDisk((Protos.OfferOrBuilder)aOffer, 0.0);
        this.mOfferGpus = MesosUtils.getGpus((Protos.OfferOrBuilder)aOffer, 0.0);
    }

    public synchronized boolean hasResources(Protos.TaskInfoOrBuilder aTaskInfo) throws OfferBucketFullException {
        if (this.mAllocatedTasks.size() < this.mMaxTasksPerOffer) {
            if (this.mOfferCpus > 0.0 && this.mOfferMem > 0.0) {
                return this.hasCpuResources(aTaskInfo) && this.hasMemResources(aTaskInfo) && this.hasDiskResources(aTaskInfo) && this.hasGpuResources(aTaskInfo);
            }
            throw new OfferBucketFullException();
        }
        throw new OfferBucketFullException();
    }

    public synchronized boolean hasCpuResources(Protos.TaskInfoOrBuilder aTaskInfo) {
        return this.mAllocatedCpus + MesosUtils.getCpus(aTaskInfo, 0.0) <= this.mOfferCpus;
    }

    public synchronized boolean hasGpuResources(Protos.TaskInfoOrBuilder aTaskInfo) {
        return this.mAllocatedGpus + MesosUtils.getGpus(aTaskInfo, 0.0) <= this.mOfferGpus;
    }

    public synchronized boolean hasMemResources(Protos.TaskInfoOrBuilder aTaskInfo) {
        return this.mAllocatedMem + MesosUtils.getMem(aTaskInfo, 0.0) <= this.mOfferMem;
    }

    public synchronized boolean hasDiskResources(Protos.TaskInfoOrBuilder aTaskInfo) {
        return this.mAllocatedDisk + MesosUtils.getDisk(aTaskInfo, 0.0) <= this.mOfferDisk;
    }

    public synchronized void add(Protos.TaskInfo.Builder aTaskInfo) {
        this.mAllocatedCpus += MesosUtils.getCpus((Protos.TaskInfoOrBuilder)aTaskInfo, 0.0);
        this.mAllocatedMem += MesosUtils.getMem((Protos.TaskInfoOrBuilder)aTaskInfo, 0.0);
        this.mAllocatedDisk += MesosUtils.getDisk((Protos.TaskInfoOrBuilder)aTaskInfo, 0.0);
        this.mAllocatedGpus += MesosUtils.getGpus((Protos.TaskInfoOrBuilder)aTaskInfo, 0.0);
        this.mAllocatedTasks.add(aTaskInfo);
    }

    public double getOfferCpus() {
        return this.mOfferCpus;
    }

    public double getOfferMem() {
        return this.mOfferMem;
    }

    public double getOfferDisk() {
        return this.mOfferDisk;
    }

    public double getOfferGpus() {
        return this.mOfferGpus;
    }

    public double getAllocatedCpus() {
        return this.mAllocatedCpus;
    }

    public double getAllocatedMem() {
        return this.mAllocatedMem;
    }

    public double getAllocatedDisk() {
        return this.mAllocatedDisk;
    }

    public double getAllocatedGpus() {
        return this.mAllocatedGpus;
    }

    public List<Protos.TaskInfo.Builder> getAllocatedTasks() {
        return this.mAllocatedTasks;
    }

    public Protos.OfferID getOfferID() {
        return this.mOfferID;
    }
}

