/*
 * Decompiled with CFR 0.152.
 */
package com.skytix.velocity.scheduler;

import com.skytix.velocity.entities.VelocityTask;
import com.skytix.velocity.scheduler.TaskEventHandler;
import com.skytix.velocity.scheduler.TaskUpdateEvent;
import java.util.concurrent.Flow;
import org.apache.mesos.v1.scheduler.Protos;

public class TaskEventUpdateSubscriber
implements Flow.Subscriber<TaskUpdateEvent> {
    private final TaskEventHandler mDefaultUpdateHandler;
    private Flow.Subscription mSubscription;

    public TaskEventUpdateSubscriber(TaskEventHandler aDefaultUpdateHandler) {
        this.mDefaultUpdateHandler = aDefaultUpdateHandler;
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.mSubscription = subscription;
        this.mSubscription.request(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNext(TaskUpdateEvent item) {
        VelocityTask task = item.getTask();
        Protos.Event.Update event = item.getEvent();
        try {
            if (task != null) {
                TaskEventHandler taskEventHandler = task.getTaskDefinition().getTaskEventHandler();
                if (taskEventHandler != null) {
                    taskEventHandler.onEvent(event);
                } else if (this.mDefaultUpdateHandler != null) {
                    this.mDefaultUpdateHandler.onEvent(event);
                }
            } else if (this.mDefaultUpdateHandler != null) {
                this.mDefaultUpdateHandler.onEvent(event);
            }
        }
        finally {
            this.mSubscription.request(1L);
        }
    }

    @Override
    public void onError(Throwable throwable) {
    }

    @Override
    public void onComplete() {
    }
}

