/*
 * Decompiled with CFR 0.152.
 */
package com.skytix.velocity.scheduler;

import com.skytix.velocity.scheduler.SchedulerRemoteProvider;
import com.skytix.velocity.scheduler.TaskRemote;
import org.apache.mesos.v1.Protos;

public class VelocityTaskRemote
implements TaskRemote {
    private SchedulerRemoteProvider schedulerRemote;
    private Protos.AgentID agentID;
    private Protos.TaskID taskID;

    @Override
    public void terminate() {
        this.schedulerRemote.get().kill(this.taskID, this.agentID);
    }

    VelocityTaskRemote(SchedulerRemoteProvider schedulerRemote, Protos.AgentID agentID, Protos.TaskID taskID) {
        this.schedulerRemote = schedulerRemote;
        this.agentID = agentID;
        this.taskID = taskID;
    }

    public static VelocityTaskRemoteBuilder builder() {
        return new VelocityTaskRemoteBuilder();
    }

    public SchedulerRemoteProvider getSchedulerRemote() {
        return this.schedulerRemote;
    }

    public Protos.AgentID getAgentID() {
        return this.agentID;
    }

    public Protos.TaskID getTaskID() {
        return this.taskID;
    }

    public static class VelocityTaskRemoteBuilder {
        private SchedulerRemoteProvider schedulerRemote;
        private Protos.AgentID agentID;
        private Protos.TaskID taskID;

        VelocityTaskRemoteBuilder() {
        }

        public VelocityTaskRemoteBuilder schedulerRemote(SchedulerRemoteProvider schedulerRemote) {
            this.schedulerRemote = schedulerRemote;
            return this;
        }

        public VelocityTaskRemoteBuilder agentID(Protos.AgentID agentID) {
            this.agentID = agentID;
            return this;
        }

        public VelocityTaskRemoteBuilder taskID(Protos.TaskID taskID) {
            this.taskID = taskID;
            return this;
        }

        public VelocityTaskRemote build() {
            return new VelocityTaskRemote(this.schedulerRemote, this.agentID, this.taskID);
        }

        public String toString() {
            return "VelocityTaskRemote.VelocityTaskRemoteBuilder(schedulerRemote=" + this.schedulerRemote + ", agentID=" + this.agentID + ", taskID=" + this.taskID + ")";
        }
    }
}

