import com.skytix.velocity.VelocityMesosScheduler;
import com.skytix.velocity.entities.TaskDefinition;
import com.skytix.velocity.mesos.Tasks;
import com.skytix.velocity.scheduler.DefaultPriority;
import com.skytix.velocity.scheduler.TaskGroup;
import com.skytix.velocity.scheduler.VelocitySchedulerConfig;
import org.apache.mesos.v1.Protos;

import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;

public class TestApp {

    public static void main(String[] args) {

        try {
            final VelocitySchedulerConfig config = VelocitySchedulerConfig.builder()
                    .frameworkID("marc-test-scheduler-1")
                    .mesosMasterURL("https://master-0.dev.redeye.co:5050")
                    .priorites(DefaultPriority.class)
                    .disableSSLTrust(true)
                    .enableGPUResources(true)
                    .restrictedGpuScheduling(false)
                    .maxNumConcurrentTasks(2)
                    .taskGroups(Arrays.asList(
                            TaskGroup.builder()
                                    .name("testGroup")
                                    .maxConcurrentTasks(5)
                                    .build(),
                            TaskGroup.builder()
                                    .name("testGroup2")
                                    .maxConcurrentTasks(1)
                                    .build()
                            )
                    )
                    .build();

            final VelocityMesosScheduler scheduler = new VelocityMesosScheduler(config);
            int idx = 0;

            for (int i = 0; i < 10; i++) {
                final AtomicInteger atomicInteger = new AtomicInteger(idx);

                final Protos.TaskInfo.Builder docker = Tasks.docker("My special test", "ubuntu", 0.1, 0, 1000, 0, true, "ls -la; sleep 3");

                final TaskDefinition taskDef = TaskDefinition.from(
                        docker,
                        DefaultPriority.STANDARD,
                        (event) -> {

                            switch (event.getStatus().getState()) {
                                case TASK_FINISHED:
                                    System.out.println(String.format("Job number %d finished", atomicInteger.get()));
                            }

                        }, "testGroup"
                );

                scheduler.launch(taskDef);
                System.out.println("Queued job " + idx);
                idx++;
            }

            for (int i = 0; i < 10; i++) {
                final AtomicInteger atomicInteger = new AtomicInteger(idx);

                final Protos.TaskInfo.Builder docker = Tasks.docker("My special test", "ubuntu", 0.1, 0, 1000, 0, true, "ls -la; sleep 3");

                final TaskDefinition taskDef = TaskDefinition.from(
                        docker,
                        DefaultPriority.STANDARD,
                        (event) -> {

                            switch (event.getStatus().getState()) {
                                case TASK_FINISHED:
                                    System.out.println(String.format("Job number %d finished", atomicInteger.get()));
                            }

                        }, "testGroup2"
                );

                scheduler.launch(taskDef);
                System.out.println("Queued job " + idx);
                idx++;
            }

            scheduler.drainAndClose();

        } catch (Exception aE) {
            aE.printStackTrace();
        }
    }

}
