package com.skytix.velocity;

import com.skytix.velocity.entities.VelocityTask;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;

import java.util.stream.Collectors;

public class MetricUtils {

    public static Counter getCounterForTask(MeterRegistry aMeterRegistry, String aName, VelocityTask aTask) {

        return aMeterRegistry.counter(aName, aTask.getTaskDefinition()
                .getMetricTags().stream()
                .map(t -> Tag.of(t.getName(), t.getValue())).collect(Collectors.toList()));
    }

    public static Timer getTimerForTask(MeterRegistry aMeterRegistry, String aName, VelocityTask aTask) {

        return aMeterRegistry.timer(aName, aTask.getTaskDefinition()
                .getMetricTags().stream()
                .map(t -> Tag.of(t.getName(), t.getValue()))
                .collect(Collectors.toList()));
    }

}
