/*
 * #%L
 * ELK OWL API Binding
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2011 Department of Computer Science, University of Oxford
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.semanticweb.elk.owlapi.wrapper;

import java.util.ArrayList;
import java.util.List;

import org.semanticweb.elk.owl.interfaces.ElkDataPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkDisjointDataPropertiesAxiom;
import org.semanticweb.elk.owl.visitors.ElkDataPropertyAxiomVisitor;
import org.semanticweb.elk.owl.visitors.ElkDisjointDataPropertiesAxiomVisitor;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;

/**
 * Implements the {@link ElkDisjointDataPropertiesAxiom} interface by wrapping
 * instances of {@link OWLDisjointDataPropertiesAxiom}
 * 
 * @author "Yevgeny Kazakov"
 * 
 * @param <T>
 *            the type of the wrapped object
 */
public class ElkDisjointDataPropertiesAxiomWrap<T extends OWLDisjointDataPropertiesAxiom>
		extends ElkDataPropertyAxiomWrap<T> implements
		ElkDisjointDataPropertiesAxiom {

	public ElkDisjointDataPropertiesAxiomWrap(T owlDisjointDataPropertiesAxiom) {
		super(owlDisjointDataPropertiesAxiom);
	}

	@Override
	public List<? extends ElkDataPropertyExpression> getDataPropertyExpressions() {
		List<ElkDataPropertyExpression> result = new ArrayList<ElkDataPropertyExpression>();
		for (OWLDataPropertyExpression dpe : this.owlObject.getProperties()) {
			result.add(converter.convert(dpe));
		}
		return result;
	}

	@Override
	public <O> O accept(ElkDataPropertyAxiomVisitor<O> visitor) {
		return accept((ElkDisjointDataPropertiesAxiomVisitor<O>) visitor);
	}

	@Override
	public <O> O accept(ElkDisjointDataPropertiesAxiomVisitor<O> visitor) {
		return visitor.visit(this);
	}
}