/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkEntity;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.reasoner.DummyProgressMonitor;
import org.semanticweb.elk.reasoner.ElkFreshEntitiesException;
import org.semanticweb.elk.reasoner.ElkInconsistentOntologyException;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.ReasonerInterrupter;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.stages.AbstractReasonerState;
import org.semanticweb.elk.reasoner.stages.ReasonerStageExecutor;
import org.semanticweb.elk.reasoner.taxonomy.FreshInstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.FreshTaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.FreshTypeNode;
import org.semanticweb.elk.reasoner.taxonomy.TaxonomyNodeUtils;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceNode;
import org.semanticweb.elk.reasoner.taxonomy.model.InstanceTaxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.Taxonomy;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.reasoner.taxonomy.model.TypeNode;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.concurrent.computation.ConcurrentExecutor;
import org.semanticweb.elk.util.concurrent.computation.ConcurrentExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reasoner
extends AbstractReasonerState {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(Reasoner.class);
    private static final ConcurrentExecutor EXECUTOR_ = ConcurrentExecutors.create((String)"elk-reasoner");
    protected ProgressMonitor progressMonitor;
    private final ReasonerStageExecutor stageExecutor_;
    private final ReasonerInterrupter interrupter_;
    private int workerNo_;
    protected boolean allowFreshEntities;

    protected Reasoner(ElkObject.Factory elkFactory, ReasonerInterrupter interrupter, ReasonerStageExecutor stageExecutor, ReasonerConfiguration config) {
        super(elkFactory, config);
        this.stageExecutor_ = stageExecutor;
        this.interrupter_ = interrupter;
        this.progressMonitor = new DummyProgressMonitor();
        this.allowFreshEntities = true;
        this.setConfigurationOptions(config);
        LOGGER_.info("ELK reasoner was created");
    }

    public synchronized void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public synchronized void setAllowFreshEntities(boolean allow) {
        this.allowFreshEntities = allow;
    }

    public synchronized boolean getAllowFreshEntities() {
        return this.allowFreshEntities;
    }

    @Override
    protected synchronized int getNumberOfWorkers() {
        return this.workerNo_;
    }

    public synchronized void setNumberOfWorkers(int workerNo) {
        this.workerNo_ = workerNo;
    }

    public synchronized void setConfigurationOptions(ReasonerConfiguration config) {
        this.workerNo_ = config.getParameterAsInt("elk.reasoner.number_of_workers");
        this.setAllowIncrementalMode(config.getParameterAsBoolean("elk.reasoner.incremental.allowed"));
    }

    @Override
    protected ConcurrentExecutor getProcessExecutor() {
        return EXECUTOR_;
    }

    @Override
    protected ReasonerStageExecutor getStageExecutor() {
        return this.stageExecutor_;
    }

    @Override
    protected ReasonerInterrupter getInterrupter() {
        return this.interrupter_;
    }

    @Override
    protected synchronized ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public synchronized boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        boolean success = true;
        if (success) {
            LOGGER_.info("ELK reasoner has shut down");
        } else {
            LOGGER_.error("ELK reasoner failed to shut down!");
        }
        return success;
    }

    public synchronized boolean shutdown() throws InterruptedException {
        return this.shutdown(1L, TimeUnit.MINUTES);
    }

    protected TaxonomyNode<ElkClass> getTaxonomyNode(ElkClass elkClass) throws ElkException {
        Taxonomy<ElkClass> taxonomy = this.getTaxonomy();
        TaxonomyNode<ElkClass> node = taxonomy.getNode(elkClass);
        if (node != null) {
            return node;
        }
        if (this.allowFreshEntities) {
            return new FreshTaxonomyNode<ElkClass>(elkClass, taxonomy);
        }
        throw new ElkFreshEntitiesException((ElkEntity)elkClass);
    }

    protected InstanceNode<ElkClass, ElkNamedIndividual> getInstanceNode(ElkNamedIndividual elkNamedIndividual) throws ElkException {
        InstanceTaxonomy<ElkClass, ElkNamedIndividual> instanceTaxonomy = this.getInstanceTaxonomy();
        InstanceNode<ElkClass, ElkNamedIndividual> node = instanceTaxonomy.getInstanceNode(elkNamedIndividual);
        if (node != null) {
            return node;
        }
        if (this.allowFreshEntities) {
            return new FreshInstanceNode<ElkClass, ElkNamedIndividual>(elkNamedIndividual, instanceTaxonomy);
        }
        throw new ElkFreshEntitiesException((ElkEntity)elkNamedIndividual);
    }

    protected TypeNode<ElkClass, ElkNamedIndividual> getTypeNode(ElkClass elkClass) throws ElkException {
        InstanceTaxonomy<ElkClass, ElkNamedIndividual> instanceTaxonomy = this.getInstanceTaxonomy();
        TypeNode<ElkClass, ElkNamedIndividual> node = instanceTaxonomy.getNode(elkClass);
        if (node != null) {
            return node;
        }
        if (this.allowFreshEntities) {
            return new FreshTypeNode<ElkClass, ElkNamedIndividual>(elkClass, instanceTaxonomy);
        }
        throw new ElkFreshEntitiesException((ElkEntity)elkClass);
    }

    protected TaxonomyNode<ElkObjectProperty> getObjectPropertyTaxonomyNode(ElkObjectProperty elkProperty) throws ElkException {
        Taxonomy<ElkObjectProperty> propertyTaxonomy = this.getObjectPropertyTaxonomy();
        TaxonomyNode<ElkObjectProperty> node = propertyTaxonomy.getNode(elkProperty);
        if (node != null) {
            return node;
        }
        if (this.allowFreshEntities) {
            return new FreshTaxonomyNode<ElkObjectProperty>(elkProperty, propertyTaxonomy);
        }
        throw new ElkFreshEntitiesException((ElkEntity)elkProperty);
    }

    public synchronized TaxonomyNode<ElkObjectProperty> getObjectPropertyNode(ElkObjectProperty property) throws ElkException {
        return this.getObjectPropertyTaxonomyNode(property);
    }

    public synchronized Node<ElkClass> getEquivalentClasses(ElkClassExpression classExpression) throws ElkInconsistentOntologyException, ElkException {
        if (classExpression instanceof ElkClass) {
            return this.getTaxonomyNode((ElkClass)classExpression);
        }
        return this.queryEquivalentClasses(classExpression);
    }

    public synchronized Node<ElkClass> getEquivalentClassesQuietly(ElkClassExpression classExpression) throws ElkException {
        try {
            return this.getEquivalentClasses(classExpression);
        }
        catch (ElkInconsistentOntologyException e) {
            return this.getTaxonomyQuietly().getBottomNode();
        }
    }

    public synchronized Set<? extends Node<ElkClass>> getSubClasses(ElkClassExpression classExpression, boolean direct) throws ElkInconsistentOntologyException, ElkException {
        if (classExpression instanceof ElkClass) {
            TaxonomyNode<ElkClass> queryNode = this.getTaxonomyNode((ElkClass)classExpression);
            return direct ? queryNode.getDirectSubNodes() : queryNode.getAllSubNodes();
        }
        Set<? extends Node<ElkClass>> subNodes = this.queryDirectSubClasses(classExpression);
        if (direct) {
            return subNodes;
        }
        final Taxonomy<ElkClass> taxonomy = this.restoreTaxonomy();
        return TaxonomyNodeUtils.getAllReachable(Operations.map(subNodes, (Operations.Transformation)new Operations.Transformation<Node<ElkClass>, TaxonomyNode<ElkClass>>(){

            public TaxonomyNode<ElkClass> transform(Node<ElkClass> node) {
                return taxonomy.getNode((ElkEntity)node.getCanonicalMember());
            }
        }), new Operations.Functor<TaxonomyNode<ElkClass>, Set<? extends TaxonomyNode<ElkClass>>>(){

            public Set<? extends TaxonomyNode<ElkClass>> apply(TaxonomyNode<ElkClass> node) {
                return node.getDirectSubNodes();
            }
        });
    }

    public synchronized Set<? extends Node<ElkClass>> getSubClassesQuietly(ElkClassExpression classExpression, boolean direct) throws ElkException {
        try {
            return this.getSubClasses(classExpression, direct);
        }
        catch (ElkInconsistentOntologyException e) {
            TaxonomyNode<ElkClass> node = this.getTaxonomyQuietly().getBottomNode();
            return direct ? node.getDirectSubNodes() : node.getAllSubNodes();
        }
    }

    public synchronized Set<? extends Node<ElkClass>> getSuperClasses(ElkClassExpression classExpression, boolean direct) throws ElkInconsistentOntologyException, ElkException {
        if (classExpression instanceof ElkClass) {
            TaxonomyNode<ElkClass> queryNode = this.getTaxonomyNode((ElkClass)classExpression);
            return direct ? queryNode.getDirectSuperNodes() : queryNode.getAllSuperNodes();
        }
        Set<? extends Node<ElkClass>> superNodes = this.queryDirectSuperClasses(classExpression);
        if (direct) {
            return superNodes;
        }
        final Taxonomy<ElkClass> taxonomy = this.restoreTaxonomy();
        return TaxonomyNodeUtils.getAllReachable(Operations.map(superNodes, (Operations.Transformation)new Operations.Transformation<Node<ElkClass>, TaxonomyNode<ElkClass>>(){

            public TaxonomyNode<ElkClass> transform(Node<ElkClass> node) {
                return taxonomy.getNode((ElkEntity)node.getCanonicalMember());
            }
        }), new Operations.Functor<TaxonomyNode<ElkClass>, Set<? extends TaxonomyNode<ElkClass>>>(){

            public Set<? extends TaxonomyNode<ElkClass>> apply(TaxonomyNode<ElkClass> node) {
                return node.getDirectSuperNodes();
            }
        });
    }

    public synchronized Set<? extends Node<ElkClass>> getSuperClassesQuietly(ElkClassExpression classExpression, boolean direct) throws ElkException {
        try {
            return this.getSuperClasses(classExpression, direct);
        }
        catch (ElkInconsistentOntologyException e) {
            TaxonomyNode<ElkClass> node = this.getTaxonomyQuietly().getBottomNode();
            return direct ? node.getDirectSuperNodes() : node.getAllSuperNodes();
        }
    }

    public synchronized Set<? extends Node<ElkObjectProperty>> getSubObjectProperties(ElkObjectProperty property, boolean direct) throws ElkException {
        TaxonomyNode<ElkObjectProperty> queryNode = this.getObjectPropertyNode(property);
        return direct ? queryNode.getDirectSubNodes() : queryNode.getAllSubNodes();
    }

    public synchronized Set<? extends Node<ElkObjectProperty>> getSuperObjectProperties(ElkObjectProperty property, boolean direct) throws ElkException {
        TaxonomyNode<ElkObjectProperty> queryNode = this.getObjectPropertyNode(property);
        return direct ? queryNode.getDirectSuperNodes() : queryNode.getAllSuperNodes();
    }

    public synchronized Set<? extends Node<ElkNamedIndividual>> getInstances(ElkClassExpression classExpression, boolean direct) throws ElkInconsistentOntologyException, ElkException {
        if (classExpression instanceof ElkClass) {
            TypeNode<ElkClass, ElkNamedIndividual> queryNode = this.getTypeNode((ElkClass)classExpression);
            return direct ? queryNode.getDirectInstanceNodes() : queryNode.getAllInstanceNodes();
        }
        Set<? extends Node<ElkNamedIndividual>> instances = this.queryDirectInstances(classExpression);
        if (direct) {
            return instances;
        }
        Set<? extends Node<ElkClass>> subNodes = this.queryDirectSubClasses(classExpression);
        final InstanceTaxonomy<ElkClass, ElkNamedIndividual> taxonomy = this.restoreInstanceTaxonomy();
        return TaxonomyNodeUtils.collectFromAllReachable(Operations.map(subNodes, (Operations.Transformation)new Operations.Transformation<Node<ElkClass>, TypeNode<ElkClass, ElkNamedIndividual>>(){

            public TypeNode<ElkClass, ElkNamedIndividual> transform(Node<ElkClass> node) {
                return taxonomy.getNode((ElkEntity)node.getCanonicalMember());
            }
        }), Operations.map(instances, (Operations.Transformation)new Operations.Transformation<Node<ElkNamedIndividual>, InstanceNode<ElkClass, ElkNamedIndividual>>(){

            public InstanceNode<ElkClass, ElkNamedIndividual> transform(Node<ElkNamedIndividual> node) {
                return taxonomy.getInstanceNode((ElkEntity)node.getCanonicalMember());
            }
        }), new Operations.Functor<TypeNode<ElkClass, ElkNamedIndividual>, Set<? extends TypeNode<ElkClass, ElkNamedIndividual>>>(){

            public Set<? extends TypeNode<ElkClass, ElkNamedIndividual>> apply(TypeNode<ElkClass, ElkNamedIndividual> node) {
                return node.getDirectSubNodes();
            }
        }, new Operations.Functor<TypeNode<ElkClass, ElkNamedIndividual>, Set<? extends InstanceNode<ElkClass, ElkNamedIndividual>>>(){

            public Set<? extends InstanceNode<ElkClass, ElkNamedIndividual>> apply(TypeNode<ElkClass, ElkNamedIndividual> node) {
                return node.getDirectInstanceNodes();
            }
        });
    }

    public synchronized Set<? extends Node<ElkNamedIndividual>> getInstancesQuietly(ElkClassExpression classExpression, boolean direct) throws ElkException {
        try {
            return this.getInstances(classExpression, direct);
        }
        catch (ElkInconsistentOntologyException e) {
            TypeNode<ElkClass, ElkNamedIndividual> node = this.getInstanceTaxonomyQuietly().getBottomNode();
            return direct ? node.getDirectInstanceNodes() : node.getAllInstanceNodes();
        }
    }

    public synchronized Set<? extends Node<ElkClass>> getTypes(ElkNamedIndividual elkNamedIndividual, boolean direct) throws ElkException {
        InstanceNode<ElkClass, ElkNamedIndividual> node = this.getInstanceNode(elkNamedIndividual);
        return direct ? node.getDirectTypeNodes() : node.getAllTypeNodes();
    }

    public synchronized boolean isSatisfiable(ElkClassExpression classExpression) throws ElkException {
        if (classExpression instanceof ElkClass) {
            TaxonomyNode<ElkClass> queryNode = this.getTaxonomyNode((ElkClass)classExpression);
            return !queryNode.contains(this.getElkFactory().getOwlNothing());
        }
        return this.querySatisfiability(classExpression);
    }

    public synchronized boolean isSatisfiableQuietly(ElkClassExpression classExpression) throws ElkException {
        try {
            return this.isSatisfiable(classExpression);
        }
        catch (ElkInconsistentOntologyException e) {
            return false;
        }
    }
}

