/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner;

import java.util.Collection;
import java.util.Iterator;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.util.concurrent.computation.ConcurrentComputationWithInputs;
import org.semanticweb.elk.util.concurrent.computation.ConcurrentExecutor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReasonerComputationWithInputs<I, F extends InputProcessorFactory<I, ?>>
extends ConcurrentComputationWithInputs<I, F> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ReasonerComputationWithInputs.class);
    protected final ProgressMonitor progressMonitor;
    protected final Iterator<? extends I> todo;
    private final int maxProgress;
    private int progress;
    I nextInput;

    public ReasonerComputationWithInputs(Collection<? extends I> inputs, F inputProcessorFactory, ConcurrentExecutor executor, int maxWorkers, ProgressMonitor progressMonitor) {
        super(inputProcessorFactory, executor, maxWorkers);
        this.progressMonitor = progressMonitor;
        this.todo = inputs.iterator();
        this.maxProgress = inputs.size();
        this.progress = 0;
        this.nextInput = null;
    }

    public void process() {
        if (!this.start()) {
            String message = "Could not start workers required for reasoner computation!";
            LOGGER_.error(message);
            throw new ElkRuntimeException(message);
        }
        try {
            if (this.nextInput != null && !this.processNextInput()) {
                return;
            }
            while (this.todo.hasNext()) {
                this.nextInput = this.todo.next();
                if (this.processNextInput()) continue;
                return;
            }
            this.finish();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ElkRuntimeException("Reasoner computation interrupted externally!");
        }
    }

    private boolean processNextInput() throws InterruptedException {
        if (!this.submit(this.nextInput)) {
            this.waitWorkers();
            return false;
        }
        this.nextInput = null;
        if (this.isInterrupted()) {
            this.waitWorkers();
            return false;
        }
        this.progressMonitor.report(++this.progress, this.maxProgress);
        return true;
    }
}

