/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import java.util.Arrays;
import org.semanticweb.elk.reasoner.completeness.IncompletenessMonitor;
import org.slf4j.Logger;

class DelegatingIncompletenessMonitor
implements IncompletenessMonitor {
    private final Iterable<? extends IncompletenessMonitor> incompletenessMonitors_;

    public DelegatingIncompletenessMonitor(Iterable<? extends IncompletenessMonitor> incompletenessMonitors) {
        this.incompletenessMonitors_ = incompletenessMonitors;
    }

    public DelegatingIncompletenessMonitor(IncompletenessMonitor ... incompletenessMonitors) {
        this(Arrays.asList(incompletenessMonitors));
    }

    @Override
    public boolean isIncomplete() {
        for (IncompletenessMonitor incompletenessMonitor : this.incompletenessMonitors_) {
            if (!incompletenessMonitor.isIncomplete()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean logNewIncompletenessReasons(Logger logger) {
        boolean result = false;
        for (IncompletenessMonitor incompletenessMonitor : this.incompletenessMonitors_) {
            result = incompletenessMonitor.logNewIncompletenessReasons(logger) || result;
        }
        return result;
    }
}

