/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToOccurrencesMonitor;
import org.semanticweb.elk.reasoner.indexing.model.Occurrence;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceStore;
import org.semanticweb.elk.util.logging.LogLevel;
import org.semanticweb.elk.util.logging.LoggerWrap;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

class IncompletenessDueToRangeAndPropertyAssertionOccurrencesInStatedAxiomsMonitor
extends IncompletenessDueToOccurrencesMonitor {
    private static final Marker MARKER_ = MarkerFactory.getMarker((String)"ObjectPropertyAssertionWithObjectPropertyRange");
    public static final int AT_MOST_N_OCCURRENCES_IN_MESSAGE = 3;
    private final LogLevel logLevel_;
    private Set<? extends ElkObject> lastOccursIn_ = Collections.emptySet();

    public IncompletenessDueToRangeAndPropertyAssertionOccurrencesInStatedAxiomsMonitor(OccurrenceStore occurrencesInStatedAxioms, LogLevel logLevel) {
        super(occurrencesInStatedAxioms);
        this.logLevel_ = logLevel;
    }

    @Override
    public boolean isIncomplete() {
        Collection<? extends ElkObject> rangeOccursIn = this.occurrences.occursIn(Occurrence.OCCURRENCE_OF_OBJECT_PROPERTY_RANGE);
        Collection<? extends ElkObject> assertionOccurrsIn = this.occurrences.occursIn(Occurrence.OCCURRENCE_OF_OBJECT_PROPERTY_ASSERTION);
        return rangeOccursIn != null && !rangeOccursIn.isEmpty() && assertionOccurrsIn != null && !assertionOccurrsIn.isEmpty();
    }

    private StringBuilder printOccurrences(Collection<? extends ElkObject> occursIn, StringBuilder message) {
        int i = 0;
        for (ElkObject elkObject : occursIn) {
            if (i >= 3) {
                message.append("\n\t...");
                break;
            }
            message.append("\n\t").append(OwlFunctionalStylePrinter.toString((ElkObject)elkObject));
            ++i;
        }
        return message;
    }

    @Override
    public boolean logNewIncompletenessReasons(Logger logger) {
        Collection<? extends ElkObject> rangeOccursIn = this.occurrences.occursIn(Occurrence.OCCURRENCE_OF_OBJECT_PROPERTY_RANGE);
        Collection<? extends ElkObject> assertionOccurrsIn = this.occurrences.occursIn(Occurrence.OCCURRENCE_OF_OBJECT_PROPERTY_ASSERTION);
        if (rangeOccursIn == null || rangeOccursIn.isEmpty() || assertionOccurrsIn == null || assertionOccurrsIn.isEmpty()) {
            this.lastOccursIn_ = Collections.emptySet();
            return false;
        }
        ImmutableSet.Builder currentOccursIn = ImmutableSet.builder();
        boolean hasNewOccurrence = false;
        for (ElkObject elkObject : rangeOccursIn) {
            currentOccursIn.add((Object)elkObject);
            if (this.lastOccursIn_.contains(elkObject)) continue;
            hasNewOccurrence = true;
        }
        for (ElkObject elkObject : assertionOccurrsIn) {
            currentOccursIn.add((Object)elkObject);
            if (this.lastOccursIn_.contains(elkObject)) continue;
            hasNewOccurrence = true;
        }
        this.lastOccursIn_ = currentOccursIn.build();
        if (hasNewOccurrence) {
            if (LoggerWrap.isEnabledFor((Logger)logger, (LogLevel)this.logLevel_)) {
                StringBuilder message = new StringBuilder("ELK supports ObjectPropertyAssertion and ObjectPropertyRange in the same ontology only partially.");
                message.append("\n");
                message.append("occurrences of ObjectPropertyAssertion:");
                this.printOccurrences(assertionOccurrsIn, message);
                message.append("\n");
                message.append("occurrences of ObjectPropertyRange:");
                this.printOccurrences(rangeOccursIn, message);
                LoggerWrap.log((Logger)logger, (LogLevel)this.logLevel_, (Marker)MARKER_, (String)message.toString());
            }
            return true;
        }
        return false;
    }
}

