/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToNegativeOccurrenceOfObjectComplementOfMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToNegativeOccurrenceOfTopObjectPropertyMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToOccurrenceOfDataHasValueMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToOccurrenceOfDisjointUnionMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToOccurrenceOfNominalMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToOccurrenceOfUnsupportedExpressionMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToOccurrencesMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToPositiveOccurrenceOfBottomObjectPropertyMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToPositiveOccurrenceOfObjectUnionOfMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessMessageProvider;
import org.semanticweb.elk.reasoner.indexing.model.Occurrence;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceStore;
import org.semanticweb.elk.util.logging.LogLevel;
import org.semanticweb.elk.util.logging.LoggerWrap;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

abstract class IncompletenessDueToSingleOccurrenceMonitor
extends IncompletenessDueToOccurrencesMonitor {
    private final LogLevel logLevel_;
    private final IncompletenessMessageProvider messageProvider_;
    private final Marker marker_ = MarkerFactory.getMarker((String)this.getOccurrence().toString());
    private Set<? extends ElkObject> lastOccursIn_ = Collections.emptySet();

    public IncompletenessDueToSingleOccurrenceMonitor(OccurrenceStore occurrences, LogLevel logLevel, IncompletenessMessageProvider messageProvider) {
        super(occurrences);
        this.logLevel_ = logLevel;
        this.messageProvider_ = messageProvider;
    }

    public abstract Occurrence getOccurrence();

    @Override
    public boolean isIncomplete() {
        Collection<? extends ElkObject> occurrsIn = this.occurrences.occursIn(this.getOccurrence());
        return occurrsIn != null && !occurrsIn.isEmpty();
    }

    @Override
    public boolean logNewIncompletenessReasons(Logger logger) {
        ImmutableSet.Builder currentOccursIn = ImmutableSet.builder();
        ArrayList<ElkObject> newOccursIn = new ArrayList<ElkObject>();
        for (ElkObject elkObject : this.occurrences.occursIn(this.getOccurrence())) {
            currentOccursIn.add((Object)elkObject);
            if (this.lastOccursIn_.contains(elkObject)) continue;
            newOccursIn.add(elkObject);
        }
        this.lastOccursIn_ = currentOccursIn.build();
        if (!newOccursIn.isEmpty()) {
            if (LoggerWrap.isEnabledFor((Logger)logger, (LogLevel)this.logLevel_)) {
                StringBuilder message = new StringBuilder(this.accept(this.messageProvider_));
                message.append("\n");
                this.messageProvider_.printOccurrences(this.occurrences.occursIn(this.getOccurrence()), message);
                LoggerWrap.log((Logger)logger, (LogLevel)this.logLevel_, (Marker)this.marker_, (String)message.toString());
            }
            return true;
        }
        return false;
    }

    public abstract <O> O accept(Visitor<O> var1);

    public static interface Visitor<O>
    extends IncompletenessDueToNegativeOccurrenceOfObjectComplementOfMonitor.Visitor<O>,
    IncompletenessDueToNegativeOccurrenceOfTopObjectPropertyMonitor.Visitor<O>,
    IncompletenessDueToOccurrenceOfDataHasValueMonitor.Visitor<O>,
    IncompletenessDueToOccurrenceOfDisjointUnionMonitor.Visitor<O>,
    IncompletenessDueToOccurrenceOfNominalMonitor.Visitor<O>,
    IncompletenessDueToOccurrenceOfUnsupportedExpressionMonitor.Visitor<O>,
    IncompletenessDueToPositiveOccurrenceOfBottomObjectPropertyMonitor.Visitor<O>,
    IncompletenessDueToPositiveOccurrenceOfObjectUnionOfMonitor.Visitor<O> {
    }
}

