/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.completeness;

import java.util.ArrayList;
import java.util.Arrays;
import org.semanticweb.elk.reasoner.completeness.DelegatingIncompletenessMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToInStatedAxiomsMessageProvider;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToNegativeOccurrenceOfObjectComplementOfMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToNegativeOccurrenceOfTopObjectPropertyMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToOccurrenceOfDataHasValueMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToOccurrenceOfDisjointUnionMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToOccurrenceOfNominalMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToOccurrenceOfUnsupportedExpressionMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToOccurrencesInClassExpressionQueryMessageProvider;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToOccurrencesInEntailmentQueryMessageProvider;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToPositiveOccurrenceOfBottomObjectPropertyMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToPositiveOccurrenceOfObjectUnionOfMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessDueToRangeAndPropertyAssertionOccurrencesInStatedAxiomsMonitor;
import org.semanticweb.elk.reasoner.completeness.IncompletenessMessageProvider;
import org.semanticweb.elk.reasoner.completeness.IncompletenessMonitor;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceStore;
import org.semanticweb.elk.util.logging.LogLevel;
import org.semanticweb.elk.util.logging.LoggerWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class IncompletenessManager {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(IncompletenessManager.class);
    private static final Marker MARKER_ = MarkerFactory.getMarker((String)"Incompleteness");
    private final IncompletenessMonitor incompletenessDueToStatedAxiomsMonitor_;

    public IncompletenessManager(OccurrenceStore occurrencesInStatedAxiomsStore) {
        this.incompletenessDueToStatedAxiomsMonitor_ = new DelegatingIncompletenessMonitor(new IncompletenessDueToNegativeOccurrenceOfObjectComplementOfMonitor(occurrencesInStatedAxiomsStore, LogLevel.INFO, IncompletenessDueToInStatedAxiomsMessageProvider.INSTANCE), new IncompletenessDueToNegativeOccurrenceOfTopObjectPropertyMonitor(occurrencesInStatedAxiomsStore, LogLevel.INFO, IncompletenessDueToInStatedAxiomsMessageProvider.INSTANCE), new IncompletenessDueToOccurrenceOfDataHasValueMonitor(occurrencesInStatedAxiomsStore, LogLevel.INFO, IncompletenessDueToInStatedAxiomsMessageProvider.INSTANCE), new IncompletenessDueToOccurrenceOfDisjointUnionMonitor(occurrencesInStatedAxiomsStore, LogLevel.INFO, IncompletenessDueToInStatedAxiomsMessageProvider.INSTANCE), new IncompletenessDueToOccurrenceOfNominalMonitor(occurrencesInStatedAxiomsStore, LogLevel.INFO, IncompletenessDueToInStatedAxiomsMessageProvider.INSTANCE), new IncompletenessDueToOccurrenceOfUnsupportedExpressionMonitor(occurrencesInStatedAxiomsStore, LogLevel.INFO, IncompletenessDueToInStatedAxiomsMessageProvider.INSTANCE), new IncompletenessDueToPositiveOccurrenceOfBottomObjectPropertyMonitor(occurrencesInStatedAxiomsStore, LogLevel.INFO, IncompletenessDueToInStatedAxiomsMessageProvider.INSTANCE), new IncompletenessDueToPositiveOccurrenceOfObjectUnionOfMonitor(occurrencesInStatedAxiomsStore, LogLevel.INFO, IncompletenessDueToInStatedAxiomsMessageProvider.INSTANCE), new IncompletenessDueToRangeAndPropertyAssertionOccurrencesInStatedAxiomsMonitor(occurrencesInStatedAxiomsStore, LogLevel.INFO));
    }

    public IncompletenessMonitor getIncompletenessDueToStatedAxiomsMonitor() {
        return this.incompletenessDueToStatedAxiomsMonitor_;
    }

    private IncompletenessMonitor getIncompletenessDueToOccurrencesInQueryMonitor(OccurrenceStore occurrencesInQuery, IncompletenessMessageProvider messageProvider) {
        return new DelegatingIncompletenessMonitor(new IncompletenessDueToNegativeOccurrenceOfObjectComplementOfMonitor(occurrencesInQuery, LogLevel.INFO, messageProvider), new IncompletenessDueToNegativeOccurrenceOfTopObjectPropertyMonitor(occurrencesInQuery, LogLevel.INFO, messageProvider), new IncompletenessDueToOccurrenceOfDataHasValueMonitor(occurrencesInQuery, LogLevel.INFO, messageProvider), new IncompletenessDueToOccurrenceOfNominalMonitor(occurrencesInQuery, LogLevel.INFO, messageProvider), new IncompletenessDueToOccurrenceOfUnsupportedExpressionMonitor(occurrencesInQuery, LogLevel.INFO, messageProvider), new IncompletenessDueToPositiveOccurrenceOfBottomObjectPropertyMonitor(occurrencesInQuery, LogLevel.INFO, messageProvider), new IncompletenessDueToPositiveOccurrenceOfObjectUnionOfMonitor(occurrencesInQuery, LogLevel.INFO, messageProvider));
    }

    public IncompletenessMonitor getReasonerIncompletenessMonitor(IncompletenessMonitor ... additionalMonitors) {
        ArrayList<IncompletenessMonitor> monitors = new ArrayList<IncompletenessMonitor>(additionalMonitors.length + 1);
        monitors.add(this.getIncompletenessDueToStatedAxiomsMonitor());
        monitors.addAll(Arrays.asList(additionalMonitors));
        return new DelegatingIncompletenessMonitor(monitors){

            @Override
            public boolean logNewIncompletenessReasons(Logger logger) {
                boolean result = super.logNewIncompletenessReasons(logger);
                if (result) {
                    LoggerWrap.log((Logger)logger, (LogLevel)LogLevel.WARN, (Marker)MARKER_, (String)"Reasoning may be incomplete! See log level INFO for more details.");
                }
                return result;
            }
        };
    }

    public IncompletenessMonitor getIncompletenessMonitorForClassification() {
        return this.getReasonerIncompletenessMonitor(new IncompletenessMonitor[0]);
    }

    public IncompletenessMonitor getIncompletenessMonitorForClassExpressionQuery(OccurrenceStore occurrencesInQuery) {
        return this.getReasonerIncompletenessMonitor(this.getIncompletenessDueToOccurrencesInQueryMonitor(occurrencesInQuery, IncompletenessDueToOccurrencesInClassExpressionQueryMessageProvider.INSTANCE));
    }

    public IncompletenessMonitor getIncompletenessMonitorForEntailmentQuery(OccurrenceStore occurrencesInQuery) {
        return this.getReasonerIncompletenessMonitor(this.getIncompletenessDueToOccurrencesInQueryMonitor(occurrencesInQuery, IncompletenessDueToOccurrencesInEntailmentQueryMessageProvider.INSTANCE));
    }

    public void log(IncompletenessMonitor monitor) {
        monitor.logNewIncompletenessReasons(LOGGER_);
    }
}

