/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.consistency;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.liveontologies.puli.Proof;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.reasoner.entailments.impl.IndividualInconsistencyEntailsOntologyInconsistencyImpl;
import org.semanticweb.elk.reasoner.entailments.impl.OntologyInconsistencyImpl;
import org.semanticweb.elk.reasoner.entailments.impl.OwlThingInconsistencyEntailsOntologyInconsistencyImpl;
import org.semanticweb.elk.reasoner.entailments.impl.TopObjectPropertyInBottomEntailsOntologyInconsistencyImpl;
import org.semanticweb.elk.reasoner.entailments.model.EntailmentInference;
import org.semanticweb.elk.reasoner.entailments.model.OntologyInconsistencyEntailmentInference;
import org.semanticweb.elk.reasoner.indexing.classes.OntologyIndexDummyChangeListener;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassEntity;
import org.semanticweb.elk.reasoner.indexing.model.IndexedContextRoot;
import org.semanticweb.elk.reasoner.indexing.model.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.OntologyIndex;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStateDummyChangeListener;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.SaturationConclusionBaseFactory;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SaturationConclusion;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.stages.PropertyHierarchyCompositionState;
import org.semanticweb.elk.util.collections.Operations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistencyCheckingState {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ConsistencyCheckingState.class);
    private final SaturationState<?> saturationState_;
    private final SaturationConclusion.Factory conclusionFactory_ = new SaturationConclusionBaseFactory();
    private final IndexedClass owlThing_;
    private final IndexedObjectProperty bottomProperty_;
    private final IndexedObjectProperty topProperty_;
    private boolean isTriviallyConsistent_ = false;
    private volatile boolean isOwlThingInconsistent_ = false;
    private volatile boolean isTopObjectPropertyInBottom_ = false;
    private final Set<IndexedIndividual> inconsistentIndividuals_ = Collections.synchronizedSet(new HashSet());
    private final Queue<IndexedClassEntity> toDoEntities_;
    private final Operations.Transformation<IndexedIndividual, OntologyInconsistencyEntailmentInference> INDIVIDUAL_TO_ENTAILMENT_INFERENCE = new Operations.Transformation<IndexedIndividual, OntologyInconsistencyEntailmentInference>(){

        public OntologyInconsistencyEntailmentInference transform(IndexedIndividual ind) {
            return new IndividualInconsistencyEntailsOntologyInconsistencyImpl(ConsistencyCheckingState.this.conclusionFactory_.getContradiction(ind), (ElkIndividual)ind.getElkEntity());
        }
    };

    private <C extends Context> ConsistencyCheckingState(SaturationState<C> saturationState, PropertyHierarchyCompositionState propertHierarchyState) {
        this.saturationState_ = saturationState;
        final OntologyIndex index = saturationState.getOntologyIndex();
        this.owlThing_ = index.getOwlThing();
        this.bottomProperty_ = index.getOwlBottomObjectProperty();
        this.topProperty_ = index.getOwlTopObjectProperty();
        this.toDoEntities_ = new ConcurrentLinkedQueue<IndexedIndividual>(index.getIndividuals());
        this.toDoEntities_.add(index.getOwlThing());
        this.isTriviallyConsistent_ = !index.hasPositiveOwlNothing();
        index.addListener(new OntologyIndexDummyChangeListener(){

            @Override
            public void individualAddition(IndexedIndividual ind) {
                ConsistencyCheckingState.this.toDoEntities_.add(ind);
            }

            @Override
            public void individualRemoval(IndexedIndividual ind) {
                ConsistencyCheckingState.this.inconsistentIndividuals_.remove(ind);
            }

            @Override
            public void positiveOwlNothingAppeared() {
                ConsistencyCheckingState.this.isTriviallyConsistent_ = false;
            }

            @Override
            public void positiveOwlNothingDisappeared() {
                ConsistencyCheckingState.this.isTriviallyConsistent_ = true;
            }
        });
        saturationState.addListener(new SaturationStateDummyChangeListener<C>(){

            @Override
            public void contextsClear() {
                ConsistencyCheckingState.this.toDoEntities_.addAll(index.getIndividuals());
                ConsistencyCheckingState.this.toDoEntities_.add(ConsistencyCheckingState.this.owlThing_);
                ConsistencyCheckingState.this.inconsistentIndividuals_.clear();
                ConsistencyCheckingState.this.isOwlThingInconsistent_ = false;
            }

            @Override
            public void contextMarkNonSaturated(C context) {
                IndexedContextRoot root = context.getRoot();
                if (root instanceof IndexedIndividual) {
                    IndexedIndividual ind = (IndexedIndividual)root;
                    ConsistencyCheckingState.this.inconsistentIndividuals_.remove(ind);
                    ConsistencyCheckingState.this.toDoEntities_.add(ind);
                } else if (root == ConsistencyCheckingState.this.owlThing_) {
                    ConsistencyCheckingState.this.isOwlThingInconsistent_ = false;
                    ConsistencyCheckingState.this.toDoEntities_.add(ConsistencyCheckingState.this.owlThing_);
                }
            }

            @Override
            public void contextMarkSaturated(C context) {
                IndexedContextRoot root = context.getRoot();
                if (!context.containsConclusion(ConsistencyCheckingState.this.conclusionFactory_.getContradiction(root))) {
                    return;
                }
                if (root instanceof IndexedIndividual) {
                    ConsistencyCheckingState.this.tellInconsistentIndividual((IndexedIndividual)root);
                } else if (root == ConsistencyCheckingState.this.owlThing_) {
                    ConsistencyCheckingState.this.tellInconsistentOwlThing();
                }
            }
        });
        propertHierarchyState.addListener(new PropertyHierarchyCompositionState.Listener(){

            @Override
            public void propertyBecameSaturated(IndexedPropertyChain chain) {
                if (ConsistencyCheckingState.this.bottomProperty_ == chain && chain.getSaturated().getSubProperties().contains(ConsistencyCheckingState.this.topProperty_)) {
                    ConsistencyCheckingState.this.tellTopObjectPropertyInBottom();
                }
            }

            @Override
            public void propertyBecameNotSaturated(IndexedPropertyChain chain) {
                if (ConsistencyCheckingState.this.bottomProperty_ == chain) {
                    ConsistencyCheckingState.this.isTopObjectPropertyInBottom_ = false;
                }
            }
        });
    }

    public static ConsistencyCheckingState create(SaturationState<?> saturationState, PropertyHierarchyCompositionState propertHierarchyState) {
        return new ConsistencyCheckingState(saturationState, propertHierarchyState);
    }

    private int pruneToDo() {
        int size = 0;
        Iterator itr = this.toDoEntities_.iterator();
        while (itr.hasNext()) {
            IndexedClassEntity next = (IndexedClassEntity)itr.next();
            if (!next.occurs()) {
                itr.remove();
                continue;
            }
            Object context = this.saturationState_.getContext(next);
            if (context != null && context.isSaturated()) {
                itr.remove();
                continue;
            }
            ++size;
        }
        return size;
    }

    public Collection<? extends IndexedClassEntity> getTestEntitites() {
        if (this.isTriviallyConsistent_) {
            return Collections.emptyList();
        }
        int size = this.pruneToDo();
        return Operations.getCollection(this.toDoEntities_, (int)size);
    }

    private void tellInconsistentOwlThing() {
        this.isOwlThingInconsistent_ = true;
        LOGGER_.trace("owl:Thing inconsistent");
    }

    private void tellTopObjectPropertyInBottom() {
        this.isTopObjectPropertyInBottom_ = true;
        LOGGER_.trace("owl:topObjectProperty is a sub-property of owl:bottomObjectProperty");
    }

    private void tellInconsistentIndividual(IndexedIndividual ind) {
        this.inconsistentIndividuals_.add(ind);
        LOGGER_.trace("{} inconsistent", (Object)ind);
    }

    public boolean isInconsistent() {
        return this.isOwlThingInconsistent_ || this.isTopObjectPropertyInBottom_ || !this.inconsistentIndividuals_.isEmpty();
    }

    public boolean isOwlThingInconsistent() {
        return this.isOwlThingInconsistent_;
    }

    public boolean isTopObjectPropertyInBottom() {
        return this.isTopObjectPropertyInBottom_;
    }

    public Collection<? extends IndexedIndividual> getInconsistentIndividuals() {
        return this.inconsistentIndividuals_;
    }

    public Proof<? extends EntailmentInference> getEvidence(final boolean atMostOne) {
        return new Proof<EntailmentInference>(){

            public Collection<OntologyInconsistencyEntailmentInference> getInferences(Object conclusion) {
                if (!OntologyInconsistencyImpl.INSTANCE.equals(conclusion)) {
                    return Collections.emptyList();
                }
                Collection<? extends IndexedIndividual> inconsistentIndividuals = ConsistencyCheckingState.this.getInconsistentIndividuals();
                Iterable result = Operations.map(inconsistentIndividuals, (Operations.Transformation)ConsistencyCheckingState.this.INDIVIDUAL_TO_ENTAILMENT_INFERENCE);
                int size = inconsistentIndividuals.size();
                if (ConsistencyCheckingState.this.isTopObjectPropertyInBottom_) {
                    result = Operations.concat((Iterable[])new Iterable[]{Operations.singleton((Object)new TopObjectPropertyInBottomEntailsOntologyInconsistencyImpl(ConsistencyCheckingState.this.conclusionFactory_.getSubPropertyChain(ConsistencyCheckingState.this.topProperty_, ConsistencyCheckingState.this.bottomProperty_))), result});
                    ++size;
                }
                if (ConsistencyCheckingState.this.isOwlThingInconsistent_) {
                    result = Operations.concat((Iterable[])new Iterable[]{Operations.singleton((Object)new OwlThingInconsistencyEntailsOntologyInconsistencyImpl(ConsistencyCheckingState.this.conclusionFactory_.getContradiction(ConsistencyCheckingState.this.owlThing_))), result});
                    ++size;
                }
                if (atMostOne) {
                    Iterator iter = result.iterator();
                    if (!iter.hasNext()) {
                        return Collections.emptyList();
                    }
                    return Collections.singleton(iter.next());
                }
                return Operations.getCollection((Iterable)result, (int)size);
            }
        };
    }
}

