/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.incremental;

import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.incremental.IncrementalProcessingStatistics;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.SaturationState;
import org.semanticweb.elk.reasoner.saturation.SaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.SaturationStatistics;
import org.semanticweb.elk.reasoner.saturation.SaturationUtils;
import org.semanticweb.elk.reasoner.saturation.conclusions.classes.SaturationConclusionBaseFactory;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ContextInitialization;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.context.ContextPremises;
import org.semanticweb.elk.reasoner.saturation.rules.ClassInferenceProducer;
import org.semanticweb.elk.reasoner.saturation.rules.RuleVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.contextinit.LinkedContextInitRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.IndexedClassDecompositionRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.LinkedSubsumerRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.SubsumerDecompositionRule;
import org.semanticweb.elk.util.concurrent.computation.DelegateInterruptMonitor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessor;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorFactory;
import org.semanticweb.elk.util.concurrent.computation.InputProcessorListenerNotifyFinishedJob;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.semanticweb.elk.util.logging.CachedTimeThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContextInitializationFactory
extends DelegateInterruptMonitor
implements InputProcessorFactory<ArrayList<Context>, InputProcessor<ArrayList<Context>>> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ContextInitializationFactory.class);
    private final Queue<ArrayList<Context>> jobsToDo_ = new ConcurrentLinkedQueue<ArrayList<Context>>();
    private final SaturationState<?> saturationState_;
    private final ContextInitialization.Factory contextInitFactory_;
    private final IndexedClassExpression[] changedComposedSubsumers_;
    private final IndexedClass[] changedDecomposedSubsumers_;
    private final LinkedContextInitRule changedContextInitRuleHead_;
    private final Map<? extends IndexedClassExpression, ? extends LinkedSubsumerRule> changedCompositionRules_;
    private AtomicInteger compositionRuleHits_ = new AtomicInteger(0);
    private AtomicInteger decompositionRuleHits_ = new AtomicInteger(0);
    private final SaturationStatistics stageStatistics_;
    private final SubsumerDecompositionRule<IndexedClass> classDecomposition_;

    public ContextInitializationFactory(InterruptMonitor interrupter, SaturationState<?> state, LinkedContextInitRule changedContextInitRuleHead, Map<? extends IndexedClassExpression, ? extends LinkedSubsumerRule> changedCompositionRules, final Map<? extends IndexedClass, ? extends IndexedClassExpression> changedDefinitions, final Map<? extends IndexedClass, ? extends ElkAxiom> changedDefinitionReasons, SaturationStatistics stageStats) {
        super(interrupter);
        this.saturationState_ = state;
        this.contextInitFactory_ = new SaturationConclusionBaseFactory();
        this.changedCompositionRules_ = changedCompositionRules;
        this.changedComposedSubsumers_ = new IndexedClassExpression[changedCompositionRules.keySet().size()];
        changedCompositionRules.keySet().toArray(this.changedComposedSubsumers_);
        this.changedDecomposedSubsumers_ = new IndexedClass[changedDefinitions.keySet().size()];
        changedDefinitions.keySet().toArray(this.changedDecomposedSubsumers_);
        this.changedContextInitRuleHead_ = changedContextInitRuleHead;
        this.stageStatistics_ = stageStats;
        this.classDecomposition_ = new IndexedClassDecompositionRule(){
            private final Map<? extends IndexedClass, ? extends IndexedClassExpression> changedDefinitions_;
            private final Map<? extends IndexedClass, ? extends ElkAxiom> changedDefinitionReasons_;
            {
                this.changedDefinitions_ = changedDefinitions;
                this.changedDefinitionReasons_ = changedDefinitionReasons;
            }

            @Override
            protected IndexedClassExpression getDefinition(IndexedClass premise) {
                return this.changedDefinitions_.get(premise);
            }

            @Override
            protected ElkAxiom getDefinitionReason(IndexedClass premise) {
                return this.changedDefinitionReasons_.get(premise);
            }
        };
    }

    public InputProcessor<ArrayList<Context>> getEngine() {
        return this.getEngine(this.getBaseContextProcessor());
    }

    private ContextProcessor getBaseContextProcessor() {
        final SaturationStatistics localStatistics = new SaturationStatistics();
        final RuleVisitor<?> ruleAppVisitor = SaturationUtils.getStatsAwareRuleVisitor(localStatistics.getRuleStatistics());
        final SaturationStateWriter<?> saturationStateWriter = this.saturationState_.getContextModifyingWriter();
        localStatistics.getConclusionStatistics().startMeasurements();
        return new ContextProcessor(){
            private int localCompsitionRuleHits_ = 0;
            private int localDecompositionRuleHits_ = 0;

            @Override
            public void process(Context context) {
                Set<IndexedClassExpression> decomposedSubsumers;
                ContextInitialization contextInit = ContextInitializationFactory.this.contextInitFactory_.getContextInitialization(context.getRoot());
                for (LinkedContextInitRule nextContextInitRule = ContextInitializationFactory.this.changedContextInitRuleHead_; nextContextInitRule != null; nextContextInitRule = (LinkedContextInitRule)nextContextInitRule.next()) {
                    LOGGER_.trace("{}: applying rule {}", (Object)context, (Object)nextContextInitRule);
                    nextContextInitRule.accept(ruleAppVisitor, contextInit, (ContextPremises)context, (ClassInferenceProducer)saturationStateWriter);
                }
                Set<IndexedClassExpression> composedSubsumers = context.getComposedSubsumers();
                if (composedSubsumers.size() > ContextInitializationFactory.this.changedComposedSubsumers_.length >> 2) {
                    for (int j = 0; j < ContextInitializationFactory.this.changedComposedSubsumers_.length; ++j) {
                        IndexedClassExpression changedICE = ContextInitializationFactory.this.changedComposedSubsumers_[j];
                        if (!composedSubsumers.contains(changedICE)) continue;
                        this.applyCompositionRules(context, changedICE);
                    }
                } else {
                    for (IndexedClassExpression changedICE : composedSubsumers) {
                        this.applyCompositionRules(context, changedICE);
                    }
                }
                if ((decomposedSubsumers = context.getDecomposedSubsumers()).size() > ContextInitializationFactory.this.changedDecomposedSubsumers_.length >> 2) {
                    for (int j = 0; j < ContextInitializationFactory.this.changedDecomposedSubsumers_.length; ++j) {
                        IndexedClass changedIC = ContextInitializationFactory.this.changedDecomposedSubsumers_[j];
                        if (!decomposedSubsumers.contains(changedIC)) continue;
                        this.applyDecompositionRules(context, changedIC);
                    }
                } else {
                    for (IndexedClassExpression changedICE : decomposedSubsumers) {
                        if (!(changedICE instanceof IndexedClass)) continue;
                        this.applyDecompositionRules(context, (IndexedClass)changedICE);
                    }
                }
            }

            @Override
            public void finish() {
                ContextInitializationFactory.this.stageStatistics_.add(localStatistics);
                ContextInitializationFactory.this.compositionRuleHits_.addAndGet(this.localCompsitionRuleHits_);
                ContextInitializationFactory.this.decompositionRuleHits_.addAndGet(this.localDecompositionRuleHits_);
            }

            private void applyCompositionRules(Context context, IndexedClassExpression changedICE) {
                LinkedSubsumerRule nextLocalRule = (LinkedSubsumerRule)ContextInitializationFactory.this.changedCompositionRules_.get(changedICE);
                if (nextLocalRule != null) {
                    ++this.localCompsitionRuleHits_;
                    LOGGER_.trace("{}: applying composition rules for {}", (Object)context, (Object)changedICE);
                }
                while (nextLocalRule != null) {
                    nextLocalRule.accept(ruleAppVisitor, changedICE, (ContextPremises)context, (ClassInferenceProducer)saturationStateWriter);
                    nextLocalRule = (LinkedSubsumerRule)nextLocalRule.next();
                }
            }

            private void applyDecompositionRules(Context context, IndexedClass changedICE) {
                ++this.localDecompositionRuleHits_;
                LOGGER_.trace("{}: applying decomposition rules for {}", (Object)context, (Object)changedICE);
                ContextInitializationFactory.this.classDecomposition_.accept(ruleAppVisitor, changedICE, (ContextPremises)context, (ClassInferenceProducer)saturationStateWriter);
            }
        };
    }

    private InputProcessor<ArrayList<Context>> getEngine(ContextProcessor baseProcessor) {
        if (SaturationUtils.COLLECT_PROCESSING_TIMES) {
            return new TimedContextCollectionProcessor(baseProcessor, this.stageStatistics_.getIncrementalProcessingStatistics(), (InterruptMonitor)this);
        }
        return new ContextCollectionProcessor(baseProcessor);
    }

    public void finish() {
        if (LOGGER_.isDebugEnabled()) {
            LOGGER_.debug("Composition rule hits: " + this.compositionRuleHits_.get());
            LOGGER_.debug("Decomposition rule hits: " + this.decompositionRuleHits_.get());
        }
    }

    static interface ContextProcessor {
        public void process(Context var1);

        public void finish();
    }

    private class TimedContextCollectionProcessor
    extends BaseInputProcessor {
        private final ContextProcessor contextProcessor_;
        private final IncrementalProcessingStatistics stageStats_;
        private final IncrementalProcessingStatistics localStats_;
        private final InterruptMonitor interrupter_;
        private int procNumber_;

        public TimedContextCollectionProcessor(ContextProcessor baseProcessor, IncrementalProcessingStatistics stageStats, InterruptMonitor interrupter) {
            this.localStats_ = new IncrementalProcessingStatistics();
            this.procNumber_ = 0;
            this.contextProcessor_ = new TimedContextProcessor(baseProcessor, this.localStats_);
            this.stageStats_ = stageStats;
            this.interrupter_ = interrupter;
            this.localStats_.startMeasurements();
        }

        @Override
        protected void process(ArrayList<Context> contexts) {
            long ts = CachedTimeThread.getCurrentTimeMillis();
            int contextCount = 0;
            int subsumerCount = 0;
            ++this.procNumber_;
            for (Context context : contexts) {
                this.contextProcessor_.process(context);
                ++contextCount;
                subsumerCount += context.getComposedSubsumers().size();
            }
            this.localStats_.changeInitContextCollectionProcessingTime += CachedTimeThread.getCurrentTimeMillis() - ts;
            this.localStats_.countContexts += (long)contextCount;
            if (contextCount > 0) {
                this.localStats_.countContextSubsumers += (long)(subsumerCount / contextCount);
            }
        }

        @Override
        public void finish() {
            super.finish();
            this.contextProcessor_.finish();
            if (this.procNumber_ > 0) {
                this.localStats_.countContextSubsumers /= (long)this.procNumber_;
            }
            this.stageStats_.add(this.localStats_);
        }

        @Override
        protected boolean isInterrupted() {
            return this.interrupter_.isInterrupted();
        }
    }

    private class ContextCollectionProcessor
    extends BaseInputProcessor {
        private final ContextProcessor contextProcessor_;

        ContextCollectionProcessor(ContextProcessor contextProcessor) {
            this.contextProcessor_ = contextProcessor;
        }

        @Override
        protected void process(ArrayList<Context> contexts) {
            for (Context context : contexts) {
                this.contextProcessor_.process(context);
            }
        }

        @Override
        public void finish() {
            super.finish();
            this.contextProcessor_.finish();
        }

        @Override
        protected boolean isInterrupted() {
            return ContextInitializationFactory.this.isInterrupted();
        }
    }

    static class TimedContextProcessor
    implements ContextProcessor {
        private final IncrementalProcessingStatistics localStats_;
        private final ContextProcessor processor_;

        TimedContextProcessor(ContextProcessor p, IncrementalProcessingStatistics localStats) {
            this.processor_ = p;
            this.localStats_ = localStats;
            this.localStats_.startMeasurements();
        }

        @Override
        public void process(Context context) {
            long ts = CachedTimeThread.getCurrentTimeMillis();
            this.processor_.process(context);
            this.localStats_.changeInitContextProcessingTime += CachedTimeThread.getCurrentTimeMillis() - ts;
        }

        @Override
        public void finish() {
            this.processor_.finish();
        }
    }

    private abstract class BaseInputProcessor
    implements InputProcessor<ArrayList<Context>> {
        private final InputProcessorListenerNotifyFinishedJob<ArrayList<Context>> listener_;

        public BaseInputProcessor() {
            this(null);
        }

        public BaseInputProcessor(InputProcessorListenerNotifyFinishedJob<ArrayList<Context>> listener) {
            this.listener_ = listener;
        }

        public void submit(ArrayList<Context> job) {
            ContextInitializationFactory.this.jobsToDo_.add(job);
        }

        public void process() throws InterruptedException {
            ArrayList nextJob;
            while (!this.isInterrupted() && (nextJob = (ArrayList)ContextInitializationFactory.this.jobsToDo_.poll()) != null) {
                this.process(nextJob);
                if (this.listener_ == null) continue;
                this.listener_.notifyFinished((Object)nextJob);
            }
        }

        public void finish() {
        }

        protected abstract boolean isInterrupted();

        protected abstract void process(ArrayList<Context> var1);
    }
}

