/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import org.semanticweb.elk.reasoner.indexing.classes.CachedIndexedClassExpressionImpl;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedClassEntity;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CachedIndexedClassEntityImpl<T extends CachedIndexedClassEntity<T>>
extends CachedIndexedClassExpressionImpl<T, T>
implements CachedIndexedClassEntity<T> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(CachedIndexedClassEntityImpl.class);
    protected int totalOccurrenceNo = 0;

    CachedIndexedClassEntityImpl(int structuralHash) {
        super(structuralHash);
    }

    @Override
    public boolean updateOccurrenceNumbers(ModifiableOntologyIndex index, OccurrenceIncrement increment) {
        this.totalOccurrenceNo += increment.totalIncrement;
        return true;
    }

    @Override
    public final boolean occurs() {
        return this.totalOccurrenceNo > 0;
    }

    @Override
    public String printOccurrenceNumbers() {
        return "[all=" + this.totalOccurrenceNo + "]";
    }

    public void checkOccurrenceNumbers() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace(this.toString() + " occurences: " + this.printOccurrenceNumbers());
        }
        if (this.totalOccurrenceNo < 0) {
            throw new ElkUnexpectedIndexingException(this.toString() + " has a negative occurrence: " + this.printOccurrenceNumbers());
        }
    }
}

