/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import org.semanticweb.elk.reasoner.indexing.classes.CachedIndexedClassExpressionImpl;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedComplexClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CachedIndexedComplexClassExpressionImpl<T extends CachedIndexedComplexClassExpression<T>>
extends CachedIndexedClassExpressionImpl<T, CachedIndexedComplexClassExpression<?>>
implements CachedIndexedComplexClassExpression<T> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(CachedIndexedComplexClassExpressionImpl.class);
    int positiveOccurrenceNo = 0;
    int negativeOccurrenceNo = 0;

    CachedIndexedComplexClassExpressionImpl(int structuralHash) {
        super(structuralHash);
    }

    @Override
    public final boolean occurs() {
        return this.positiveOccurrenceNo > 0 || this.negativeOccurrenceNo > 0;
    }

    @Override
    public final String printOccurrenceNumbers() {
        return "[pos=" + this.positiveOccurrenceNo + "; neg=" + this.negativeOccurrenceNo + "]";
    }

    public final void checkOccurrenceNumbers() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace(this.toString() + " occurences: " + this.printOccurrenceNumbers());
        }
        if (this.positiveOccurrenceNo < 0 || this.negativeOccurrenceNo < 0) {
            throw new ElkUnexpectedIndexingException(this.toString() + " has a negative occurrence: " + this.printOccurrenceNumbers());
        }
    }

    final boolean updateAndCheckOccurrenceNumbers(ModifiableOntologyIndex index, OccurrenceIncrement increment) {
        if (!this.updateOccurrenceNumbers(index, increment)) {
            LOGGER_.trace("{}: cannot index!", (Object)this);
            return false;
        }
        this.checkOccurrenceNumbers();
        return true;
    }
}

