/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import org.semanticweb.elk.reasoner.indexing.classes.CachedIndexedComplexClassExpressionImpl;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedObjectComplementOf;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.Occurrence;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.ContradictionFromNegationRule;

class CachedIndexedObjectComplementOfImpl
extends CachedIndexedComplexClassExpressionImpl<CachedIndexedObjectComplementOf>
implements CachedIndexedObjectComplementOf {
    private final ModifiableIndexedClassExpression negated_;

    CachedIndexedObjectComplementOfImpl(ModifiableIndexedClassExpression negated) {
        super(CachedIndexedObjectComplementOf.Helper.structuralHashCode(negated));
        this.negated_ = negated;
    }

    @Override
    public final ModifiableIndexedClassExpression getNegated() {
        return this.negated_;
    }

    public final CachedIndexedObjectComplementOf structuralEquals(Object other) {
        return CachedIndexedObjectComplementOf.Helper.structuralEquals(this, other);
    }

    @Override
    public final boolean updateOccurrenceNumbers(ModifiableOntologyIndex index, OccurrenceIncrement increment) {
        if (this.positiveOccurrenceNo == 0 && increment.positiveIncrement > 0 && !ContradictionFromNegationRule.addRulesFor(this, index)) {
            return false;
        }
        this.positiveOccurrenceNo += increment.positiveIncrement;
        this.negativeOccurrenceNo += increment.negativeIncrement;
        this.checkOccurrenceNumbers();
        if (this.positiveOccurrenceNo == 0 && increment.positiveIncrement < 0 && !ContradictionFromNegationRule.removeRulesFor(this, index)) {
            this.positiveOccurrenceNo -= increment.positiveIncrement;
            this.negativeOccurrenceNo -= increment.negativeIncrement;
            return false;
        }
        for (int i = 0; i < Math.abs(increment.negativeIncrement); ++i) {
            index.onIndexing(Occurrence.NEGATIVE_OCCURRENCE_OF_OBJECT_COMPLEMENT_OF);
        }
        return true;
    }

    @Override
    public final <O> O accept(IndexedClassExpression.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CachedIndexedObjectComplementOf accept(CachedIndexedClassExpression.Filter filter) {
        return filter.filter(this);
    }
}

