/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.reasoner.indexing.classes.CachedIndexedComplexClassExpressionImpl;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedObjectUnionOf;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.Occurrence;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.ObjectUnionFromDisjunctRule;

class CachedIndexedObjectUnionOfImpl
extends CachedIndexedComplexClassExpressionImpl<CachedIndexedObjectUnionOf>
implements CachedIndexedObjectUnionOf {
    private final List<ModifiableIndexedClassExpression> disjuncts_;

    CachedIndexedObjectUnionOfImpl(List<? extends ModifiableIndexedClassExpression> disjuncts) {
        this(new Initializer(disjuncts));
    }

    private CachedIndexedObjectUnionOfImpl(Initializer init) {
        super(CachedIndexedObjectUnionOf.Helper.structuralHashCode(init.disjuncts_));
        this.disjuncts_ = init.disjuncts_;
    }

    public final List<ModifiableIndexedClassExpression> getDisjuncts() {
        return this.disjuncts_;
    }

    public final CachedIndexedObjectUnionOf structuralEquals(Object other) {
        return CachedIndexedObjectUnionOf.Helper.structuralEquals(this, other);
    }

    @Override
    public final boolean updateOccurrenceNumbers(ModifiableOntologyIndex index, OccurrenceIncrement increment) {
        if (this.negativeOccurrenceNo == 0 && increment.negativeIncrement > 0 && !ObjectUnionFromDisjunctRule.addRulesFor(this, index)) {
            return false;
        }
        this.positiveOccurrenceNo += increment.positiveIncrement;
        this.negativeOccurrenceNo += increment.negativeIncrement;
        this.checkOccurrenceNumbers();
        if (this.negativeOccurrenceNo == 0 && increment.negativeIncrement < 0 && !ObjectUnionFromDisjunctRule.removeRulesFor(this, index)) {
            this.positiveOccurrenceNo -= increment.positiveIncrement;
            this.negativeOccurrenceNo -= increment.negativeIncrement;
            return false;
        }
        for (int i = 0; i < Math.abs(increment.positiveIncrement); ++i) {
            index.onIndexing(Occurrence.POSITIVE_OCCURRENCE_OF_OBJECT_UNION_OF);
        }
        return true;
    }

    @Override
    public final <O> O accept(IndexedClassExpression.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public CachedIndexedObjectUnionOf accept(CachedIndexedClassExpression.Filter filter) {
        return filter.filter(this);
    }

    private static class Initializer {
        private final List<ModifiableIndexedClassExpression> disjuncts_ = new ArrayList<ModifiableIndexedClassExpression>(2);

        Initializer(List<? extends ModifiableIndexedClassExpression> disjuncts) {
            for (ModifiableIndexedClassExpression modifiableIndexedClassExpression : disjuncts) {
                this.disjuncts_.add(modifiableIndexedClassExpression);
            }
        }
    }
}

