/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.reasoner.indexing.classes.CachedIndexedClassImpl;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedOwlNothing;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.ContradictionFromOwlNothingRule;

final class CachedIndexedOwlNothingImpl
extends CachedIndexedClassImpl
implements CachedIndexedOwlNothing {
    private int positiveOccurrenceNo = 0;
    private final List<CachedIndexedOwlNothing.ChangeListener> listeners_ = new ArrayList<CachedIndexedOwlNothing.ChangeListener>();

    CachedIndexedOwlNothingImpl(ElkClass entity) {
        super(entity);
    }

    @Override
    public boolean occursPositively() {
        return this.positiveOccurrenceNo > 0;
    }

    boolean updateTotalOccurrenceNo(ModifiableOntologyIndex index, int totalIncrement) {
        if (this.totalOccurrenceNo == 0 && totalIncrement > 0 && !ContradictionFromOwlNothingRule.addRuleFor(this, index)) {
            return false;
        }
        this.totalOccurrenceNo += totalIncrement;
        return this.totalOccurrenceNo != 0 || totalIncrement >= 0 || ContradictionFromOwlNothingRule.removeRuleFor(this, index);
    }

    boolean updatePositiveOccurrenceNo(int positiveIncrement) {
        block4: {
            block3: {
                this.positiveOccurrenceNo += positiveIncrement;
                if (this.positiveOccurrenceNo <= 0) break block3;
                if (this.positiveOccurrenceNo > positiveIncrement) break block4;
                for (int i = 0; i < this.listeners_.size(); ++i) {
                    this.listeners_.get(i).positiveOccurrenceAppeared();
                }
                break block4;
            }
            if (this.positiveOccurrenceNo > positiveIncrement) {
                for (int i = 0; i < this.listeners_.size(); ++i) {
                    this.listeners_.get(i).positiveOccurrenceDisappeared();
                }
            }
        }
        return true;
    }

    @Override
    public final boolean updateOccurrenceNumbers(ModifiableOntologyIndex index, OccurrenceIncrement increment) {
        if (!this.updateTotalOccurrenceNo(index, increment.totalIncrement)) {
            return false;
        }
        if (!this.updatePositiveOccurrenceNo(increment.positiveIncrement)) {
            this.updateTotalOccurrenceNo(index, -increment.positiveIncrement);
            return false;
        }
        return true;
    }

    @Override
    public boolean addListener(CachedIndexedOwlNothing.ChangeListener listener) {
        return this.listeners_.add(listener);
    }

    @Override
    public boolean removeListener(CachedIndexedOwlNothing.ChangeListener listener) {
        return this.listeners_.remove(listener);
    }
}

