/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.reasoner.indexing.classes.CachedIndexedClassImpl;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedOwlThing;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;
import org.semanticweb.elk.reasoner.saturation.rules.contextinit.OwlThingContextInitRule;

final class CachedIndexedOwlThingImpl
extends CachedIndexedClassImpl
implements CachedIndexedOwlThing {
    private int negativeOccurrenceNo = 0;
    private final List<CachedIndexedOwlThing.ChangeListener> listeners_ = new ArrayList<CachedIndexedOwlThing.ChangeListener>();

    CachedIndexedOwlThingImpl(ElkClass entity) {
        super(entity);
    }

    @Override
    public boolean occursNegatively() {
        return this.negativeOccurrenceNo > 0;
    }

    boolean updateNegativeOccurrenceNo(ModifiableOntologyIndex index, int negativeIncrement) {
        block6: {
            block5: {
                this.negativeOccurrenceNo += negativeIncrement;
                if (this.negativeOccurrenceNo <= 0) break block5;
                if (this.negativeOccurrenceNo > negativeIncrement) break block6;
                if (!OwlThingContextInitRule.addRuleFor(this, index)) {
                    this.negativeOccurrenceNo -= negativeIncrement;
                    return false;
                }
                for (int i = 0; i < this.listeners_.size(); ++i) {
                    this.listeners_.get(i).negativeOccurrenceAppeared();
                }
                break block6;
            }
            if (this.negativeOccurrenceNo > negativeIncrement) {
                if (!OwlThingContextInitRule.removeRuleFor(this, index)) {
                    this.negativeOccurrenceNo -= negativeIncrement;
                    return false;
                }
                for (int i = 0; i < this.listeners_.size(); ++i) {
                    this.listeners_.get(i).negativeOccurrenceDisappeared();
                }
            }
        }
        return true;
    }

    @Override
    public final boolean updateOccurrenceNumbers(ModifiableOntologyIndex index, OccurrenceIncrement increment) {
        if (!this.updateNegativeOccurrenceNo(index, increment.negativeIncrement)) {
            return false;
        }
        if (!super.updateOccurrenceNumbers(index, increment)) {
            this.updateNegativeOccurrenceNo(index, -increment.negativeIncrement);
            return false;
        }
        return true;
    }

    @Override
    public boolean addListener(CachedIndexedOwlThing.ChangeListener listener) {
        return this.listeners_.add(listener);
    }

    @Override
    public boolean removeListener(CachedIndexedOwlThing.ChangeListener listener) {
        return this.listeners_.remove(listener);
    }
}

