/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.reasoner.indexing.classes.CachedIndexedObjectImpl;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedObject;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedComplexPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObject;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;
import org.semanticweb.elk.reasoner.saturation.properties.SaturatedPropertyChain;
import org.semanticweb.elk.util.collections.entryset.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CachedIndexedPropertyChainImpl<T extends CachedIndexedPropertyChain<T> & Entry<T, N>, N>
extends CachedIndexedObjectImpl<T, N>
implements CachedIndexedPropertyChain<T>,
Entry<T, N> {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(CachedIndexedPropertyChainImpl.class);
    private static ArrayList<?> EMPTY_ARRAY_LIST_ = new ArrayList(0);
    int totalOccurrenceNo = 0;
    private final SaturatedPropertyChain saturated_ = new SaturatedPropertyChain(this);
    private ArrayList<IndexedObjectProperty> toldSuperProperties_;
    private ArrayList<ElkAxiom> toldSuperPropertiesReasons_;
    private Collection<IndexedComplexPropertyChain> rightChains_;

    protected static <T> ArrayList<T> emptyArrayList() {
        return EMPTY_ARRAY_LIST_;
    }

    CachedIndexedPropertyChainImpl(int structuralHash) {
        super(structuralHash);
    }

    @Override
    public final boolean occurs() {
        return this.totalOccurrenceNo > 0;
    }

    public final ArrayList<IndexedObjectProperty> getToldSuperProperties() {
        if (this.toldSuperProperties_ == null) {
            ArrayList<IndexedObjectProperty> result = CachedIndexedPropertyChainImpl.emptyArrayList();
            return result;
        }
        return this.toldSuperProperties_;
    }

    public ArrayList<ElkAxiom> getToldSuperPropertiesReasons() {
        if (this.toldSuperPropertiesReasons_ == null) {
            ArrayList<ElkAxiom> result = CachedIndexedPropertyChainImpl.emptyArrayList();
            return result;
        }
        return this.toldSuperPropertiesReasons_;
    }

    @Override
    public final Collection<IndexedComplexPropertyChain> getRightChains() {
        return this.rightChains_ == null ? Collections.emptySet() : Collections.unmodifiableCollection(this.rightChains_);
    }

    @Override
    public final SaturatedPropertyChain getSaturated() {
        return this.saturated_;
    }

    @Override
    public final int compareTo(ModifiableIndexedPropertyChain o) {
        int otherHash;
        if (this == o) {
            return 0;
        }
        int thisHash = this.hashCode();
        if (thisHash == (otherHash = o.hashCode())) {
            return this.toString().compareTo(o.toString());
        }
        return thisHash < otherHash ? -1 : 1;
    }

    @Override
    public final boolean addToldSuperObjectProperty(IndexedObjectProperty superObjectProperty, ElkAxiom reason) {
        if (this.toldSuperProperties_ == null) {
            this.toldSuperProperties_ = new ArrayList(1);
        }
        if (this.toldSuperPropertiesReasons_ == null) {
            this.toldSuperPropertiesReasons_ = new ArrayList(1);
        }
        this.toldSuperProperties_.add(superObjectProperty);
        this.toldSuperPropertiesReasons_.add(reason);
        return true;
    }

    @Override
    public final boolean removeToldSuperObjectProperty(IndexedObjectProperty superObjectProperty, ElkAxiom reason) {
        int i = this.indexOf(superObjectProperty, reason);
        if (i < 0) {
            return false;
        }
        this.toldSuperProperties_.remove(i);
        this.toldSuperPropertiesReasons_.remove(i);
        if (this.toldSuperProperties_.isEmpty()) {
            this.toldSuperProperties_ = null;
        }
        if (this.toldSuperPropertiesReasons_.isEmpty()) {
            this.toldSuperPropertiesReasons_ = null;
        }
        return true;
    }

    private int indexOf(IndexedPropertyChain superObjectProperty, ElkAxiom reason) {
        for (int i = 0; i < this.toldSuperProperties_.size(); ++i) {
            if (!this.toldSuperProperties_.get(i).equals(superObjectProperty) || !this.toldSuperPropertiesReasons_.get(i).equals(reason)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean addRightChain(IndexedComplexPropertyChain chain) {
        if (this.rightChains_ == null) {
            this.rightChains_ = new ArrayList<IndexedComplexPropertyChain>(1);
        }
        return this.rightChains_.add(chain);
    }

    @Override
    public final boolean removeRightChain(IndexedComplexPropertyChain chain) {
        boolean success = false;
        if (this.rightChains_ != null) {
            success = this.rightChains_.remove(chain);
            if (this.rightChains_.isEmpty()) {
                this.rightChains_ = null;
            }
        }
        return success;
    }

    public final String printOccurrenceNumbers() {
        return "[all=" + this.totalOccurrenceNo + "]";
    }

    public final void checkOccurrenceNumbers() {
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace(this + " occurences: " + this.printOccurrenceNumbers());
        }
        if (this.totalOccurrenceNo < 0) {
            throw new ElkUnexpectedIndexingException(this + " has a negative occurrence: " + this.printOccurrenceNumbers());
        }
    }

    public final boolean updateAndCheckOccurrenceNumbers(ModifiableOntologyIndex index, OccurrenceIncrement increment) {
        if (!this.updateOccurrenceNumbers(index, increment)) {
            return false;
        }
        this.checkOccurrenceNumbers();
        return true;
    }

    @Override
    public final <O> O accept(IndexedObject.Visitor<O> visitor) {
        return (O)this.accept(visitor);
    }

    @Override
    public T accept(CachedIndexedObject.Filter filter) {
        return (T)this.accept(filter);
    }
}

