/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.owl.visitors.ElkAxiomVisitor;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkAxiomConverter;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkIndexingUnsupportedException;
import org.semanticweb.elk.reasoner.indexing.model.IndexingListener;
import org.semanticweb.elk.reasoner.indexing.model.Occurrence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeIndexingProcessor
implements ElkAxiomProcessor {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ChangeIndexingProcessor.class);
    public static final String ADDITION = "addition";
    public static final String REMOVAL = "removal";
    private final ElkAxiomConverter indexer_;
    private final String type_;
    private final IndexingListener indexingListener_;

    public ChangeIndexingProcessor(ElkAxiomConverter indexer, String type, IndexingListener indexingListener) {
        this.indexer_ = indexer;
        this.type_ = type;
        this.indexingListener_ = indexingListener;
    }

    public void visit(ElkAxiom elkAxiom) {
        try {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("$$ indexing " + OwlFunctionalStylePrinter.toString((ElkObject)elkAxiom) + " for " + this.type_);
            }
            elkAxiom.accept((ElkAxiomVisitor)this.indexer_);
        }
        catch (ElkIndexingUnsupportedException e) {
            this.indexingListener_.onIndexing(Occurrence.OCCURRENCE_OF_UNSUPPORTED_EXPRESSION);
        }
    }
}

