/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionProcessor;
import org.semanticweb.elk.owl.visitors.ElkClassExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkIndexingUnsupportedException;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkPolarityExpressionConverter;
import org.semanticweb.elk.reasoner.indexing.model.IndexingListener;
import org.semanticweb.elk.reasoner.indexing.model.Occurrence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassQueryIndexingProcessor
implements ElkClassExpressionProcessor {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ClassQueryIndexingProcessor.class);
    public static final String ADDITION = "addition";
    public static final String REMOVAL = "removal";
    private final ElkPolarityExpressionConverter indexer_;
    private final String type_;
    private final IndexingListener indexingListener_;

    public ClassQueryIndexingProcessor(ElkPolarityExpressionConverter indexer, String type, IndexingListener indexingListener) {
        this.indexer_ = indexer;
        this.type_ = type;
        this.indexingListener_ = indexingListener;
    }

    public void visit(ElkClassExpression elkClassExpression) {
        try {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("$$ indexing {} for {}", (Object)OwlFunctionalStylePrinter.toString((ElkObject)elkClassExpression), (Object)this.type_);
            }
            elkClassExpression.accept((ElkClassExpressionVisitor)this.indexer_);
        }
        catch (ElkIndexingUnsupportedException e) {
            this.indexingListener_.onIndexing(Occurrence.OCCURRENCE_OF_UNSUPPORTED_EXPRESSION);
        }
    }
}

