/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.predefined.PredefinedElkEntityFactory;
import org.semanticweb.elk.reasoner.indexing.classes.DirectIndex;
import org.semanticweb.elk.reasoner.indexing.conversion.ElkUnexpectedIndexingException;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedObject;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.IndexedEntity;
import org.semanticweb.elk.reasoner.indexing.model.IndexedIndividual;
import org.semanticweb.elk.reasoner.indexing.model.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClassExpression;
import org.semanticweb.elk.reasoner.saturation.rules.contextinit.ChainableContextInitRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.ChainableSubsumerRule;
import org.semanticweb.elk.util.collections.ArrayHashMap;
import org.semanticweb.elk.util.collections.ArrayHashSet;
import org.semanticweb.elk.util.collections.Operations;
import org.semanticweb.elk.util.collections.chains.AbstractChain;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DifferentialIndex
extends DirectIndex {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(DifferentialIndex.class);
    boolean incrementalMode = false;
    private Set<ElkClass> addedClasses_;
    private Set<ElkClass> removedClasses_;
    private Set<ElkNamedIndividual> addedIndividuals_;
    private Set<ElkNamedIndividual> removedIndividuals_;
    private Set<ElkObjectProperty> addedObjectProperties_;
    private Set<ElkObjectProperty> removedObjectProperties_;
    private final IndexedEntity.Visitor<Void> entityInsertionListener_ = new EntityInsertionListener();
    private final IndexedEntity.Visitor<Void> entityDeletionListener_ = new EntityDeletionListener();
    private Set<CachedIndexedObject<?>> todoDeletions_;
    private ChainableContextInitRule addedContextInitRules_;
    private ChainableContextInitRule removedContextInitRules_;
    private Map<ModifiableIndexedClassExpression, ChainableSubsumerRule> addedContextRuleHeadByClassExpressions_;
    private Map<ModifiableIndexedClassExpression, ChainableSubsumerRule> removedContextRuleHeadByClassExpressions_;
    private Map<ModifiableIndexedClass, ModifiableIndexedClassExpression> addedDefinitions_;
    private Map<ModifiableIndexedClass, ModifiableIndexedClassExpression> removedDefinitions_;
    private Map<ModifiableIndexedClass, ElkAxiom> addedDefinitionReasons_;
    private Map<ModifiableIndexedClass, ElkAxiom> removedDefinitionReasons_;

    public DifferentialIndex(PredefinedElkEntityFactory elkFactory) {
        super(elkFactory);
        this.init();
    }

    void init() {
        this.initClassChanges();
        this.initIndividualChanges();
        this.initObjectPropertyChanges();
        this.initAdditions();
        this.initDeletions();
    }

    public void initClassChanges() {
        this.addedClasses_ = new ArrayHashSet(32);
        this.removedClasses_ = new ArrayHashSet(32);
    }

    public void initIndividualChanges() {
        this.addedIndividuals_ = new ArrayHashSet(32);
        this.removedIndividuals_ = new ArrayHashSet(32);
    }

    public void initObjectPropertyChanges() {
        this.addedObjectProperties_ = new ArrayHashSet(32);
        this.removedObjectProperties_ = new ArrayHashSet(32);
    }

    public void initAdditions() {
        this.addedContextInitRules_ = null;
        this.addedContextRuleHeadByClassExpressions_ = new ArrayHashMap(32);
        this.addedDefinitions_ = new ArrayHashMap(32);
        this.addedDefinitionReasons_ = new ArrayHashMap(32);
    }

    public void initDeletions() {
        this.removedContextInitRules_ = null;
        this.todoDeletions_ = new ArrayHashSet(1024);
        this.removedContextRuleHeadByClassExpressions_ = new ArrayHashMap(32);
        this.removedDefinitions_ = new ArrayHashMap(32);
        this.removedDefinitionReasons_ = new ArrayHashMap(32);
    }

    @Override
    public void add(CachedIndexedObject<?> input) {
        if (!this.incrementalMode) {
            super.add((CachedIndexedObject)input);
            return;
        }
        LOGGER_.trace("{}: to add", input);
        if (input instanceof IndexedEntity) {
            ((IndexedEntity)((Object)input)).accept(this.entityInsertionListener_);
        }
        if (this.todoDeletions_.remove(input)) {
            return;
        }
        super.add((CachedIndexedObject)input);
    }

    @Override
    public void remove(CachedIndexedObject<?> input) {
        if (!this.incrementalMode) {
            super.remove((CachedIndexedObject)input);
            return;
        }
        LOGGER_.trace("{}: to remove", input);
        if (input instanceof IndexedEntity) {
            ((IndexedEntity)((Object)input)).accept(this.entityDeletionListener_);
        }
        this.todoDeletions_.add(input);
    }

    @Override
    public boolean add(ModifiableIndexedClassExpression target, ChainableSubsumerRule newRule) {
        if (!this.incrementalMode) {
            return super.add(target, newRule);
        }
        if (newRule.removeFrom(this.getRemovedContextRuleChain(target))) {
            if (newRule.addTo(target.getCompositionRuleChain())) {
                return true;
            }
            newRule.addTo(this.getRemovedContextRuleChain(target));
        }
        return newRule.addTo(this.getAddedContextRuleChain(target));
    }

    @Override
    public boolean remove(ModifiableIndexedClassExpression target, ChainableSubsumerRule oldRule) {
        if (!this.incrementalMode) {
            return super.remove(target, oldRule);
        }
        if (oldRule.removeFrom(this.getAddedContextRuleChain(target))) {
            return true;
        }
        if (oldRule.addTo(this.getRemovedContextRuleChain(target))) {
            if (oldRule.removeFrom(target.getCompositionRuleChain())) {
                return true;
            }
            oldRule.removeFrom(this.getRemovedContextRuleChain(target));
        }
        return false;
    }

    @Override
    public boolean tryAddDefinition(ModifiableIndexedClass target, ModifiableIndexedClassExpression definition, ElkAxiom reason) {
        if (!this.incrementalMode) {
            return super.tryAddDefinition(target, definition, reason);
        }
        IndexedClassExpression removedDefintion = this.removedDefinitions_.get(target);
        ElkAxiom removedDefinitionReason = this.removedDefinitionReasons_.get(target);
        if (target.getDefinition() != removedDefintion || this.addedDefinitions_.get(target) != null) {
            return false;
        }
        if (removedDefintion == definition && removedDefinitionReason.equals(reason)) {
            this.removedDefinitions_.remove(target);
            this.removedDefinitionReasons_.remove(target);
            target.setDefinition(definition, reason);
        } else {
            this.addedDefinitions_.put(target, definition);
            this.addedDefinitionReasons_.put(target, reason);
        }
        return true;
    }

    @Override
    public boolean tryRemoveDefinition(ModifiableIndexedClass target, ModifiableIndexedClassExpression definition, ElkAxiom reason) {
        if (!this.incrementalMode) {
            return super.tryRemoveDefinition(target, definition, reason);
        }
        IndexedClassExpression addedDefinition = this.addedDefinitions_.get(target);
        ElkAxiom addedDefinitionReason = this.addedDefinitionReasons_.get(target);
        if (addedDefinition == definition && addedDefinitionReason.equals(reason)) {
            this.addedDefinitions_.remove(target);
            this.addedDefinitionReasons_.remove(target);
            return true;
        }
        if (addedDefinition != null || target.getDefinition() != definition || !target.getDefinitionReason().equals(reason)) {
            return false;
        }
        target.removeDefinition();
        this.removedDefinitions_.put(target, definition);
        this.removedDefinitionReasons_.put(target, reason);
        return true;
    }

    @Override
    public boolean addContextInitRule(ChainableContextInitRule newRule) {
        if (!this.incrementalMode) {
            return super.addContextInitRule(newRule);
        }
        if (newRule.removeFrom(this.getRemovedContextInitRuleChain())) {
            if (newRule.addTo(this.getContextInitRuleChain())) {
                return true;
            }
            newRule.addTo(this.getRemovedContextInitRuleChain());
        }
        return newRule.addTo(this.getAddedContextInitRuleChain());
    }

    @Override
    public boolean removeContextInitRule(ChainableContextInitRule oldRule) {
        if (!this.incrementalMode) {
            return super.removeContextInitRule(oldRule);
        }
        if (oldRule.removeFrom(this.getAddedContextInitRuleChain())) {
            return true;
        }
        if (oldRule.addTo(this.getRemovedContextInitRuleChain())) {
            if (oldRule.removeFrom(this.getContextInitRuleChain())) {
                return true;
            }
            oldRule.removeFrom(this.getRemovedContextInitRuleChain());
        }
        return false;
    }

    public ChainableContextInitRule getAddedContextInitRules() {
        return this.addedContextInitRules_;
    }

    public ChainableContextInitRule getRemovedContextInitRules() {
        return this.removedContextInitRules_;
    }

    public Map<? extends IndexedClassExpression, ChainableSubsumerRule> getAddedContextRulesByClassExpressions() {
        return this.addedContextRuleHeadByClassExpressions_;
    }

    public Map<? extends IndexedClassExpression, ChainableSubsumerRule> getRemovedContextRulesByClassExpressions() {
        return this.removedContextRuleHeadByClassExpressions_;
    }

    public Map<? extends IndexedClass, ? extends IndexedClassExpression> getAddedDefinitions() {
        return this.addedDefinitions_;
    }

    public Map<? extends IndexedClass, ? extends ElkAxiom> getAddedDefinitionReasons() {
        return this.addedDefinitionReasons_;
    }

    public Map<? extends IndexedClass, ? extends IndexedClassExpression> getRemovedDefinitions() {
        return this.removedDefinitions_;
    }

    public Map<? extends IndexedClass, ? extends ElkAxiom> getRemovedDefinitionReasons() {
        return this.removedDefinitionReasons_;
    }

    public Collection<ElkClass> getAddedClasses() {
        return this.addedClasses_;
    }

    public Collection<ElkNamedIndividual> getAddedIndividuals() {
        return this.addedIndividuals_;
    }

    public Iterable<? extends IndexedClassExpression> getRemovedClassExpressions() {
        return Operations.filter(this.todoDeletions_, IndexedClassExpression.class);
    }

    public void clearDeletedRules() {
        for (CachedIndexedObject<?> deletion : this.todoDeletions_) {
            LOGGER_.trace("{}: comitting removal", deletion);
            super.remove((CachedIndexedObject)deletion);
        }
        this.initDeletions();
    }

    public void commitAddedRules() {
        Chain<ChainableContextInitRule> contextInitRuleChain = this.getContextInitRuleChain();
        for (ChainableContextInitRule nextContextInitRule = this.addedContextInitRules_; nextContextInitRule != null; nextContextInitRule = (ChainableContextInitRule)nextContextInitRule.next()) {
            nextContextInitRule.addTo(contextInitRuleChain);
        }
        for (ModifiableIndexedClassExpression modifiableIndexedClassExpression : this.addedContextRuleHeadByClassExpressions_.keySet()) {
            LOGGER_.trace("{}: committing context rule additions", (Object)modifiableIndexedClassExpression);
            Chain<ChainableSubsumerRule> classExpressionRuleChain = modifiableIndexedClassExpression.getCompositionRuleChain();
            for (ChainableSubsumerRule nextClassExpressionRule = this.addedContextRuleHeadByClassExpressions_.get(modifiableIndexedClassExpression); nextClassExpressionRule != null; nextClassExpressionRule = (ChainableSubsumerRule)nextClassExpressionRule.next()) {
                nextClassExpressionRule.addTo(classExpressionRuleChain);
            }
        }
        for (ModifiableIndexedClass modifiableIndexedClass : this.addedDefinitions_.keySet()) {
            ModifiableIndexedClassExpression definition = this.addedDefinitions_.get(modifiableIndexedClass);
            ElkAxiom reason = this.addedDefinitionReasons_.get(modifiableIndexedClass);
            LOGGER_.trace("{}: committing definition addition {}", (Object)modifiableIndexedClass, (Object)definition);
            if (modifiableIndexedClass.setDefinition(definition, reason)) continue;
            throw new ElkUnexpectedIndexingException(modifiableIndexedClass);
        }
        this.initAdditions();
    }

    public boolean isFullyCommitted() {
        return !(this.addedContextInitRules_ != null || this.removedContextInitRules_ != null || this.addedContextRuleHeadByClassExpressions_ != null && !this.addedContextRuleHeadByClassExpressions_.isEmpty() || this.removedContextRuleHeadByClassExpressions_ != null && !this.removedContextRuleHeadByClassExpressions_.isEmpty());
    }

    public void setIncrementalMode(boolean incremental) {
        if (this.incrementalMode == incremental) {
            return;
        }
        LOGGER_.trace("set incremental mode: " + incremental);
        this.incrementalMode = incremental;
        if (!incremental) {
            this.clearDeletedRules();
            this.commitAddedRules();
            this.initClassChanges();
            this.initIndividualChanges();
        }
    }

    public boolean isIncrementalMode() {
        return this.incrementalMode;
    }

    private Chain<ChainableContextInitRule> getAddedContextInitRuleChain() {
        return new AbstractChain<ChainableContextInitRule>(){

            public ChainableContextInitRule next() {
                return DifferentialIndex.this.addedContextInitRules_;
            }

            public void setNext(ChainableContextInitRule tail) {
                DifferentialIndex.this.addedContextInitRules_ = tail;
            }
        };
    }

    private Chain<ChainableContextInitRule> getRemovedContextInitRuleChain() {
        return new AbstractChain<ChainableContextInitRule>(){

            public ChainableContextInitRule next() {
                return DifferentialIndex.this.removedContextInitRules_;
            }

            public void setNext(ChainableContextInitRule tail) {
                DifferentialIndex.this.removedContextInitRules_ = tail;
            }
        };
    }

    private Chain<ChainableSubsumerRule> getAddedContextRuleChain(ModifiableIndexedClassExpression target) {
        return AbstractChain.getMapBackedChain(this.addedContextRuleHeadByClassExpressions_, (Object)target);
    }

    private Chain<ChainableSubsumerRule> getRemovedContextRuleChain(ModifiableIndexedClassExpression target) {
        return AbstractChain.getMapBackedChain(this.removedContextRuleHeadByClassExpressions_, (Object)target);
    }

    private class EntityInsertionListener
    implements IndexedEntity.Visitor<Void> {
        private EntityInsertionListener() {
        }

        @Override
        public Void visit(IndexedClass element) {
            ElkClass entity = element.getElkEntity();
            if (!DifferentialIndex.this.removedClasses_.remove(entity)) {
                DifferentialIndex.this.addedClasses_.add(entity);
            }
            return null;
        }

        @Override
        public Void visit(IndexedIndividual element) {
            ElkNamedIndividual entity = element.getElkEntity();
            if (!DifferentialIndex.this.removedIndividuals_.remove(entity)) {
                DifferentialIndex.this.addedIndividuals_.add(entity);
            }
            return null;
        }

        @Override
        public Void visit(IndexedObjectProperty element) {
            ElkObjectProperty entity = element.getElkEntity();
            if (!DifferentialIndex.this.removedObjectProperties_.remove(entity)) {
                DifferentialIndex.this.addedObjectProperties_.add(entity);
            }
            return null;
        }
    }

    private class EntityDeletionListener
    implements IndexedEntity.Visitor<Void> {
        private EntityDeletionListener() {
        }

        @Override
        public Void visit(IndexedClass element) {
            ElkClass entity = element.getElkEntity();
            if (!DifferentialIndex.this.addedClasses_.remove(entity)) {
                DifferentialIndex.this.removedClasses_.add(entity);
            }
            return null;
        }

        @Override
        public Void visit(IndexedIndividual element) {
            ElkNamedIndividual entity = element.getElkEntity();
            if (!DifferentialIndex.this.addedIndividuals_.remove(entity)) {
                DifferentialIndex.this.removedIndividuals_.add(entity);
            }
            return null;
        }

        @Override
        public Void visit(IndexedObjectProperty element) {
            ElkObjectProperty entity = element.getElkEntity();
            if (!DifferentialIndex.this.addedObjectProperties_.remove(entity)) {
                DifferentialIndex.this.removedObjectProperties_.add(entity);
            }
            return null;
        }
    }
}

