/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.classes;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.predefined.PredefinedElkEntityFactory;
import org.semanticweb.elk.reasoner.indexing.classes.ModifiableIndexedObjectCacheImpl;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedOwlNothing;
import org.semanticweb.elk.reasoner.indexing.model.CachedIndexedOwlThing;
import org.semanticweb.elk.reasoner.indexing.model.IndexingListener;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClass;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableIndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.model.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.model.Occurrence;
import org.semanticweb.elk.reasoner.indexing.model.OccurrenceIncrement;
import org.semanticweb.elk.reasoner.indexing.model.OntologyIndex;
import org.semanticweb.elk.reasoner.saturation.rules.contextinit.ChainableContextInitRule;
import org.semanticweb.elk.reasoner.saturation.rules.contextinit.LinkedContextInitRule;
import org.semanticweb.elk.reasoner.saturation.rules.contextinit.RootContextInitializationRule;
import org.semanticweb.elk.reasoner.saturation.rules.subsumers.ChainableSubsumerRule;
import org.semanticweb.elk.util.collections.chains.AbstractChain;
import org.semanticweb.elk.util.collections.chains.Chain;

public class DirectIndex
extends ModifiableIndexedObjectCacheImpl
implements ModifiableOntologyIndex {
    private ChainableContextInitRule contextInitRules_;
    private final List<OntologyIndex.ChangeListener> listeners_;
    private final List<IndexingListener> indexingListeners_ = new ArrayList<IndexingListener>();

    public DirectIndex(PredefinedElkEntityFactory elkFactory) {
        super(elkFactory);
        this.listeners_ = new ArrayList<OntologyIndex.ChangeListener>();
        RootContextInitializationRule.addRuleFor(this);
        OccurrenceIncrement addition = OccurrenceIncrement.getNeutralIncrement(1);
        this.getOwlThing().updateOccurrenceNumbers(this, addition);
        this.getOwlNothing().updateOccurrenceNumbers(this, addition);
        this.getOwlTopObjectProperty().updateOccurrenceNumbers(this, addition);
        this.getOwlBottomObjectProperty().updateOccurrenceNumbers(this, addition);
        this.getOwlThing().addListener(new CachedIndexedOwlThing.ChangeListener(){

            @Override
            public void negativeOccurrenceAppeared() {
                for (int i = 0; i < DirectIndex.this.listeners_.size(); ++i) {
                    ((OntologyIndex.ChangeListener)DirectIndex.this.listeners_.get(i)).negativeOwlThingAppeared();
                }
            }

            @Override
            public void negativeOccurrenceDisappeared() {
                for (int i = 0; i < DirectIndex.this.listeners_.size(); ++i) {
                    ((OntologyIndex.ChangeListener)DirectIndex.this.listeners_.get(i)).negativeOwlThingDisappeared();
                }
            }
        });
        this.getOwlNothing().addListener(new CachedIndexedOwlNothing.ChangeListener(){

            @Override
            public void positiveOccurrenceAppeared() {
                for (int i = 0; i < DirectIndex.this.listeners_.size(); ++i) {
                    ((OntologyIndex.ChangeListener)DirectIndex.this.listeners_.get(i)).positiveOwlNothingAppeared();
                }
            }

            @Override
            public void positiveOccurrenceDisappeared() {
                for (int i = 0; i < DirectIndex.this.listeners_.size(); ++i) {
                    ((OntologyIndex.ChangeListener)DirectIndex.this.listeners_.get(i)).positiveOwlNothingDisappeared();
                }
            }
        });
    }

    @Override
    public final LinkedContextInitRule getContextInitRuleHead() {
        return this.contextInitRules_;
    }

    @Override
    public boolean addContextInitRule(ChainableContextInitRule newRule) {
        return newRule.addTo(this.getContextInitRuleChain());
    }

    @Override
    public boolean removeContextInitRule(ChainableContextInitRule oldRule) {
        return oldRule.removeFrom(this.getContextInitRuleChain());
    }

    @Override
    public boolean add(ModifiableIndexedClassExpression target, ChainableSubsumerRule rule) {
        return rule.addTo(target.getCompositionRuleChain());
    }

    @Override
    public boolean remove(ModifiableIndexedClassExpression target, ChainableSubsumerRule rule) {
        return rule.removeFrom(target.getCompositionRuleChain());
    }

    @Override
    public final boolean hasNegativeOwlThing() {
        return this.getOwlThing().occursNegatively();
    }

    @Override
    public final boolean hasPositiveOwlNothing() {
        return this.getOwlNothing().occursPositively();
    }

    @Override
    public boolean tryAddDefinition(ModifiableIndexedClass target, ModifiableIndexedClassExpression definition, ElkAxiom reason) {
        return target.setDefinition(definition, reason);
    }

    @Override
    public boolean tryRemoveDefinition(ModifiableIndexedClass target, ModifiableIndexedClassExpression definition, ElkAxiom reason) {
        if (target.getDefinition() != definition || !target.getDefinitionReason().equals(reason)) {
            return false;
        }
        target.removeDefinition();
        return true;
    }

    public Chain<ChainableContextInitRule> getContextInitRuleChain() {
        return new AbstractChain<ChainableContextInitRule>(){

            public ChainableContextInitRule next() {
                return DirectIndex.this.contextInitRules_;
            }

            public void setNext(ChainableContextInitRule tail) {
                DirectIndex.this.contextInitRules_ = tail;
                for (int i = 0; i < DirectIndex.this.listeners_.size(); ++i) {
                    ((OntologyIndex.ChangeListener)DirectIndex.this.listeners_.get(i)).contextInitRuleHeadSet(tail);
                }
            }
        };
    }

    @Override
    public boolean addListener(OntologyIndex.ChangeListener listener) {
        if (!super.addListener(listener)) {
            return false;
        }
        if (!this.listeners_.add(listener)) {
            super.removeListener(listener);
            return false;
        }
        return true;
    }

    @Override
    public boolean removeListener(OntologyIndex.ChangeListener listener) {
        if (!super.removeListener(listener)) {
            return false;
        }
        if (!this.listeners_.remove(listener)) {
            super.addListener(listener);
            return false;
        }
        return true;
    }

    @Override
    public boolean addOccurrenceIndexingListener(IndexingListener listener) {
        return this.indexingListeners_.add(listener);
    }

    @Override
    public boolean removeOccurrenceIndexingListener(IndexingListener listener) {
        return this.indexingListeners_.remove(listener);
    }

    @Override
    public void onIndexing(Occurrence occurrence) {
        for (IndexingListener listener : this.indexingListeners_) {
            listener.onIndexing(occurrence);
        }
    }
}

